/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.DynamicArrayStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.IllegalStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.ShortString;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;

public class PropertyStore
extends AbstractStore
implements Store {
    public static final int DEFAULT_DATA_BLOCK_SIZE = 120;
    private static final String VERSION = "PropertyStore v0.9.9";
    public static final int RECORD_SIZE = 25;
    private DynamicStringStore stringPropertyStore;
    private PropertyIndexStore propertyIndexStore;
    private DynamicArrayStore arrayPropertyStore;

    public PropertyStore(String fileName, Map<?, ?> config) {
        super(fileName, config, IdType.PROPERTY);
    }

    @Override
    protected void initStorage() {
        this.stringPropertyStore = new DynamicStringStore(this.getStorageFileName() + ".strings", this.getConfig(), IdType.STRING_BLOCK);
        this.propertyIndexStore = new PropertyIndexStore(this.getStorageFileName() + ".index", this.getConfig());
        this.arrayPropertyStore = new DynamicArrayStore(this.getStorageFileName() + ".arrays", this.getConfig(), IdType.ARRAY_BLOCK);
    }

    @Override
    protected void setRecovered() {
        super.setRecovered();
        this.stringPropertyStore.setRecovered();
        this.propertyIndexStore.setRecovered();
        this.arrayPropertyStore.setRecovered();
    }

    @Override
    protected void unsetRecovered() {
        super.unsetRecovered();
        this.stringPropertyStore.unsetRecovered();
        this.propertyIndexStore.unsetRecovered();
        this.arrayPropertyStore.unsetRecovered();
    }

    @Override
    protected void closeStorage() {
        if (this.stringPropertyStore != null) {
            this.stringPropertyStore.close();
            this.stringPropertyStore = null;
        }
        if (this.propertyIndexStore != null) {
            this.propertyIndexStore.close();
            this.propertyIndexStore = null;
        }
        if (this.arrayPropertyStore != null) {
            this.arrayPropertyStore.close();
            this.arrayPropertyStore = null;
        }
    }

    @Override
    public void flushAll() {
        this.stringPropertyStore.flushAll();
        this.propertyIndexStore.flushAll();
        this.arrayPropertyStore.flushAll();
        super.flushAll();
    }

    @Override
    public String getTypeAndVersionDescriptor() {
        return VERSION;
    }

    @Override
    public int getRecordSize() {
        return 25;
    }

    public static void createStore(String fileName, Map<?, ?> config) {
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)config.get(IdGeneratorFactory.class);
        PropertyStore.createEmptyStore(fileName, VERSION, idGeneratorFactory);
        int stringStoreBlockSize = 120;
        int arrayStoreBlockSize = 120;
        try {
            int value;
            String stringBlockSize = (String)config.get("string_block_size");
            String arrayBlockSize = (String)config.get("array_block_size");
            if (stringBlockSize != null && (value = Integer.parseInt(stringBlockSize)) > 0) {
                stringStoreBlockSize = value;
            }
            if (arrayBlockSize != null && (value = Integer.parseInt(arrayBlockSize)) > 0) {
                arrayStoreBlockSize = value;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception creating store", e);
        }
        DynamicStringStore.createStore(fileName + ".strings", stringStoreBlockSize, idGeneratorFactory, IdType.STRING_BLOCK);
        PropertyIndexStore.createStore(fileName + ".index", idGeneratorFactory);
        DynamicArrayStore.createStore(fileName + ".arrays", arrayStoreBlockSize, idGeneratorFactory);
    }

    private long nextStringBlockId() {
        return this.stringPropertyStore.nextBlockId();
    }

    public void freeStringBlockId(long blockId) {
        this.stringPropertyStore.freeBlockId(blockId);
    }

    private long nextArrayBlockId() {
        return this.arrayPropertyStore.nextBlockId();
    }

    public void freeArrayBlockId(long blockId) {
        this.arrayPropertyStore.freeBlockId(blockId);
    }

    public PropertyIndexStore getIndexStore() {
        return this.propertyIndexStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(PropertyRecord record, boolean recovered) {
        assert (recovered);
        this.setRecovered();
        try {
            this.updateRecord(record);
            this.registerIdFromUpdateRecord(record.getId());
        }
        finally {
            this.unsetRecovered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(PropertyRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window);
        }
        finally {
            this.releaseWindow(window);
        }
        if (!record.isLight()) {
            for (DynamicRecord valueRecord : record.getValueRecords()) {
                if (valueRecord.getType() == PropertyType.STRING.intValue()) {
                    this.stringPropertyStore.updateRecord(valueRecord);
                    continue;
                }
                if (valueRecord.getType() == PropertyType.ARRAY.intValue()) {
                    this.arrayPropertyStore.updateRecord(valueRecord);
                    continue;
                }
                throw new InvalidRecordException("Unknown dynamic record");
            }
        }
    }

    private void updateRecord(PropertyRecord record, PersistenceWindow window) {
        long id = record.getId();
        Buffer buffer = window.getOffsettedBuffer(id);
        if (record.inUse()) {
            long prevProp = record.getPrevProp();
            long prevModifier = prevProp == (long)Record.NO_NEXT_PROPERTY.intValue() ? 0L : (prevProp & 0xF00000000L) >> 28;
            long nextProp = record.getNextProp();
            long nextModifier = nextProp == (long)Record.NO_NEXT_PROPERTY.intValue() ? 0L : (nextProp & 0xF00000000L) >> 16;
            short inUseUnsignedByte = (short)((long)Record.IN_USE.byteValue() | prevModifier);
            int typeInt = record.getType().intValue();
            typeInt = (int)((long)typeInt | nextModifier);
            buffer.put((byte)inUseUnsignedByte).putInt(typeInt).putInt(record.getKeyIndexId()).putLong(record.getPropBlock()).putInt((int)prevProp).putInt((int)nextProp);
        } else {
            buffer.put(Record.NOT_IN_USE.byteValue());
            if (!this.isInRecoveryMode()) {
                this.freeId(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyRecord getLightRecord(long id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            PropertyRecord record = this.getRecord(id, window);
            record.setIsLight(true);
            PropertyRecord propertyRecord = record;
            return propertyRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    public void makeHeavy(PropertyRecord record) {
        block3: {
            block2: {
                record.setIsLight(false);
                if (record.getType() != PropertyType.STRING) break block2;
                Collection<DynamicRecord> stringRecords = this.stringPropertyStore.getLightRecords(record.getPropBlock());
                for (DynamicRecord stringRecord : stringRecords) {
                    stringRecord.setType(PropertyType.STRING.intValue());
                    record.addValueRecord(stringRecord);
                }
                break block3;
            }
            if (record.getType() != PropertyType.ARRAY) break block3;
            Collection<DynamicRecord> arrayRecords = this.arrayPropertyStore.getLightRecords(record.getPropBlock());
            for (DynamicRecord arrayRecord : arrayRecords) {
                arrayRecord.setType(PropertyType.ARRAY.intValue());
                record.addValueRecord(arrayRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyRecord getRecord(long id) {
        PropertyRecord record;
        block7: {
            block6: {
                PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
                try {
                    record = this.getRecord(id, window);
                }
                finally {
                    this.releaseWindow(window);
                }
                if (record.getType() != PropertyType.STRING) break block6;
                Collection<DynamicRecord> stringRecords = this.stringPropertyStore.getLightRecords(record.getPropBlock());
                record.setIsLight(false);
                for (DynamicRecord stringRecord : stringRecords) {
                    stringRecord.setType(PropertyType.STRING.intValue());
                    record.addValueRecord(stringRecord);
                }
                break block7;
            }
            if (record.getType() != PropertyType.ARRAY) break block7;
            Collection<DynamicRecord> arrayRecords = this.arrayPropertyStore.getLightRecords(record.getPropBlock());
            record.setIsLight(false);
            for (DynamicRecord arrayRecord : arrayRecords) {
                arrayRecord.setType(PropertyType.ARRAY.intValue());
                record.addValueRecord(arrayRecord);
            }
        }
        return record;
    }

    private PropertyRecord getRecord(long id, PersistenceWindow window) {
        boolean inUse;
        Buffer buffer = window.getOffsettedBuffer(id);
        long inUseByte = buffer.get();
        boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
        if (!inUse) {
            throw new InvalidRecordException("Record[" + id + "] not in use");
        }
        PropertyRecord record = new PropertyRecord(id);
        long typeInt = buffer.getInt();
        record.setType(this.getEnumType((int)typeInt & 0xFFFF));
        record.setInUse(true);
        record.setKeyIndexId(buffer.getInt());
        record.setPropBlock(buffer.getLong());
        long prevProp = buffer.getUnsignedInt();
        long prevModifier = (inUseByte & 0xF0L) << 28;
        long nextProp = buffer.getUnsignedInt();
        long nextModifier = (typeInt & 0xF0000L) << 16;
        record.setPrevProp(PropertyStore.longFromIntAndMod(prevProp, prevModifier));
        record.setNextProp(PropertyStore.longFromIntAndMod(nextProp, nextModifier));
        return record;
    }

    private PropertyType getEnumType(int type) {
        return PropertyType.getPropertyType(type, false);
    }

    public Object getValue(PropertyRecord propertyRecord) {
        return propertyRecord.getType().getValue(propertyRecord, this);
    }

    @Override
    public void makeStoreOk() {
        this.propertyIndexStore.makeStoreOk();
        this.stringPropertyStore.makeStoreOk();
        this.arrayPropertyStore.makeStoreOk();
        super.makeStoreOk();
    }

    @Override
    public void rebuildIdGenerators() {
        this.propertyIndexStore.rebuildIdGenerators();
        this.stringPropertyStore.rebuildIdGenerators();
        this.arrayPropertyStore.rebuildIdGenerators();
        super.rebuildIdGenerators();
    }

    public void updateIdGenerators() {
        this.propertyIndexStore.updateIdGenerators();
        this.stringPropertyStore.updateHighId();
        this.arrayPropertyStore.updateHighId();
        this.updateHighId();
    }

    private Collection<DynamicRecord> allocateStringRecords(long valueBlockId, char[] chars) {
        return this.stringPropertyStore.allocateRecords(valueBlockId, chars);
    }

    private Collection<DynamicRecord> allocateArrayRecords(long valueBlockId, Object array) {
        return this.arrayPropertyStore.allocateRecords(valueBlockId, array);
    }

    public void encodeValue(PropertyRecord record, Object value) {
        if (value instanceof String) {
            String string = (String)value;
            if (ShortString.encode(string, record)) {
                record.setType(PropertyType.SHORT_STRING);
                return;
            }
            long stringBlockId = this.nextStringBlockId();
            record.setPropBlock(stringBlockId);
            int length = string.length();
            char[] chars = new char[length];
            string.getChars(0, length, chars, 0);
            Collection<DynamicRecord> valueRecords = this.allocateStringRecords(stringBlockId, chars);
            for (DynamicRecord valueRecord : valueRecords) {
                valueRecord.setType(PropertyType.STRING.intValue());
                record.addValueRecord(valueRecord);
            }
            record.setType(PropertyType.STRING);
        } else if (value instanceof Integer) {
            record.setPropBlock(((Integer)value).intValue());
            record.setType(PropertyType.INT);
        } else if (value instanceof Boolean) {
            record.setPropBlock((Boolean)value != false ? 1 : 0);
            record.setType(PropertyType.BOOL);
        } else if (value instanceof Float) {
            record.setPropBlock(Float.floatToRawIntBits(((Float)value).floatValue()));
            record.setType(PropertyType.FLOAT);
        } else if (value instanceof Long) {
            record.setPropBlock((Long)value);
            record.setType(PropertyType.LONG);
        } else if (value instanceof Double) {
            record.setPropBlock(Double.doubleToRawLongBits((Double)value));
            record.setType(PropertyType.DOUBLE);
        } else if (value instanceof Byte) {
            record.setPropBlock(((Byte)value).byteValue());
            record.setType(PropertyType.BYTE);
        } else if (value instanceof Character) {
            record.setPropBlock(((Character)value).charValue());
            record.setType(PropertyType.CHAR);
        } else if (value.getClass().isArray()) {
            long arrayBlockId = this.nextArrayBlockId();
            record.setPropBlock(arrayBlockId);
            Collection<DynamicRecord> arrayRecords = this.allocateArrayRecords(arrayBlockId, value);
            for (DynamicRecord valueRecord : arrayRecords) {
                valueRecord.setType(PropertyType.ARRAY.intValue());
                record.addValueRecord(valueRecord);
            }
            record.setType(PropertyType.ARRAY);
        } else if (value instanceof Short) {
            record.setPropBlock(((Short)value).shortValue());
            record.setType(PropertyType.SHORT);
        } else {
            throw new IllegalArgumentException("Unknown property type on: " + value);
        }
    }

    public Object getStringFor(PropertyRecord propRecord) {
        long recordToFind = propRecord.getPropBlock();
        HashMap<Long, DynamicRecord> recordsMap = new HashMap<Long, DynamicRecord>();
        for (DynamicRecord record : propRecord.getValueRecords()) {
            recordsMap.put(record.getId(), record);
        }
        LinkedList<char[]> charList = new LinkedList<char[]>();
        int totalSize = 0;
        while (recordToFind != (long)Record.NO_NEXT_BLOCK.intValue()) {
            DynamicRecord record = (DynamicRecord)recordsMap.get(recordToFind);
            if (record.isLight()) {
                this.stringPropertyStore.makeHeavy(record);
            }
            if (!record.isCharData()) {
                ByteBuffer buf = ByteBuffer.wrap(record.getData());
                char[] chars = new char[record.getData().length / 2];
                totalSize += chars.length;
                buf.asCharBuffer().get(chars);
                charList.add(chars);
            } else {
                charList.add(record.getDataAsChar());
            }
            recordToFind = record.getNextBlock();
        }
        StringBuffer buf = new StringBuffer();
        for (char[] str : charList) {
            buf.append(str);
        }
        return buf.toString();
    }

    public Object getArrayFor(PropertyRecord propertyRecord) {
        return PropertyStore.getArrayFor(propertyRecord.getPropBlock(), propertyRecord.getValueRecords(), this.arrayPropertyStore);
    }

    public static Object getArrayFor(long startRecord, Iterable<DynamicRecord> records, DynamicArrayStore arrayPropertyStore) {
        long recordToFind = startRecord;
        HashMap<Long, DynamicRecord> recordsMap = new HashMap<Long, DynamicRecord>();
        for (DynamicRecord record : records) {
            recordsMap.put(record.getId(), record);
        }
        LinkedList<byte[]> byteList = new LinkedList<byte[]>();
        int totalSize = 0;
        while (recordToFind != (long)Record.NO_NEXT_BLOCK.intValue()) {
            byte[] bytes;
            ByteBuffer buf;
            DynamicRecord record = (DynamicRecord)recordsMap.get(recordToFind);
            if (record.isLight()) {
                arrayPropertyStore.makeHeavy(record);
            }
            if (!record.isCharData()) {
                buf = ByteBuffer.wrap(record.getData());
                bytes = new byte[record.getData().length];
                totalSize += bytes.length;
            } else {
                throw new InvalidRecordException("Expected byte data on record " + record);
            }
            buf.get(bytes);
            byteList.add(bytes);
            recordToFind = record.getNextBlock();
        }
        byte[] bArray = new byte[totalSize];
        int offset = 0;
        for (byte[] currentArray : byteList) {
            System.arraycopy(currentArray, 0, bArray, offset, currentArray.length);
            offset += currentArray.length;
        }
        return arrayPropertyStore.getRightArray(bArray);
    }

    @Override
    protected boolean versionFound(String version) {
        if (!version.startsWith("PropertyStore")) {
            return false;
        }
        if (version.equals("PropertyStore v0.9.5")) {
            return true;
        }
        throw new IllegalStoreVersionException("Store version [" + version + "]. Please make sure you are not running old Neo4j kernel " + " towards a store that has been created by newer version " + " of Neo4j.");
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.add(this.stringPropertyStore.getWindowPoolStats());
        list.add(this.arrayPropertyStore.getWindowPoolStats());
        list.add(this.getWindowPoolStats());
        return list;
    }

    public int getStringBlockSize() {
        return this.stringPropertyStore.getBlockSize();
    }

    public int getArrayBlockSize() {
        return this.arrayPropertyStore.getBlockSize();
    }
}

