/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.neo4j.kernel.impl.core.FastRelTypeElement;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelTypeElementIterator;
import org.neo4j.kernel.impl.util.RelIdArray;

class RelTypeElement
extends RelTypeElementIterator {
    private RelIdArray src;
    private final Set<Long> remove = new HashSet<Long>();
    private final RelIdArray.RelIdIterator srcIterator;
    private final RelIdArray.RelIdIterator addIterator;
    private RelIdArray.RelIdIterator currentIterator;
    private long nextElement;
    private boolean nextElementDetermined;
    private final RelIdArray.DirectionWrapper direction;

    static RelTypeElementIterator create(String type, NodeImpl node, RelIdArray src, RelIdArray add, RelIdArray remove, RelIdArray.DirectionWrapper direction) {
        if (add == null && remove == null) {
            return new FastRelTypeElement(type, node, src, direction);
        }
        return new RelTypeElement(type, node, src, add, remove, direction);
    }

    private RelTypeElement(String type, NodeImpl node, RelIdArray src, RelIdArray add, RelIdArray remove, RelIdArray.DirectionWrapper direction) {
        super(type, node);
        this.direction = direction;
        if (src == null) {
            src = RelIdArray.EMPTY;
        }
        this.src = src;
        this.srcIterator = src.iterator(direction);
        RelIdArray.RelIdIterator relIdIterator = this.addIterator = add == null ? RelIdArray.EMPTY.iterator(direction) : add.iterator(direction);
        if (remove != null) {
            RelIdArray.RelIdIterator iterator = remove.iterator(RelIdArray.DirectionWrapper.BOTH);
            while (iterator.hasNext()) {
                this.remove.add(iterator.next());
            }
        }
        this.currentIterator = this.srcIterator;
    }

    @Override
    public boolean hasNext(NodeManager nodeManager) {
        if (this.nextElementDetermined) {
            return this.nextElement != -1L;
        }
        while (this.currentIterator.hasNext() || this.currentIterator != this.addIterator) {
            while (this.currentIterator.hasNext()) {
                long value = this.currentIterator.next();
                if (this.remove.contains(value)) continue;
                this.nextElement = value;
                this.nextElementDetermined = true;
                return true;
            }
            this.currentIterator = this.addIterator;
        }
        this.nextElementDetermined = true;
        this.nextElement = -1L;
        return false;
    }

    @Override
    public long next(NodeManager nodeManager) {
        if (!this.hasNext(nodeManager)) {
            throw new NoSuchElementException();
        }
        this.nextElementDetermined = false;
        return this.nextElement;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSrcEmpty() {
        return this.src.isEmpty();
    }

    @Override
    public RelTypeElementIterator setSrc(RelIdArray newSrc) {
        return new FastRelTypeElement(this.getType(), this.getNode(), newSrc, this.direction);
    }

    @Override
    public void updateSrc(RelIdArray newSrc) {
        this.srcIterator.updateSource(newSrc);
    }

    @Override
    public void notifyAboutMoreRelationships() {
        this.srcIterator.doAnotherRound();
    }
}

