/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.annotations;

import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

abstract class CompilationManipulator {
    private static final Class<?> JAVAC_ENVIRONMENT = CompilationManipulator.loadClass("com.sun.tools.javac.processing.JavacProcessingEnvironment");

    CompilationManipulator() {
    }

    static CompilationManipulator load(ProcessingEnvironment processingEnv) {
        try {
            if (JAVAC_ENVIRONMENT != null && JAVAC_ENVIRONMENT.isInstance(processingEnv)) {
                return new JavacManipulator(processingEnv);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Throwable e) {
            return null;
        }
    }

    abstract boolean updateAnnotationValue(Element var1, AnnotationMirror var2, String var3, String var4);

    private static class JavacManipulator
    extends CompilationManipulator {
        private final Trees trees;
        private final TreeMaker maker;
        private final JavacElements elements;

        JavacManipulator(ProcessingEnvironment env) {
            Context context = ((JavacProcessingEnvironment)env).getContext();
            this.trees = Trees.instance(env);
            this.maker = TreeMaker.instance(context);
            this.elements = JavacElements.instance(context);
        }

        @Override
        boolean updateAnnotationValue(Element annotated, AnnotationMirror annotation, String key, String value) {
            Tree leaf = this.trees.getTree(annotated, annotation);
            if (leaf instanceof JCTree.JCAnnotation) {
                JCTree.JCAnnotation annot = (JCTree.JCAnnotation)leaf;
                for (JCTree.JCExpression expr : annot.args) {
                    if (!(expr instanceof JCTree.JCAssign)) continue;
                    JCTree.JCAssign assign = (JCTree.JCAssign)expr;
                    if (!(assign.lhs instanceof JCTree.JCIdent)) continue;
                    JCTree.JCIdent ident = (JCTree.JCIdent)assign.lhs;
                    if (!ident.name.contentEquals(key)) continue;
                    assign.rhs = this.maker.Literal(value);
                    return true;
                }
                annot.args = annot.args.append(this.maker.Assign(this.maker.Ident(this.elements.getName(key)), this.maker.Literal(value)));
                return true;
            }
            return false;
        }
    }
}

