/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.index.Index;
import org.neo4j.kernel.AbstractAutoIndexerImpl;
import org.neo4j.kernel.EmbeddedGraphDbImpl;

class NodeAutoIndexerImpl
extends AbstractAutoIndexerImpl<Node> {
    static final String NODE_AUTO_INDEX = "node_auto_index";

    public NodeAutoIndexerImpl(EmbeddedGraphDbImpl gdb) {
        super(gdb);
    }

    @Override
    protected Iterable<PropertyEntry<Node>> getAssignedPropertiesOnCommit(TransactionData data) {
        return data.assignedNodeProperties();
    }

    @Override
    protected String getAutoIndexConfigListName() {
        return "node_keys_indexable";
    }

    @Override
    protected String getAutoIndexName() {
        return NODE_AUTO_INDEX;
    }

    @Override
    protected String getEnableConfigName() {
        return "node_auto_indexing";
    }

    @Override
    protected Index<Node> getIndexInternal() {
        return this.getGraphDbImpl().index().forNodes(NODE_AUTO_INDEX);
    }

    @Override
    protected Iterable<PropertyEntry<Node>> getRemovedPropertiesOnCommit(TransactionData data) {
        return data.removedNodeProperties();
    }
}

