/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.cache.LruCache;
import org.neo4j.kernel.impl.transaction.xaframework.IllegalLogFormatException;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.BufferedFileChannel;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;

public class XaLogicalLog {
    private final Logger log;
    private static final char CLEAN = 'C';
    private static final char LOG1 = '1';
    private static final char LOG2 = '2';
    private FileChannel fileChannel = null;
    private final ByteBuffer buffer;
    private LogBuffer writeBuffer = null;
    private long previousLogLastCommittedTx = -1L;
    private long logVersion = 0L;
    private final ArrayMap<Integer, LogEntry.Start> xidIdentMap = new ArrayMap(4, false, true);
    private final Map<Integer, XaTransaction> recoveredTxMap = new HashMap<Integer, XaTransaction>();
    private int nextIdentifier = 1;
    private boolean scanIsComplete = false;
    private boolean nonCleanShutdown = false;
    private String fileName = null;
    private final XaResourceManager xaRm;
    private final XaCommandFactory cf;
    private final XaTransactionFactory xaTf;
    private char currentLog = (char)67;
    private boolean keepLogs = false;
    private boolean autoRotate = true;
    private long rotateAtSize = 0x1900000L;
    private boolean backupSlave = false;
    private final String storeDir;
    private final LogBufferFactory logBufferFactory;
    private boolean doingRecovery;
    private final StringLogger msgLog;
    private final LruCache<Long, TxPosition> txStartPositionCache = new LruCache("Tx start position cache", 10000, null);
    private final ArrayMap<Thread, Integer> txIdentMap = new ArrayMap(5, true, true);
    public static final int MASTER_ID_REPRESENTING_NO_MASTER = -1;

    XaLogicalLog(String fileName, XaResourceManager xaRm, XaCommandFactory cf, XaTransactionFactory xaTf, Map<Object, Object> config) {
        this.fileName = fileName;
        this.xaRm = xaRm;
        this.cf = cf;
        this.xaTf = xaTf;
        this.logBufferFactory = (LogBufferFactory)config.get(LogBufferFactory.class);
        this.log = Logger.getLogger(this.getClass().getName() + File.separator + fileName);
        this.buffer = ByteBuffer.allocateDirect(713);
        this.storeDir = (String)config.get("store_dir");
        this.msgLog = StringLogger.getLogger(this.storeDir);
    }

    synchronized void open() throws IOException {
        String activeFileName = this.fileName + ".active";
        if (!new File(activeFileName).exists()) {
            if (new File(this.fileName).exists()) {
                this.open(this.fileName);
            } else {
                this.open(this.getLog1FileName());
                this.setActiveLog('1');
            }
        } else {
            FileChannel fc = new RandomAccessFile(activeFileName, "rw").getChannel();
            byte[] bytes = new byte[256];
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            int read = fc.read(buf);
            fc.close();
            if (read != 4) {
                throw new IllegalStateException("Read " + read + " bytes from " + activeFileName + " but expected 4");
            }
            buf.flip();
            char c = buf.asCharBuffer().get();
            if (c == 'C') {
                String newLog = this.getLog1FileName();
                File file = new File(newLog);
                if (file.exists()) {
                    this.fixCleanKill(newLog);
                }
                if ((file = new File(this.getLog2FileName())).exists()) {
                    this.fixCleanKill(file.getPath());
                }
                this.open(newLog);
                this.setActiveLog('1');
            } else if (c == '1') {
                String newLog = this.getLog1FileName();
                if (!new File(newLog).exists()) {
                    throw new IllegalStateException("Active marked as 1 but no " + newLog + " exist");
                }
                File otherLog = new File(this.getLog2FileName());
                this.safeDeleteFile(otherLog);
                this.currentLog = (char)49;
                this.open(newLog);
            } else if (c == '2') {
                String newLog = this.getLog2FileName();
                if (!new File(newLog).exists()) {
                    throw new IllegalStateException("Active marked as 2 but no " + newLog + " exist");
                }
                File otherLog = new File(this.getLog1FileName());
                this.safeDeleteFile(otherLog);
                this.currentLog = (char)50;
                this.open(newLog);
            } else {
                throw new IllegalStateException("Unknown active log: " + c);
            }
        }
        this.instantiateCorrectWriteBuffer();
    }

    private void instantiateCorrectWriteBuffer() throws IOException {
        this.writeBuffer = this.instantiateCorrectWriteBuffer(this.fileChannel);
    }

    private LogBuffer instantiateCorrectWriteBuffer(FileChannel channel) throws IOException {
        return this.logBufferFactory.create(channel);
    }

    private void safeDeleteFile(File file) {
        if (file.exists() && !file.delete()) {
            this.log.warning("Unable to delete " + file.getName());
        }
    }

    private void fixCleanKill(String fileName) throws IOException {
        File file = new File(fileName);
        if (!this.keepLogs) {
            if (!file.delete()) {
                throw new IllegalStateException("Active marked as clean and unable to delete log " + fileName);
            }
        } else {
            this.renameCurrentLogFileAndIncrementVersion(fileName, file.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(String fileToOpen) throws IOException {
        this.fileChannel = new RandomAccessFile(fileToOpen, "rw").getChannel();
        if (this.fileChannel.size() != 0L) {
            this.nonCleanShutdown = true;
            this.doingRecovery = true;
            try {
                this.doInternalRecovery(fileToOpen);
            }
            finally {
                this.doingRecovery = false;
            }
        } else {
            this.logVersion = this.xaTf.getCurrentVersion();
            long lastTxId = this.xaTf.getLastCommittedTx();
            LogIoUtils.writeLogHeader(this.buffer, this.logVersion, lastTxId);
            this.previousLogLastCommittedTx = lastTxId;
            this.fileChannel.write(this.buffer);
            this.scanIsComplete = true;
            this.msgLog.logMessage("Opened [" + fileToOpen + "] clean empty log, version=" + this.logVersion, true);
        }
    }

    public boolean scanIsComplete() {
        return this.scanIsComplete;
    }

    private int getNextIdentifier() {
        ++this.nextIdentifier;
        if (this.nextIdentifier < 0) {
            this.nextIdentifier = 1;
        }
        return this.nextIdentifier;
    }

    public synchronized int start(Xid xid) throws XAException {
        if (this.backupSlave) {
            throw new XAException("Resource is configured as backup slave, no new transactions can be started for " + this.fileName + "." + this.currentLog);
        }
        int xidIdent = this.getNextIdentifier();
        try {
            long position = this.writeBuffer.getFileChannelPosition();
            LogEntry.Start start = new LogEntry.Start(xid, xidIdent, position);
            LogIoUtils.writeStart(this.writeBuffer, xidIdent, xid);
            this.xidIdentMap.put(xidIdent, start);
        }
        catch (IOException e) {
            throw Exceptions.withCause(new XAException("Logical log couldn't start transaction: " + e), e);
        }
        return xidIdent;
    }

    public synchronized void prepare(int identifier) throws XAException {
        LogEntry.Start startEntry = this.xidIdentMap.get(identifier);
        assert (startEntry != null);
        try {
            LogIoUtils.writePrepare(this.writeBuffer, identifier);
        }
        catch (IOException e) {
            throw Exceptions.withCause(new XAException("Logical log unable to mark prepare [" + identifier + "] "), e);
        }
    }

    public synchronized void commitOnePhase(int identifier, long txId, int masterId) throws XAException {
        LogEntry.Start startEntry = this.xidIdentMap.get(identifier);
        assert (startEntry != null);
        assert (txId != -1L);
        try {
            LogIoUtils.writeCommit(false, this.writeBuffer, identifier, txId, masterId);
            this.writeBuffer.force();
            this.cacheTxStartPosition(txId, masterId, startEntry);
        }
        catch (IOException e) {
            throw Exceptions.withCause(new XAException("Logical log unable to mark 1P-commit [" + identifier + "] "), e);
        }
    }

    private synchronized void cacheTxStartPosition(long txId, int masterId, LogEntry.Start startEntry) {
        if (startEntry.getStartPosition() == -1L) {
            throw new RuntimeException("StartEntry.position is " + startEntry.getStartPosition());
        }
        this.txStartPositionCache.put((Long)txId, new TxPosition(this.logVersion, masterId, startEntry.getIdentifier(), startEntry.getStartPosition()));
    }

    public synchronized void done(int identifier) throws XAException {
        if (this.backupSlave) {
            return;
        }
        assert (this.xidIdentMap.get(identifier) != null);
        try {
            LogIoUtils.writeDone(this.writeBuffer, identifier);
            this.xidIdentMap.remove(identifier);
        }
        catch (IOException e) {
            throw Exceptions.withCause(new XAException("Logical log unable to mark as done [" + identifier + "] "), e);
        }
    }

    synchronized void doneInternal(int identifier) throws IOException {
        this.buffer.clear();
        LogIoUtils.writeDone(this.buffer, identifier);
        this.buffer.flip();
        this.fileChannel.write(this.buffer);
        this.xidIdentMap.remove(identifier);
        this.fileChannel.force(false);
    }

    public synchronized void commitTwoPhase(int identifier, long txId, int masterId) throws XAException {
        LogEntry.Start startEntry = this.xidIdentMap.get(identifier);
        assert (startEntry != null);
        assert (txId != -1L);
        try {
            LogIoUtils.writeCommit(true, this.writeBuffer, identifier, txId, masterId);
            this.writeBuffer.force();
            this.cacheTxStartPosition(txId, masterId, startEntry);
        }
        catch (IOException e) {
            throw Exceptions.withCause(new XAException("Logical log unable to mark 2PC [" + identifier + "] "), e);
        }
    }

    public synchronized void writeCommand(XaCommand command, int identifier) throws IOException {
        this.checkLogRotation();
        assert (this.xidIdentMap.get(identifier) != null);
        LogIoUtils.writeCommand(this.writeBuffer, identifier, command);
    }

    private void applyEntry(LogEntry entry) throws IOException {
        if (entry instanceof LogEntry.Start) {
            this.applyStartEntry((LogEntry.Start)entry);
        } else if (entry instanceof LogEntry.Prepare) {
            this.applyPrepareEntry((LogEntry.Prepare)entry);
        } else if (entry instanceof LogEntry.Command) {
            this.applyCommandEntry((LogEntry.Command)entry);
        } else if (entry instanceof LogEntry.OnePhaseCommit) {
            this.applyOnePhaseCommitEntry((LogEntry.OnePhaseCommit)entry);
        } else if (entry instanceof LogEntry.TwoPhaseCommit) {
            this.applyTwoPhaseCommitEntry((LogEntry.TwoPhaseCommit)entry);
        } else if (entry instanceof LogEntry.Done) {
            this.applyDoneEntry((LogEntry.Done)entry);
        } else {
            throw new RuntimeException("Unrecognized log entry " + entry);
        }
    }

    private void applyStartEntry(LogEntry.Start entry) throws IOException {
        int identifier = entry.getIdentifier();
        if (identifier >= this.nextIdentifier) {
            this.nextIdentifier = identifier + 1;
        }
        Xid xid = entry.getXid();
        this.xidIdentMap.put(identifier, entry);
        XaTransaction xaTx = this.xaTf.create(identifier);
        xaTx.setRecovered();
        this.recoveredTxMap.put(identifier, xaTx);
        this.xaRm.injectStart(xid, xaTx);
        this.fileChannel.force(false);
    }

    private void applyPrepareEntry(LogEntry.Prepare prepareEntry) throws IOException {
        int identifier = prepareEntry.getIdentifier();
        LogEntry.Start entry = this.xidIdentMap.get(identifier);
        if (entry == null) {
            throw new IOException("Unknown xid for identifier " + identifier);
        }
        Xid xid = entry.getXid();
        if (this.xaRm.injectPrepare(xid)) {
            this.xidIdentMap.remove(identifier);
            this.recoveredTxMap.remove(identifier);
        }
    }

    private void applyOnePhaseCommitEntry(LogEntry.OnePhaseCommit commit) throws IOException {
        int identifier = commit.getIdentifier();
        long txId = commit.getTxId();
        LogEntry.Start startEntry = this.xidIdentMap.get(identifier);
        if (startEntry == null) {
            throw new IOException("Unknown xid for identifier " + identifier);
        }
        Xid xid = startEntry.getXid();
        try {
            XaTransaction xaTx = this.xaRm.getXaTransaction(xid);
            xaTx.setCommitTxId(txId);
            this.xaRm.injectOnePhaseCommit(xid);
            this.logRecoveryMessage("Injected one phase commit, txId=" + commit.getTxId());
        }
        catch (XAException e) {
            throw new IOException(e);
        }
    }

    private void logRecoveryMessage(String string) {
        if (this.doingRecovery) {
            this.msgLog.logMessage(string, true);
        }
    }

    private void applyDoneEntry(LogEntry.Done done) throws IOException {
        int identifier = done.getIdentifier();
        LogEntry.Start entry = this.xidIdentMap.get(identifier);
        if (entry == null) {
            throw new IOException("Unknown xid for identifier " + identifier);
        }
        Xid xid = entry.getXid();
        this.xaRm.pruneXid(xid);
        this.xidIdentMap.remove(identifier);
        this.recoveredTxMap.remove(identifier);
    }

    private void applyTwoPhaseCommitEntry(LogEntry.TwoPhaseCommit commit) throws IOException {
        int identifier = commit.getIdentifier();
        long txId = commit.getTxId();
        LogEntry.Start startEntry = this.xidIdentMap.get(identifier);
        if (startEntry == null) {
            throw new IOException("Unknown xid for identifier " + identifier);
        }
        Xid xid = startEntry.getXid();
        if (xid == null) {
            throw new IOException("Xid null for identifier " + identifier);
        }
        try {
            XaTransaction xaTx = this.xaRm.getXaTransaction(xid);
            xaTx.setCommitTxId(txId);
            this.xaRm.injectTwoPhaseCommit(xid);
            this.logRecoveryMessage("Injected two phase commit, txId=" + commit.getTxId());
        }
        catch (XAException e) {
            throw new IOException(e);
        }
    }

    private void applyCommandEntry(LogEntry.Command entry) throws IOException {
        int identifier = entry.getIdentifier();
        XaCommand command = entry.getXaCommand();
        if (command == null) {
            throw new IOException("Null command for identifier " + identifier);
        }
        command.setRecovered();
        XaTransaction xaTx = this.recoveredTxMap.get(identifier);
        xaTx.injectCommand(command);
    }

    private void checkLogRotation() throws IOException {
        long firstStartEntry;
        long currentPos;
        if (this.autoRotate && this.writeBuffer.getFileChannelPosition() >= this.rotateAtSize && (currentPos = this.writeBuffer.getFileChannelPosition()) - (firstStartEntry = this.getFirstStartEntry(currentPos)) < this.rotateAtSize / 2L) {
            this.rotate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameCurrentLogFileAndIncrementVersion(String logFileName, long endPosition) throws IOException {
        File file = new File(logFileName);
        if (!file.exists()) {
            throw new IOException("Logical log[" + logFileName + "] not found");
        }
        String newName = this.getFileName(this.xaTf.getAndSetNewVersion());
        File newFile = new File(newName);
        boolean renamed = FileUtils.renameFile(file, newFile);
        if (!renamed) {
            throw new IOException("Failed to rename log to: " + newName);
        }
        AbstractInterruptibleChannel channel = null;
        try {
            channel = new RandomAccessFile(newName, "rw").getChannel();
            FileUtils.truncateFile((FileChannel)channel, endPosition);
        }
        catch (IOException e) {
            this.log.log(Level.WARNING, "Failed to truncate log at correct size", e);
        }
        finally {
            if (channel != null) {
                channel.close();
            }
        }
    }

    private void deleteCurrentLogFile(String logFileName) throws IOException {
        File file = new File(logFileName);
        if (!file.exists()) {
            throw new IOException("Logical log[" + logFileName + "] not found");
        }
        boolean deleted = FileUtils.deleteFile(file);
        if (!deleted) {
            this.log.warning("Unable to delete clean logical log[" + logFileName + "]");
        }
    }

    private void releaseCurrentLogFile() throws IOException {
        if (this.writeBuffer != null) {
            this.writeBuffer.force();
            this.writeBuffer = null;
        }
        this.fileChannel.close();
        this.fileChannel = null;
    }

    public synchronized void close() throws IOException {
        if (this.fileChannel == null || !this.fileChannel.isOpen()) {
            this.log.fine("Logical log: " + this.fileName + " already closed");
            return;
        }
        long endPosition = this.writeBuffer.getFileChannelPosition();
        if (this.xidIdentMap.size() > 0) {
            this.log.info("Close invoked with " + this.xidIdentMap.size() + " running transaction(s). ");
            this.writeBuffer.force();
            this.writeBuffer = null;
            this.fileChannel.close();
            this.log.info("Dirty log: " + this.fileName + "." + this.currentLog + " now closed. Recovery will be started automatically next " + "time it is opened.");
            return;
        }
        this.releaseCurrentLogFile();
        char logWas = this.currentLog;
        if (this.currentLog != 'C') {
            this.setActiveLog('C');
        }
        if (!this.keepLogs || this.backupSlave) {
            if (logWas == 'C') {
                this.deleteCurrentLogFile(this.fileName);
            } else {
                this.deleteCurrentLogFile(this.fileName + "." + logWas);
            }
        } else {
            this.renameCurrentLogFileAndIncrementVersion(this.fileName + "." + logWas, endPosition);
        }
        this.msgLog.logMessage("Closed log " + this.fileName, true);
    }

    private long[] readAndAssertLogHeader(ByteBuffer buffer, ReadableByteChannel channel, long expectedVersion) throws IOException {
        long[] header = LogIoUtils.readLogHeader(buffer, channel, true);
        if (header[0] != expectedVersion) {
            throw new IOException("Wrong version in log. Expected " + expectedVersion + ", but got " + header[0]);
        }
        return header;
    }

    StringLogger getStringLogger() {
        return this.msgLog;
    }

    private void doInternalRecovery(String logFileName) throws IOException {
        LogEntry entry;
        long lastCommittedTx;
        this.log.info("Non clean shutdown detected on log [" + logFileName + "]. Recovery started ...");
        this.msgLog.logMessage("Non clean shutdown detected on log [" + logFileName + "]. Recovery started ...", true);
        long[] header = this.readLogHeader(this.fileChannel, "Tried to do recovery on log with illegal format version");
        if (header == null) {
            this.log.info("Unable to read header information, no records in logical log.");
            this.msgLog.logMessage("No log version found for " + logFileName, true);
            this.fileChannel.close();
            boolean success = FileUtils.renameFile(new File(logFileName), new File(logFileName + "_unknown_timestamp_" + System.currentTimeMillis() + ".log"));
            assert (success);
            this.fileChannel.close();
            this.fileChannel = new RandomAccessFile(logFileName, "rw").getChannel();
            return;
        }
        this.logVersion = header[0];
        this.previousLogLastCommittedTx = lastCommittedTx = header[1];
        this.log.fine("Logical log version: " + this.logVersion + " with committed tx[" + lastCommittedTx + "]");
        this.msgLog.logMessage("[" + logFileName + "] logVersion=" + this.logVersion + " with committed tx=" + lastCommittedTx, true);
        long logEntriesFound = 0L;
        long lastEntryPos = this.fileChannel.position();
        this.fileChannel = new BufferedFileChannel(this.fileChannel);
        while ((entry = this.readEntry()) != null) {
            this.applyEntry(entry);
            ++logEntriesFound;
            lastEntryPos = this.fileChannel.position();
        }
        this.fileChannel = ((BufferedFileChannel)this.fileChannel).getSource();
        this.fileChannel.position(lastEntryPos);
        this.msgLog.logMessage("[" + logFileName + "] entries found=" + logEntriesFound + " lastEntryPos=" + lastEntryPos, true);
        this.buffer.clear();
        while (this.buffer.hasRemaining()) {
            this.buffer.put((byte)0);
        }
        this.buffer.flip();
        long endPosition = this.fileChannel.size();
        do {
            long bytesLeft;
            if ((bytesLeft = this.fileChannel.size() - this.fileChannel.position()) < (long)this.buffer.capacity()) {
                this.buffer.limit((int)bytesLeft);
            }
            this.fileChannel.write(this.buffer);
            this.buffer.flip();
        } while (this.fileChannel.position() < endPosition);
        this.fileChannel.position(lastEntryPos);
        this.scanIsComplete = true;
        this.log.fine("Internal recovery completed, scanned " + logEntriesFound + " log entries.");
        this.xaRm.checkXids();
        if (this.xidIdentMap.size() == 0) {
            this.log.fine("Recovery completed.");
            this.msgLog.logMessage("Recovery on log [" + logFileName + "] completed.");
        } else {
            this.log.fine("[" + logFileName + "] Found " + this.xidIdentMap.size() + " prepared 2PC transactions.");
            this.msgLog.logMessage("Recovery on log [" + logFileName + "] completed with " + this.xidIdentMap + " prepared transactions found.");
            for (LogEntry.Start startEntry : this.xidIdentMap.values()) {
                this.log.fine("[" + logFileName + "] 2PC xid[" + startEntry.getXid() + "]");
            }
        }
        this.recoveredTxMap.clear();
    }

    void reset() {
        this.xidIdentMap.clear();
        this.recoveredTxMap.clear();
    }

    private LogEntry readEntry() throws IOException {
        long position = this.fileChannel.position();
        LogEntry entry = LogIoUtils.readEntry(this.buffer, this.fileChannel, this.cf);
        if (entry instanceof LogEntry.Start) {
            ((LogEntry.Start)entry).setStartPosition(position);
        }
        return entry;
    }

    void registerTxIdentifier(int identifier) {
        this.txIdentMap.put(Thread.currentThread(), identifier);
    }

    void unregisterTxIdentifier() {
        this.txIdentMap.remove(Thread.currentThread());
    }

    public int getCurrentTxIdentifier() {
        Integer intValue = this.txIdentMap.get(Thread.currentThread());
        if (intValue != null) {
            return intValue;
        }
        return -1;
    }

    public ReadableByteChannel getLogicalLog(long version) throws IOException {
        return this.getLogicalLog(version, 0L);
    }

    public ReadableByteChannel getLogicalLog(long version, long position) throws IOException {
        String name = this.getFileName(version);
        if (!new File(name).exists()) {
            throw new IOException("No such log version:" + version);
        }
        FileChannel channel = new RandomAccessFile(name, "r").getChannel();
        channel.position(position);
        return channel;
    }

    private void extractPreparedTransactionFromLog(int identifier, FileChannel log, LogBuffer targetBuffer) throws IOException {
        LogEntry entry;
        LogEntry.Start startEntry = this.xidIdentMap.get(identifier);
        log.position(startEntry.getStartPosition());
        boolean found = false;
        while ((entry = LogIoUtils.readEntry(this.buffer, log, this.cf)) != null) {
            if (entry.getIdentifier() != identifier) continue;
            if (entry instanceof LogEntry.Prepare) break;
            if (entry instanceof LogEntry.Start || entry instanceof LogEntry.Command) {
                LogIoUtils.writeLogEntry(entry, targetBuffer);
                found = true;
                continue;
            }
            throw new RuntimeException("Expected start or command entry but found: " + entry);
        }
        if (!found) {
            throw new IOException("Transaction for internal identifier[" + identifier + "] not found in current log");
        }
    }

    private LogEntry.Commit extractTransactionFromLog(long txId, long expectedVersion, ReadableByteChannel log, LogBuffer targetBuffer) throws IOException {
        LogEntry entry;
        HashMap transactions = new HashMap();
        TxPosition txPosition = this.txStartPositionCache.get(txId);
        LogEntryCollector collector = txPosition != null ? new KnownIdentifierCollector(txPosition.identifier, targetBuffer) : new KnownTxIdCollector(txId, targetBuffer);
        LogEntry.Commit commitEntry = null;
        while ((entry = LogIoUtils.readEntry(this.buffer, log, this.cf)) != null && commitEntry == null) {
            if (!collector.collect(entry) || !(entry instanceof LogEntry.Commit)) continue;
            commitEntry = (LogEntry.Commit)entry;
        }
        if (commitEntry == null) {
            this.msgLog.logMessage("txId=" + txId + " not found in log=" + expectedVersion, true);
            throw new IOException("Transaction[" + txId + "] not found in log (" + expectedVersion + ") " + "current version is (" + this.logVersion + ")");
        }
        if (targetBuffer != null) {
            LogIoUtils.writeLogEntry(new LogEntry.Done(collector.getIdentifier()), targetBuffer);
        }
        return commitEntry;
    }

    private void assertLogCanContainTx(long txId, long prevTxId) throws IOException {
        if (prevTxId >= txId) {
            throw new IOException("Log says " + txId + " can not exist in this log (prev tx id=" + prevTxId + ")");
        }
    }

    public synchronized ReadableByteChannel getPreparedTransaction(int identifier) throws IOException {
        FileChannel log = (FileChannel)this.getLogicalLogOrMyself(this.logVersion, 0L);
        InMemoryLogBuffer buffer = new InMemoryLogBuffer();
        this.extractPreparedTransactionFromLog(identifier, log, buffer);
        log.close();
        return buffer;
    }

    private ReadableByteChannel wrapInMemoryLogEntryRepresentation(List<LogEntry> entries) throws IOException {
        InMemoryLogBuffer buffer = new InMemoryLogBuffer();
        for (LogEntry entry : entries) {
            LogIoUtils.writeLogEntry(entry, buffer);
        }
        return buffer;
    }

    public synchronized void getPreparedTransaction(int identifier, LogBuffer targetBuffer) throws IOException {
        FileChannel log = (FileChannel)this.getLogicalLogOrMyself(this.logVersion, 0L);
        this.extractPreparedTransactionFromLog(identifier, log, targetBuffer);
        log.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogEntry.Commit extractLogEntryList(long txId, LogBuffer targetBuffer) throws IOException {
        long version = 0L;
        Channel log = null;
        TxPosition txPosition = this.txStartPositionCache.get(txId);
        try {
            if (txPosition != null) {
                version = txPosition.version;
                log = this.getLogicalLogOrMyself(version, txPosition.position);
            } else {
                version = this.findLogContainingTxId(txId)[0];
                if (version == -1L) {
                    throw new RuntimeException("txId:" + txId + " not found in any logical log " + "(starting at " + this.logVersion + " and searching backwards");
                }
                log = this.getLogicalLogOrMyself(version, 0L);
                long[] header = this.readAndAssertLogHeader(this.buffer, (ReadableByteChannel)log, version);
                long prevTxId = header[1];
                this.assertLogCanContainTx(txId, prevTxId);
            }
            LogEntry.Commit commit = this.extractTransactionFromLog(txId, version, (ReadableByteChannel)log, targetBuffer);
            return commit;
        }
        finally {
            if (log != null) {
                log.close();
            }
        }
    }

    public synchronized ReadableByteChannel getCommittedTransaction(long txId) throws IOException {
        InMemoryLogBuffer target = new InMemoryLogBuffer();
        this.extractLogEntryList(txId, target);
        return target;
    }

    public synchronized void getCommittedTransaction(long txId, LogBuffer buffer) throws IOException {
        this.extractLogEntryList(txId, buffer);
    }

    public synchronized int getMasterIdForCommittedTransaction(long txId) throws IOException {
        if (txId == 1L) {
            return -1;
        }
        TxPosition cache = this.txStartPositionCache.get(txId);
        if (cache != null) {
            return cache.masterId;
        }
        LogEntry.Commit commitEntry = this.extractLogEntryList(txId, null);
        if (commitEntry != null) {
            return commitEntry.getMasterId();
        }
        throw new RuntimeException("Unable to find commit entry in for txId[" + txId + "]");
    }

    private ReadableByteChannel getLogicalLogOrMyself(long version, long position) throws IOException {
        if (version < this.logVersion) {
            return this.getLogicalLog(version, position);
        }
        if (version == this.logVersion) {
            String currentLogName = this.getCurrentLogFileName();
            FileChannel channel = new RandomAccessFile(currentLogName, "r").getChannel();
            channel = this.logBufferFactory.combine(channel, this.writeBuffer);
            channel.position(position);
            return channel;
        }
        throw new RuntimeException("Version[" + version + "] is higher then current log version[" + this.logVersion + "]");
    }

    private String getCurrentLogFileName() {
        return this.currentLog == '1' ? this.getLog1FileName() : this.getLog2FileName();
    }

    private long[] findLogContainingTxId(long txId) throws IOException {
        long version;
        long committedTx = this.previousLogLastCommittedTx;
        for (version = this.logVersion; version >= 0L; --version) {
            ReadableByteChannel log = this.getLogicalLogOrMyself(version, 0L);
            ByteBuffer buf = ByteBuffer.allocate(16);
            long[] header = this.readAndAssertLogHeader(buf, log, version);
            committedTx = header[1];
            log.close();
            if (committedTx < txId) break;
        }
        return new long[]{version, committedTx};
    }

    public long getLogicalLogLength(long version) {
        File file = new File(this.getFileName(version));
        return file.exists() ? file.length() : -1L;
    }

    public boolean hasLogicalLog(long version) {
        return new File(this.getFileName(version)).exists();
    }

    public boolean deleteLogicalLog(long version) {
        File file = new File(this.getFileName(version));
        return file.exists() ? FileUtils.deleteFile(file) : false;
    }

    public void makeBackupSlave() {
        if (this.xidIdentMap.size() > 0) {
            throw new IllegalStateException("There are active transactions");
        }
        this.backupSlave = true;
    }

    private long[] readLogHeader(ReadableByteChannel source, String message) throws IOException {
        try {
            return LogIoUtils.readLogHeader(this.buffer, source, true);
        }
        catch (IllegalLogFormatException e) {
            this.msgLog.logMessage(message, e);
            throw e;
        }
    }

    public synchronized void applyLog(ReadableByteChannel byteChannel) throws IOException {
        if (!this.backupSlave) {
            throw new IllegalStateException("This is not a backup slave");
        }
        if (this.xidIdentMap.size() > 0) {
            throw new IllegalStateException("There are active transactions");
        }
        long[] header = this.readLogHeader(byteChannel, "Tried to apply log with illegal log format");
        this.logVersion = header[0];
        long previousCommittedTx = header[1];
        if (this.logVersion != this.xaTf.getCurrentVersion()) {
            throw new IllegalStateException("Tried to apply version " + this.logVersion + " but expected version " + this.xaTf.getCurrentVersion());
        }
        this.log.fine("Logical log version: " + this.logVersion + "(previous committed tx=" + previousCommittedTx + ")");
        this.msgLog.logMessage("Applying log version=" + this.logVersion + " (previous committed tx=" + previousCommittedTx + ")", true);
        long logEntriesFound = 0L;
        LogApplier logApplier = new LogApplier(byteChannel);
        this.scanIsComplete = false;
        this.scanIsComplete = false;
        while (logApplier.readAndApplyEntry()) {
            ++logEntriesFound;
        }
        this.scanIsComplete = true;
        byteChannel.close();
        this.xaTf.flushAll();
        this.xaTf.getAndSetNewVersion();
        this.xaRm.reset();
        this.msgLog.logMessage("Apply of log version=" + this.logVersion + " successfull, " + logEntriesFound + " nr of log entries found.", true);
        this.log.info("Log[" + this.fileName + "] version " + this.logVersion + " applied successfully.");
    }

    public synchronized void applyTransactionWithoutTxId(ReadableByteChannel byteChannel, long nextTxId, int masterId) throws IOException {
        if (nextTxId != this.xaTf.getLastCommittedTx() + 1L) {
            throw new IllegalStateException("Tried to apply tx " + nextTxId + " but expected transaction " + (this.xaTf.getCurrentVersion() + 1L));
        }
        this.msgLog.logMessage("applyTxWithoutTxId log version: " + this.logVersion + ", committing tx=" + nextTxId + ") @ pos " + this.writeBuffer.getFileChannelPosition(), true);
        long logEntriesFound = 0L;
        this.scanIsComplete = false;
        LogApplier logApplier = new LogApplier(byteChannel);
        int xidIdent = this.getNextIdentifier();
        long startEntryPosition = this.writeBuffer.getFileChannelPosition();
        while (logApplier.readAndWriteAndApplyEntry(xidIdent)) {
            ++logEntriesFound;
        }
        byteChannel.close();
        LogEntry.Start startEntry = logApplier.startEntry;
        if (startEntry == null) {
            throw new IOException("Unable to find start entry");
        }
        startEntry.setStartPosition(startEntryPosition);
        LogEntry.OnePhaseCommit commit = new LogEntry.OnePhaseCommit(xidIdent, nextTxId, masterId);
        LogIoUtils.writeLogEntry(commit, this.writeBuffer);
        Xid xid = startEntry.getXid();
        try {
            XaTransaction xaTx = this.xaRm.getXaTransaction(xid);
            xaTx.setCommitTxId(nextTxId);
            this.xaRm.commit(xid, true);
            LogEntry.Done doneEntry = new LogEntry.Done(startEntry.getIdentifier());
            LogIoUtils.writeLogEntry(doneEntry, this.writeBuffer);
            this.xidIdentMap.remove(startEntry.getIdentifier());
            this.recoveredTxMap.remove(startEntry.getIdentifier());
            this.cacheTxStartPosition(nextTxId, masterId, startEntry);
        }
        catch (XAException e) {
            throw new IOException(e);
        }
        this.scanIsComplete = true;
        this.msgLog.logMessage("Applied external tx and generated tx id=" + nextTxId, true);
    }

    public synchronized void applyTransaction(ReadableByteChannel byteChannel) throws IOException {
        long logEntriesFound = 0L;
        this.scanIsComplete = false;
        LogApplier logApplier = new LogApplier(byteChannel);
        int xidIdent = this.getNextIdentifier();
        long startEntryPosition = this.writeBuffer.getFileChannelPosition();
        while (logApplier.readAndWriteAndApplyEntry(xidIdent)) {
            ++logEntriesFound;
        }
        byteChannel.close();
        this.scanIsComplete = true;
        LogEntry.Start startEntry = logApplier.startEntry;
        if (startEntry == null) {
            throw new IOException("Unable to find start entry");
        }
        startEntry.setStartPosition(startEntryPosition);
        this.cacheTxStartPosition(logApplier.commitEntry.getTxId(), logApplier.commitEntry.getMasterId(), startEntry);
    }

    private String getLog1FileName() {
        return this.fileName + ".1";
    }

    private String getLog2FileName() {
        return this.fileName + ".2";
    }

    public synchronized void rotate() throws IOException {
        LogEntry entry;
        this.xaTf.flushAll();
        String newLogFile = this.getLog2FileName();
        String currentLogFile = this.getLog1FileName();
        char newActiveLog = '2';
        long currentVersion = this.xaTf.getCurrentVersion();
        String oldCopy = this.getFileName(currentVersion);
        if (this.currentLog == 'C' || this.currentLog == '2') {
            newActiveLog = '1';
            newLogFile = this.getLog1FileName();
            currentLogFile = this.getLog2FileName();
        } else assert (this.currentLog == '1');
        this.assertFileDoesntExist(newLogFile, "New log file");
        this.assertFileDoesntExist(oldCopy, "Copy log file");
        this.msgLog.logMessage("Rotating [" + currentLogFile + "] @ version=" + currentVersion + " to " + newLogFile + "from position " + this.writeBuffer.getFileChannelPosition(), true);
        long endPosition = this.writeBuffer.getFileChannelPosition();
        this.writeBuffer.force();
        FileChannel newLog = new RandomAccessFile(newLogFile, "rw").getChannel();
        long lastTx = this.xaTf.getLastCommittedTx();
        LogIoUtils.writeLogHeader(this.buffer, currentVersion + 1L, lastTx);
        this.previousLogLastCommittedTx = lastTx;
        if (newLog.write(this.buffer) != 16) {
            throw new IOException("Unable to write log version to new");
        }
        long pos = this.fileChannel.position();
        this.fileChannel.position(0L);
        this.readAndAssertLogHeader(this.buffer, this.fileChannel, currentVersion);
        this.fileChannel.position(pos);
        if (this.xidIdentMap.size() > 0) {
            long firstEntryPosition = this.getFirstStartEntry(endPosition);
            this.fileChannel.position(firstEntryPosition);
            this.msgLog.logMessage("Rotate log first start entry @ pos=" + firstEntryPosition);
        }
        LogBuffer newLogBuffer = this.instantiateCorrectWriteBuffer(newLog);
        while ((entry = LogIoUtils.readEntry(this.buffer, this.fileChannel, this.cf)) != null) {
            LogEntry.Start startEntry;
            if (this.xidIdentMap.get(entry.getIdentifier()) == null) continue;
            if (entry instanceof LogEntry.Start) {
                startEntry = (LogEntry.Start)entry;
                startEntry.setStartPosition(newLog.position());
                this.xidIdentMap.put(startEntry.getIdentifier(), startEntry);
            } else if (entry instanceof LogEntry.Commit) {
                startEntry = this.xidIdentMap.get(entry.getIdentifier());
                LogEntry.Commit commitEntry = (LogEntry.Commit)entry;
                this.cacheTxStartPosition(commitEntry.getTxId(), commitEntry.getMasterId(), startEntry);
                this.msgLog.logMessage("Updated tx " + ((LogEntry.Commit)entry).getTxId() + " with " + startEntry.getStartPosition());
            }
            LogIoUtils.writeLogEntry(entry, newLogBuffer);
        }
        newLogBuffer.force();
        newLog.position(newLogBuffer.getFileChannelPosition());
        this.msgLog.logMessage("Rotate: old log scanned, newLog @ pos=" + newLog.position(), true);
        newLog.force(false);
        this.releaseCurrentLogFile();
        this.setActiveLog(newActiveLog);
        if (this.keepLogs) {
            this.renameCurrentLogFileAndIncrementVersion(currentLogFile, endPosition);
        } else {
            this.deleteCurrentLogFile(currentLogFile);
            this.xaTf.getAndSetNewVersion();
        }
        this.logVersion = this.xaTf.getCurrentVersion();
        if (this.xaTf.getCurrentVersion() != currentVersion + 1L) {
            throw new IOException("version change failed");
        }
        this.fileChannel = newLog;
        this.instantiateCorrectWriteBuffer();
        this.msgLog.logMessage("Log rotated, newLog @ pos=" + this.writeBuffer.getFileChannelPosition() + " and version " + this.logVersion, true);
    }

    private void assertFileDoesntExist(String file, String description) throws IOException {
        if (new File(file).exists()) {
            throw new IOException(description + ": " + file + " already exist");
        }
    }

    private long getFirstStartEntry(long endPosition) {
        long firstEntryPosition = endPosition;
        for (LogEntry.Start entry : this.xidIdentMap.values()) {
            if (entry.getStartPosition() >= firstEntryPosition) continue;
            assert (entry.getStartPosition() > 0L);
            firstEntryPosition = entry.getStartPosition();
        }
        return firstEntryPosition;
    }

    private void setActiveLog(char c) throws IOException {
        if (c != 'C' && c != '1' && c != '2') {
            throw new IllegalArgumentException("Log must be either clean, 1 or 2");
        }
        if (c == this.currentLog) {
            throw new IllegalStateException("Log should not be equal to current " + this.currentLog);
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[4]);
        bb.asCharBuffer().put(c).flip();
        FileChannel fc = new RandomAccessFile(this.fileName + ".active", "rw").getChannel();
        int wrote = fc.write(bb);
        if (wrote != 4) {
            throw new IllegalStateException("Expected to write 4 -> " + wrote);
        }
        fc.force(false);
        fc.close();
        this.currentLog = c;
    }

    public void setKeepLogs(boolean keep) {
        this.keepLogs = keep;
    }

    public boolean isLogsKept() {
        return this.keepLogs;
    }

    public void setAutoRotateLogs(boolean autoRotate) {
        this.autoRotate = autoRotate;
    }

    public boolean isLogsAutoRotated() {
        return this.autoRotate;
    }

    public void setLogicalLogTargetSize(long size) {
        this.rotateAtSize = size;
    }

    public long getLogicalLogTargetSize() {
        return this.rotateAtSize;
    }

    public String getFileName(long version) {
        return this.fileName + ".v" + version;
    }

    public boolean wasNonClean() {
        return this.nonCleanShutdown;
    }

    private static class KnownTxIdCollector
    implements LogEntryCollector {
        private final Map<Integer, List<LogEntry>> transactions = new HashMap<Integer, List<LogEntry>>();
        private final long txId;
        private final LogBuffer target;
        private int identifier;

        KnownTxIdCollector(long txId, LogBuffer target) {
            this.txId = txId;
            this.target = target;
        }

        @Override
        public int getIdentifier() {
            return this.identifier;
        }

        @Override
        public boolean collect(LogEntry entry) throws IOException {
            boolean interesting = false;
            if (entry instanceof LogEntry.Start) {
                LinkedList<LogEntry> list = new LinkedList<LogEntry>();
                list.add(entry);
                this.transactions.put(entry.getIdentifier(), list);
            } else if (entry instanceof LogEntry.Commit) {
                if (((LogEntry.Commit)entry).getTxId() == this.txId) {
                    interesting = true;
                    this.identifier = entry.getIdentifier();
                    List<LogEntry> entries = this.transactions.get(this.identifier);
                    entries.add(entry);
                    this.writeToBuffer(entries);
                }
            } else if (entry instanceof LogEntry.Command || entry instanceof LogEntry.Prepare) {
                List<LogEntry> list = this.transactions.get(entry.getIdentifier());
                if (list != null) {
                    list.add(entry);
                }
            } else if (entry instanceof LogEntry.Done) {
                this.transactions.remove(entry.getIdentifier());
            } else {
                throw new RuntimeException("Unknown entry: " + entry);
            }
            return interesting;
        }

        private void writeToBuffer(List<LogEntry> entries) throws IOException {
            if (this.target != null) {
                for (LogEntry entry : entries) {
                    LogIoUtils.writeLogEntry(entry, this.target);
                }
            }
        }
    }

    private static class KnownIdentifierCollector
    implements LogEntryCollector {
        private final int identifier;
        private final LogBuffer target;

        KnownIdentifierCollector(int identifier, LogBuffer target) {
            this.identifier = identifier;
            this.target = target;
        }

        @Override
        public int getIdentifier() {
            return this.identifier;
        }

        @Override
        public boolean collect(LogEntry entry) throws IOException {
            if (entry.getIdentifier() == this.identifier) {
                if (this.target != null) {
                    LogIoUtils.writeLogEntry(entry, this.target);
                }
                return true;
            }
            return false;
        }
    }

    private static interface LogEntryCollector {
        public boolean collect(LogEntry var1) throws IOException;

        public int getIdentifier();
    }

    private static class TxPosition {
        final long version;
        final int masterId;
        final int identifier;
        final long position;

        private TxPosition(long version, int masterId, int identifier, long position) {
            this.version = version;
            this.masterId = masterId;
            this.identifier = identifier;
            this.position = position;
        }
    }

    private class LogApplier {
        private final ReadableByteChannel byteChannel;
        private LogEntry.Start startEntry;
        private LogEntry.Commit commitEntry;

        LogApplier(ReadableByteChannel byteChannel) {
            this.byteChannel = byteChannel;
        }

        boolean readAndApplyEntry() throws IOException {
            LogEntry entry = LogIoUtils.readEntry(XaLogicalLog.this.buffer, this.byteChannel, XaLogicalLog.this.cf);
            if (entry != null) {
                XaLogicalLog.this.applyEntry(entry);
            }
            return entry != null;
        }

        boolean readAndWriteAndApplyEntry(int newXidIdentifier) throws IOException {
            LogEntry entry = LogIoUtils.readEntry(XaLogicalLog.this.buffer, this.byteChannel, XaLogicalLog.this.cf);
            if (entry != null) {
                entry.setIdentifier(newXidIdentifier);
                if (entry instanceof LogEntry.Commit) {
                    this.commitEntry = (LogEntry.Commit)entry;
                } else if (entry instanceof LogEntry.Start) {
                    this.startEntry = (LogEntry.Start)entry;
                }
                LogIoUtils.writeLogEntry(entry, XaLogicalLog.this.writeBuffer);
                XaLogicalLog.this.applyEntry(entry);
                return true;
            }
            return false;
        }
    }
}

