/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.IllegalStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;

public class PropertyIndexStore
extends AbstractStore
implements Store {
    private static final String VERSION = "PropertyIndex v0.9.9";
    private static final int KEY_STORE_BLOCK_SIZE = 30;
    private static final int RECORD_SIZE = 9;
    private DynamicStringStore keyPropertyStore;

    public PropertyIndexStore(String fileName, Map<?, ?> config) {
        super(fileName, config, IdType.PROPERTY_INDEX);
    }

    @Override
    protected void initStorage() {
        this.keyPropertyStore = new DynamicStringStore(this.getStorageFileName() + ".keys", this.getConfig(), IdType.PROPERTY_INDEX_BLOCK);
    }

    @Override
    public String getTypeAndVersionDescriptor() {
        return VERSION;
    }

    @Override
    public int getRecordSize() {
        return 9;
    }

    @Override
    protected void setRecovered() {
        super.setRecovered();
        this.keyPropertyStore.setRecovered();
    }

    @Override
    protected void unsetRecovered() {
        super.unsetRecovered();
        this.keyPropertyStore.unsetRecovered();
    }

    @Override
    public void makeStoreOk() {
        this.keyPropertyStore.makeStoreOk();
        super.makeStoreOk();
    }

    @Override
    public void rebuildIdGenerators() {
        this.keyPropertyStore.rebuildIdGenerators();
        super.rebuildIdGenerators();
    }

    public void updateIdGenerators() {
        this.keyPropertyStore.updateHighId();
        this.updateHighId();
    }

    public void freeBlockId(int id) {
        this.keyPropertyStore.freeBlockId(id);
    }

    @Override
    protected void closeStorage() {
        if (this.keyPropertyStore != null) {
            this.keyPropertyStore.close();
            this.keyPropertyStore = null;
        }
    }

    @Override
    public void flushAll() {
        this.keyPropertyStore.flushAll();
        super.flushAll();
    }

    public static void createStore(String fileName, IdGeneratorFactory idGeneratorFactory) {
        PropertyIndexStore.createEmptyStore(fileName, VERSION, idGeneratorFactory);
        DynamicStringStore.createStore(fileName + ".keys", 30, idGeneratorFactory, IdType.PROPERTY_INDEX_BLOCK);
    }

    public PropertyIndexData[] getPropertyIndexes(int count) {
        LinkedList<PropertyIndexData> indexList = new LinkedList<PropertyIndexData>();
        long maxIdInUse = this.getHighestPossibleIdInUse();
        int found = 0;
        int i = 0;
        while ((long)i <= maxIdInUse && found < count) {
            block3: {
                PropertyIndexRecord record;
                try {
                    record = this.getRecord(i);
                }
                catch (InvalidRecordException t) {
                    break block3;
                }
                ++found;
                indexList.add(new PropertyIndexData(record.getId(), this.getStringFor(record)));
            }
            ++i;
        }
        return indexList.toArray(new PropertyIndexData[indexList.size()]);
    }

    public PropertyIndexData getPropertyIndex(int id) {
        PropertyIndexRecord record = this.getRecord(id);
        return new PropertyIndexData(record.getId(), this.getStringFor(record));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyIndexData getPropertyIndex(int id, boolean recovered) {
        assert (recovered);
        try {
            this.setRecovered();
            PropertyIndexRecord record = this.getRecord(id);
            PropertyIndexData propertyIndexData = new PropertyIndexData(record.getId(), this.getStringFor(record));
            return propertyIndexData;
        }
        finally {
            this.unsetRecovered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyIndexRecord getRecord(int id) {
        PropertyIndexRecord record;
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            record = this.getRecord(id, window);
        }
        finally {
            this.releaseWindow(window);
        }
        Collection<DynamicRecord> keyRecords = this.keyPropertyStore.getLightRecords(record.getKeyBlockId());
        for (DynamicRecord keyRecord : keyRecords) {
            record.addKeyRecord(keyRecord);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyIndexRecord getLightRecord(int id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            PropertyIndexRecord record = this.getRecord(id, window);
            record.setIsLight(true);
            PropertyIndexRecord propertyIndexRecord = record;
            return propertyIndexRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(PropertyIndexRecord record, boolean recovered) {
        assert (recovered);
        this.setRecovered();
        try {
            this.updateRecord(record);
            this.registerIdFromUpdateRecord(record.getId());
        }
        finally {
            this.unsetRecovered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(PropertyIndexRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window);
        }
        finally {
            this.releaseWindow(window);
        }
        if (!record.isLight()) {
            for (DynamicRecord keyRecord : record.getKeyRecords()) {
                this.keyPropertyStore.updateRecord(keyRecord);
            }
        }
    }

    public Collection<DynamicRecord> allocateKeyRecords(int keyBlockId, char[] chars) {
        return this.keyPropertyStore.allocateRecords((long)keyBlockId, chars);
    }

    public int nextKeyBlockId() {
        return (int)this.keyPropertyStore.nextBlockId();
    }

    private PropertyIndexRecord getRecord(int id, PersistenceWindow window) {
        boolean inUse;
        Buffer buffer = window.getOffsettedBuffer(id);
        boolean bl = inUse = buffer.get() == Record.IN_USE.byteValue();
        if (!inUse) {
            throw new InvalidRecordException("Record[" + id + "] not in use");
        }
        PropertyIndexRecord record = new PropertyIndexRecord(id);
        record.setInUse(inUse);
        record.setPropertyCount(buffer.getInt());
        record.setKeyBlockId(buffer.getInt());
        return record;
    }

    private void updateRecord(PropertyIndexRecord record, PersistenceWindow window) {
        int id = record.getId();
        Buffer buffer = window.getOffsettedBuffer(id);
        if (record.inUse()) {
            buffer.put(Record.IN_USE.byteValue()).putInt(record.getPropertyCount()).putInt(record.getKeyBlockId());
        } else {
            buffer.put(Record.NOT_IN_USE.byteValue());
            if (!this.isInRecoveryMode()) {
                this.freeId(id);
            }
        }
    }

    public void makeHeavy(PropertyIndexRecord record) {
        record.setIsLight(false);
        Collection<DynamicRecord> keyRecords = this.keyPropertyStore.getRecords(record.getKeyBlockId());
        for (DynamicRecord keyRecord : keyRecords) {
            record.addKeyRecord(keyRecord);
        }
    }

    public String getStringFor(PropertyIndexRecord propRecord) {
        int recordToFind = propRecord.getKeyBlockId();
        Iterator<DynamicRecord> records = propRecord.getKeyRecords().iterator();
        LinkedList<char[]> charList = new LinkedList<char[]>();
        int totalSize = 0;
        while (recordToFind != Record.NO_NEXT_BLOCK.intValue() && records.hasNext()) {
            DynamicRecord record = records.next();
            if (!record.inUse() || record.getId() != (long)recordToFind) continue;
            if (record.isLight()) {
                this.keyPropertyStore.makeHeavy(record);
            }
            if (!record.isCharData()) {
                ByteBuffer buf = ByteBuffer.wrap(record.getData());
                char[] chars = new char[record.getData().length / 2];
                totalSize += chars.length;
                buf.asCharBuffer().get(chars);
                charList.add(chars);
            } else {
                charList.add(record.getDataAsChar());
            }
            recordToFind = (int)record.getNextBlock();
            records = propRecord.getKeyRecords().iterator();
        }
        StringBuilder buf = new StringBuilder();
        for (char[] str : charList) {
            buf.append(str);
        }
        return buf.toString();
    }

    public String toString() {
        return "PropertyIndexStore";
    }

    @Override
    protected boolean versionFound(String version) {
        if (!version.startsWith("PropertyIndex")) {
            return false;
        }
        if (version.equals("PropertyIndex v0.9.5")) {
            return true;
        }
        throw new IllegalStoreVersionException("Store version [" + version + "]. Please make sure you are not running old Neo4j kernel " + " towards a store that has been created by newer version " + " of Neo4j.");
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.add(this.keyPropertyStore.getWindowPoolStats());
        list.add(this.getWindowPoolStats());
        return list;
    }
}

