/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import org.neo4j.kernel.impl.nioneo.store.PropertyData;

public class PropertyDatas {
    public static PropertyData forBoolean(int index, long id, boolean value) {
        return new BooleanPropertyData(index, id, value);
    }

    public static PropertyData forByte(int index, long id, byte value) {
        return new BytePropertyData(index, id, value);
    }

    public static PropertyData forShort(int index, long id, short value) {
        return new ShortPropertyData(index, id, value);
    }

    public static PropertyData forChar(int index, long id, char value) {
        return new CharPropertyData(index, id, value);
    }

    public static PropertyData forInt(int index, long id, int value) {
        return value < LowIntPropertyData.LIMIT ? new LowIntPropertyData(index, id, value) : new IntPropertyData(index, id, value);
    }

    public static PropertyData forLong(int index, long id, long value) {
        return value < LowLongPropertyData.LIMIT ? new LowLongPropertyData(index, id, value) : new LongPropertyData(index, id, value);
    }

    public static PropertyData forFloat(int index, long id, float value) {
        return new FloatPropertyData(index, id, value);
    }

    public static PropertyData forDouble(int index, long id, double value) {
        return new DoublePropertyData(index, id, value);
    }

    public static PropertyData forStringOrArray(int index, long id, Object value) {
        return new ObjectPropertyData(index, id, value);
    }

    private static class ObjectPropertyData
    implements PropertyData {
        private final long id;
        private Object value;
        private final int index;

        public ObjectPropertyData(int index, long id, Object value) {
            this.index = index;
            this.id = id;
            this.value = value;
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setNewValue(Object newValue) {
            this.value = newValue;
        }
    }

    private static class DoublePropertyData
    extends PrimitivePropertyData {
        private final long id;
        private final double value;

        private DoublePropertyData(int index, long id, double value) {
            super(index);
            this.id = id;
            this.value = value;
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    private static class FloatPropertyData
    extends PrimitivePropertyData {
        private final long id;
        private final float value;

        private FloatPropertyData(int index, long id, float value) {
            super(index);
            this.id = id;
            this.value = value;
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.value);
        }
    }

    private static class LongPropertyData
    extends PrimitivePropertyData {
        private final long id;
        private final long value;

        private LongPropertyData(int index, long id, long value) {
            super(index);
            this.id = id;
            this.value = value;
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    private static class LowLongPropertyData
    extends PrimitivePropertyData {
        private static final long LIMIT = (long)Math.pow(2.0, 28.0);
        private final long idAndValue;

        private LowLongPropertyData(int index, long id, long value) {
            super(index);
            this.idAndValue = id | value << 36;
        }

        @Override
        public long getId() {
            return this.idAndValue & 0xFFFFFFFFFL;
        }

        @Override
        public Object getValue() {
            return (this.idAndValue & 0xFFFFFFF000000000L) >> 36;
        }
    }

    private static class IntPropertyData
    extends PrimitivePropertyData {
        private final long id;
        private final int value;

        private IntPropertyData(int index, long id, int value) {
            super(index);
            this.id = id;
            this.value = value;
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    private static class LowIntPropertyData
    extends PrimitivePropertyData {
        private static final int LIMIT = (int)Math.pow(2.0, 28.0);
        private final long idAndValue;

        private LowIntPropertyData(int index, long id, int value) {
            super(index);
            this.idAndValue = id | (long)value << 36;
        }

        @Override
        public long getId() {
            return this.idAndValue & 0xFFFFFFFFFL;
        }

        @Override
        public Object getValue() {
            return (int)((this.idAndValue & 0xFFFFFFF000000000L) >> 36);
        }
    }

    private static class CharPropertyData
    extends PrimitivePropertyData {
        private final long idAndValue;

        private CharPropertyData(int index, long id, char value) {
            super(index);
            this.idAndValue = id | (long)value << 48;
        }

        @Override
        public long getId() {
            return this.idAndValue & 0xFFFFFFFFFFFFL;
        }

        @Override
        public Object getValue() {
            return Character.valueOf((char)((this.idAndValue & 0xFFFF000000000000L) >> 48));
        }
    }

    private static class ShortPropertyData
    extends PrimitivePropertyData {
        private final long idAndValue;

        private ShortPropertyData(int index, long id, short value) {
            super(index);
            this.idAndValue = id | (long)value << 48;
        }

        @Override
        public long getId() {
            return this.idAndValue & 0xFFFFFFFFFFFFL;
        }

        @Override
        public Object getValue() {
            return (short)((this.idAndValue & 0xFFFF000000000000L) >> 48);
        }
    }

    private static class BytePropertyData
    extends PrimitivePropertyData {
        private final long idAndValue;

        private BytePropertyData(int index, long id, byte value) {
            super(index);
            this.idAndValue = id | (long)value << 56;
        }

        @Override
        public long getId() {
            return this.idAndValue & 0xFFFFFFFFFFFFFFL;
        }

        @Override
        public Object getValue() {
            return (byte)((this.idAndValue & 0xFF00000000000000L) >> 56);
        }
    }

    private static class BooleanPropertyData
    extends PrimitivePropertyData {
        private final long idAndValue;

        private BooleanPropertyData(int index, long id, boolean value) {
            super(index);
            this.idAndValue = id | (long)(value ? 1 : 0) << 63;
        }

        @Override
        public long getId() {
            return this.idAndValue & Long.MAX_VALUE;
        }

        @Override
        public Object getValue() {
            return (this.idAndValue & Long.MIN_VALUE) != 0L;
        }
    }

    private static abstract class PrimitivePropertyData
    implements PropertyData {
        private final int index;

        PrimitivePropertyData(int index) {
            this.index = index;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void setNewValue(Object newValue) {
            throw new IllegalStateException("This shouldn't be called, only valid on String/array types");
        }
    }
}

