/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.IllegalStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;

class DynamicArrayStore
extends AbstractDynamicStore {
    private static final String VERSION = "ArrayPropertyStore v0.9.9";

    public DynamicArrayStore(String fileName, Map<?, ?> config, IdType idType) {
        super(fileName, config, idType);
    }

    @Override
    public String getTypeAndVersionDescriptor() {
        return VERSION;
    }

    public static void createStore(String fileName, int blockSize, IdGeneratorFactory idGeneratorFactory) {
        DynamicArrayStore.createEmptyStore(fileName, blockSize, VERSION, idGeneratorFactory, IdType.ARRAY_BLOCK);
    }

    private Collection<DynamicRecord> allocateFromInt(long startBlock, int[] array) {
        int size = array.length * 4 + 1;
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.INT.byteValue());
        for (int i : array) {
            buf.putInt(i);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    private Collection<DynamicRecord> allocateFromInt(long startBlock, Integer[] array) {
        int size = array.length * 4 + 1;
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.INT.byteValue());
        Integer[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int i = arr$[i$];
            buf.putInt(i);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    private Collection<DynamicRecord> allocateFromShort(long startBlock, short[] array) {
        int size = array.length * 2 + 1;
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.SHORT.byteValue());
        for (short i : array) {
            buf.putShort(i);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    private Collection<DynamicRecord> allocateFromShort(long startBlock, Short[] array) {
        int size = array.length * 2 + 1;
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.SHORT.byteValue());
        Short[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            short i = arr$[i$];
            buf.putShort(i);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    private Collection<DynamicRecord> allocateFromString(long startBlock, String[] array) {
        int size = 5;
        for (String str : array) {
            size += 4 + str.length() * 2;
        }
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.STRING.byteValue());
        buf.putInt(array.length);
        for (String str : array) {
            int length = str.length();
            char[] chars = new char[length];
            str.getChars(0, length, chars, 0);
            buf.putInt(length * 2);
            for (char c : chars) {
                buf.putChar(c);
            }
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    private Collection<DynamicRecord> allocateFromBool(long startBlock, boolean[] array) {
        int size = 5 + array.length / 8;
        if (array.length % 8 > 0) {
            ++size;
        }
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.BOOL.byteValue());
        buf.putInt(array.length);
        byte currentValue = 0;
        int byteItr = 0;
        for (boolean b : array) {
            if (b) {
                currentValue = (byte)(currentValue + (1 << byteItr));
            }
            if (++byteItr != 8) continue;
            buf.put(currentValue);
            byteItr = 0;
            currentValue = 0;
        }
        if (byteItr != 0) {
            buf.put(currentValue);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    private Collection<DynamicRecord> allocateFromBool(long startBlock, Boolean[] array) {
        int size = 5 + array.length / 8;
        if (array.length % 8 > 0) {
            ++size;
        }
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.BOOL.byteValue());
        buf.putInt(array.length);
        byte currentValue = 0;
        int byteItr = 0;
        for (Boolean b : array) {
            if (b.booleanValue()) {
                currentValue = (byte)(currentValue + (1 << byteItr));
            }
            if (++byteItr != 8) continue;
            buf.put(currentValue);
            byteItr = 0;
            currentValue = 0;
        }
        if (byteItr != 0) {
            buf.put(currentValue);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    private Collection<DynamicRecord> allocateFromDouble(long startBlock, double[] array) {
        int size = array.length * 8 + 1;
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.DOUBLE.byteValue());
        for (double d : array) {
            buf.putDouble(d);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    private Collection<DynamicRecord> allocateFromDouble(long startBlock, Double[] array) {
        int size = array.length * 8 + 1;
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.DOUBLE.byteValue());
        Double[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double d = arr$[i$];
            buf.putDouble(d);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    private Collection<DynamicRecord> allocateFromFloat(long startBlock, float[] array) {
        int size = array.length * 4 + 1;
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.FLOAT.byteValue());
        for (float f : array) {
            buf.putFloat(f);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    private Collection<DynamicRecord> allocateFromFloat(long startBlock, Float[] array) {
        int size = array.length * 4 + 1;
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.FLOAT.byteValue());
        Float[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            float f = arr$[i$].floatValue();
            buf.putFloat(f);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    private Collection<DynamicRecord> allocateFromLong(long startBlock, long[] array) {
        int size = array.length * 8 + 1;
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.LONG.byteValue());
        for (long l : array) {
            buf.putLong(l);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    private Collection<DynamicRecord> allocateFromLong(long startBlock, Long[] array) {
        int size = array.length * 8 + 1;
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.LONG.byteValue());
        Long[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            long l = arr$[i$];
            buf.putLong(l);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    private Collection<DynamicRecord> allocateFromByte(long startBlock, byte[] array) {
        int size = array.length + 1;
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.BYTE.byteValue());
        buf.put(array);
        return this.allocateRecords(startBlock, buf.array());
    }

    private Collection<DynamicRecord> allocateFromByte(long startBlock, Byte[] array) {
        int size = array.length + 1;
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.BYTE.byteValue());
        Byte[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte b = arr$[i$];
            buf.put(b);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    private Collection<DynamicRecord> allocateFromChar(long startBlock, char[] array) {
        int size = array.length * 2 + 1;
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.CHAR.byteValue());
        for (char c : array) {
            buf.putChar(c);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    private Collection<DynamicRecord> allocateFromChar(long startBlock, Character[] array) {
        int size = array.length * 2 + 1;
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(ArrayType.CHAR.byteValue());
        Character[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            char c = arr$[i$].charValue();
            buf.putChar(c);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    public Collection<DynamicRecord> allocateRecords(long startBlock, Object array) {
        if (array instanceof int[]) {
            return this.allocateFromInt(startBlock, (int[])array);
        }
        if (array instanceof Integer[]) {
            return this.allocateFromInt(startBlock, (Integer[])array);
        }
        if (array instanceof String[]) {
            return this.allocateFromString(startBlock, (String[])array);
        }
        if (array instanceof boolean[]) {
            return this.allocateFromBool(startBlock, (boolean[])array);
        }
        if (array instanceof Boolean[]) {
            return this.allocateFromBool(startBlock, (Boolean[])array);
        }
        if (array instanceof double[]) {
            return this.allocateFromDouble(startBlock, (double[])array);
        }
        if (array instanceof Double[]) {
            return this.allocateFromDouble(startBlock, (Double[])array);
        }
        if (array instanceof float[]) {
            return this.allocateFromFloat(startBlock, (float[])array);
        }
        if (array instanceof Float[]) {
            return this.allocateFromFloat(startBlock, (Float[])array);
        }
        if (array instanceof long[]) {
            return this.allocateFromLong(startBlock, (long[])array);
        }
        if (array instanceof Long[]) {
            return this.allocateFromLong(startBlock, (Long[])array);
        }
        if (array instanceof byte[]) {
            return this.allocateFromByte(startBlock, (byte[])array);
        }
        if (array instanceof Byte[]) {
            return this.allocateFromByte(startBlock, (Byte[])array);
        }
        if (array instanceof char[]) {
            return this.allocateFromChar(startBlock, (char[])array);
        }
        if (array instanceof Character[]) {
            return this.allocateFromChar(startBlock, (Character[])array);
        }
        if (array instanceof short[]) {
            return this.allocateFromShort(startBlock, (short[])array);
        }
        if (array instanceof Short[]) {
            return this.allocateFromShort(startBlock, (Short[])array);
        }
        throw new IllegalArgumentException(array + " not a valid array type.");
    }

    public Object getRightArray(byte[] bArray) {
        ByteBuffer buf = ByteBuffer.wrap(bArray);
        byte type = buf.get();
        if (type == ArrayType.INT.byteValue()) {
            int size = (bArray.length - 1) / 4;
            assert ((bArray.length - 1) % 4 == 0);
            int[] array = new int[size];
            for (int i = 0; i < size; ++i) {
                array[i] = buf.getInt();
            }
            return array;
        }
        if (type == ArrayType.STRING.byteValue()) {
            String[] array = new String[buf.getInt()];
            for (int i = 0; i < array.length; ++i) {
                int charLength = buf.getInt() / 2;
                char[] charBuffer = new char[charLength];
                for (int j = 0; j < charLength; ++j) {
                    charBuffer[j] = buf.getChar();
                }
                array[i] = new String(charBuffer);
            }
            return array;
        }
        if (type == ArrayType.BOOL.byteValue()) {
            boolean[] array = new boolean[buf.getInt()];
            int byteItr = 1;
            byte currentValue = buf.get();
            for (int i = 0; i < array.length; ++i) {
                boolean bl = array[i] = (currentValue & byteItr) > 0;
                if ((byteItr *= 2) != 256) continue;
                byteItr = 0;
                currentValue = buf.get();
            }
            return array;
        }
        if (type == ArrayType.DOUBLE.byteValue()) {
            int size = (bArray.length - 1) / 8;
            assert ((bArray.length - 1) % 8 == 0);
            double[] array = new double[size];
            for (int i = 0; i < size; ++i) {
                array[i] = buf.getDouble();
            }
            return array;
        }
        if (type == ArrayType.FLOAT.byteValue()) {
            int size = (bArray.length - 1) / 4;
            assert ((bArray.length - 1) % 4 == 0);
            float[] array = new float[size];
            for (int i = 0; i < size; ++i) {
                array[i] = buf.getFloat();
            }
            return array;
        }
        if (type == ArrayType.LONG.byteValue()) {
            int size = (bArray.length - 1) / 8;
            assert ((bArray.length - 1) % 8 == 0);
            long[] array = new long[size];
            for (int i = 0; i < size; ++i) {
                array[i] = buf.getLong();
            }
            return array;
        }
        if (type == ArrayType.BYTE.byteValue()) {
            int size = bArray.length - 1;
            byte[] array = new byte[size];
            buf.get(array);
            return array;
        }
        if (type == ArrayType.CHAR.byteValue()) {
            int size = (bArray.length - 1) / 2;
            assert ((bArray.length - 1) % 2 == 0);
            char[] array = new char[size];
            for (int i = 0; i < size; ++i) {
                array[i] = buf.getChar();
            }
            return array;
        }
        if (type == ArrayType.SHORT.byteValue()) {
            int size = (bArray.length - 1) / 2;
            assert ((bArray.length - 1) % 2 == 0);
            short[] array = new short[size];
            for (int i = 0; i < size; i = (int)((short)(i + 1))) {
                array[i] = buf.getShort();
            }
            return array;
        }
        throw new InvalidRecordException("Unknown array type[" + type + "]");
    }

    @Override
    protected boolean versionFound(String version) {
        if (!version.startsWith("ArrayPropertyStore")) {
            return false;
        }
        if (version.equals("ArrayPropertyStore v0.9.5")) {
            long blockSize = this.getBlockSize();
            if (blockSize > 65548L) {
                throw new IllegalStoreVersionException("Store version[" + version + "] has " + (blockSize - 13L) + " block size " + "(limit is " + 65535 + ") and can not be upgraded to a newer version.");
            }
            return true;
        }
        throw new IllegalStoreVersionException("Store version [" + version + "]. Please make sure you are not running old Neo4j kernel " + " towards a store that has been created by newer version " + " of Neo4j.");
    }

    private static enum ArrayType {
        ILLEGAL(0),
        INT(1),
        STRING(2),
        BOOL(3),
        DOUBLE(4),
        FLOAT(5),
        LONG(6),
        BYTE(7),
        CHAR(8),
        SHORT(10);

        private int type;

        private ArrayType(int type) {
            this.type = type;
        }

        public byte byteValue() {
            return (byte)this.type;
        }
    }
}

