/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.core.IntArrayIterator;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.core.RelTypeElement;
import org.neo4j.kernel.impl.core.RelTypeElementIterator;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.traversal.OldTraverserWrapper;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;

class NodeImpl
extends Primitive {
    private static final RelIdArray[] NO_RELATIONSHIPS = new RelIdArray[0];
    private volatile RelIdArray[] relationships;
    private long relChainPosition = Record.NO_NEXT_RELATIONSHIP.intValue();
    private long id;

    NodeImpl(long id) {
        this(id, false);
    }

    NodeImpl(long id, boolean newNode) {
        super(newNode);
        this.id = id;
        if (newNode) {
            this.relationships = NO_RELATIONSHIPS;
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public int hashCode() {
        return (int)(this.id >>> 32 ^ this.id);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof NodeImpl && ((NodeImpl)obj).id == this.id;
    }

    @Override
    protected PropertyData changeProperty(NodeManager nodeManager, long propertyId, Object value) {
        return nodeManager.nodeChangeProperty(this, propertyId, value);
    }

    @Override
    protected PropertyData addProperty(NodeManager nodeManager, PropertyIndex index, Object value) {
        return nodeManager.nodeAddProperty(this, index, value);
    }

    @Override
    protected void removeProperty(NodeManager nodeManager, long propertyId) {
        nodeManager.nodeRemoveProperty(this, propertyId);
    }

    @Override
    protected ArrayMap<Integer, PropertyData> loadProperties(NodeManager nodeManager, boolean light) {
        return nodeManager.loadProperties(this, light);
    }

    List<RelTypeElementIterator> getAllRelationships(NodeManager nodeManager, RelIdArray.DirectionWrapper direction) {
        this.ensureRelationshipMapNotNull(nodeManager);
        LinkedList<RelTypeElementIterator> relTypeList = new LinkedList<RelTypeElementIterator>();
        boolean hasModifications = nodeManager.getLockReleaser().hasRelationshipModifications(this);
        ArrayMap<String, RelIdArray> addMap = null;
        if (hasModifications) {
            addMap = nodeManager.getCowRelationshipAddMap(this);
        }
        for (RelIdArray src : this.relationships) {
            String type = src.getType();
            RelIdArray remove = null;
            RelIdArray add = null;
            if (hasModifications) {
                remove = nodeManager.getCowRelationshipRemoveMap(this, type);
                if (addMap != null) {
                    add = addMap.get(type);
                }
            }
            relTypeList.add(RelTypeElement.create(type, this, src, add, remove, direction));
        }
        if (addMap != null) {
            for (String type : addMap.keySet()) {
                if (this.getRelIdArray(type) != null) continue;
                RelIdArray remove = nodeManager.getCowRelationshipRemoveMap(this, type);
                RelIdArray add = addMap.get(type);
                relTypeList.add(RelTypeElement.create(type, this, null, add, remove, direction));
            }
        }
        return relTypeList;
    }

    List<RelTypeElementIterator> getAllRelationshipsOfType(NodeManager nodeManager, RelIdArray.DirectionWrapper direction, RelationshipType ... types) {
        this.ensureRelationshipMapNotNull(nodeManager);
        LinkedList<RelTypeElementIterator> relTypeList = new LinkedList<RelTypeElementIterator>();
        boolean hasModifications = nodeManager.getLockReleaser().hasRelationshipModifications(this);
        for (RelationshipType type : types) {
            RelIdArray src = this.getRelIdArray(type.name());
            RelIdArray remove = null;
            RelIdArray add = null;
            if (hasModifications) {
                remove = nodeManager.getCowRelationshipRemoveMap(this, type.name());
                add = nodeManager.getCowRelationshipAddMap(this, type.name());
            }
            relTypeList.add(RelTypeElement.create(type.name(), this, src, add, remove, direction));
        }
        return relTypeList;
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager) {
        return new IntArrayIterator(this.getAllRelationships(nodeManager, RelIdArray.DirectionWrapper.BOTH), this, RelIdArray.DirectionWrapper.BOTH, nodeManager, new RelationshipType[0]);
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, Direction dir) {
        RelIdArray.DirectionWrapper direction = RelIdArray.wrap(dir);
        return new IntArrayIterator(this.getAllRelationships(nodeManager, direction), this, direction, nodeManager, new RelationshipType[0]);
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, RelationshipType type) {
        RelationshipType[] types = new RelationshipType[]{type};
        return new IntArrayIterator(this.getAllRelationshipsOfType(nodeManager, RelIdArray.DirectionWrapper.BOTH, types), this, RelIdArray.DirectionWrapper.BOTH, nodeManager, types);
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, RelationshipType ... types) {
        return new IntArrayIterator(this.getAllRelationshipsOfType(nodeManager, RelIdArray.DirectionWrapper.BOTH, types), this, RelIdArray.DirectionWrapper.BOTH, nodeManager, types);
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, Direction direction, RelationshipType ... types) {
        RelIdArray.DirectionWrapper dir = RelIdArray.wrap(direction);
        return new IntArrayIterator(this.getAllRelationshipsOfType(nodeManager, dir, types), this, dir, nodeManager, types);
    }

    public Relationship getSingleRelationship(NodeManager nodeManager, RelationshipType type, Direction dir) {
        RelIdArray.DirectionWrapper direction = RelIdArray.wrap(dir);
        RelationshipType[] types = new RelationshipType[]{type};
        IntArrayIterator rels = new IntArrayIterator(this.getAllRelationshipsOfType(nodeManager, direction, types), this, direction, nodeManager, types);
        if (!rels.hasNext()) {
            return null;
        }
        Relationship rel = (Relationship)rels.next();
        if (rels.hasNext()) {
            throw new NotFoundException("More than one relationship[" + type + ", " + (Object)((Object)dir) + "] found for " + this);
        }
        return rel;
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, RelationshipType type, Direction dir) {
        RelationshipType[] types = new RelationshipType[]{type};
        RelIdArray.DirectionWrapper direction = RelIdArray.wrap(dir);
        return new IntArrayIterator(this.getAllRelationshipsOfType(nodeManager, direction, types), this, direction, nodeManager, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(NodeManager nodeManager) {
        nodeManager.acquireLock(this, LockType.WRITE);
        boolean success = false;
        try {
            ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this, true);
            ArrayMap<Integer, PropertyData> removedProps = nodeManager.deleteNode(this);
            if (removedProps.size() > 0) {
                for (int index : removedProps.keySet()) {
                    skipMap.put(index, removedProps.get(index));
                }
            }
            success = true;
        }
        finally {
            nodeManager.releaseLock(this, LockType.WRITE);
            if (!success) {
                nodeManager.setRollbackOnly();
            }
        }
    }

    public String toString() {
        return "NodeImpl#" + this.getId();
    }

    void addRelationship(NodeManager nodeManager, RelationshipType type, long relId, RelIdArray.DirectionWrapper dir) {
        RelIdArray relationshipSet = nodeManager.getCowRelationshipAddMap(this, type.name(), true);
        relationshipSet.add(relId, dir);
    }

    void removeRelationship(NodeManager nodeManager, RelationshipType type, long relId) {
        RelIdArray relationshipSet = nodeManager.getCowRelationshipRemoveMap(this, type.name(), true);
        relationshipSet.add(relId, RelIdArray.DirectionWrapper.OUTGOING);
    }

    private void ensureRelationshipMapNotNull(NodeManager nodeManager) {
        if (this.relationships == null) {
            this.loadInitialRelationships(nodeManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInitialRelationships(NodeManager nodeManager) {
        Map<Long, RelationshipImpl> map = null;
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            if (this.relationships == null) {
                this.relChainPosition = nodeManager.getRelationshipChainPosition(this);
                ArrayMap<String, RelIdArray> tmpRelMap = new ArrayMap<String, RelIdArray>();
                map = this.getMoreRelationships(nodeManager, tmpRelMap);
                this.relationships = this.toRelIdArray(tmpRelMap);
            }
        }
        if (map != null) {
            nodeManager.putAllInRelCache(map);
        }
    }

    private RelIdArray[] toRelIdArray(ArrayMap<String, RelIdArray> tmpRelMap) {
        if (tmpRelMap == null || tmpRelMap.size() == 0) {
            return NO_RELATIONSHIPS;
        }
        RelIdArray[] result = new RelIdArray[tmpRelMap.size()];
        int i = 0;
        for (RelIdArray array : tmpRelMap.values()) {
            result[i++] = array.shrink();
        }
        return result;
    }

    private Map<Long, RelationshipImpl> getMoreRelationships(NodeManager nodeManager, ArrayMap<String, RelIdArray> tmpRelMap) {
        if (!this.hasMoreRelationshipsToLoad()) {
            return null;
        }
        Pair<ArrayMap<String, RelIdArray>, Map<Long, RelationshipImpl>> pair = nodeManager.getMoreRelationships(this);
        ArrayMap<String, RelIdArray> addMap = pair.first();
        if (addMap.size() == 0) {
            return null;
        }
        for (String type : addMap.keySet()) {
            RelIdArray addRels = addMap.get(type);
            RelIdArray srcRels = tmpRelMap.get(type);
            if (srcRels == null) {
                tmpRelMap.put(type, addRels);
                continue;
            }
            RelIdArray newSrcRels = srcRels.addAll(addRels);
            if (newSrcRels == srcRels) continue;
            tmpRelMap.put(type, newSrcRels);
        }
        return pair.other();
    }

    private boolean hasMoreRelationshipsToLoad() {
        return this.relChainPosition != (long)Record.NO_NEXT_RELATIONSHIP.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getMoreRelationships(NodeManager nodeManager) {
        Pair<ArrayMap<String, RelIdArray>, Map<Long, RelationshipImpl>> pair;
        if (!this.hasMoreRelationshipsToLoad()) {
            return false;
        }
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            if (!this.hasMoreRelationshipsToLoad()) {
                return false;
            }
            pair = nodeManager.getMoreRelationships(this);
            ArrayMap<String, RelIdArray> addMap = pair.first();
            if (addMap.size() == 0) {
                return false;
            }
            for (String type : addMap.keySet()) {
                RelIdArray addRels = addMap.get(type);
                RelIdArray srcRels = this.getRelIdArray(type);
                if (srcRels == null) {
                    this.putRelIdArray(addRels);
                    continue;
                }
                RelIdArray newSrcRels = srcRels.addAll(addRels);
                if (newSrcRels == srcRels) continue;
                this.putRelIdArray(newSrcRels);
            }
        }
        nodeManager.putAllInRelCache(pair.other());
        return true;
    }

    private RelIdArray getRelIdArray(String type) {
        for (RelIdArray array : this.relationships) {
            if (!array.getType().equals(type)) continue;
            return array;
        }
        return null;
    }

    private void putRelIdArray(RelIdArray addRels) {
        RelIdArray[] newArray;
        String expectedType = addRels.getType();
        RelIdArray[] safeRelationships = this.relationships;
        boolean stay = true;
        block0: while (stay) {
            stay = false;
            for (int i = 0; i < safeRelationships.length; ++i) {
                if (!safeRelationships[i].getType().equals(expectedType)) continue;
                if (this.relationships == safeRelationships) {
                    safeRelationships[i] = addRels;
                    return;
                }
                stay = true;
                safeRelationships = this.relationships;
                continue block0;
            }
        }
        while (true) {
            newArray = new RelIdArray[safeRelationships.length + 1];
            System.arraycopy(safeRelationships, 0, newArray, 0, safeRelationships.length);
            newArray[safeRelationships.length] = addRels;
            if (this.relationships == safeRelationships) break;
            safeRelationships = this.relationships;
        }
        this.relationships = newArray;
    }

    public Relationship createRelationshipTo(NodeManager nodeManager, Node otherNode, RelationshipType type) {
        return nodeManager.createRelationship(this, otherNode, type);
    }

    public Traverser traverse(NodeManager nodeManager, Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
        return OldTraverserWrapper.traverse(new NodeProxy(this.id, nodeManager), traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{relationshipType, direction});
    }

    public Traverser traverse(NodeManager nodeManager, Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
        return OldTraverserWrapper.traverse(new NodeProxy(this.id, nodeManager), traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{firstRelationshipType, firstDirection, secondRelationshipType, secondDirection});
    }

    public Traverser traverse(NodeManager nodeManager, Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        return OldTraverserWrapper.traverse(new NodeProxy(this.id, nodeManager), traversalOrder, stopEvaluator, returnableEvaluator, relationshipTypesAndDirections);
    }

    public boolean hasRelationship(NodeManager nodeManager) {
        return this.getRelationships(nodeManager).iterator().hasNext();
    }

    public boolean hasRelationship(NodeManager nodeManager, RelationshipType ... types) {
        return this.getRelationships(nodeManager, types).iterator().hasNext();
    }

    public boolean hasRelationship(NodeManager nodeManager, Direction direction, RelationshipType ... types) {
        return this.getRelationships(nodeManager, direction, types).iterator().hasNext();
    }

    public boolean hasRelationship(NodeManager nodeManager, Direction dir) {
        return this.getRelationships(nodeManager, dir).iterator().hasNext();
    }

    public boolean hasRelationship(NodeManager nodeManager, RelationshipType type, Direction dir) {
        return this.getRelationships(nodeManager, type, dir).iterator().hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitRelationshipMaps(ArrayMap<String, RelIdArray> cowRelationshipAddMap, ArrayMap<String, RelIdArray> cowRelationshipRemoveMap) {
        if (this.relationships == null) {
            return;
        }
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            RelIdArray remove;
            if (cowRelationshipAddMap != null) {
                for (String type : cowRelationshipAddMap.keySet()) {
                    RelIdArray add = cowRelationshipAddMap.get(type);
                    remove = null;
                    if (cowRelationshipRemoveMap != null) {
                        remove = cowRelationshipRemoveMap.get(type);
                    }
                    RelIdArray src = this.getRelIdArray(type);
                    this.putRelIdArray(RelIdArray.from(src, add, remove));
                }
            }
            if (cowRelationshipRemoveMap != null) {
                for (String type : cowRelationshipRemoveMap.keySet()) {
                    if (cowRelationshipAddMap != null && cowRelationshipAddMap.get(type) != null) continue;
                    RelIdArray src = this.getRelIdArray(type);
                    remove = cowRelationshipRemoveMap.get(type);
                    this.putRelIdArray(RelIdArray.from(src, null, remove));
                }
            }
        }
    }

    long getRelChainPosition() {
        return this.relChainPosition;
    }

    void setRelChainPosition(long position) {
        this.relChainPosition = position;
    }

    RelIdArray getRelationshipIds(String type) {
        return this.getRelIdArray(type);
    }

    RelIdArray[] getRelationshipIds() {
        return this.relationships;
    }
}

