/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.lang.reflect.InvocationTargetException;

public class Exceptions {
    public static <T extends Throwable> T withCause(T exception, Throwable cause) {
        try {
            exception.initCause(cause);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return exception;
    }

    public static RuntimeException launderedException(Throwable exception) {
        return Exceptions.launderedException("Unexpected Exception", exception);
    }

    public static RuntimeException launderedException(String messageForUnexpected, Throwable exception) {
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        if (exception instanceof InvocationTargetException) {
            return Exceptions.launderedException(messageForUnexpected, ((InvocationTargetException)exception).getTargetException());
        }
        return new RuntimeException(messageForUnexpected, exception);
    }

    private Exceptions() {
    }
}

