/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.neo4j.graphdb.Direction;

public class RelIdArray {
    private static final DirectionWrapper[] DIRECTIONS_FOR_OUTGOING = new DirectionWrapper[]{DirectionWrapper.OUTGOING, DirectionWrapper.BOTH};
    private static final DirectionWrapper[] DIRECTIONS_FOR_INCOMING = new DirectionWrapper[]{DirectionWrapper.INCOMING, DirectionWrapper.BOTH};
    private static final DirectionWrapper[] DIRECTIONS_FOR_BOTH = new DirectionWrapper[]{DirectionWrapper.OUTGOING, DirectionWrapper.INCOMING, DirectionWrapper.BOTH};
    public static final RelIdArray EMPTY = new RelIdArray(){
        private RelIdIterator emptyIterator = new RelIdIterator(null, new DirectionWrapper[0]){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            protected boolean nextBlock() {
                return false;
            }

            @Override
            public void doAnotherRound() {
            }
        };

        @Override
        public RelIdIterator iterator(DirectionWrapper direction) {
            return this.emptyIterator;
        }
    };
    private IdBlock lastOutBlock;
    private IdBlock lastInBlock;
    private IdBlock lastLoopBlock;
    public static final IdBlock EMPTY_BLOCK = new LowIdBlock(DirectionWrapper.BOTH){

        @Override
        int length() {
            return 0;
        }
    };

    public void add(long id, DirectionWrapper direction) {
        IdBlock lastBlock = direction.lastBlock(this);
        long highBits = id & 0xFFFFFFFF00000000L;
        if (lastBlock == null || lastBlock.getHighBits() != highBits) {
            IdBlock newLastBlock = highBits == 0L ? new LowIdBlock(direction) : new HighIdBlock(direction, highBits);
            newLastBlock.prev = lastBlock;
            direction.assignTopLevelBlock(this, newLastBlock);
            lastBlock = newLastBlock;
        }
        lastBlock.add((int)id);
    }

    public void addAll(RelIdArray source) {
        if (source == null) {
            return;
        }
        if (source.lastOutBlock != null) {
            if (this.lastOutBlock == null) {
                this.lastOutBlock = source.lastOutBlock.copy();
            } else if (this.lastOutBlock.getHighBits() == source.lastOutBlock.getHighBits()) {
                this.lastOutBlock.addAll(source.lastOutBlock);
                if (source.lastOutBlock.prev != null) {
                    RelIdArray.last(this.lastOutBlock).prev = source.lastOutBlock.prev.copy();
                }
            } else {
                RelIdArray.last(this.lastOutBlock).prev = source.lastOutBlock.copy();
            }
        }
        if (source.lastInBlock != null) {
            if (this.lastInBlock == null) {
                this.lastInBlock = source.lastInBlock.copy();
            } else if (this.lastInBlock.getHighBits() == source.lastInBlock.getHighBits()) {
                this.lastInBlock.addAll(source.lastInBlock);
                if (source.lastInBlock.prev != null) {
                    RelIdArray.last(this.lastInBlock).prev = source.lastInBlock.prev.copy();
                }
            } else {
                RelIdArray.last(this.lastInBlock).prev = source.lastInBlock.copy();
            }
        }
        if (source.lastLoopBlock != null) {
            if (this.lastLoopBlock == null) {
                this.lastLoopBlock = source.lastLoopBlock.copy();
            } else if (this.lastLoopBlock.getHighBits() == source.lastLoopBlock.getHighBits()) {
                this.lastLoopBlock.addAll(source.lastLoopBlock);
                if (source.lastLoopBlock.prev != null) {
                    RelIdArray.last(this.lastLoopBlock).prev = source.lastLoopBlock.prev.copy();
                }
            } else {
                RelIdArray.last(this.lastLoopBlock).prev = source.lastLoopBlock.copy();
            }
        }
    }

    private static IdBlock last(IdBlock block) {
        while (block.prev != null) {
            block = block.prev;
        }
        return block;
    }

    public boolean isEmpty() {
        return this.lastOutBlock == null && this.lastInBlock == null;
    }

    public RelIdIterator iterator(DirectionWrapper direction) {
        return direction.iterator(this);
    }

    public static DirectionWrapper wrap(Direction direction) {
        switch (direction) {
            case OUTGOING: {
                return DirectionWrapper.OUTGOING;
            }
            case INCOMING: {
                return DirectionWrapper.INCOMING;
            }
            case BOTH: {
                return DirectionWrapper.BOTH;
            }
        }
        throw new IllegalArgumentException("" + (Object)((Object)direction));
    }

    public static RelIdArray from(RelIdArray src, RelIdArray add, RelIdArray remove) {
        if (remove == null) {
            if (src == null) {
                return add;
            }
            if (add != null) {
                RelIdArray newArray = new RelIdArray();
                newArray.addAll(src);
                newArray.addAll(add);
                return newArray;
            }
            return src;
        }
        if (src == null && add == null) {
            return null;
        }
        RelIdArray newArray = new RelIdArray();
        newArray.addAll(src);
        Set<Long> removedSet = remove.asSet();
        RelIdArray.evictExcluded(newArray, removedSet);
        if (add != null) {
            RelIdIterator fromIterator = add.iterator(DirectionWrapper.BOTH);
            while (fromIterator.hasNext()) {
                long value = fromIterator.next();
                if (removedSet.contains(value)) continue;
                newArray.add(value, fromIterator.currentDirection);
            }
        }
        return newArray;
    }

    private static void evictExcluded(RelIdArray ids, Set<Long> excluded) {
        RelIdIterator iterator = DirectionWrapper.BOTH.iterator(ids);
        while (iterator.hasNext()) {
            long value = iterator.next();
            if (!excluded.contains(value)) continue;
            boolean swapSuccessful = false;
            IteratorState state = iterator.currentState;
            IdBlock block = state.block;
            for (int j = block.length - 1; j >= state.relativePosition; --j) {
                long backValue = block.get(j);
                block.length--;
                if (excluded.contains(backValue)) continue;
                block.set(backValue, state.relativePosition - 1);
                swapSuccessful = true;
                break;
            }
            if (swapSuccessful) continue;
            block.length--;
        }
    }

    private Set<Long> asSet() {
        HashSet<Long> set = new HashSet<Long>();
        RelIdIterator iterator = DirectionWrapper.BOTH.iterator(this);
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static class RelIdIterator {
        private final DirectionWrapper[] directions;
        private int directionPosition = -1;
        private DirectionWrapper currentDirection;
        private IteratorState currentState;
        private final IteratorState[] states;
        private long nextElement;
        private boolean nextElementDetermined;
        private final RelIdArray ids;

        RelIdIterator(RelIdArray ids, DirectionWrapper[] directions) {
            this.ids = ids;
            this.directions = directions;
            this.states = new IteratorState[directions.length];
            IdBlock block = null;
            while (block == null && this.directionPosition + 1 < directions.length) {
                this.currentDirection = directions[++this.directionPosition];
                block = this.currentDirection.lastBlock(ids);
            }
            if (block != null) {
                this.states[this.directionPosition] = this.currentState = new IteratorState(block, 0);
            }
        }

        public boolean hasNext() {
            if (this.nextElementDetermined) {
                return this.nextElement != -1L;
            }
            do {
                if (this.currentState == null || !this.currentState.hasNext()) continue;
                this.nextElement = this.currentState.next();
                this.nextElementDetermined = true;
                return true;
            } while (this.nextBlock());
            this.nextElementDetermined = false;
            this.nextElement = -1L;
            return false;
        }

        protected boolean nextBlock() {
            if (this.currentState != null && this.currentState.nextBlock()) {
                return true;
            }
            return this.findNextBlock();
        }

        public void doAnotherRound() {
            this.directionPosition = -1;
            this.findNextBlock();
        }

        protected boolean findNextBlock() {
            while (this.directionPosition + 1 < this.directions.length) {
                this.currentDirection = this.directions[++this.directionPosition];
                IteratorState nextState = this.states[this.directionPosition];
                if (nextState != null) {
                    this.currentState = nextState;
                    return true;
                }
                IdBlock block = this.currentDirection.lastBlock(this.ids);
                if (block == null) continue;
                this.states[this.directionPosition] = this.currentState = new IteratorState(block, 0);
                return true;
            }
            return false;
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextElementDetermined = false;
            return this.nextElement;
        }
    }

    private static class IteratorState {
        private IdBlock block;
        private int relativePosition;
        private int absolutePosition;

        public IteratorState(IdBlock block, int relativePosition) {
            this.block = block;
            this.relativePosition = relativePosition;
        }

        boolean nextBlock() {
            if (this.block.prev != null) {
                this.block = this.block.prev;
                this.relativePosition = 0;
                return true;
            }
            return false;
        }

        boolean hasNext() {
            return this.relativePosition < this.block.length;
        }

        long next() {
            ++this.absolutePosition;
            return this.block.get(this.relativePosition++);
        }
    }

    private static class HighIdBlock
    extends IdBlock {
        private final long highBits;

        HighIdBlock(DirectionWrapper dir, long highBits) {
            super(dir);
            this.highBits = highBits;
        }

        @Override
        long transform(int id) {
            return (long)id & 0xFFFFFFFFL | this.highBits;
        }

        @Override
        protected IdBlock copyInstance() {
            return new HighIdBlock(this.tempDirRemoveThisLater, this.highBits);
        }

        @Override
        long getHighBits() {
            return this.highBits;
        }
    }

    private static class LowIdBlock
    extends IdBlock {
        public LowIdBlock(DirectionWrapper dir) {
            super(dir);
        }

        @Override
        long transform(int id) {
            return (long)id & 0xFFFFFFFFL;
        }

        @Override
        protected IdBlock copyInstance() {
            return new LowIdBlock(this.tempDirRemoveThisLater);
        }

        @Override
        long getHighBits() {
            return 0L;
        }
    }

    public static abstract class IdBlock {
        protected DirectionWrapper tempDirRemoveThisLater;
        private int[] ids = new int[2];
        private int length;
        private IdBlock prev;

        public IdBlock(DirectionWrapper dir) {
            this.tempDirRemoveThisLater = dir;
        }

        IdBlock copy() {
            IdBlock copy = this.copyInstance();
            copy.ids = new int[this.ids.length];
            System.arraycopy(this.ids, 0, copy.ids, 0, this.length);
            copy.length = this.length;
            if (this.prev != null) {
                copy.prev = this.prev.copy();
            }
            return copy;
        }

        protected abstract IdBlock copyInstance();

        int length() {
            return this.length;
        }

        void add(int id) {
            if (this.length == this.ids.length) {
                int[] newIds = new int[this.length * 2];
                System.arraycopy(this.ids, 0, newIds, 0, this.ids.length);
                this.ids = newIds;
            }
            this.ids[this.length++] = id;
        }

        void addAll(IdBlock block) {
            int newLength = this.length + block.length;
            if (newLength >= this.ids.length) {
                int[] newIds = new int[newLength];
                System.arraycopy(this.ids, 0, newIds, 0, this.length);
                this.ids = newIds;
            }
            System.arraycopy(block.ids, 0, this.ids, this.length, block.length);
            this.length = newLength;
        }

        long get(int index) {
            assert (index >= 0 && index < this.length);
            return this.transform(this.ids[index]);
        }

        abstract long transform(int var1);

        void set(long id, int index) {
            this.ids[index] = (int)id;
        }

        abstract long getHighBits();

        public String toString() {
            return this.tempDirRemoveThisLater.name() + ", " + this.hashCode();
        }
    }

    public static enum DirectionWrapper {
        OUTGOING(Direction.OUTGOING){

            @Override
            RelIdIterator iterator(RelIdArray ids) {
                return new RelIdIterator(ids, DIRECTIONS_FOR_OUTGOING);
            }

            @Override
            IdBlock lastBlock(RelIdArray ids) {
                return ids.lastOutBlock;
            }

            @Override
            void assignTopLevelBlock(RelIdArray ids, IdBlock block) {
                ids.lastOutBlock = block;
            }
        }
        ,
        INCOMING(Direction.INCOMING){

            @Override
            RelIdIterator iterator(RelIdArray ids) {
                return new RelIdIterator(ids, DIRECTIONS_FOR_INCOMING);
            }

            @Override
            IdBlock lastBlock(RelIdArray ids) {
                return ids.lastInBlock;
            }

            @Override
            void assignTopLevelBlock(RelIdArray ids, IdBlock block) {
                ids.lastInBlock = block;
            }
        }
        ,
        BOTH(Direction.BOTH){

            @Override
            RelIdIterator iterator(RelIdArray ids) {
                return new RelIdIterator(ids, DIRECTIONS_FOR_BOTH);
            }

            @Override
            IdBlock lastBlock(RelIdArray ids) {
                return ids.lastLoopBlock;
            }

            @Override
            void assignTopLevelBlock(RelIdArray ids, IdBlock block) {
                ids.lastLoopBlock = block;
            }
        };

        private final Direction direction;

        private DirectionWrapper(Direction direction) {
            this.direction = direction;
        }

        abstract RelIdIterator iterator(RelIdArray var1);

        abstract IdBlock lastBlock(RelIdArray var1);

        abstract void assignTopLevelBlock(RelIdArray var1, IdBlock var2);

        public Direction direction() {
            return this.direction;
        }
    }
}

