/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.nioneo.xa.ReadTransaction;
import org.neo4j.kernel.impl.persistence.NeoStoreTransaction;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;

public class WriteTransaction
extends XaTransaction
implements NeoStoreTransaction {
    private final Map<Long, NodeRecord> nodeRecords = new HashMap<Long, NodeRecord>();
    private final Map<Long, PropertyRecord> propertyRecords = new HashMap<Long, PropertyRecord>();
    private final Map<Long, RelationshipRecord> relRecords = new HashMap<Long, RelationshipRecord>();
    private final Map<Integer, RelationshipTypeRecord> relTypeRecords = new HashMap<Integer, RelationshipTypeRecord>();
    private final Map<Integer, PropertyIndexRecord> propIndexRecords = new HashMap<Integer, PropertyIndexRecord>();
    private final ArrayList<Command.NodeCommand> nodeCommands = new ArrayList();
    private final ArrayList<Command.PropertyCommand> propCommands = new ArrayList();
    private final ArrayList<Command.PropertyIndexCommand> propIndexCommands = new ArrayList();
    private final ArrayList<Command.RelationshipCommand> relCommands = new ArrayList();
    private final ArrayList<Command.RelationshipTypeCommand> relTypeCommands = new ArrayList();
    private final NeoStore neoStore;
    private boolean committed = false;
    private boolean prepared = false;
    private final LockReleaser lockReleaser;
    private final LockManager lockManager;
    private XaConnection xaConnection;

    WriteTransaction(int identifier, XaLogicalLog log, NeoStore neoStore, LockReleaser lockReleaser, LockManager lockManager) {
        super(identifier, log);
        this.neoStore = neoStore;
        this.lockReleaser = lockReleaser;
        this.lockManager = lockManager;
    }

    @Override
    public boolean isReadOnly() {
        if (this.isRecovered()) {
            return this.nodeCommands.size() == 0 && this.propCommands.size() == 0 && this.relCommands.size() == 0 && this.relTypeCommands.size() == 0 && this.propIndexCommands.size() == 0;
        }
        return this.nodeRecords.size() == 0 && this.relRecords.size() == 0 && this.relTypeRecords.size() == 0 && this.propertyRecords.size() == 0 && this.propIndexRecords.size() == 0;
    }

    @Override
    public void doAddCommand(XaCommand command) {
    }

    @Override
    protected void doPrepare() throws XAException {
        Command command;
        if (this.committed) {
            throw new XAException("Cannot prepare committed transaction[" + this.getIdentifier() + "]");
        }
        if (this.prepared) {
            throw new XAException("Cannot prepare prepared transaction[" + this.getIdentifier() + "]");
        }
        this.prepared = true;
        for (RelationshipTypeRecord relationshipTypeRecord : this.relTypeRecords.values()) {
            command = new Command.RelationshipTypeCommand(this.neoStore.getRelationshipTypeStore(), relationshipTypeRecord);
            this.relTypeCommands.add((Command.RelationshipTypeCommand)command);
            this.addCommand(command);
        }
        for (NodeRecord nodeRecord : this.nodeRecords.values()) {
            if (!nodeRecord.inUse() && nodeRecord.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                throw new InvalidRecordException("Node record " + nodeRecord + " still has relationships");
            }
            command = new Command.NodeCommand(this.neoStore.getNodeStore(), nodeRecord);
            this.nodeCommands.add((Command.NodeCommand)command);
            if (!nodeRecord.inUse()) {
                this.removeNodeFromCache(nodeRecord.getId());
            }
            this.addCommand(command);
        }
        for (RelationshipRecord relationshipRecord : this.relRecords.values()) {
            command = new Command.RelationshipCommand(this.neoStore.getRelationshipStore(), relationshipRecord);
            this.relCommands.add((Command.RelationshipCommand)command);
            if (!relationshipRecord.inUse()) {
                this.removeRelationshipFromCache(relationshipRecord.getId());
            }
            this.addCommand(command);
        }
        for (PropertyIndexRecord propertyIndexRecord : this.propIndexRecords.values()) {
            command = new Command.PropertyIndexCommand(this.neoStore.getPropertyStore().getIndexStore(), propertyIndexRecord);
            this.propIndexCommands.add((Command.PropertyIndexCommand)command);
            this.addCommand(command);
        }
        for (PropertyRecord propertyRecord : this.propertyRecords.values()) {
            command = new Command.PropertyCommand(this.neoStore.getPropertyStore(), propertyRecord);
            this.propCommands.add((Command.PropertyCommand)command);
            this.addCommand(command);
        }
    }

    @Override
    protected void injectCommand(XaCommand xaCommand) {
        if (xaCommand instanceof Command.NodeCommand) {
            this.nodeCommands.add((Command.NodeCommand)xaCommand);
        } else if (xaCommand instanceof Command.RelationshipCommand) {
            this.relCommands.add((Command.RelationshipCommand)xaCommand);
        } else if (xaCommand instanceof Command.PropertyCommand) {
            this.propCommands.add((Command.PropertyCommand)xaCommand);
        } else if (xaCommand instanceof Command.PropertyIndexCommand) {
            this.propIndexCommands.add((Command.PropertyIndexCommand)xaCommand);
        } else if (xaCommand instanceof Command.RelationshipTypeCommand) {
            this.relTypeCommands.add((Command.RelationshipTypeCommand)xaCommand);
        } else {
            throw new IllegalArgumentException("Unknown command " + xaCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRollback() throws XAException {
        if (this.committed) {
            throw new XAException("Cannot rollback partialy commited transaction[" + this.getIdentifier() + "]. Recover and " + "commit");
        }
        try {
            for (RelationshipTypeRecord relationshipTypeRecord : this.relTypeRecords.values()) {
                if (relationshipTypeRecord.isCreated()) {
                    this.getRelationshipTypeStore().freeId(relationshipTypeRecord.getId());
                    for (DynamicRecord dynamicRecord : relationshipTypeRecord.getTypeRecords()) {
                        if (!dynamicRecord.isCreated()) continue;
                        this.getRelationshipTypeStore().freeBlockId((int)dynamicRecord.getId());
                    }
                }
                this.removeRelationshipTypeFromCache(relationshipTypeRecord.getId());
            }
            for (NodeRecord nodeRecord : this.nodeRecords.values()) {
                if (nodeRecord.isCreated()) {
                    this.getNodeStore().freeId(nodeRecord.getId());
                }
                this.removeNodeFromCache(nodeRecord.getId());
            }
            for (RelationshipRecord relationshipRecord : this.relRecords.values()) {
                if (relationshipRecord.isCreated()) {
                    this.getRelationshipStore().freeId(relationshipRecord.getId());
                }
                this.removeRelationshipFromCache(relationshipRecord.getId());
            }
            for (PropertyIndexRecord propertyIndexRecord : this.propIndexRecords.values()) {
                if (!propertyIndexRecord.isCreated()) continue;
                this.getPropertyStore().getIndexStore().freeId(propertyIndexRecord.getId());
                for (DynamicRecord dynamicRecord : propertyIndexRecord.getKeyRecords()) {
                    if (!dynamicRecord.isCreated()) continue;
                    this.getPropertyStore().getIndexStore().freeBlockId((int)dynamicRecord.getId());
                }
            }
            for (PropertyRecord propertyRecord : this.propertyRecords.values()) {
                if (propertyRecord.getNodeId() != -1L) {
                    this.removeNodeFromCache(propertyRecord.getNodeId());
                } else if (propertyRecord.getRelId() != -1L) {
                    this.removeRelationshipFromCache(propertyRecord.getRelId());
                }
                if (!propertyRecord.isCreated()) continue;
                this.getPropertyStore().freeId(propertyRecord.getId());
                for (DynamicRecord dynamicRecord : propertyRecord.getValueRecords()) {
                    if (!dynamicRecord.isCreated()) continue;
                    if (dynamicRecord.getType() == PropertyType.STRING.intValue()) {
                        this.getPropertyStore().freeStringBlockId(dynamicRecord.getId());
                        continue;
                    }
                    if (dynamicRecord.getType() == PropertyType.ARRAY.intValue()) {
                        this.getPropertyStore().freeArrayBlockId(dynamicRecord.getId());
                        continue;
                    }
                    throw new InvalidRecordException("Unknown type on " + dynamicRecord);
                }
            }
        }
        finally {
            this.nodeRecords.clear();
            this.propertyRecords.clear();
            this.relRecords.clear();
            this.relTypeRecords.clear();
            this.propIndexRecords.clear();
            this.nodeCommands.clear();
            this.propCommands.clear();
            this.propIndexCommands.clear();
            this.relCommands.clear();
            this.relTypeCommands.clear();
            if (!this.isRecovered()) {
                this.lockReleaser.rollback();
            }
        }
    }

    private void removeRelationshipTypeFromCache(int id) {
        this.lockReleaser.removeRelationshipTypeFromCache(id);
    }

    private void removeRelationshipFromCache(long id) {
        this.lockReleaser.removeRelationshipFromCache(id);
    }

    private void removeNodeFromCache(long id) {
        this.lockReleaser.removeNodeFromCache(id);
    }

    private void addRelationshipType(int id) {
        this.setRecovered();
        RelationshipTypeData type = this.isRecovered() ? this.neoStore.getRelationshipTypeStore().getRelationshipType(id, true) : this.neoStore.getRelationshipTypeStore().getRelationshipType(id);
        this.lockReleaser.addRelationshipType(type);
    }

    private void addPropertyIndexCommand(int id) {
        PropertyIndexData index = this.isRecovered() ? this.neoStore.getPropertyStore().getIndexStore().getPropertyIndex(id, true) : this.neoStore.getPropertyStore().getIndexStore().getPropertyIndex(id);
        this.lockReleaser.addPropertyIndex(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCommit() throws XAException {
        if (!this.isRecovered() && !this.prepared) {
            throw new XAException("Cannot commit non prepared transaction[" + this.getIdentifier() + "]");
        }
        if (this.isRecovered()) {
            this.commitRecovered();
            return;
        }
        if (!this.isRecovered() && this.getCommitTxId() != this.neoStore.getLastCommittedTx() + 1L) {
            throw new RuntimeException("Tx id: " + this.getCommitTxId() + " not next transaction (" + this.neoStore.getLastCommittedTx() + ")");
        }
        try {
            this.committed = true;
            CommandSorter sorter = new CommandSorter();
            Collections.sort(this.relTypeCommands, sorter);
            for (Command.RelationshipTypeCommand relationshipTypeCommand : this.relTypeCommands) {
                relationshipTypeCommand.execute();
            }
            Collections.sort(this.nodeCommands, sorter);
            for (Command.NodeCommand nodeCommand : this.nodeCommands) {
                nodeCommand.execute();
            }
            Collections.sort(this.relCommands, sorter);
            for (Command.RelationshipCommand relationshipCommand : this.relCommands) {
                relationshipCommand.execute();
            }
            Collections.sort(this.propIndexCommands, sorter);
            for (Command.PropertyIndexCommand propertyIndexCommand : this.propIndexCommands) {
                propertyIndexCommand.execute();
            }
            Collections.sort(this.propCommands, sorter);
            for (Command.PropertyCommand propertyCommand : this.propCommands) {
                propertyCommand.execute();
            }
            this.neoStore.setLastCommittedTx(this.getCommitTxId());
            if (!this.isRecovered()) {
                this.lockReleaser.commit();
            }
        }
        finally {
            this.nodeRecords.clear();
            this.propertyRecords.clear();
            this.relRecords.clear();
            this.relTypeRecords.clear();
            this.propIndexRecords.clear();
            this.nodeCommands.clear();
            this.propCommands.clear();
            this.propIndexCommands.clear();
            this.relCommands.clear();
            this.relTypeCommands.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitRecovered() {
        try {
            this.committed = true;
            CommandSorter sorter = new CommandSorter();
            Collections.sort(this.propIndexCommands, sorter);
            for (Command.PropertyIndexCommand propertyIndexCommand : this.propIndexCommands) {
                propertyIndexCommand.execute();
                this.addPropertyIndexCommand((int)propertyIndexCommand.getKey());
            }
            Collections.sort(this.propCommands, sorter);
            for (Command.PropertyCommand propertyCommand : this.propCommands) {
                propertyCommand.execute();
                this.removePropertyFromCache(propertyCommand);
            }
            Collections.sort(this.relTypeCommands, sorter);
            for (Command.RelationshipTypeCommand relationshipTypeCommand : this.relTypeCommands) {
                relationshipTypeCommand.execute();
                this.addRelationshipType((int)relationshipTypeCommand.getKey());
            }
            Collections.sort(this.relCommands, sorter);
            for (Command.RelationshipCommand relationshipCommand : this.relCommands) {
                relationshipCommand.execute();
                this.removeRelationshipFromCache(relationshipCommand.getKey());
                this.removeNodeFromCache(relationshipCommand.getFirstNode());
                this.removeNodeFromCache(relationshipCommand.getSecondNode());
            }
            Collections.sort(this.nodeCommands, sorter);
            for (Command.NodeCommand nodeCommand : this.nodeCommands) {
                nodeCommand.execute();
                this.removeNodeFromCache(nodeCommand.getKey());
            }
            this.neoStore.setRecoveredStatus(true);
            try {
                this.neoStore.setLastCommittedTx(this.getCommitTxId());
            }
            finally {
                this.neoStore.setRecoveredStatus(false);
            }
            this.neoStore.getIdGeneratorFactory().updateIdGenerators(this.neoStore);
            if (!this.isRecovered()) {
                this.lockReleaser.commit();
            }
        }
        finally {
            this.nodeRecords.clear();
            this.propertyRecords.clear();
            this.relRecords.clear();
            this.relTypeRecords.clear();
            this.propIndexRecords.clear();
            this.nodeCommands.clear();
            this.propCommands.clear();
            this.propIndexCommands.clear();
            this.relCommands.clear();
            this.relTypeCommands.clear();
        }
    }

    private void removePropertyFromCache(Command.PropertyCommand command) {
        long nodeId = command.getNodeId();
        long relId = command.getRelId();
        if (nodeId != -1L) {
            this.removeNodeFromCache(nodeId);
        } else if (relId != -1L) {
            this.removeRelationshipFromCache(relId);
        }
    }

    private RelationshipTypeStore getRelationshipTypeStore() {
        return this.neoStore.getRelationshipTypeStore();
    }

    private int getRelGrabSize() {
        return this.neoStore.getRelationshipGrabSize();
    }

    private NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    private RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    private PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    @Override
    public boolean nodeLoadLight(long nodeId) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        if (nodeRecord != null) {
            return true;
        }
        return this.getNodeStore().loadLightNode(nodeId);
    }

    @Override
    public RelationshipRecord relLoadLight(long id) {
        RelationshipRecord relRecord = this.getRelationshipRecord(id);
        if (relRecord != null) {
            return relRecord;
        }
        relRecord = this.getRelationshipStore().getLightRel(id);
        if (relRecord != null) {
            return relRecord;
        }
        return null;
    }

    @Override
    public ArrayMap<Integer, PropertyData> nodeDelete(long nodeId) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        if (nodeRecord == null) {
            nodeRecord = this.getNodeStore().getRecord(nodeId);
            this.addNodeRecord(nodeRecord);
        }
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Unable to delete Node[" + nodeId + "] since it has already been deleted.");
        }
        nodeRecord.setInUse(false);
        ArrayMap<Integer, PropertyData> propertyMap = new ArrayMap<Integer, PropertyData>(9, false, true);
        long nextProp = nodeRecord.getNextProp();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = this.getPropertyRecord(nextProp);
            if (propRecord == null) {
                propRecord = this.getPropertyStore().getRecord(nextProp);
                this.addPropertyRecord(propRecord);
            }
            if (propRecord.isLight()) {
                this.getPropertyStore().makeHeavy(propRecord);
            }
            if (!propRecord.isCreated()) {
                if (!propRecord.isChanged()) {
                    propertyMap.put(propRecord.getKeyIndexId(), new PropertyData(propRecord.getId(), this.propertyGetValueOrNull(propRecord)));
                } else {
                    PropertyRecord diskValue = this.getPropertyStore().getRecord(propRecord.getId());
                    this.getPropertyStore().makeHeavy(diskValue);
                    propertyMap.put(diskValue.getKeyIndexId(), new PropertyData(diskValue.getId(), this.propertyGetValueOrNull(diskValue)));
                }
            }
            nextProp = propRecord.getNextProp();
            propRecord.setInUse(false);
            for (DynamicRecord valueRecord : propRecord.getValueRecords()) {
                valueRecord.setInUse(false);
            }
        }
        return propertyMap;
    }

    @Override
    public ArrayMap<Integer, PropertyData> relDelete(long id) {
        RelationshipRecord record = this.getRelationshipRecord(id);
        if (record == null) {
            record = this.getRelationshipStore().getRecord(id);
            this.addRelationshipRecord(record);
        }
        if (!record.inUse()) {
            throw new IllegalStateException("Unable to delete relationship[" + id + "] since it is already deleted.");
        }
        ArrayMap<Integer, PropertyData> propertyMap = new ArrayMap<Integer, PropertyData>(9, false, true);
        long nextProp = record.getNextProp();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = this.getPropertyRecord(nextProp);
            if (propRecord == null) {
                propRecord = this.getPropertyStore().getRecord(nextProp);
                this.addPropertyRecord(propRecord);
            }
            if (propRecord.isLight()) {
                this.getPropertyStore().makeHeavy(propRecord);
            }
            if (!propRecord.isCreated()) {
                if (!propRecord.isChanged()) {
                    propertyMap.put(propRecord.getKeyIndexId(), new PropertyData(propRecord.getId(), this.propertyGetValueOrNull(propRecord)));
                } else {
                    PropertyRecord diskValue = this.getPropertyStore().getRecord(propRecord.getId());
                    this.getPropertyStore().makeHeavy(diskValue);
                    propertyMap.put(diskValue.getKeyIndexId(), new PropertyData(diskValue.getId(), this.propertyGetValueOrNull(diskValue)));
                }
            }
            nextProp = propRecord.getNextProp();
            propRecord.setInUse(false);
            for (DynamicRecord valueRecord : propRecord.getValueRecords()) {
                valueRecord.setInUse(false);
            }
        }
        this.disconnectRelationship(record);
        this.updateNodes(record);
        record.setInUse(false);
        return propertyMap;
    }

    private void disconnectRelationship(RelationshipRecord rel) {
        RelationshipRecord nextRel;
        boolean changed;
        RelationshipRecord prevRel;
        LockableRelationship lockableRel;
        if (rel.getFirstPrevRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            lockableRel = new LockableRelationship(rel.getFirstPrevRel());
            this.getWriteLock(lockableRel);
            prevRel = this.getRelationshipRecord(rel.getFirstPrevRel());
            if (prevRel == null) {
                prevRel = this.getRelationshipStore().getRecord(rel.getFirstPrevRel());
                this.addRelationshipRecord(prevRel);
            }
            changed = false;
            if (prevRel.getFirstNode() == rel.getFirstNode()) {
                prevRel.setFirstNextRel(rel.getFirstNextRel());
                changed = true;
            }
            if (prevRel.getSecondNode() == rel.getFirstNode()) {
                prevRel.setSecondNextRel(rel.getFirstNextRel());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(prevRel + " don't match " + rel);
            }
        }
        if (rel.getFirstNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            lockableRel = new LockableRelationship(rel.getFirstNextRel());
            this.getWriteLock(lockableRel);
            nextRel = this.getRelationshipRecord(rel.getFirstNextRel());
            if (nextRel == null) {
                nextRel = this.getRelationshipStore().getRecord(rel.getFirstNextRel());
                this.addRelationshipRecord(nextRel);
            }
            changed = false;
            if (nextRel.getFirstNode() == rel.getFirstNode()) {
                nextRel.setFirstPrevRel(rel.getFirstPrevRel());
                changed = true;
            }
            if (nextRel.getSecondNode() == rel.getFirstNode()) {
                nextRel.setSecondPrevRel(rel.getFirstPrevRel());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(nextRel + " don't match " + rel);
            }
        }
        if (rel.getSecondPrevRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            lockableRel = new LockableRelationship(rel.getSecondPrevRel());
            this.getWriteLock(lockableRel);
            prevRel = this.getRelationshipRecord(rel.getSecondPrevRel());
            if (prevRel == null) {
                prevRel = this.getRelationshipStore().getRecord(rel.getSecondPrevRel());
                this.addRelationshipRecord(prevRel);
            }
            changed = false;
            if (prevRel.getFirstNode() == rel.getSecondNode()) {
                prevRel.setFirstNextRel(rel.getSecondNextRel());
                changed = true;
            }
            if (prevRel.getSecondNode() == rel.getSecondNode()) {
                prevRel.setSecondNextRel(rel.getSecondNextRel());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(prevRel + " don't match " + rel);
            }
        }
        if (rel.getSecondNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            lockableRel = new LockableRelationship(rel.getSecondNextRel());
            this.getWriteLock(lockableRel);
            nextRel = this.getRelationshipRecord(rel.getSecondNextRel());
            if (nextRel == null) {
                nextRel = this.getRelationshipStore().getRecord(rel.getSecondNextRel());
                this.addRelationshipRecord(nextRel);
            }
            changed = false;
            if (nextRel.getFirstNode() == rel.getSecondNode()) {
                nextRel.setFirstPrevRel(rel.getSecondPrevRel());
                changed = true;
            }
            if (nextRel.getSecondNode() == rel.getSecondNode()) {
                nextRel.setSecondPrevRel(rel.getSecondPrevRel());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(nextRel + " don't match " + rel);
            }
        }
    }

    private void getWriteLock(Relationship lockableRel) {
        this.lockManager.getWriteLock(lockableRel);
        this.lockReleaser.addLockToTransaction(lockableRel, LockType.WRITE);
    }

    @Override
    public long getRelationshipChainPosition(long nodeId) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        if (nodeRecord != null && nodeRecord.isCreated()) {
            return Record.NO_NEXT_RELATIONSHIP.intValue();
        }
        return this.getNodeStore().getRecord(nodeId).getNextRel();
    }

    @Override
    public Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, Long> getMoreRelationships(long nodeId, long position) {
        return ReadTransaction.getMoreRelationships(nodeId, position, this.getRelGrabSize(), this.getRelationshipStore());
    }

    private void updateNodes(RelationshipRecord rel) {
        if (rel.getFirstPrevRel() == (long)Record.NO_PREV_RELATIONSHIP.intValue()) {
            NodeRecord firstNode = this.getNodeRecord(rel.getFirstNode());
            if (firstNode == null) {
                firstNode = this.getNodeStore().getRecord(rel.getFirstNode());
                this.addNodeRecord(firstNode);
            }
            firstNode.setNextRel(rel.getFirstNextRel());
        }
        if (rel.getSecondPrevRel() == (long)Record.NO_PREV_RELATIONSHIP.intValue()) {
            NodeRecord secondNode = this.getNodeRecord(rel.getSecondNode());
            if (secondNode == null) {
                secondNode = this.getNodeStore().getRecord(rel.getSecondNode());
                this.addNodeRecord(secondNode);
            }
            secondNode.setNextRel(rel.getSecondNextRel());
        }
    }

    @Override
    public void relRemoveProperty(long relId, long propertyId) {
        RelationshipRecord relRecord = this.getRelationshipRecord(relId);
        if (relRecord == null) {
            relRecord = this.getRelationshipStore().getRecord(relId);
        }
        if (!relRecord.inUse()) {
            throw new IllegalStateException("Property remove on relationship[" + relId + "] illegal since it has been deleted.");
        }
        PropertyRecord propRecord = this.getPropertyRecord(propertyId);
        if (propRecord == null) {
            propRecord = this.getPropertyStore().getRecord(propertyId);
            this.addPropertyRecord(propRecord);
        }
        if (!propRecord.inUse()) {
            throw new IllegalStateException("Unable to delete property[" + propertyId + "] since it is already deleted.");
        }
        propRecord.setRelId(relId);
        if (propRecord.isLight()) {
            this.getPropertyStore().makeHeavy(propRecord);
        }
        propRecord.setInUse(false);
        for (DynamicRecord valueRecord : propRecord.getValueRecords()) {
            if (!valueRecord.inUse()) continue;
            valueRecord.setInUse(false, propRecord.getType().intValue());
        }
        long prevProp = propRecord.getPrevProp();
        long nextProp = propRecord.getNextProp();
        if (relRecord.getNextProp() == propertyId) {
            relRecord.setNextProp(nextProp);
            this.addRelationshipRecord(relRecord);
        }
        if (prevProp != (long)Record.NO_PREVIOUS_PROPERTY.intValue()) {
            PropertyRecord prevPropRecord = this.getPropertyRecord(prevProp);
            if (prevPropRecord == null) {
                prevPropRecord = this.getPropertyStore().getLightRecord(prevProp);
                this.addPropertyRecord(prevPropRecord);
            }
            assert (prevPropRecord.inUse());
            prevPropRecord.setNextProp(nextProp);
        }
        if (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord nextPropRecord = this.getPropertyRecord(nextProp);
            if (nextPropRecord == null) {
                nextPropRecord = this.getPropertyStore().getLightRecord(nextProp);
                this.addPropertyRecord(nextPropRecord);
            }
            assert (nextPropRecord.inUse());
            nextPropRecord.setPrevProp(prevProp);
        }
    }

    @Override
    public ArrayMap<Integer, PropertyData> relLoadProperties(long relId, boolean light) {
        ArrayMap<Integer, PropertyData> propertyMap = new ArrayMap<Integer, PropertyData>(9, false, true);
        RelationshipRecord relRecord = this.getRelationshipRecord(relId);
        if (relRecord != null && relRecord.isCreated()) {
            return propertyMap;
        }
        if (relRecord != null && !relRecord.inUse() && !light) {
            throw new IllegalStateException("Relationship[" + relId + "] has been deleted in this tx");
        }
        relRecord = this.getRelationshipStore().getRecord(relId);
        if (!relRecord.inUse()) {
            throw new InvalidRecordException("Relationship[" + relId + "] not in use");
        }
        long nextProp = relRecord.getNextProp();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = this.getPropertyStore().getLightRecord(nextProp);
            propertyMap.put(propRecord.getKeyIndexId(), new PropertyData(propRecord.getId(), this.propertyGetValueOrNull(propRecord)));
            nextProp = propRecord.getNextProp();
        }
        return propertyMap;
    }

    @Override
    public ArrayMap<Integer, PropertyData> nodeLoadProperties(long nodeId, boolean light) {
        ArrayMap<Integer, PropertyData> propertyMap = new ArrayMap<Integer, PropertyData>(9, false, true);
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        if (nodeRecord != null && nodeRecord.isCreated()) {
            return propertyMap;
        }
        if (nodeRecord != null && !nodeRecord.inUse() && !light) {
            throw new IllegalStateException("Node[" + nodeId + "] has been deleted in this tx");
        }
        nodeRecord = this.getNodeStore().getRecord(nodeId);
        if (!nodeRecord.inUse()) {
            throw new InvalidRecordException("Node[" + nodeId + "] not in use");
        }
        long nextProp = nodeRecord.getNextProp();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = this.getPropertyStore().getLightRecord(nextProp);
            propertyMap.put(propRecord.getKeyIndexId(), new PropertyData(propRecord.getId(), this.propertyGetValueOrNull(propRecord)));
            nextProp = propRecord.getNextProp();
        }
        return propertyMap;
    }

    public Object propertyGetValueOrNull(PropertyRecord propertyRecord) {
        return propertyRecord.getType().getValue(propertyRecord, propertyRecord.isLight() ? null : this.getPropertyStore());
    }

    @Override
    public Object loadPropertyValue(long id) {
        PropertyRecord propertyRecord = this.getPropertyStore().getRecord(id);
        if (propertyRecord.isLight()) {
            this.getPropertyStore().makeHeavy(propertyRecord);
        }
        return propertyRecord.getType().getValue(propertyRecord, this.getPropertyStore());
    }

    @Override
    public void nodeRemoveProperty(long nodeId, long propertyId) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        if (nodeRecord == null) {
            nodeRecord = this.getNodeStore().getRecord(nodeId);
        }
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Property remove on node[" + nodeId + "] illegal since it has been deleted.");
        }
        PropertyRecord propRecord = this.getPropertyRecord(propertyId);
        if (propRecord == null) {
            propRecord = this.getPropertyStore().getRecord(propertyId);
            this.addPropertyRecord(propRecord);
        }
        if (!propRecord.inUse()) {
            throw new IllegalStateException("Unable to delete property[" + propertyId + "] since it is already deleted.");
        }
        propRecord.setNodeId(nodeId);
        if (propRecord.isLight()) {
            this.getPropertyStore().makeHeavy(propRecord);
        }
        propRecord.setInUse(false);
        for (DynamicRecord valueRecord : propRecord.getValueRecords()) {
            if (!valueRecord.inUse()) continue;
            valueRecord.setInUse(false, propRecord.getType().intValue());
        }
        long prevProp = propRecord.getPrevProp();
        long nextProp = propRecord.getNextProp();
        if (nodeRecord.getNextProp() == propertyId) {
            nodeRecord.setNextProp(nextProp);
            this.addNodeRecord(nodeRecord);
        }
        if (prevProp != (long)Record.NO_PREVIOUS_PROPERTY.intValue()) {
            PropertyRecord prevPropRecord = this.getPropertyRecord(prevProp);
            if (prevPropRecord == null) {
                prevPropRecord = this.getPropertyStore().getLightRecord(prevProp);
                this.addPropertyRecord(prevPropRecord);
            }
            assert (prevPropRecord.inUse());
            prevPropRecord.setNextProp(nextProp);
        }
        if (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord nextPropRecord = this.getPropertyRecord(nextProp);
            if (nextPropRecord == null) {
                nextPropRecord = this.getPropertyStore().getLightRecord(nextProp);
                this.addPropertyRecord(nextPropRecord);
            }
            assert (nextPropRecord.inUse());
            nextPropRecord.setPrevProp(prevProp);
        }
    }

    @Override
    public void relChangeProperty(long relId, long propertyId, Object value) {
        RelationshipRecord relRecord = this.getRelationshipRecord(relId);
        if (relRecord == null) {
            relRecord = this.getRelationshipStore().getRecord(relId);
        }
        if (!relRecord.inUse()) {
            throw new IllegalStateException("Property change on relationship[" + relId + "] illegal since it has been deleted.");
        }
        PropertyRecord propertyRecord = this.getPropertyRecord(propertyId);
        if (propertyRecord == null) {
            propertyRecord = this.getPropertyStore().getRecord(propertyId);
            this.addPropertyRecord(propertyRecord);
        }
        if (!propertyRecord.inUse()) {
            throw new IllegalStateException("Unable to change property[" + propertyId + "] since it is deleted.");
        }
        propertyRecord.setRelId(relId);
        if (propertyRecord.isLight()) {
            this.getPropertyStore().makeHeavy(propertyRecord);
        }
        propertyRecord.setChanged();
        if (propertyRecord.getType() == PropertyType.STRING) {
            for (DynamicRecord record : propertyRecord.getValueRecords()) {
                if (!record.inUse()) continue;
                record.setInUse(false, PropertyType.STRING.intValue());
            }
        } else if (propertyRecord.getType() == PropertyType.ARRAY) {
            for (DynamicRecord record : propertyRecord.getValueRecords()) {
                if (!record.inUse()) continue;
                record.setInUse(false, PropertyType.ARRAY.intValue());
            }
        }
        this.getPropertyStore().encodeValue(propertyRecord, value);
        this.addPropertyRecord(propertyRecord);
    }

    @Override
    public void nodeChangeProperty(long nodeId, long propertyId, Object value) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        if (nodeRecord == null) {
            nodeRecord = this.getNodeStore().getRecord(nodeId);
        }
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Property change on node[" + nodeId + "] illegal since it has been deleted.");
        }
        PropertyRecord propertyRecord = this.getPropertyRecord(propertyId);
        if (propertyRecord == null) {
            propertyRecord = this.getPropertyStore().getRecord(propertyId);
            this.addPropertyRecord(propertyRecord);
        }
        if (!propertyRecord.inUse()) {
            throw new IllegalStateException("Unable to change property[" + propertyId + "] since it is deleted.");
        }
        propertyRecord.setNodeId(nodeId);
        if (propertyRecord.isLight()) {
            this.getPropertyStore().makeHeavy(propertyRecord);
        }
        propertyRecord.setChanged();
        if (propertyRecord.getType() == PropertyType.STRING) {
            for (DynamicRecord record : propertyRecord.getValueRecords()) {
                if (!record.inUse()) continue;
                record.setInUse(false, PropertyType.STRING.intValue());
            }
        } else if (propertyRecord.getType() == PropertyType.ARRAY) {
            for (DynamicRecord record : propertyRecord.getValueRecords()) {
                if (!record.inUse()) continue;
                record.setInUse(false, PropertyType.ARRAY.intValue());
            }
        }
        this.getPropertyStore().encodeValue(propertyRecord, value);
        this.addPropertyRecord(propertyRecord);
    }

    public void relAddProperty(long relId, long propertyId, PropertyIndex index, Object value) {
        RelationshipRecord relRecord = this.getRelationshipRecord(relId);
        if (relRecord == null) {
            relRecord = this.getRelationshipStore().getRecord(relId);
            this.addRelationshipRecord(relRecord);
        }
        if (!relRecord.inUse()) {
            throw new IllegalStateException("Property add on relationship[" + relId + "] illegal since it has been deleted.");
        }
        PropertyRecord propertyRecord = new PropertyRecord(propertyId);
        propertyRecord.setInUse(true);
        propertyRecord.setCreated();
        propertyRecord.setRelId(relId);
        if (relRecord.getNextProp() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            PropertyRecord prevProp = this.getPropertyRecord(relRecord.getNextProp());
            if (prevProp == null) {
                prevProp = this.getPropertyStore().getLightRecord(relRecord.getNextProp());
                this.addPropertyRecord(prevProp);
            }
            assert (prevProp.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue());
            prevProp.setPrevProp(propertyId);
            propertyRecord.setNextProp(prevProp.getId());
        }
        int keyIndexId = index.getKeyId();
        propertyRecord.setKeyIndexId(keyIndexId);
        this.getPropertyStore().encodeValue(propertyRecord, value);
        relRecord.setNextProp(propertyId);
        this.addPropertyRecord(propertyRecord);
    }

    public void nodeAddProperty(long nodeId, long propertyId, PropertyIndex index, Object value) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        if (nodeRecord == null) {
            nodeRecord = this.getNodeStore().getRecord(nodeId);
            this.addNodeRecord(nodeRecord);
        }
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Property add on node[" + nodeId + "] illegal since it has been deleted.");
        }
        PropertyRecord propertyRecord = new PropertyRecord(propertyId);
        propertyRecord.setInUse(true);
        propertyRecord.setCreated();
        propertyRecord.setNodeId(nodeId);
        this.getPropertyStore().encodeValue(propertyRecord, value);
        if (nodeRecord.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord prevProp = this.getPropertyRecord(nodeRecord.getNextProp());
            if (prevProp == null) {
                prevProp = this.getPropertyStore().getLightRecord(nodeRecord.getNextProp());
                this.addPropertyRecord(prevProp);
            }
            assert (prevProp.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue());
            prevProp.setPrevProp(propertyId);
            propertyRecord.setNextProp(prevProp.getId());
        }
        int keyIndexId = index.getKeyId();
        propertyRecord.setKeyIndexId(keyIndexId);
        nodeRecord.setNextProp(propertyId);
        this.addPropertyRecord(propertyRecord);
    }

    @Override
    public void relationshipCreate(long id, int type, long firstNodeId, long secondNodeId) {
        NodeRecord firstNode = this.getNodeRecord(firstNodeId);
        if (firstNode == null) {
            firstNode = this.getNodeStore().getRecord(firstNodeId);
            this.addNodeRecord(firstNode);
        }
        if (!firstNode.inUse()) {
            throw new IllegalStateException("First node[" + firstNodeId + "] is deleted and cannot be used to create a relationship");
        }
        NodeRecord secondNode = this.getNodeRecord(secondNodeId);
        if (secondNode == null) {
            secondNode = this.getNodeStore().getRecord(secondNodeId);
            this.addNodeRecord(secondNode);
        }
        if (!secondNode.inUse()) {
            throw new IllegalStateException("Second node[" + secondNodeId + "] is deleted and cannot be used to create a relationship");
        }
        RelationshipRecord record = new RelationshipRecord(id, firstNodeId, secondNodeId, type);
        record.setInUse(true);
        record.setCreated();
        this.addRelationshipRecord(record);
        this.connectRelationship(firstNode, secondNode, record);
    }

    private void connectRelationship(NodeRecord firstNode, NodeRecord secondNode, RelationshipRecord rel) {
        assert (firstNode.getNextRel() != rel.getId());
        assert (secondNode.getNextRel() != rel.getId());
        rel.setFirstNextRel(firstNode.getNextRel());
        rel.setSecondNextRel(secondNode.getNextRel());
        this.connect(firstNode, rel);
        this.connect(secondNode, rel);
        firstNode.setNextRel(rel.getId());
        secondNode.setNextRel(rel.getId());
    }

    private void connect(NodeRecord node, RelationshipRecord rel) {
        if (node.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            LockableRelationship lockableRel = new LockableRelationship(node.getNextRel());
            this.getWriteLock(lockableRel);
            RelationshipRecord nextRel = this.getRelationshipRecord(node.getNextRel());
            if (nextRel == null) {
                nextRel = this.getRelationshipStore().getRecord(node.getNextRel());
                this.addRelationshipRecord(nextRel);
            }
            boolean changed = false;
            if (nextRel.getFirstNode() == node.getId()) {
                nextRel.setFirstPrevRel(rel.getId());
                changed = true;
            }
            if (nextRel.getSecondNode() == node.getId()) {
                nextRel.setSecondPrevRel(rel.getId());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(node + " dont match " + nextRel);
            }
        }
    }

    @Override
    public void nodeCreate(long nodeId) {
        NodeRecord nodeRecord = new NodeRecord(nodeId);
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
        this.addNodeRecord(nodeRecord);
    }

    @Override
    public String loadIndex(int id) {
        PropertyIndexStore indexStore = this.getPropertyStore().getIndexStore();
        PropertyIndexRecord index = this.getPropertyIndexRecord(id);
        if (index == null) {
            index = indexStore.getRecord(id);
        }
        if (index.isLight()) {
            indexStore.makeHeavy(index);
        }
        return indexStore.getStringFor(index);
    }

    @Override
    public PropertyIndexData[] loadPropertyIndexes(int count) {
        PropertyIndexStore indexStore = this.getPropertyStore().getIndexStore();
        return indexStore.getPropertyIndexes(count);
    }

    @Override
    public void createPropertyIndex(String key, int id) {
        PropertyIndexRecord record = new PropertyIndexRecord(id);
        record.setInUse(true);
        record.setCreated();
        PropertyIndexStore propIndexStore = this.getPropertyStore().getIndexStore();
        int keyBlockId = propIndexStore.nextKeyBlockId();
        record.setKeyBlockId(keyBlockId);
        int length = key.length();
        char[] chars = new char[length];
        key.getChars(0, length, chars, 0);
        Collection<DynamicRecord> keyRecords = propIndexStore.allocateKeyRecords(keyBlockId, chars);
        for (DynamicRecord keyRecord : keyRecords) {
            record.addKeyRecord(keyRecord);
        }
        this.addPropertyIndexRecord(record);
    }

    @Override
    public void createRelationshipType(int id, String name) {
        RelationshipTypeRecord record = new RelationshipTypeRecord(id);
        record.setInUse(true);
        record.setCreated();
        int blockId = (int)this.getRelationshipTypeStore().nextBlockId();
        record.setTypeBlock(blockId);
        int length = name.length();
        char[] chars = new char[length];
        name.getChars(0, length, chars, 0);
        Collection<DynamicRecord> typeNameRecords = this.getRelationshipTypeStore().allocateTypeNameRecords(blockId, chars);
        for (DynamicRecord typeRecord : typeNameRecords) {
            record.addTypeRecord(typeRecord);
        }
        this.addRelationshipTypeRecord(record);
    }

    void addNodeRecord(NodeRecord record) {
        this.nodeRecords.put(record.getId(), record);
    }

    NodeRecord getNodeRecord(long nodeId) {
        return this.nodeRecords.get(nodeId);
    }

    void addRelationshipRecord(RelationshipRecord record) {
        this.relRecords.put(record.getId(), record);
    }

    RelationshipRecord getRelationshipRecord(long relId) {
        return this.relRecords.get(relId);
    }

    void addPropertyRecord(PropertyRecord record) {
        this.propertyRecords.put(record.getId(), record);
    }

    PropertyRecord getPropertyRecord(long propertyId) {
        return this.propertyRecords.get(propertyId);
    }

    void addRelationshipTypeRecord(RelationshipTypeRecord record) {
        this.relTypeRecords.put(record.getId(), record);
    }

    void addPropertyIndexRecord(PropertyIndexRecord record) {
        this.propIndexRecords.put(record.getId(), record);
    }

    PropertyIndexRecord getPropertyIndexRecord(int id) {
        return this.propIndexRecords.get(id);
    }

    @Override
    public RelIdArray getCreatedNodes() {
        RelIdArray createdNodes = new RelIdArray();
        for (NodeRecord record : this.nodeRecords.values()) {
            if (!record.isCreated()) continue;
            createdNodes.add(record.getId(), RelIdArray.DirectionWrapper.OUTGOING);
        }
        return createdNodes;
    }

    @Override
    public boolean isNodeCreated(long nodeId) {
        NodeRecord record = this.nodeRecords.get(nodeId);
        if (record != null) {
            return record.isCreated();
        }
        return false;
    }

    @Override
    public boolean isRelationshipCreated(long relId) {
        RelationshipRecord record = this.relRecords.get(relId);
        if (record != null) {
            return record.isCreated();
        }
        return false;
    }

    @Override
    public int getKeyIdForProperty(long propertyId) {
        PropertyRecord propRecord = this.getPropertyRecord(propertyId);
        if (propRecord == null) {
            propRecord = this.getPropertyStore().getLightRecord(propertyId);
        }
        return propRecord.getKeyIndexId();
    }

    @Override
    public XAResource getXAResource() {
        return this.xaConnection.getXaResource();
    }

    @Override
    public void destroy() {
        this.xaConnection.destroy();
    }

    @Override
    public void setXaConnection(XaConnection connection) {
        this.xaConnection = connection;
    }

    @Override
    public long nodeAddProperty(long nodeId, PropertyIndex index, Object value) {
        long propertyId = this.neoStore.getPropertyStore().nextId();
        this.nodeAddProperty(nodeId, propertyId, index, value);
        return propertyId;
    }

    @Override
    public long relAddProperty(long relId, PropertyIndex index, Object value) {
        long propertyId = this.neoStore.getPropertyStore().nextId();
        this.relAddProperty(relId, propertyId, index, value);
        return propertyId;
    }

    @Override
    public RelationshipTypeData[] loadRelationshipTypes() {
        RelationshipTypeData[] relTypeData = this.neoStore.getRelationshipTypeStore().getRelationshipTypes();
        RelationshipTypeData[] rawRelTypeData = new RelationshipTypeData[relTypeData.length];
        for (int i = 0; i < relTypeData.length; ++i) {
            rawRelTypeData[i] = new RelationshipTypeData(relTypeData[i].getId(), relTypeData[i].getName());
        }
        return rawRelTypeData;
    }

    private static class LockableRelationship
    implements Relationship {
        private final long id;

        LockableRelationship(long id) {
            this.id = id;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node getEndNode() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public GraphDatabaseService getGraphDatabase() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node[] getNodes() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node getOtherNode(Node node) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Object getProperty(String key) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Object getProperty(String key, Object defaultValue) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Iterable<String> getPropertyKeys() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Iterable<Object> getPropertyValues() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Node getStartNode() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public RelationshipType getType() {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public boolean isType(RelationshipType type) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public boolean hasProperty(String key) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public Object removeProperty(String key) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        @Override
        public void setProperty(String key, Object value) {
            throw new UnsupportedOperationException("Lockable rel");
        }

        public boolean equals(Object o) {
            if (!(o instanceof Relationship)) {
                return false;
            }
            return this.getId() == ((Relationship)o).getId();
        }

        public int hashCode() {
            return (int)(this.id >>> 32 ^ this.id);
        }

        public String toString() {
            return "Lockable relationship #" + this.getId();
        }
    }

    static class CommandSorter
    implements Comparator<Command>,
    Serializable {
        CommandSorter() {
        }

        @Override
        public int compare(Command o1, Command o2) {
            long id2;
            long id1 = o1.getKey();
            long diff = id1 - (id2 = o2.getKey());
            if (diff > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (diff < Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return (int)diff;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof CommandSorter;
        }

        public int hashCode() {
            return 3217;
        }
    }
}

