/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelTypeElementIterator;
import org.neo4j.kernel.impl.util.RelIdArray;

class FastRelTypeElement
extends RelTypeElementIterator {
    private final RelIdArray src;
    private final RelIdArray.RelIdIterator iterator;
    private final RelIdArray.DirectionWrapper direction;

    FastRelTypeElement(String type, NodeImpl node, RelIdArray src, RelIdArray.DirectionWrapper direction) {
        super(type, node);
        this.direction = direction;
        this.src = src == null ? RelIdArray.EMPTY : src;
        this.iterator = this.src.iterator(direction);
    }

    @Override
    public boolean hasNext(NodeManager nodeManager) {
        return this.iterator.hasNext();
    }

    @Override
    public long next(NodeManager nodeManager) {
        return this.iterator.next();
    }

    @Override
    public boolean isSrcEmpty() {
        return this.src.isEmpty();
    }

    @Override
    public RelTypeElementIterator setSrc(RelIdArray newSrc) {
        return new FastRelTypeElement(this.getType(), this.getNode(), newSrc, this.direction);
    }

    @Override
    public void notifyAboutMoreRelationships() {
        this.iterator.doAnotherRound();
    }
}

