/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.neo4j.kernel.impl.core.FastRelTypeElement;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelTypeElementIterator;
import org.neo4j.kernel.impl.util.RelIdArray;

class RelTypeElement
extends RelTypeElementIterator {
    private final RelIdArray src;
    private final Set<Long> remove = new HashSet<Long>();
    private final RelIdArray.RelIdIterator srcIterator;
    private final RelIdArray.RelIdIterator addIterator;
    private RelIdArray.RelIdIterator currentIterator;
    private Long nextElement = null;

    static RelTypeElementIterator create(String type, NodeImpl node, RelIdArray src, RelIdArray add, RelIdArray remove) {
        if (add == null && remove == null) {
            return new FastRelTypeElement(type, node, src);
        }
        return new RelTypeElement(type, node, src, add, remove);
    }

    private RelTypeElement(String type, NodeImpl node, RelIdArray src, RelIdArray add, RelIdArray remove) {
        super(type, node);
        if (src == null) {
            src = RelIdArray.EMPTY;
        }
        this.src = src;
        this.srcIterator = src.iterator();
        RelIdArray.RelIdIterator relIdIterator = this.addIterator = add == null ? RelIdArray.EMPTY.iterator() : add.iterator();
        if (remove != null) {
            RelIdArray.RelIdIterator iterator = remove.iterator();
            while (iterator.hasNext()) {
                this.remove.add(iterator.next());
            }
        }
        this.currentIterator = this.srcIterator;
    }

    @Override
    public boolean hasNext(NodeManager nodeManager) {
        if (this.nextElement != null) {
            return true;
        }
        while (this.currentIterator.hasNext() || this.currentIterator == this.srcIterator) {
            while (this.currentIterator.hasNext()) {
                long value = this.currentIterator.next();
                if (this.remove.contains(value)) continue;
                this.nextElement = value;
                return true;
            }
            this.currentIterator = this.addIterator;
        }
        return false;
    }

    @Override
    public long next(NodeManager nodeManager) {
        this.hasNext(nodeManager);
        if (this.nextElement != null) {
            Long elementToReturn = this.nextElement;
            this.nextElement = null;
            return elementToReturn;
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSrcEmpty() {
        return this.src.isEmpty();
    }

    @Override
    public RelTypeElementIterator setSrc(RelIdArray newSrc) {
        return new FastRelTypeElement(this.getType(), this.getNode(), newSrc, this.srcIterator.position());
    }
}

