/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class RelIdArray {
    public static final RelIdArray EMPTY = new RelIdArray(){
        private RelIdIterator emptyIterator = new RelIdIterator(){

            @Override
            public boolean hasNext() {
                return false;
            }
        };

        @Override
        public RelIdIterator iterator() {
            return this.emptyIterator;
        }
    };
    private final List<IdBlock> blocks = new ArrayList<IdBlock>();
    private IdBlock lastBlock;
    public static final IdBlock EMPTY_BLOCK = new IdBlock(0L){

        @Override
        int length() {
            return 0;
        }
    };

    public void add(long id) {
        long highBits = id & 0xFFFFFFFF00000000L;
        if (this.lastBlock == null || this.lastBlock.highBits != highBits) {
            this.addBlock(highBits);
        }
        this.lastBlock.add((int)id);
    }

    public void addAll(RelIdArray source) {
        if (source == null) {
            return;
        }
        for (IdBlock block : source.blocks) {
            IdBlock copy = block.copy();
            this.blocks.add(copy);
            this.lastBlock = copy;
        }
    }

    public int length() {
        int length = 0;
        for (IdBlock block : this.blocks) {
            length += block.length;
        }
        return length;
    }

    public boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    private void addBlock(long highBits) {
        this.lastBlock = new IdBlock(highBits);
        this.blocks.add(this.lastBlock);
    }

    public RelIdIterator iterator() {
        return new RelIdIterator();
    }

    public static RelIdArray from(RelIdArray src, RelIdArray add, RelIdArray remove) {
        if (remove == null) {
            if (src == null) {
                return add;
            }
            if (add != null) {
                RelIdArray newArray = new RelIdArray();
                newArray.addAll(src);
                newArray.addAll(add);
                return newArray;
            }
            return src;
        }
        if (src == null && add == null) {
            return null;
        }
        RelIdArray newArray = new RelIdArray();
        newArray.addAll(src);
        Set<Long> removedSet = remove.asSet();
        RelIdArray.evictExcluded(newArray, removedSet);
        if (add != null) {
            RelIdIterator iterator = add.iterator();
            while (iterator.hasNext()) {
                long value = iterator.next();
                if (removedSet.contains(value)) continue;
                newArray.add(value);
            }
        }
        return newArray;
    }

    private static void evictExcluded(RelIdArray ids, Set<Long> excluded) {
        RelIdIterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            long value = iterator.next();
            if (!excluded.contains(value)) continue;
            boolean swapSuccessful = false;
            IdBlock block = iterator.currentBlock;
            for (int j = block.length - 1; j >= iterator.relativePosition; --j) {
                long backValue = block.get(j);
                block.length--;
                if (excluded.contains(backValue)) continue;
                block.set(backValue, iterator.relativePosition - 1);
                swapSuccessful = true;
                break;
            }
            if (swapSuccessful) continue;
            iterator.currentBlock.length--;
        }
    }

    private Set<Long> asSet() {
        HashSet<Long> set = new HashSet<Long>(this.length() + 1, 1.0f);
        RelIdIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public class RelIdIterator {
        private int blockIndex = 1;
        private IdBlock currentBlock = RelIdArray.this.isEmpty() ? EMPTY_BLOCK : (IdBlock)RelIdArray.access$200(RelIdArray.this).get(0);
        private int relativePosition;
        private int absolutePosition;
        private Long nextElement;

        public boolean hasNext() {
            if (this.nextElement != null) {
                return true;
            }
            while (true) {
                int blockLength;
                if (this.relativePosition < (blockLength = this.currentBlock.length())) {
                    this.nextElement = this.currentBlock.get(this.relativePosition++);
                    return true;
                }
                if (this.blockIndex >= RelIdArray.this.blocks.size()) break;
                this.goToNextBlock();
            }
            return false;
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long result = this.nextElement;
            this.nextElement = null;
            return result;
        }

        public void fastForwardTo(int position) {
            while (this.absolutePosition < position) {
                this.goToNextBlock();
            }
            this.absolutePosition = position;
        }

        private void goToNextBlock() {
            int leftInBlock = this.currentBlock.length - this.relativePosition;
            this.absolutePosition += leftInBlock;
            this.currentBlock = (IdBlock)RelIdArray.this.blocks.get(this.blockIndex++);
            this.relativePosition = 0;
        }

        public int position() {
            return this.absolutePosition;
        }
    }

    public static class IdBlock {
        private final long highBits;
        private int[] ids;
        private int length;

        IdBlock(long highBits) {
            this.highBits = highBits;
            this.ids = new int[2];
        }

        int length() {
            return this.length;
        }

        void add(int id) {
            if (this.length == this.ids.length) {
                int[] newIds = new int[this.length * 2];
                System.arraycopy(this.ids, 0, newIds, 0, this.ids.length);
                this.ids = newIds;
            }
            this.ids[this.length++] = id;
        }

        long get(int index) {
            assert (index >= 0 && index < this.length);
            return (long)this.ids[index] & 0xFFFFFFFFL | this.highBits;
        }

        void set(long id, int index) {
            this.ids[index] = (int)id;
        }

        IdBlock copy() {
            IdBlock copy = new IdBlock(this.highBits);
            copy.ids = new int[this.ids.length];
            System.arraycopy(this.ids, 0, copy.ids, 0, this.length);
            copy.length = this.length;
            return copy;
        }
    }
}

