/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.transaction.xaframework.CloseableByteBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;

public class DirectMappedLogBuffer
implements LogBuffer {
    static final int BUFFER_SIZE = 524288;
    private final FileChannel fileChannel;
    private CloseableByteBuffer byteBuffer = null;
    private long bufferStartPosition;

    public DirectMappedLogBuffer(FileChannel fileChannel) throws IOException {
        this.fileChannel = fileChannel;
        this.bufferStartPosition = fileChannel.position();
        this.byteBuffer = CloseableByteBuffer.wrap(ByteBuffer.allocateDirect(524288));
    }

    private void ensureCapacity(int plusSize) throws IOException {
        if (this.byteBuffer == null || 524288 - this.byteBuffer.position() < plusSize) {
            this.writeOut();
        }
    }

    @Override
    public LogBuffer put(byte b) throws IOException {
        this.ensureCapacity(1);
        this.byteBuffer.put(b);
        return this;
    }

    @Override
    public LogBuffer putShort(short s) throws IOException {
        this.ensureCapacity(2);
        this.byteBuffer.putShort(s);
        return this;
    }

    @Override
    public LogBuffer putInt(int i) throws IOException {
        this.ensureCapacity(4);
        this.byteBuffer.putInt(i);
        return this;
    }

    @Override
    public LogBuffer putLong(long l) throws IOException {
        this.ensureCapacity(8);
        this.byteBuffer.putLong(l);
        return this;
    }

    @Override
    public LogBuffer putFloat(float f) throws IOException {
        this.ensureCapacity(4);
        this.byteBuffer.putFloat(f);
        return this;
    }

    @Override
    public LogBuffer putDouble(double d) throws IOException {
        this.ensureCapacity(8);
        this.byteBuffer.putDouble(d);
        return this;
    }

    @Override
    public LogBuffer put(byte[] bytes) throws IOException {
        this.put(bytes, 0);
        return this;
    }

    private void put(byte[] bytes, int offset) throws IOException {
        int bytesToWrite = bytes.length - offset;
        if (bytesToWrite > 524288) {
            bytesToWrite = 524288;
        }
        this.ensureCapacity(bytesToWrite);
        this.byteBuffer.put(bytes, offset, bytesToWrite);
        if ((offset += bytesToWrite) < bytes.length) {
            this.put(bytes, offset);
        }
    }

    @Override
    public LogBuffer put(char[] chars) throws IOException {
        this.put(chars, 0);
        return this;
    }

    private void put(char[] chars, int offset) throws IOException {
        int charsToWrite = chars.length - offset;
        if (charsToWrite * 2 > 524288) {
            charsToWrite = 262144;
        }
        this.ensureCapacity(charsToWrite * 2);
        int oldPos = this.byteBuffer.position();
        this.byteBuffer.asCharBuffer().put(chars, offset, charsToWrite);
        this.byteBuffer.position(oldPos + charsToWrite * 2);
        if ((offset += charsToWrite) < chars.length) {
            this.put(chars, offset);
        }
    }

    @Override
    public void writeOut() throws IOException {
        this.byteBuffer.flip();
        this.bufferStartPosition += (long)this.fileChannel.write(this.byteBuffer.getDelegate(), this.bufferStartPosition);
        this.byteBuffer.clear();
    }

    @Override
    public void force() throws IOException {
        this.writeOut();
        this.fileChannel.force(false);
    }

    @Override
    public long getFileChannelPosition() {
        if (this.byteBuffer != null) {
            return this.bufferStartPosition + (long)this.byteBuffer.position();
        }
        return this.bufferStartPosition;
    }

    @Override
    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public CloseableByteBuffer getBuffer() {
        return this.byteBuffer.duplicate();
    }
}

