/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.TransactionImpl;
import org.neo4j.kernel.impl.transaction.TxFinishHook;
import org.neo4j.kernel.impl.transaction.TxLog;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaResource;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.StringLogger;

public class TxManager
extends AbstractTransactionManager {
    private static Logger log = Logger.getLogger(TxManager.class.getName());
    private ArrayMap<Thread, TransactionImpl> txThreadMap;
    private final String txLogDir;
    private static String separator = File.separator;
    private String logSwitcherFileName = "active_tx_log";
    private String txLog1FileName = "tm_tx_log.1";
    private String txLog2FileName = "tm_tx_log.2";
    private final int maxTxLogRecordCount = 1000;
    private int eventIdentifierCounter = 0;
    private TxLog txLog = null;
    private XaDataSourceManager xaDsManager = null;
    private boolean tmOk = false;
    private boolean blocked = false;
    private final KernelPanicEventGenerator kpe;
    private final AtomicInteger startedTxCount = new AtomicInteger(0);
    private final AtomicInteger comittedTxCount = new AtomicInteger(0);
    private final AtomicInteger rolledBackTxCount = new AtomicInteger(0);
    private int peakConcurrentTransactions = 0;
    private final StringLogger msgLog;
    final TxFinishHook finishHook;

    TxManager(String txLogDir, KernelPanicEventGenerator kpe, TxFinishHook finishHook) {
        this.txLogDir = txLogDir;
        this.msgLog = StringLogger.getLogger(txLogDir);
        this.kpe = kpe;
        this.finishHook = finishHook;
    }

    synchronized int getNextEventIdentifier() {
        return this.eventIdentifierCounter++;
    }

    private <E extends Exception> E logAndReturn(String msg, E exception) {
        try {
            this.msgLog.logMessage(msg, exception, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return exception;
    }

    @Override
    public void stop() {
        if (this.txLog != null) {
            try {
                this.txLog.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Unable to close tx log[" + this.txLog.getName() + "]", e);
            }
        }
        this.msgLog.logMessage("TM shutting down", true);
        StringLogger.close(this.txLogDir);
    }

    @Override
    public void init(XaDataSourceManager xaDsManagerToUse) {
        this.xaDsManager = xaDsManagerToUse;
        this.txThreadMap = new ArrayMap(5, true, true);
        this.logSwitcherFileName = this.txLogDir + separator + "active_tx_log";
        this.txLog1FileName = "tm_tx_log.1";
        this.txLog2FileName = "tm_tx_log.2";
        try {
            if (new File(this.logSwitcherFileName).exists()) {
                FileChannel fc = new RandomAccessFile(this.logSwitcherFileName, "rw").getChannel();
                byte[] fileName = new byte[256];
                ByteBuffer buf = ByteBuffer.wrap(fileName);
                fc.read(buf);
                fc.close();
                String currentTxLog = this.txLogDir + separator + UTF8.decode(fileName).trim();
                if (!new File(currentTxLog).exists()) {
                    throw this.logAndReturn("TM startup failure", new TransactionFailureException("Unable to start TM, active tx log file[" + currentTxLog + "] not found."));
                }
                this.txLog = new TxLog(currentTxLog);
                this.msgLog.logMessage("TM opening log: " + currentTxLog, true);
            } else {
                if (new File(this.txLogDir + separator + this.txLog1FileName).exists() || new File(this.txLogDir + separator + this.txLog2FileName).exists()) {
                    throw this.logAndReturn("TM startup failure", new TransactionFailureException("Unable to start TM, no active tx log file found but found either " + this.txLog1FileName + " or " + this.txLog2FileName + " file, please set one of them as active or " + "remove them."));
                }
                ByteBuffer buf = ByteBuffer.wrap(this.txLog1FileName.getBytes("UTF-8"));
                FileChannel fc = new RandomAccessFile(this.logSwitcherFileName, "rw").getChannel();
                fc.write(buf);
                this.txLog = new TxLog(this.txLogDir + separator + this.txLog1FileName);
                this.msgLog.logMessage("TM new log: " + this.txLog1FileName, true);
                fc.force(true);
                fc.close();
            }
            Iterator<List<TxLog.Record>> danglingRecordList = this.txLog.getDanglingRecords();
            if (danglingRecordList.hasNext()) {
                log.info("Unresolved transactions found, recovery started ...");
                this.recover(danglingRecordList);
                log.info("Recovery completed, all transactions have been resolved to a consistent state.");
                this.msgLog.logMessage("Recovery completed, all transactions have been resolved to a consistent state.");
            }
            this.getTxLog().truncate();
            this.tmOk = true;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Unable to start TM", e);
            throw this.logAndReturn("TM startup failure", new TransactionFailureException("Unable to start TM", e));
        }
    }

    synchronized TxLog getTxLog() throws IOException {
        if (this.txLog.getRecordCount() > 1000) {
            if (this.txLog.getName().endsWith(this.txLog1FileName)) {
                this.txLog.switchToLogFile(this.txLogDir + separator + this.txLog2FileName);
                this.changeActiveLog(this.txLog2FileName);
            } else if (this.txLog.getName().endsWith(this.txLog2FileName)) {
                this.txLog.switchToLogFile(this.txLogDir + separator + this.txLog1FileName);
                this.changeActiveLog(this.txLog1FileName);
            } else {
                this.setTmNotOk();
                log.severe("Unknown active tx log file[" + this.txLog.getName() + "], unable to switch.");
                IOException ex = new IOException("Unknown txLogFile[" + this.txLog.getName() + "] not equals to either [" + this.txLog1FileName + "] or [" + this.txLog2FileName + "]");
                throw this.logAndReturn("TM error accessing log file", ex);
            }
        }
        return this.txLog;
    }

    private void changeActiveLog(String newFileName) throws IOException {
        FileChannel fc = new RandomAccessFile(this.logSwitcherFileName, "rw").getChannel();
        ByteBuffer buf = ByteBuffer.wrap(UTF8.encode(newFileName));
        fc.truncate(0L);
        fc.write(buf);
        fc.force(true);
        fc.close();
    }

    void setTmNotOk() {
        this.tmOk = false;
        this.msgLog.logMessage("setting TM not OK", new Throwable());
        this.kpe.generateEvent(ErrorState.TX_MANAGER_NOT_OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attemptWaitForTxCompletionAndBlockFutureTransactions(long maxWaitTimeMillis) {
        this.msgLog.logMessage("TxManager is blocking new transactions and waiting for active to fail...");
        this.blocked = true;
        ArrayList<TransactionImpl> failedTransactions = new ArrayList<TransactionImpl>();
        ArrayMap<Thread, TransactionImpl> arrayMap = this.txThreadMap;
        synchronized (arrayMap) {
            for (TransactionImpl tx : this.txThreadMap.values()) {
                try {
                    int status = tx.getStatus();
                    if (status == 8 || status == 9) continue;
                    tx.setRollbackOnly();
                }
                catch (IllegalStateException e) {
                    failedTransactions.add(tx);
                }
                catch (SystemException e) {
                    failedTransactions.add(tx);
                }
            }
        }
        this.msgLog.logMessage("TxManager blocked transactions" + (failedTransactions.isEmpty() ? "" : ", but failed for: " + ((Object)failedTransactions).toString()));
        long endTime = System.currentTimeMillis() + maxWaitTimeMillis;
        while (this.txThreadMap.size() > 0 && System.currentTimeMillis() < endTime) {
            Thread.yield();
        }
    }

    private void recover(Iterator<List<TxLog.Record>> danglingRecordList) {
        this.msgLog.logMessage("TM non resolved transactions found in " + this.txLog.getName(), true);
        try {
            ArrayList<NonCompletedTransaction> commitList = new ArrayList<NonCompletedTransaction>();
            LinkedList<Xid> rollbackList = new LinkedList<Xid>();
            HashMap<Resource, XAResource> resourceMap = new HashMap<Resource, XAResource>();
            this.buildRecoveryInfo(commitList, rollbackList, resourceMap, danglingRecordList);
            Iterator resourceItr = resourceMap.keySet().iterator();
            LinkedList<Xid> recoveredXidsList = new LinkedList<Xid>();
            while (resourceItr.hasNext()) {
                XAResource xaRes = (XAResource)resourceMap.get(resourceItr.next());
                Xid[] xids = xaRes.recover(0);
                for (int i = 0; i < xids.length; ++i) {
                    if (XidImpl.isThisTm(xids[i].getGlobalTransactionId())) {
                        if (rollbackList.contains(xids[i])) {
                            log.fine("Found pre commit " + xids[i] + " rolling back ... ");
                            this.msgLog.logMessage("TM: Found pre commit " + xids[i] + " rolling back ... ", true);
                            rollbackList.remove(xids[i]);
                            xaRes.rollback(xids[i]);
                            continue;
                        }
                        recoveredXidsList.add(xids[i]);
                        continue;
                    }
                    log.warning("Unknown xid: " + xids[i]);
                }
            }
            Collections.sort(commitList, new Comparator<NonCompletedTransaction>(){

                @Override
                public int compare(NonCompletedTransaction r1, NonCompletedTransaction r2) {
                    return r1.getSequenceNumber() - r2.getSequenceNumber();
                }
            });
            for (NonCompletedTransaction nct : commitList) {
                int seq = nct.getSequenceNumber();
                Xid[] xids = nct.getXids();
                log.fine("Marked as commit tx-seq[" + seq + "] branch length: " + xids.length);
                for (Xid xid : xids) {
                    if (!recoveredXidsList.contains(xid)) {
                        log.fine("Tx-seq[" + seq + "][" + xid + "] not found in recovered xid list, " + "assuming already committed");
                        continue;
                    }
                    recoveredXidsList.remove(xid);
                    Resource resource = new Resource(xid.getBranchQualifier());
                    if (!resourceMap.containsKey(resource)) {
                        TransactionFailureException ex = new TransactionFailureException("Couldn't find XAResource for " + xid);
                        throw this.logAndReturn("TM: recovery error", ex);
                    }
                    log.fine("Commiting tx seq[" + seq + "][" + xid + "] ... ");
                    this.msgLog.logMessage("TM: Committing tx " + xid, true);
                    ((XAResource)resourceMap.get(resource)).commit(xid, false);
                }
            }
            for (Xid xid : recoveredXidsList) {
                Resource resource = new Resource(xid.getBranchQualifier());
                if (!resourceMap.containsKey(resource)) {
                    TransactionFailureException ex = new TransactionFailureException("Couldn't find XAResource for " + xid);
                    throw this.logAndReturn("TM: recovery error", ex);
                }
                log.fine("Rollback " + xid + " ... ");
                this.msgLog.logMessage("TM: no match found for " + xid + " removing", true);
                ((XAResource)resourceMap.get(resource)).rollback(xid);
            }
            if (rollbackList.size() > 0) {
                log.fine("TxLog contained unresolved xids that needed rollback. They couldn't be matched to any of the XAResources recover list. Assuming " + rollbackList.size() + " transactions already rolled back.");
                this.msgLog.logMessage("TM: no match found for in total " + rollbackList.size() + " transaction that should have been rolled back", true);
            }
            for (XAResource participant : MapUtil.reverse(resourceMap).keySet()) {
                this.xaResourceToDataSource(participant).rotateLogicalLog();
            }
        }
        catch (IOException e) {
            throw this.logAndReturn("TM: recovery failed", new TransactionFailureException("Recovery failed.", e));
        }
        catch (XAException e) {
            throw this.logAndReturn("TM: recovery failed", new TransactionFailureException("Recovery failed.", e));
        }
    }

    private XaDataSource xaResourceToDataSource(XAResource participant) {
        byte[] participantBranchId = this.xaDsManager.getBranchId(participant);
        for (XaDataSource dataSource : this.xaDsManager.getAllRegisteredDataSources()) {
            if (!Arrays.equals(participantBranchId, dataSource.getBranchId())) continue;
            return dataSource;
        }
        throw this.logAndReturn("TM recovery data source not found", new TransactionFailureException("Data source for recovery participant " + participant + ", " + Arrays.toString(participantBranchId) + " couldn't be found"));
    }

    private void buildRecoveryInfo(List<NonCompletedTransaction> commitList, List<Xid> rollbackList, Map<Resource, XAResource> resourceMap, Iterator<List<TxLog.Record>> danglingRecordList) {
        while (danglingRecordList.hasNext()) {
            Iterator<TxLog.Record> dListItr = danglingRecordList.next().iterator();
            TxLog.Record startRecord = dListItr.next();
            if (startRecord.getType() != 1) {
                throw this.logAndReturn("TM error building recovery info", new TransactionFailureException("First record not a start record, type=" + startRecord.getType()));
            }
            HashSet<Resource> branchSet = new HashSet<Resource>();
            int markedCommit = -1;
            while (dListItr.hasNext()) {
                TxLog.Record record = dListItr.next();
                if (record.getType() == 2) {
                    if (markedCommit != -1) {
                        throw this.logAndReturn("TM error building recovery info", new TransactionFailureException("Already marked commit " + startRecord));
                    }
                    branchSet.add(new Resource(record.getBranchId()));
                    continue;
                }
                if (record.getType() == 3) {
                    if (markedCommit != -1) {
                        throw this.logAndReturn("TM error building recovery info", new TransactionFailureException("Already marked commit " + startRecord));
                    }
                    markedCommit = record.getSequenceNumber();
                    continue;
                }
                throw this.logAndReturn("TM error building recovery info", new TransactionFailureException("Illegal record type[" + record.getType() + "]"));
            }
            Iterator resourceItr = branchSet.iterator();
            LinkedList<Xid> xids = new LinkedList<Xid>();
            while (resourceItr.hasNext()) {
                Resource resource = (Resource)resourceItr.next();
                if (!resourceMap.containsKey(resource)) {
                    resourceMap.put(resource, this.getXaResource(resource.getResourceId()));
                }
                xids.add(new XidImpl(startRecord.getGlobalId(), resource.getResourceId()));
            }
            if (markedCommit != -1) {
                commitList.add(new NonCompletedTransaction(markedCommit, xids));
                continue;
            }
            rollbackList.addAll(xids);
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        if (this.blocked) {
            throw new SystemException("TxManager is preventing new transactions from starting due a shutdown is imminent");
        }
        this.assertTmOk("tx begin");
        Thread thread = Thread.currentThread();
        TransactionImpl tx = this.txThreadMap.get(thread);
        if (tx != null) {
            throw this.logAndReturn("TM error tx begin", new NotSupportedException("Nested transactions not supported"));
        }
        tx = new TransactionImpl(this);
        this.txThreadMap.put(thread, tx);
        int concurrentTxCount = this.txThreadMap.size();
        if (concurrentTxCount > this.peakConcurrentTransactions) {
            this.peakConcurrentTransactions = concurrentTxCount;
        }
        this.startedTxCount.incrementAndGet();
    }

    private void assertTmOk(String source) throws SystemException {
        if (!this.tmOk) {
            throw this.logAndReturn("TM error " + source, new SystemException("TM has encountered some problem, please perform neccesary action (tx recovery/restart)"));
        }
    }

    void writeStartRecord(byte[] globalId) throws SystemException {
        try {
            this.getTxLog().txStart(globalId);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error writing transaction log", e);
            this.setTmNotOk();
            throw (SystemException)((Object)this.logAndReturn("TM error write start record", (Exception)((Object)Exceptions.withCause(new SystemException("TM encountered a problem,  error writing transaction log,"), e))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, IllegalStateException, SystemException {
        block8: {
            this.assertTmOk("tx commit");
            Thread thread = Thread.currentThread();
            TransactionImpl tx = this.txThreadMap.get(thread);
            if (tx == null) {
                throw this.logAndReturn("TM error tx commit", new IllegalStateException("Not in transaction"));
            }
            boolean hasAnyLocks = false;
            try {
                hasAnyLocks = this.finishHook.hasAnyLocks(tx);
                if (tx.getStatus() != 0 && tx.getStatus() != 1) {
                    throw this.logAndReturn("TM error tx commit", new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus())));
                }
                tx.doBeforeCompletion();
                if (tx.getStatus() == 0) {
                    this.comittedTxCount.incrementAndGet();
                    this.commit(thread, tx);
                    break block8;
                }
                if (tx.getStatus() == 1) {
                    this.rolledBackTxCount.incrementAndGet();
                    this.rollbackCommit(thread, tx);
                    break block8;
                }
                throw this.logAndReturn("TM error tx commit", new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus())));
            }
            finally {
                if (hasAnyLocks) {
                    this.finishHook.finishTransaction(tx.getEventIdentifier());
                }
            }
        }
    }

    private void commit(Thread thread, TransactionImpl tx) throws SystemException, HeuristicMixedException, HeuristicRollbackException {
        Throwable commitFailureCause = null;
        int xaErrorCode = -1;
        if (tx.getResourceCount() == 0) {
            tx.setStatus(3);
        } else {
            try {
                tx.doCommit();
            }
            catch (XAException e) {
                xaErrorCode = e.errorCode;
                log.log(Level.SEVERE, "Commit failed, status=" + this.getTxStatusAsString(tx.getStatus()) + ", errorCode=" + xaErrorCode, e);
                if (tx.getStatus() == 3) {
                    this.setTmNotOk();
                    throw this.logAndReturn("TM error tx commit", new TransactionFailureException("commit threw exception but status is committed?", e));
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Commit failed", t);
                commitFailureCause = t;
            }
        }
        if (tx.getStatus() != 3) {
            try {
                tx.doRollback();
            }
            catch (XAException e) {
                log.log(Level.SEVERE, "Unable to rollback transaction. Some resources may be commited others not. Neo4j kernel should be SHUTDOWN for resource maintance and transaction recovery ---->", e);
                this.setTmNotOk();
                String commitError = commitFailureCause != null ? "error in commit: " + commitFailureCause : "error code in commit: " + xaErrorCode;
                throw (HeuristicMixedException)((Object)this.logAndReturn("TM error tx commit", (Exception)((Object)Exceptions.withCause(new HeuristicMixedException("Unable to rollback ---> " + commitError + " ---> error code for rollback: " + e.errorCode), e))));
            }
            tx.doAfterCompletion();
            this.txThreadMap.remove(thread);
            try {
                if (tx.isGlobalStartRecordWritten()) {
                    this.getTxLog().txDone(tx.getGlobalId());
                }
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Error writing transaction log", e);
                this.setTmNotOk();
                throw (SystemException)((Object)this.logAndReturn("TM error tx commit", (Exception)((Object)Exceptions.withCause(new SystemException("TM encountered a problem,  error writing transaction log"), e))));
            }
            tx.setStatus(6);
            if (commitFailureCause == null) {
                throw this.logAndReturn("TM error tx commit", new HeuristicRollbackException("Failed to commit, transaction rolledback ---> error code was: " + xaErrorCode));
            }
            throw (HeuristicRollbackException)((Object)this.logAndReturn("TM error tx commit", (Exception)((Object)Exceptions.withCause(new HeuristicRollbackException("Failed to commit, transaction rolledback ---> " + commitFailureCause), commitFailureCause))));
        }
        tx.doAfterCompletion();
        this.txThreadMap.remove(thread);
        try {
            if (tx.isGlobalStartRecordWritten()) {
                this.getTxLog().txDone(tx.getGlobalId());
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error writing transaction log", e);
            this.setTmNotOk();
            throw (SystemException)((Object)this.logAndReturn("TM error tx commit", (Exception)((Object)Exceptions.withCause(new SystemException("TM encountered a problem,  error writing transaction log"), e))));
        }
        tx.setStatus(6);
    }

    private void rollbackCommit(Thread thread, TransactionImpl tx) throws HeuristicMixedException, RollbackException, SystemException {
        try {
            tx.doRollback();
        }
        catch (XAException e) {
            log.log(Level.SEVERE, "Unable to rollback marked transaction. Some resources may be commited others not. Neo4j kernel should be SHUTDOWN for resource maintance and transaction recovery ---->", e);
            this.setTmNotOk();
            throw (HeuristicMixedException)((Object)this.logAndReturn("TM error tx rollback commit", (Exception)((Object)Exceptions.withCause(new HeuristicMixedException("Unable to rollback  ---> error code for rollback: " + e.errorCode), e))));
        }
        tx.doAfterCompletion();
        this.txThreadMap.remove(thread);
        try {
            if (tx.isGlobalStartRecordWritten()) {
                this.getTxLog().txDone(tx.getGlobalId());
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error writing transaction log", e);
            this.setTmNotOk();
            throw (SystemException)((Object)this.logAndReturn("TM error tx rollback commit", (Exception)((Object)Exceptions.withCause(new SystemException("TM encountered a problem,  error writing transaction log"), e))));
        }
        tx.setStatus(6);
        throw new RollbackException("Failed to commit, transaction rolledback");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SystemException {
        block11: {
            this.assertTmOk("tx rollback");
            Thread thread = Thread.currentThread();
            TransactionImpl tx = this.txThreadMap.get(thread);
            if (tx == null) {
                throw new IllegalStateException("Not in transaction");
            }
            boolean hasAnyLocks = false;
            try {
                hasAnyLocks = this.finishHook.hasAnyLocks(tx);
                if (tx.getStatus() == 0 || tx.getStatus() == 1 || tx.getStatus() == 7) {
                    tx.setStatus(1);
                    tx.doBeforeCompletion();
                    try {
                        this.rolledBackTxCount.incrementAndGet();
                        tx.doRollback();
                    }
                    catch (XAException e) {
                        log.log(Level.SEVERE, "Unable to rollback marked or active transaction. Some resources may be commited others not. Neo4j kernel should be SHUTDOWN for resource maintance and transaction recovery ---->", e);
                        this.setTmNotOk();
                        throw (SystemException)((Object)this.logAndReturn("TM error tx rollback", (Exception)((Object)Exceptions.withCause(new SystemException("Unable to rollback  ---> error code for rollback: " + e.errorCode), e))));
                    }
                    tx.doAfterCompletion();
                    this.txThreadMap.remove(thread);
                    try {
                        if (tx.isGlobalStartRecordWritten()) {
                            this.getTxLog().txDone(tx.getGlobalId());
                        }
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "Error writing transaction log", e);
                        this.setTmNotOk();
                        throw (SystemException)((Object)this.logAndReturn("TM error tx rollback", (Exception)((Object)Exceptions.withCause(new SystemException("TM encountered a problem,  error writing transaction log"), e))));
                    }
                    tx.setStatus(6);
                    break block11;
                }
                throw new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus()));
            }
            finally {
                if (hasAnyLocks) {
                    this.finishHook.finishTransaction(tx.getEventIdentifier());
                }
            }
        }
    }

    public int getStatus() {
        Thread thread = Thread.currentThread();
        TransactionImpl tx = this.txThreadMap.get(thread);
        if (tx != null) {
            return tx.getStatus();
        }
        return 6;
    }

    public Transaction getTransaction() {
        return this.txThreadMap.get(Thread.currentThread());
    }

    public void resume(Transaction tx) throws IllegalStateException, SystemException {
        TransactionImpl txImpl;
        this.assertTmOk("tx resume");
        Thread thread = Thread.currentThread();
        if (this.txThreadMap.get(thread) != null) {
            throw new IllegalStateException("Transaction already associated");
        }
        if (tx != null && (txImpl = (TransactionImpl)tx).getStatus() != 6) {
            if (txImpl.isActive()) {
                throw new IllegalStateException(txImpl + " already active");
            }
            txImpl.markAsActive();
            this.txThreadMap.put(thread, txImpl);
        }
    }

    public Transaction suspend() throws SystemException {
        this.assertTmOk("tx suspend");
        TransactionImpl tx = this.txThreadMap.remove(Thread.currentThread());
        if (tx != null) {
            tx.markAsSuspended();
        }
        return tx;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.assertTmOk("tx set rollback only");
        Thread thread = Thread.currentThread();
        TransactionImpl tx = this.txThreadMap.get(thread);
        if (tx == null) {
            throw new IllegalStateException("Not in transaction");
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.assertTmOk("tx set timeout");
    }

    byte[] getBranchId(XAResource xaRes) {
        byte[] branchId;
        if (xaRes instanceof XaResource && (branchId = ((XaResource)xaRes).getBranchId()) != null) {
            return branchId;
        }
        return this.xaDsManager.getBranchId(xaRes);
    }

    XAResource getXaResource(byte[] branchId) {
        return this.xaDsManager.getXaResource(branchId);
    }

    String getTxStatusAsString(int status) {
        switch (status) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 8: {
                return "STATUS_COMMITING";
            }
            case 3: {
                return "STATUS_COMMITED";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
        }
        return "STATUS_UNKNOWN(" + status + ")";
    }

    public synchronized void dumpTransactions() {
        Iterator<TransactionImpl> itr = this.txThreadMap.values().iterator();
        if (!itr.hasNext()) {
            System.out.println("No uncompleted transactions");
            return;
        }
        System.out.println("Uncompleted transactions found: ");
        while (itr.hasNext()) {
            System.out.println(itr.next());
        }
    }

    public int getEventIdentifier() {
        TransactionImpl tx = (TransactionImpl)this.getTransaction();
        if (tx != null) {
            return tx.getEventIdentifier();
        }
        return -1;
    }

    public int getStartedTxCount() {
        return this.startedTxCount.get();
    }

    public int getCommittedTxCount() {
        return this.comittedTxCount.get();
    }

    public int getRolledbackTxCount() {
        return this.rolledBackTxCount.get();
    }

    public int getActiveTxCount() {
        return this.txThreadMap.size();
    }

    public int getPeakConcurrentTxCount() {
        return this.peakConcurrentTransactions;
    }

    private static class Resource {
        private byte[] resourceId = null;
        private volatile int hashCode = 0;

        Resource(byte[] resourceId) {
            if (resourceId == null || resourceId.length == 0) {
                throw new IllegalArgumentException("Illegal resourceId");
            }
            this.resourceId = resourceId;
        }

        byte[] getResourceId() {
            return this.resourceId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Resource)) {
                return false;
            }
            byte[] otherResourceId = ((Resource)o).getResourceId();
            if (this.resourceId.length != otherResourceId.length) {
                return false;
            }
            for (int i = 0; i < this.resourceId.length; ++i) {
                if (this.resourceId[i] == otherResourceId[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int calcHash = 0;
                for (int i = 0; i < this.resourceId.length; ++i) {
                    calcHash += this.resourceId[i] << i * 8;
                }
                this.hashCode = 3217 * calcHash;
            }
            return this.hashCode;
        }
    }

    private static class NonCompletedTransaction {
        private int seqNr = -1;
        private List<Xid> xidList = null;

        NonCompletedTransaction(int seqNr, List<Xid> xidList) {
            this.seqNr = seqNr;
            this.xidList = xidList;
        }

        int getSequenceNumber() {
            return this.seqNr;
        }

        Xid[] getXids() {
            return this.xidList.toArray(new XidImpl[this.xidList.size()]);
        }

        public String toString() {
            return "NonCompletedTx[" + this.seqNr + "," + this.xidList + "]";
        }
    }
}

