/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyEventData;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.util.ArrayMap;

abstract class Primitive {
    private static final PropertyData[] NO_PROPERTIES = new PropertyData[0];
    private volatile PropertyData[] properties;

    protected abstract PropertyData changeProperty(NodeManager var1, PropertyData var2, Object var3);

    protected abstract PropertyData addProperty(NodeManager var1, PropertyIndex var2, Object var3);

    protected abstract void removeProperty(NodeManager var1, PropertyData var2);

    protected abstract ArrayMap<Integer, PropertyData> loadProperties(NodeManager var1, boolean var2);

    Primitive(boolean newPrimitive) {
        if (newPrimitive) {
            this.properties = NO_PROPERTIES;
        }
    }

    public abstract long getId();

    public int hashCode() {
        long id = this.getId();
        return (int)(id >>> 32 ^ id);
    }

    public Iterable<Object> getPropertyValues(NodeManager nodeManager) {
        ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties(nodeManager);
        ArrayList<Object> values = new ArrayList<Object>();
        for (PropertyData property : this.properties) {
            Integer index = property.getIndex();
            if (skipMap != null && skipMap.get(index) != null || addMap != null && addMap.get(index) != null) continue;
            values.add(property.getValue());
        }
        if (addMap != null) {
            for (PropertyData property : addMap.values()) {
                values.add(property.getValue());
            }
        }
        return values;
    }

    public Iterable<String> getPropertyKeys(NodeManager nodeManager) {
        ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties(nodeManager);
        ArrayList<String> keys = new ArrayList<String>();
        for (PropertyData property : this.properties) {
            Integer index = property.getIndex();
            if (skipMap != null && skipMap.get(index) != null || addMap != null && addMap.get(index) != null) continue;
            keys.add(nodeManager.getIndexFor(index).getKey());
        }
        if (addMap != null) {
            for (Integer index : addMap.keySet()) {
                keys.add(nodeManager.getIndexFor(index).getKey());
            }
        }
        return keys;
    }

    public Object getProperty(NodeManager nodeManager, String key) throws NotFoundException {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties(nodeManager);
        for (PropertyIndex index : nodeManager.index(key)) {
            PropertyData property;
            if (skipMap != null && skipMap.get(index.getKeyId()) != null) {
                throw this.newPropertyNotFoundException(key);
            }
            if (addMap != null && (property = addMap.get(index.getKeyId())) != null) {
                return this.getPropertyValue(nodeManager, property);
            }
            property = this.getPropertyForIndex(index.getKeyId());
            if (property == null) continue;
            return this.getPropertyValue(nodeManager, property);
        }
        PropertyData property = this.getSlowProperty(nodeManager, addMap, skipMap, key);
        if (property != null) {
            return this.getPropertyValue(nodeManager, property);
        }
        throw this.newPropertyNotFoundException(key);
    }

    private NotFoundException newPropertyNotFoundException(String key) {
        return new NotFoundException(key + " property not found for " + this + ".");
    }

    private PropertyData getSlowProperty(NodeManager nodeManager, ArrayMap<Integer, PropertyData> addMap, ArrayMap<Integer, PropertyData> skipMap, String key) {
        if (nodeManager.hasAllPropertyIndexes()) {
            return null;
        }
        if (addMap != null) {
            for (int keyId : addMap.keySet()) {
                PropertyIndex indexToCheck;
                if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key)) continue;
                if (skipMap != null && skipMap.get(keyId) != null) {
                    throw this.newPropertyNotFoundException(key);
                }
                PropertyData property = addMap.get(indexToCheck.getKeyId());
                if (property == null) continue;
                return property;
            }
        }
        for (PropertyData property : this.properties) {
            PropertyIndex indexToCheck;
            int keyId = property.getIndex();
            if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key)) continue;
            if (skipMap != null && skipMap.get(keyId) != null) {
                throw this.newPropertyNotFoundException(key);
            }
            if (property == null) continue;
            return property;
        }
        return null;
    }

    public Object getProperty(NodeManager nodeManager, String key, Object defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties(nodeManager);
        for (PropertyIndex index : nodeManager.index(key)) {
            PropertyData property;
            if (skipMap != null && skipMap.get(index.getKeyId()) != null) {
                return defaultValue;
            }
            if (addMap != null && (property = addMap.get(index.getKeyId())) != null) {
                return this.getPropertyValue(nodeManager, property);
            }
            property = this.getPropertyForIndex(index.getKeyId());
            if (property == null) continue;
            return this.getPropertyValue(nodeManager, property);
        }
        PropertyData property = this.getSlowProperty(nodeManager, addMap, skipMap, key);
        if (property != null) {
            return this.getPropertyValue(nodeManager, property);
        }
        return defaultValue;
    }

    public boolean hasProperty(NodeManager nodeManager, String key) {
        if (key == null) {
            return false;
        }
        ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties(nodeManager);
        for (PropertyIndex index : nodeManager.index(key)) {
            PropertyData property;
            if (skipMap != null && skipMap.get(index.getKeyId()) != null) {
                return false;
            }
            if (addMap != null && (property = addMap.get(index.getKeyId())) != null) {
                return true;
            }
            property = this.getPropertyForIndex(index.getKeyId());
            if (property == null) continue;
            return true;
        }
        PropertyData property = this.getSlowProperty(nodeManager, addMap, skipMap, key);
        return property != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(NodeManager nodeManager, String key, Object value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Null parameter, key=" + key + ", " + "value=" + value);
        }
        nodeManager.acquireLock(this, LockType.WRITE);
        boolean success = false;
        try {
            this.ensureFullProperties(nodeManager);
            ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this, true);
            ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
            PropertyIndex index = null;
            PropertyData property = null;
            boolean foundInSkipMap = false;
            for (PropertyIndex cachedIndex : nodeManager.index(key)) {
                if (skipMap != null && skipMap.remove(cachedIndex.getKeyId()) != null) {
                    foundInSkipMap = true;
                }
                index = cachedIndex;
                property = addMap.get(cachedIndex.getKeyId());
                if (property == null && (property = this.getPropertyForIndex(cachedIndex.getKeyId())) == null) continue;
                break;
            }
            if (property == null && !nodeManager.hasAllPropertyIndexes()) {
                Iterator<Object> i$ = addMap.keySet().iterator();
                while (i$.hasNext()) {
                    PropertyIndex indexToCheck;
                    int keyId = (Integer)i$.next();
                    if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key)) continue;
                    if (skipMap != null) {
                        skipMap.remove(indexToCheck.getKeyId());
                    }
                    index = indexToCheck;
                    property = addMap.get(indexToCheck.getKeyId());
                    if (property == null) continue;
                    break;
                }
                if (property == null) {
                    for (PropertyData aProperty : this.properties) {
                        PropertyIndex indexToCheck;
                        int keyId = aProperty.getIndex();
                        if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key)) continue;
                        if (skipMap != null) {
                            skipMap.remove(indexToCheck.getKeyId());
                        }
                        index = indexToCheck;
                        property = this.getPropertyForIndex(indexToCheck.getKeyId());
                        if (property != null) break;
                    }
                }
            }
            if (index == null) {
                index = nodeManager.createPropertyIndex(key);
            }
            property = property != null && !foundInSkipMap ? this.changeProperty(nodeManager, property, value) : this.addProperty(nodeManager, index, value);
            addMap.put(index.getKeyId(), property);
            success = true;
        }
        finally {
            nodeManager.releaseLock(this, LockType.WRITE);
            if (!success) {
                nodeManager.setRollbackOnly();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeProperty(NodeManager nodeManager, String key) {
        if (key == null) {
            throw new IllegalArgumentException("Null parameter.");
        }
        nodeManager.acquireLock(this, LockType.WRITE);
        boolean success = false;
        try {
            Object object;
            this.ensureFullProperties(nodeManager);
            PropertyData property = null;
            ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
            ArrayMap<Integer, PropertyData> removeMap = nodeManager.getCowPropertyRemoveMap(this, false);
            for (PropertyIndex cachedIndex : nodeManager.index(key)) {
                if (addMap != null && (property = addMap.remove(cachedIndex.getKeyId())) != null) {
                    removeMap = removeMap != null ? removeMap : nodeManager.getCowPropertyRemoveMap(this, true);
                    removeMap.put(cachedIndex.getKeyId(), property);
                    break;
                }
                if (removeMap != null && removeMap.get(cachedIndex.getKeyId()) != null) {
                    success = true;
                    Object var9_11 = null;
                    return var9_11;
                }
                property = this.getPropertyForIndex(cachedIndex.getKeyId());
                if (property == null) continue;
                removeMap = removeMap != null ? removeMap : nodeManager.getCowPropertyRemoveMap(this, true);
                removeMap.put(cachedIndex.getKeyId(), property);
                break;
            }
            if (property == null && !nodeManager.hasAllPropertyIndexes() && addMap != null) {
                Iterator<Object> i$ = addMap.keySet().iterator();
                while (i$.hasNext()) {
                    PropertyIndex indexToCheck;
                    int keyId = (Integer)i$.next();
                    if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key) || (property = addMap.remove(indexToCheck.getKeyId())) == null) continue;
                    removeMap = removeMap != null ? removeMap : nodeManager.getCowPropertyRemoveMap(this, true);
                    removeMap.put(indexToCheck.getKeyId(), property);
                    break;
                }
                if (property == null) {
                    for (PropertyData aProperty : this.properties) {
                        PropertyIndex indexToCheck;
                        int keyId = aProperty.getIndex();
                        if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key) || (property = this.getPropertyForIndex(indexToCheck.getKeyId())) == null) continue;
                        removeMap = removeMap != null ? removeMap : nodeManager.getCowPropertyRemoveMap(this, true);
                        removeMap.put(indexToCheck.getKeyId(), property);
                        break;
                    }
                }
            }
            if (property == null) {
                success = true;
                object = null;
                return object;
            }
            this.removeProperty(nodeManager, property);
            success = true;
            object = this.getPropertyValue(nodeManager, property);
            return object;
        }
        finally {
            nodeManager.releaseLock(this, LockType.WRITE);
            if (!success) {
                nodeManager.setRollbackOnly();
            }
        }
    }

    private Object getPropertyValue(NodeManager nodeManager, PropertyData property) {
        Object value = property.getValue();
        if (value == null) {
            value = nodeManager.loadPropertyValue(property.getId());
            property.setNewValue(value);
        }
        return value;
    }

    protected void commitPropertyMaps(ArrayMap<Integer, PropertyData> cowPropertyAddMap, ArrayMap<Integer, PropertyData> cowPropertyRemoveMap) {
        PropertyData existingProperty;
        int i;
        if (this.properties == null) {
            return;
        }
        PropertyData[] newArray = this.properties;
        int extraLength = 0;
        if (cowPropertyAddMap != null) {
            extraLength += cowPropertyAddMap.size();
        }
        if (extraLength > 0) {
            newArray = new PropertyData[this.properties.length + extraLength];
            System.arraycopy(this.properties, 0, newArray, 0, this.properties.length);
        }
        int newArraySize = this.properties.length;
        if (cowPropertyRemoveMap != null) {
            block0: for (Integer keyIndex : cowPropertyRemoveMap.keySet()) {
                for (i = 0; i < newArraySize; ++i) {
                    existingProperty = newArray[i];
                    if (existingProperty.getIndex() != keyIndex.intValue()) continue;
                    int swapWith = --newArraySize;
                    newArray[i] = newArray[swapWith];
                    newArray[swapWith] = null;
                    continue block0;
                }
            }
        }
        if (cowPropertyAddMap != null) {
            block2: for (PropertyData addedProperty : cowPropertyAddMap.values()) {
                for (i = 0; i < newArray.length; ++i) {
                    existingProperty = newArray[i];
                    if (existingProperty != null && addedProperty.getIndex() != existingProperty.getIndex()) continue;
                    newArray[i] = addedProperty;
                    if (existingProperty != null) continue block2;
                    ++newArraySize;
                    continue block2;
                }
            }
        }
        if (newArraySize < newArray.length) {
            PropertyData[] compactedNewArray = new PropertyData[newArraySize];
            System.arraycopy(newArray, 0, compactedNewArray, 0, newArraySize);
            this.properties = compactedNewArray;
        } else {
            this.properties = newArray;
        }
    }

    private PropertyData getPropertyForIndex(int keyId) {
        for (PropertyData property : this.properties) {
            if (property.getIndex() != keyId) continue;
            return property;
        }
        return null;
    }

    private boolean ensureFullProperties(NodeManager nodeManager) {
        if (this.properties == null) {
            this.properties = this.toPropertyArray(this.loadProperties(nodeManager, false));
            return true;
        }
        return false;
    }

    private PropertyData[] toPropertyArray(ArrayMap<Integer, PropertyData> loadedProperties) {
        if (loadedProperties == null || loadedProperties.size() == 0) {
            return NO_PROPERTIES;
        }
        PropertyData[] result = new PropertyData[loadedProperties.size()];
        int i = 0;
        for (PropertyData property : loadedProperties.values()) {
            result[i++] = property;
        }
        return result;
    }

    private boolean ensureFullLightProperties(NodeManager nodeManager) {
        if (this.properties == null) {
            this.properties = this.toPropertyArray(this.loadProperties(nodeManager, true));
            return true;
        }
        return false;
    }

    protected List<PropertyEventData> getAllCommittedProperties(NodeManager nodeManager) {
        this.ensureFullLightProperties(nodeManager);
        if (this.properties == null) {
            return new ArrayList<PropertyEventData>();
        }
        ArrayList<PropertyEventData> props = new ArrayList<PropertyEventData>(this.properties.length);
        for (PropertyData property : this.properties) {
            PropertyIndex index = nodeManager.getIndexFor(property.getIndex());
            Object value = this.getPropertyValue(nodeManager, property);
            props.add(new PropertyEventData(index.getKey(), value));
        }
        return props;
    }

    protected Object getCommittedPropertyValue(NodeManager nodeManager, String key) {
        this.ensureFullLightProperties(nodeManager);
        for (PropertyIndex index : nodeManager.index(key)) {
            PropertyData property = this.getPropertyForIndex(index.getKeyId());
            if (property == null) continue;
            return this.getPropertyValue(nodeManager, property);
        }
        return null;
    }
}

