/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.neo4j.kernel.impl.cache.AdaptiveCacheManager;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.HitCounter;

public class LruCache<K, E>
implements Cache<K, E> {
    private final String name;
    int maxSize = 1000;
    private boolean resizing = false;
    private boolean adaptive = false;
    private final AdaptiveCacheManager cacheManager;
    private final Map<K, E> cache = new LinkedHashMap<K, E>(500, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, E> eldest) {
            if (super.size() > LruCache.this.maxSize) {
                if (LruCache.this.isAdaptive() && !LruCache.this.isResizing()) {
                    LruCache.this.adaptCache();
                } else {
                    super.remove(eldest.getKey());
                    LruCache.this.elementCleaned(eldest.getValue());
                }
            }
            return false;
        }
    };
    private final HitCounter counter = HitCounter.create();

    void adaptCache() {
        if (this.cacheManager != null) {
            this.cacheManager.adaptCache(this);
        }
    }

    public LruCache(String name, int maxSize, AdaptiveCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        if (name == null || maxSize < 1) {
            throw new IllegalArgumentException("maxSize=" + maxSize + ", name=" + name);
        }
        this.name = name;
        this.maxSize = maxSize;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized void put(K key, E element) {
        if (key == null || element == null) {
            throw new IllegalArgumentException("key=" + key + ", element=" + element);
        }
        this.cache.put(key, element);
    }

    @Override
    public synchronized E remove(K key) {
        if (key == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        return this.cache.remove(key);
    }

    @Override
    public synchronized E get(K key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.counter.count(this.cache.get(key));
    }

    @Override
    public synchronized void clear() {
        this.resizeInternal(0);
    }

    @Override
    public synchronized int size() {
        return this.cache.size();
    }

    @Override
    public int maxSize() {
        return this.maxSize;
    }

    @Override
    public synchronized void resize(int newMaxSize) {
        if (newMaxSize < 1) {
            throw new IllegalArgumentException("newMaxSize=" + newMaxSize);
        }
        this.resizeInternal(newMaxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeInternal(int newMaxSize) {
        this.resizing = true;
        try {
            if (newMaxSize >= this.size()) {
                this.maxSize = newMaxSize;
            } else if (newMaxSize == 0) {
                this.cache.clear();
            } else {
                this.maxSize = newMaxSize;
                Iterator<Map.Entry<K, E>> itr = this.cache.entrySet().iterator();
                while (itr.hasNext() && this.cache.size() > this.maxSize) {
                    E element = itr.next().getValue();
                    itr.remove();
                    this.elementCleaned(element);
                }
            }
        }
        finally {
            this.resizing = false;
        }
    }

    boolean isResizing() {
        return this.resizing;
    }

    @Override
    public void elementCleaned(E element) {
    }

    @Override
    public boolean isAdaptive() {
        return this.adaptive;
    }

    @Override
    public void setAdaptiveStatus(boolean status) {
        this.adaptive = status;
    }

    @Override
    public void putAll(Map<K, E> map) {
        this.cache.putAll(map);
    }

    @Override
    public long hitCount() {
        return this.counter.getHitsCount();
    }

    @Override
    public long missCount() {
        return this.counter.getMissCount();
    }
}

