/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.annotations;

import java.io.IOException;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.neo4j.kernel.impl.annotations.AnnotationProcessor;
import org.neo4j.kernel.impl.annotations.CompilationManipulator;
import org.neo4j.kernel.impl.annotations.Documented;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"org.neo4j.kernel.impl.annotations.Documented"})
public class DocumentationProcessor
extends AnnotationProcessor {
    private static final String DEFAULT_VALUE;
    private CompilationManipulator manipulator = null;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.manipulator = CompilationManipulator.load(processingEnv);
    }

    @Override
    void process(TypeElement annotationType, Element annotated, AnnotationMirror annotation, Map<? extends ExecutableElement, ? extends AnnotationValue> values) throws IOException {
        if (values.size() != 1) {
            this.warn(annotated, annotation, "Annotation values don't match the expectation");
            return;
        }
        String value = (String)values.values().iterator().next().getValue();
        if (DEFAULT_VALUE.equals(value) || value == null) {
            if (this.manipulator == null) {
                this.warn(annotated, annotation, "Cannot update annotation values for this compiler");
                return;
            }
            String javadoc = this.processingEnv.getElementUtils().getDocComment(annotated);
            if (javadoc == null) {
                this.warn(annotated, annotation, "Cannot extract JavaDoc documentation comment for " + annotated);
                javadoc = "Documentation not available";
            }
            if (!this.manipulator.updateAnnotationValue(annotated, annotation, "value", javadoc)) {
                this.warn(annotated, annotation, "Failed to update annotation value");
            }
        }
    }

    static {
        String defaultValue = "";
        try {
            defaultValue = (String)Documented.class.getMethod("value", new Class[0]).getDefaultValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFAULT_VALUE = defaultValue;
    }
}

