/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.ByteBuffer;
import java.util.Random;

public final class StoreId {
    private static final Random r = new Random(System.currentTimeMillis());
    private final long creationTime;
    private final long randomId;

    public StoreId() {
        this(System.currentTimeMillis(), r.nextLong());
    }

    public StoreId(long creationTime, long randomId) {
        this.creationTime = creationTime;
        this.randomId = randomId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getRandomId() {
        return this.randomId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StoreId) {
            StoreId that = (StoreId)obj;
            return that.creationTime == this.creationTime && that.randomId == this.randomId;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.creationTime ^ this.randomId);
    }

    public byte[] serialize() {
        return ByteBuffer.wrap(new byte[16]).putLong(this.creationTime).putLong(this.randomId).array();
    }

    public String toString() {
        return "StoreId[time:" + this.creationTime + ", id:" + this.randomId + "]";
    }

    public static StoreId deserialize(byte[] data) {
        assert (data.length == 16) : "unexpected data";
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return StoreId.deserialize(buffer);
    }

    public static StoreId deserialize(ByteBuffer buffer) {
        long creationTime = buffer.getLong();
        long randomId = buffer.getLong();
        return new StoreId(creationTime, randomId);
    }
}

