/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Triplet;
import org.neo4j.kernel.impl.cache.AdaptiveCacheManager;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.LruCache;
import org.neo4j.kernel.impl.cache.NoCache;
import org.neo4j.kernel.impl.cache.SoftLruCache;
import org.neo4j.kernel.impl.cache.StrongReferenceCache;
import org.neo4j.kernel.impl.cache.WeakLruCache;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.LowRelationshipImpl;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.core.PropertyIndexManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.core.RelationshipTypeHolder;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.LockException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdArrayWithLoops;

public class NodeManager {
    private static Logger log = Logger.getLogger(NodeManager.class.getName());
    private long referenceNodeId = 0L;
    private final GraphDatabaseService graphDbService;
    private final Cache<Long, NodeImpl> nodeCache;
    private final Cache<Long, RelationshipImpl> relCache;
    private final AdaptiveCacheManager cacheManager;
    private final CacheType cacheType;
    private final LockManager lockManager;
    private final TransactionManager transactionManager;
    private final LockReleaser lockReleaser;
    private final PropertyIndexManager propertyIndexManager;
    private final RelationshipTypeHolder relTypeHolder;
    private final PersistenceManager persistenceManager;
    private final EntityIdGenerator idGenerator;
    private boolean useAdaptiveCache = false;
    private float adaptiveCacheHeapRatio = 0.77f;
    private int minNodeCacheSize = 0;
    private int minRelCacheSize = 0;
    private int maxNodeCacheSize = 1500;
    private int maxRelCacheSize = 3500;
    private static final int LOCK_STRIPE_COUNT = 32;
    private final ReentrantLock[] loadLocks = new ReentrantLock[32];

    NodeManager(GraphDatabaseService graphDb, AdaptiveCacheManager cacheManager, LockManager lockManager, LockReleaser lockReleaser, TransactionManager transactionManager, PersistenceManager persistenceManager, EntityIdGenerator idGenerator, RelationshipTypeCreator relTypeCreator, CacheType cacheType) {
        this.graphDbService = graphDb;
        this.cacheManager = cacheManager;
        this.lockManager = lockManager;
        this.transactionManager = transactionManager;
        this.propertyIndexManager = new PropertyIndexManager(transactionManager, persistenceManager, idGenerator);
        this.lockReleaser = lockReleaser;
        lockReleaser.setNodeManager(this);
        lockReleaser.setPropertyIndexManager(this.propertyIndexManager);
        this.persistenceManager = persistenceManager;
        this.idGenerator = idGenerator;
        this.relTypeHolder = new RelationshipTypeHolder(transactionManager, persistenceManager, idGenerator, relTypeCreator);
        this.cacheType = cacheType;
        this.nodeCache = cacheType.node(cacheManager);
        this.relCache = cacheType.relationship(cacheManager);
        for (int i = 0; i < this.loadLocks.length; ++i) {
            this.loadLocks[i] = new ReentrantLock();
        }
    }

    public GraphDatabaseService getGraphDbService() {
        return this.graphDbService;
    }

    public CacheType getCacheType() {
        return this.cacheType;
    }

    private void parseParams(Map<Object, Object> params) {
        Object value;
        if (params.containsKey("use_adaptive_cache")) {
            value = (String)params.get("use_adaptive_cache");
            if (((String)value).toLowerCase().equals("yes")) {
                this.useAdaptiveCache = true;
            } else if (((String)value).toLowerCase().equals("no")) {
                this.useAdaptiveCache = false;
            } else {
                log.warning("Unable to parse use_adaptive_cache=" + (String)value);
            }
        }
        if (params.containsKey("adaptive_cache_heap_ratio")) {
            value = params.get("adaptive_cache_heap_ratio");
            try {
                this.adaptiveCacheHeapRatio = Float.parseFloat((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse adaptive_cache_heap_ratio " + value);
            }
            if (this.adaptiveCacheHeapRatio < 0.1f) {
                this.adaptiveCacheHeapRatio = 0.1f;
            }
            if (this.adaptiveCacheHeapRatio > 0.95f) {
                this.adaptiveCacheHeapRatio = 0.95f;
            }
        }
        if (params.containsKey("min_node_cache_size")) {
            value = params.get("min_node_cache_size");
            try {
                this.minNodeCacheSize = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse min_node_cache_size " + value);
            }
        }
        if (params.containsKey("min_relationship_cache_size")) {
            value = params.get("min_relationship_cache_size");
            try {
                this.minRelCacheSize = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse min_relationship_cache_size " + value);
            }
        }
        if (params.containsKey("max_node_cache_size")) {
            value = params.get("max_node_cache_size");
            try {
                this.maxNodeCacheSize = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse max_node_cache_size " + value);
            }
        }
        if (params.containsKey("max_relationship_cache_size")) {
            value = params.get("max_relationship_cache_size");
            try {
                this.maxRelCacheSize = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse max_relationship_cache_size " + value);
            }
        }
    }

    public void start(Map<Object, Object> params) {
        this.parseParams(params);
        this.nodeCache.resize(this.maxNodeCacheSize);
        this.relCache.resize(this.maxRelCacheSize);
        if (this.useAdaptiveCache && this.cacheType.needsCacheManagerRegistration) {
            this.cacheManager.registerCache(this.nodeCache, this.adaptiveCacheHeapRatio, this.minNodeCacheSize);
            this.cacheManager.registerCache(this.relCache, this.adaptiveCacheHeapRatio, this.minRelCacheSize);
            this.cacheManager.start(params);
        }
    }

    public void stop() {
        if (this.useAdaptiveCache && this.cacheType.needsCacheManagerRegistration) {
            this.cacheManager.stop();
            this.cacheManager.unregisterCache(this.nodeCache);
            this.cacheManager.unregisterCache(this.relCache);
        }
        this.relTypeHolder.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createNode() {
        long id = this.idGenerator.nextId(Node.class);
        NodeImpl node = new NodeImpl(id, true);
        this.acquireLock(node, LockType.WRITE);
        boolean success = false;
        try {
            this.persistenceManager.nodeCreate(id);
            this.nodeCache.put(id, node);
            success = true;
            NodeProxy nodeProxy = new NodeProxy(id, this);
            return nodeProxy;
        }
        finally {
            this.releaseLock(node, LockType.WRITE);
            if (!success) {
                this.setRollbackOnly();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relationship createRelationship(NodeImpl startNode, Node endNode, RelationshipType type) {
        long startNodeId;
        NodeImpl firstNode;
        if (startNode == null || endNode == null || type == null) {
            throw new IllegalArgumentException("Null parameter, startNode=" + startNode + ", endNode=" + endNode + ", type=" + type);
        }
        if (!this.relTypeHolder.isValidRelationshipType(type)) {
            this.relTypeHolder.addValidRelationshipType(type.name(), true);
        }
        if ((firstNode = this.getLightNode(startNodeId = startNode.getId())) == null) {
            this.setRollbackOnly();
            throw new NotFoundException("First node[" + startNode.getId() + "] deleted");
        }
        long endNodeId = endNode.getId();
        NodeImpl secondNode = this.getLightNode(endNodeId);
        if (secondNode == null) {
            this.setRollbackOnly();
            throw new NotFoundException("Second node[" + endNode.getId() + "] deleted");
        }
        long id = this.idGenerator.nextId(Relationship.class);
        int typeId = this.getRelationshipTypeIdFor(type);
        RelationshipImpl rel = this.newRelationshipImpl(id, startNodeId, endNodeId, type, typeId, true);
        boolean firstNodeTaken = false;
        boolean secondNodeTaken = false;
        this.acquireLock(rel, LockType.WRITE);
        boolean success = false;
        try {
            this.acquireLock(firstNode, LockType.WRITE);
            firstNodeTaken = true;
            this.acquireLock(secondNode, LockType.WRITE);
            secondNodeTaken = true;
            this.persistenceManager.relationshipCreate(id, typeId, startNodeId, endNodeId);
            if (startNodeId == endNodeId) {
                firstNode.addRelationship(this, type, id, RelIdArray.DirectionWrapper.BOTH);
            } else {
                firstNode.addRelationship(this, type, id, RelIdArray.DirectionWrapper.OUTGOING);
                secondNode.addRelationship(this, type, id, RelIdArray.DirectionWrapper.INCOMING);
            }
            this.relCache.put(rel.getId(), rel);
            success = true;
            RelationshipProxy relationshipProxy = new RelationshipProxy(id, this);
            return relationshipProxy;
        }
        finally {
            boolean releaseFailed = false;
            if (firstNodeTaken) {
                try {
                    this.releaseLock(firstNode, LockType.WRITE);
                }
                catch (Exception e) {
                    releaseFailed = true;
                    log.log(Level.SEVERE, "Failed to release lock", e);
                }
            }
            if (secondNodeTaken) {
                try {
                    this.releaseLock(secondNode, LockType.WRITE);
                }
                catch (Exception e) {
                    releaseFailed = true;
                    log.log(Level.SEVERE, "Failed to release lock", e);
                }
            }
            this.releaseLock(rel, LockType.WRITE);
            if (!success) {
                this.setRollbackOnly();
            }
            if (releaseFailed) {
                throw new LockException("Unable to release locks [" + startNode + "," + endNode + "] in relationship create->" + rel);
            }
        }
    }

    private RelationshipImpl newRelationshipImpl(long id, long startNodeId, long endNodeId, RelationshipType type, int typeId, boolean newRel) {
        return new LowRelationshipImpl(id, startNodeId, endNodeId, typeId, newRel);
    }

    private ReentrantLock lockId(long id) {
        int stripe = (int)(id / 32768L) % 32;
        if (stripe < 0) {
            stripe *= -1;
        }
        ReentrantLock lock = this.loadLocks[stripe];
        lock.lock();
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getNodeById(long nodeId) throws NotFoundException {
        NodeImpl node = this.nodeCache.get(nodeId);
        if (node != null) {
            return new NodeProxy(nodeId, this);
        }
        ReentrantLock loadLock = this.lockId(nodeId);
        try {
            if (this.nodeCache.get(nodeId) != null) {
                NodeProxy nodeProxy = new NodeProxy(nodeId, this);
                return nodeProxy;
            }
            if (!this.persistenceManager.loadLightNode(nodeId)) {
                throw new NotFoundException("Node[" + nodeId + "]");
            }
            node = new NodeImpl(nodeId);
            this.nodeCache.put(nodeId, node);
            NodeProxy nodeProxy = new NodeProxy(nodeId, this);
            return nodeProxy;
        }
        finally {
            loadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeImpl getLightNode(long nodeId) {
        NodeImpl node = this.nodeCache.get(nodeId);
        if (node != null) {
            return node;
        }
        ReentrantLock loadLock = this.lockId(nodeId);
        try {
            node = this.nodeCache.get(nodeId);
            if (node != null) {
                NodeImpl nodeImpl = node;
                return nodeImpl;
            }
            if (!this.persistenceManager.loadLightNode(nodeId)) {
                NodeImpl nodeImpl = null;
                return nodeImpl;
            }
            node = new NodeImpl(nodeId);
            this.nodeCache.put(nodeId, node);
            NodeImpl nodeImpl = node;
            return nodeImpl;
        }
        finally {
            loadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeImpl getNodeForProxy(long nodeId) {
        NodeImpl node = this.nodeCache.get(nodeId);
        if (node != null) {
            return node;
        }
        ReentrantLock loadLock = this.lockId(nodeId);
        try {
            node = this.nodeCache.get(nodeId);
            if (node != null) {
                NodeImpl nodeImpl = node;
                return nodeImpl;
            }
            if (!this.persistenceManager.loadLightNode(nodeId)) {
                throw new NotFoundException("Node[" + nodeId + "] not found.");
            }
            node = new NodeImpl(nodeId);
            this.nodeCache.put(nodeId, node);
            NodeImpl nodeImpl = node;
            return nodeImpl;
        }
        finally {
            loadLock.unlock();
        }
    }

    public Node getReferenceNode() throws NotFoundException {
        if (this.referenceNodeId == -1L) {
            throw new NotFoundException("No reference node set");
        }
        return this.getNodeById(this.referenceNodeId);
    }

    void setReferenceNodeId(long nodeId) {
        this.referenceNodeId = nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relationship getRelationshipById(long relId) throws NotFoundException {
        RelationshipImpl relationship = this.relCache.get(relId);
        if (relationship != null) {
            return new RelationshipProxy(relId, this);
        }
        ReentrantLock loadLock = this.lockId(relId);
        try {
            relationship = this.relCache.get(relId);
            if (relationship != null) {
                RelationshipProxy relationshipProxy = new RelationshipProxy(relId, this);
                return relationshipProxy;
            }
            RelationshipRecord data = this.persistenceManager.loadLightRelationship(relId);
            if (data == null) {
                throw new NotFoundException("Relationship[" + relId + "]");
            }
            int typeId = data.getType();
            RelationshipType type = this.getRelationshipTypeById(typeId);
            if (type == null) {
                throw new NotFoundException("Relationship[" + data.getId() + "] exist but relationship type[" + typeId + "] not found.");
            }
            long startNodeId = data.getFirstNode();
            long endNodeId = data.getSecondNode();
            relationship = this.newRelationshipImpl(relId, startNodeId, endNodeId, type, typeId, false);
            this.relCache.put(relId, relationship);
            RelationshipProxy relationshipProxy = new RelationshipProxy(relId, this);
            return relationshipProxy;
        }
        finally {
            loadLock.unlock();
        }
    }

    RelationshipType getRelationshipTypeById(int id) {
        return this.relTypeHolder.getRelationshipType(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RelationshipImpl getRelForProxy(long relId) {
        RelationshipImpl relationship = this.relCache.get(relId);
        if (relationship != null) {
            return relationship;
        }
        ReentrantLock loadLock = this.lockId(relId);
        try {
            relationship = this.relCache.get(relId);
            if (relationship != null) {
                RelationshipImpl relationshipImpl = relationship;
                return relationshipImpl;
            }
            RelationshipRecord data = this.persistenceManager.loadLightRelationship(relId);
            if (data == null) {
                throw new NotFoundException("Relationship[" + relId + "] not found.");
            }
            int typeId = data.getType();
            RelationshipType type = this.getRelationshipTypeById(typeId);
            if (type == null) {
                throw new NotFoundException("Relationship[" + data.getId() + "] exist but relationship type[" + typeId + "] not found.");
            }
            relationship = this.newRelationshipImpl(relId, data.getFirstNode(), data.getSecondNode(), type, typeId, false);
            this.relCache.put(relId, relationship);
            RelationshipImpl relationshipImpl = relationship;
            return relationshipImpl;
        }
        finally {
            loadLock.unlock();
        }
    }

    public void removeNodeFromCache(long nodeId) {
        this.nodeCache.remove(nodeId);
    }

    public void removeRelationshipFromCache(long id) {
        this.relCache.remove(id);
    }

    Object loadPropertyValue(long id) {
        return this.persistenceManager.loadPropertyValue(id);
    }

    long getRelationshipChainPosition(NodeImpl node) {
        return this.persistenceManager.getRelationshipChainPosition(node.getId());
    }

    Triplet<ArrayMap<String, RelIdArray>, Map<Long, RelationshipImpl>, Long> getMoreRelationships(NodeImpl node) {
        boolean hasLoops;
        long nodeId = node.getId();
        long position = node.getRelChainPosition();
        Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, Long> rels = this.persistenceManager.getMoreRelationships(nodeId, position);
        ArrayMap<String, RelIdArray> newRelationshipMap = new ArrayMap<String, RelIdArray>();
        HashMap<Long, RelationshipImpl> relsMap = new HashMap<Long, RelationshipImpl>(150);
        Iterable<RelationshipRecord> loops = rels.first().get((Object)RelIdArray.DirectionWrapper.BOTH);
        boolean bl = hasLoops = loops != null;
        if (hasLoops) {
            this.receiveRelationships(loops, newRelationshipMap, relsMap, RelIdArray.DirectionWrapper.BOTH, true);
        }
        this.receiveRelationships(rels.first().get((Object)RelIdArray.DirectionWrapper.OUTGOING), newRelationshipMap, relsMap, RelIdArray.DirectionWrapper.OUTGOING, hasLoops);
        this.receiveRelationships(rels.first().get((Object)RelIdArray.DirectionWrapper.INCOMING), newRelationshipMap, relsMap, RelIdArray.DirectionWrapper.INCOMING, hasLoops);
        return Triplet.of(newRelationshipMap, relsMap, rels.other());
    }

    private void receiveRelationships(Iterable<RelationshipRecord> rels, ArrayMap<String, RelIdArray> newRelationshipMap, Map<Long, RelationshipImpl> relsMap, RelIdArray.DirectionWrapper dir, boolean hasLoops) {
        for (RelationshipRecord rel : rels) {
            long relId = rel.getId();
            RelationshipImpl relImpl = this.relCache.get(relId);
            RelationshipType type = null;
            if (relImpl == null) {
                type = this.getRelationshipTypeById(rel.getType());
                assert (type != null);
                relImpl = this.newRelationshipImpl(relId, rel.getFirstNode(), rel.getSecondNode(), type, rel.getType(), false);
                relsMap.put(relId, relImpl);
            } else {
                type = relImpl.getType(this);
            }
            RelIdArray relationshipSet = newRelationshipMap.get(type.name());
            if (relationshipSet == null) {
                relationshipSet = hasLoops ? new RelIdArrayWithLoops(type.name()) : new RelIdArray(type.name());
                newRelationshipMap.put(type.name(), relationshipSet);
            }
            relationshipSet.add(relId, dir);
        }
    }

    void putAllInRelCache(Map<Long, RelationshipImpl> map) {
        this.relCache.putAll(map);
    }

    ArrayMap<Integer, PropertyData> loadProperties(NodeImpl node, boolean light) {
        return this.persistenceManager.loadNodeProperties(node.getId(), light);
    }

    ArrayMap<Integer, PropertyData> loadProperties(RelationshipImpl relationship, boolean light) {
        return this.persistenceManager.loadRelProperties(relationship.getId(), light);
    }

    public int getNodeCacheSize() {
        return this.nodeCache.size();
    }

    public int getRelationshipCacheSize() {
        return this.relCache.size();
    }

    public void clearCache() {
        this.nodeCache.clear();
        this.relCache.clear();
    }

    void setRollbackOnly() {
        try {
            this.transactionManager.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            log.log(Level.FINE, "Failed to set transaction rollback only", e);
        }
        catch (SystemException se) {
            log.log(Level.SEVERE, "Failed to set transaction rollback only", se);
        }
    }

    void acquireLock(Primitive resource, LockType lockType) {
        PropertyContainer container;
        if (resource instanceof NodeImpl) {
            container = new NodeProxy(resource.getId(), this);
        } else if (resource instanceof RelationshipImpl) {
            container = new RelationshipProxy(resource.getId(), this);
        } else {
            throw new LockException("Unkown primitivite type: " + resource);
        }
        if (lockType == LockType.READ) {
            this.lockManager.getReadLock(container);
        } else if (lockType == LockType.WRITE) {
            this.lockManager.getWriteLock(container);
        } else {
            throw new LockException("Unknown lock type: " + (Object)((Object)lockType));
        }
    }

    void releaseLock(Primitive resource, LockType lockType) {
        PropertyContainer container;
        if (resource instanceof NodeImpl) {
            container = new NodeProxy(resource.getId(), this);
        } else if (resource instanceof RelationshipImpl) {
            container = new RelationshipProxy(resource.getId(), this);
        } else {
            throw new LockException("Unkown primitivite type: " + resource);
        }
        if (lockType == LockType.READ) {
            this.lockManager.releaseReadLock(container, null);
        } else if (lockType == LockType.WRITE) {
            this.lockReleaser.addLockToTransaction(container, lockType);
        } else {
            throw new LockException("Unknown lock type: " + (Object)((Object)lockType));
        }
    }

    public long getHighestPossibleIdInUse(Class<?> clazz) {
        return this.idGenerator.getHighestPossibleIdInUse(clazz);
    }

    public long getNumberOfIdsInUse(Class<?> clazz) {
        return this.idGenerator.getNumberOfIdsInUse(clazz);
    }

    public void removeRelationshipTypeFromCache(int id) {
        this.relTypeHolder.removeRelType(id);
    }

    void addPropertyIndexes(PropertyIndexData[] propertyIndexes) {
        this.propertyIndexManager.addPropertyIndexes(propertyIndexes);
    }

    void setHasAllpropertyIndexes(boolean hasAll) {
        this.propertyIndexManager.setHasAll(hasAll);
    }

    void clearPropertyIndexes() {
        this.propertyIndexManager.clear();
    }

    PropertyIndex getIndexFor(int keyId) {
        return this.propertyIndexManager.getIndexFor(keyId);
    }

    Iterable<PropertyIndex> index(String key) {
        return this.propertyIndexManager.index(key);
    }

    boolean hasAllPropertyIndexes() {
        return this.propertyIndexManager.hasAll();
    }

    boolean hasIndexFor(int keyId) {
        return this.propertyIndexManager.hasIndexFor(keyId);
    }

    PropertyIndex createPropertyIndex(String key) {
        return this.propertyIndexManager.createPropertyIndex(key);
    }

    int getRelationshipTypeIdFor(RelationshipType type) {
        return this.relTypeHolder.getIdFor(type);
    }

    void addRawRelationshipTypes(RelationshipTypeData[] relTypes) {
        this.relTypeHolder.addRawRelationshipTypes(relTypes);
    }

    Iterable<RelationshipType> getRelationshipTypes() {
        return this.relTypeHolder.getRelationshipTypes();
    }

    ArrayMap<Integer, PropertyData> deleteNode(NodeImpl node) {
        this.deletePrimitive(node);
        return this.persistenceManager.nodeDelete(node.getId());
    }

    PropertyData nodeAddProperty(NodeImpl node, PropertyIndex index, Object value) {
        return this.persistenceManager.nodeAddProperty(node.getId(), index, value);
    }

    PropertyData nodeChangeProperty(NodeImpl node, long propertyId, Object value) {
        return this.persistenceManager.nodeChangeProperty(node.getId(), propertyId, value);
    }

    void nodeRemoveProperty(NodeImpl node, long propertyId) {
        this.persistenceManager.nodeRemoveProperty(node.getId(), propertyId);
    }

    ArrayMap<Integer, PropertyData> deleteRelationship(RelationshipImpl rel) {
        this.deletePrimitive(rel);
        return this.persistenceManager.relDelete(rel.getId());
    }

    PropertyData relAddProperty(RelationshipImpl rel, PropertyIndex index, Object value) {
        return this.persistenceManager.relAddProperty(rel.getId(), index, value);
    }

    PropertyData relChangeProperty(RelationshipImpl rel, long propertyId, Object value) {
        return this.persistenceManager.relChangeProperty(rel.getId(), propertyId, value);
    }

    void relRemoveProperty(RelationshipImpl rel, long propertyId) {
        this.persistenceManager.relRemoveProperty(rel.getId(), propertyId);
    }

    public Collection<Long> getCowRelationshipRemoveMap(NodeImpl node, String type) {
        return this.lockReleaser.getCowRelationshipRemoveMap(node, type);
    }

    public Collection<Long> getCowRelationshipRemoveMap(NodeImpl node, String type, boolean create) {
        return this.lockReleaser.getCowRelationshipRemoveMap(node, type, create);
    }

    public ArrayMap<String, RelIdArray> getCowRelationshipAddMap(NodeImpl node) {
        return this.lockReleaser.getCowRelationshipAddMap(node);
    }

    public RelIdArray getCowRelationshipAddMap(NodeImpl node, String string) {
        return this.lockReleaser.getCowRelationshipAddMap(node, string);
    }

    public RelIdArray getCowRelationshipAddMap(NodeImpl node, String string, boolean create) {
        return this.lockReleaser.getCowRelationshipAddMap(node, string, create);
    }

    public NodeImpl getNodeIfCached(long nodeId) {
        return this.nodeCache.get(nodeId);
    }

    public RelationshipImpl getRelIfCached(long nodeId) {
        return this.relCache.get(nodeId);
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyRemoveMap(Primitive primitive) {
        return this.lockReleaser.getCowPropertyRemoveMap(primitive);
    }

    private void deletePrimitive(Primitive primitive) {
        this.lockReleaser.deletePrimitive(primitive);
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyAddMap(Primitive primitive) {
        return this.lockReleaser.getCowPropertyAddMap(primitive);
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyAddMap(Primitive primitive, boolean create) {
        return this.lockReleaser.getCowPropertyAddMap(primitive, create);
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyRemoveMap(Primitive primitive, boolean create) {
        return this.lockReleaser.getCowPropertyRemoveMap(primitive, create);
    }

    LockReleaser getLockReleaser() {
        return this.lockReleaser;
    }

    void addRelationshipType(RelationshipTypeData type) {
        this.relTypeHolder.addRawRelationshipType(type);
    }

    void addPropertyIndex(PropertyIndexData index) {
        this.propertyIndexManager.addPropertyIndex(index);
    }

    public TransactionData getTransactionData() {
        return this.lockReleaser.getTransactionData();
    }

    RelIdArray getCreatedNodes() {
        return this.persistenceManager.getCreatedNodes();
    }

    boolean nodeCreated(long nodeId) {
        return this.persistenceManager.isNodeCreated(nodeId);
    }

    boolean relCreated(long relId) {
        return this.persistenceManager.isRelationshipCreated(relId);
    }

    public String getKeyForProperty(long propertyId) {
        int keyId = this.persistenceManager.getKeyIdForProperty(propertyId);
        return this.propertyIndexManager.getIndexFor(keyId).getKey();
    }

    public RelationshipTypeHolder getRelationshipTypeHolder() {
        return this.relTypeHolder;
    }

    public static enum CacheType {
        weak(false, "weak reference cache"){

            @Override
            Cache<Long, NodeImpl> node(AdaptiveCacheManager cacheManager) {
                return new WeakLruCache<Long, NodeImpl>(CacheType.NODE_CACHE_NAME);
            }

            @Override
            Cache<Long, RelationshipImpl> relationship(AdaptiveCacheManager cacheManager) {
                return new WeakLruCache<Long, RelationshipImpl>(CacheType.RELATIONSHIP_CACHE_NAME);
            }
        }
        ,
        soft(false, "soft reference cache"){

            @Override
            Cache<Long, NodeImpl> node(AdaptiveCacheManager cacheManager) {
                return new SoftLruCache<Long, NodeImpl>(CacheType.NODE_CACHE_NAME);
            }

            @Override
            Cache<Long, RelationshipImpl> relationship(AdaptiveCacheManager cacheManager) {
                return new SoftLruCache<Long, RelationshipImpl>(CacheType.RELATIONSHIP_CACHE_NAME);
            }
        }
        ,
        old(true, "lru cache"){

            @Override
            Cache<Long, NodeImpl> node(AdaptiveCacheManager cacheManager) {
                return new LruCache<Long, NodeImpl>(CacheType.NODE_CACHE_NAME, 1500, cacheManager);
            }

            @Override
            Cache<Long, RelationshipImpl> relationship(AdaptiveCacheManager cacheManager) {
                return new LruCache<Long, RelationshipImpl>(CacheType.RELATIONSHIP_CACHE_NAME, 3500, cacheManager);
            }
        }
        ,
        none(false, "no cache"){

            @Override
            Cache<Long, NodeImpl> node(AdaptiveCacheManager cacheManager) {
                return new NoCache<Long, NodeImpl>(CacheType.NODE_CACHE_NAME);
            }

            @Override
            Cache<Long, RelationshipImpl> relationship(AdaptiveCacheManager cacheManager) {
                return new NoCache<Long, RelationshipImpl>(CacheType.RELATIONSHIP_CACHE_NAME);
            }
        }
        ,
        strong(false, "strong reference cache"){

            @Override
            Cache<Long, NodeImpl> node(AdaptiveCacheManager cacheManager) {
                return new StrongReferenceCache<Long, NodeImpl>(CacheType.NODE_CACHE_NAME);
            }

            @Override
            Cache<Long, RelationshipImpl> relationship(AdaptiveCacheManager cacheManager) {
                return new StrongReferenceCache<Long, RelationshipImpl>(CacheType.RELATIONSHIP_CACHE_NAME);
            }
        };

        private static final String NODE_CACHE_NAME = "NodeCache";
        private static final String RELATIONSHIP_CACHE_NAME = "RelationshipCache";
        final boolean needsCacheManagerRegistration;
        private final String description;

        private CacheType(boolean needsCacheManagerRegistration, String description) {
            this.needsCacheManagerRegistration = needsCacheManagerRegistration;
            this.description = description;
        }

        abstract Cache<Long, NodeImpl> node(AdaptiveCacheManager var1);

        abstract Cache<Long, RelationshipImpl> relationship(AdaptiveCacheManager var1);

        public String getDescription() {
            return this.description;
        }
    }
}

