/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.ShortString;

public enum PropertyType {
    ILLEGAL(0){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            throw new InvalidRecordException("Invalid type: 0 for record " + record);
        }
    }
    ,
    INT(1){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return (int)record.getPropBlock();
        }
    }
    ,
    STRING(2){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            if (store == null) {
                return null;
            }
            return store.getStringFor(record);
        }
    }
    ,
    BOOL(3){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            if (record.getPropBlock() == 1L) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }
    ,
    DOUBLE(4){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return Double.longBitsToDouble(record.getPropBlock());
        }
    }
    ,
    FLOAT(5){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return new Float(Float.intBitsToFloat((int)record.getPropBlock()));
        }
    }
    ,
    LONG(6){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return record.getPropBlock();
        }
    }
    ,
    BYTE(7){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return (byte)record.getPropBlock();
        }
    }
    ,
    CHAR(8){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return Character.valueOf((char)record.getPropBlock());
        }
    }
    ,
    ARRAY(9){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            if (store == null) {
                return null;
            }
            return store.getArrayFor(record);
        }
    }
    ,
    SHORT(10){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return (short)record.getPropBlock();
        }
    }
    ,
    SHORT_STRING(11){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return ShortString.decode(record.getPropBlock());
        }
    };

    private int type;

    private PropertyType(int type) {
        this.type = type;
    }

    public int intValue() {
        return this.type;
    }

    public abstract Object getValue(PropertyRecord var1, PropertyStore var2);

    public static PropertyType getPropertyType(int type, boolean nullOnIllegal) {
        switch (type) {
            case 0: {
                if (!nullOnIllegal) break;
                return null;
            }
            case 1: {
                return INT;
            }
            case 2: {
                return STRING;
            }
            case 3: {
                return BOOL;
            }
            case 4: {
                return DOUBLE;
            }
            case 5: {
                return FLOAT;
            }
            case 6: {
                return LONG;
            }
            case 7: {
                return BYTE;
            }
            case 8: {
                return CHAR;
            }
            case 9: {
                return ARRAY;
            }
            case 10: {
                return SHORT;
            }
            case 11: {
                return SHORT_STRING;
            }
        }
        throw new InvalidRecordException("Unknown property type:" + type);
    }
}

