/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.IllegalStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;

public class NodeStore
extends AbstractStore
implements Store {
    private static final String VERSION = "NodeStore v0.9.9";
    public static final int RECORD_SIZE = 9;

    public NodeStore(String fileName, Map<?, ?> config) {
        super(fileName, config, IdType.NODE);
    }

    @Override
    public String getTypeAndVersionDescriptor() {
        return VERSION;
    }

    @Override
    public int getRecordSize() {
        return 9;
    }

    public static void createStore(String fileName, Map<?, ?> config) {
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)config.get(IdGeneratorFactory.class);
        NodeStore.createEmptyStore(fileName, VERSION, idGeneratorFactory);
        NodeStore store = new NodeStore(fileName, config);
        NodeRecord nodeRecord = new NodeRecord(store.nextId());
        nodeRecord.setInUse(true);
        store.updateRecord(nodeRecord);
        store.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRecord getRecord(long id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            NodeRecord record;
            NodeRecord nodeRecord = record = this.getRecord(id, window, false);
            return nodeRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(NodeRecord record, boolean recovered) {
        assert (recovered);
        this.setRecovered();
        try {
            this.updateRecord(record);
            this.registerIdFromUpdateRecord(record.getId());
        }
        finally {
            this.unsetRecovered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(NodeRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadLightNode(long id) {
        PersistenceWindow window = null;
        try {
            window = this.acquireWindow(id, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return false;
        }
        try {
            NodeRecord record = this.getRecord(id, window, true);
            if (record == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    private NodeRecord getRecord(long id, PersistenceWindow window, boolean check) {
        boolean inUse;
        Buffer buffer = window.getOffsettedBuffer(id);
        long inUseByte = buffer.get();
        boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
        if (!inUse) {
            if (check) {
                return null;
            }
            throw new InvalidRecordException("Record[" + id + "] not in use");
        }
        long nextRel = buffer.getUnsignedInt();
        long nextProp = buffer.getUnsignedInt();
        long relModifier = (inUseByte & 0xEL) << 31;
        long propModifier = (inUseByte & 0xF0L) << 28;
        NodeRecord nodeRecord = new NodeRecord(id);
        nodeRecord.setInUse(inUse);
        nodeRecord.setNextRel(NodeStore.longFromIntAndMod(nextRel, relModifier));
        nodeRecord.setNextProp(NodeStore.longFromIntAndMod(nextProp, propModifier));
        return nodeRecord;
    }

    private void updateRecord(NodeRecord record, PersistenceWindow window) {
        long id = record.getId();
        Buffer buffer = window.getOffsettedBuffer(id);
        if (record.inUse()) {
            long nextRel = record.getNextRel();
            long nextProp = record.getNextProp();
            short relModifier = nextRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? (short)0 : (short)((nextRel & 0x700000000L) >> 31);
            int propModifier = (short)(nextProp == (long)Record.NO_NEXT_PROPERTY.intValue() ? 0 : (short)((nextProp & 0xF00000000L) >> 28));
            short inUseUnsignedByte = (short)(Record.IN_USE.byteValue() | relModifier | propModifier);
            buffer.put((byte)inUseUnsignedByte).putInt((int)nextRel).putInt((int)nextProp);
        } else {
            buffer.put(Record.NOT_IN_USE.byteValue());
            if (!this.isInRecoveryMode()) {
                this.freeId(id);
            }
        }
    }

    public String toString() {
        return "NodeStore";
    }

    @Override
    protected boolean versionFound(String version) {
        if (!version.startsWith("NodeStore")) {
            return false;
        }
        if (version.equals("NodeStore v0.9.5")) {
            return true;
        }
        throw new IllegalStoreVersionException("Store version [" + version + "]. Please make sure you are not running old Neo4j kernel " + " towards a store that has been created by newer version " + " of Neo4j.");
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.add(this.getWindowPoolStats());
        return list;
    }
}

