/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelTypeElementIterator;
import org.neo4j.kernel.impl.util.RelIdArray;

class FastRelTypeElement
extends RelTypeElementIterator {
    private final RelIdArray src;
    private final RelIdArray.RelIdIterator iterator;

    FastRelTypeElement(String type, NodeImpl node, RelIdArray src) {
        super(type, node);
        this.src = src == null ? RelIdArray.EMPTY : src;
        this.iterator = this.src.iterator();
    }

    FastRelTypeElement(String type, NodeImpl node, RelIdArray src, int position) {
        this(type, node, src);
        this.iterator.fastForwardTo(position);
    }

    @Override
    public boolean hasNext(NodeManager nodeManager) {
        return this.iterator.hasNext();
    }

    @Override
    public long next(NodeManager nodeManager) {
        return this.iterator.next();
    }

    @Override
    public boolean isSrcEmpty() {
        return this.src.isEmpty();
    }

    @Override
    public RelTypeElementIterator setSrc(RelIdArray newSrc) {
        int position = this.iterator.position();
        return new FastRelTypeElement(this.getType(), this.getNode(), newSrc, position);
    }
}

