/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.transaction.LockNotFoundException;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.RagManager;
import org.neo4j.kernel.impl.util.ArrayMap;

class RWLock {
    private int writeCount = 0;
    private int readCount = 0;
    private int marked = 0;
    private final Object resource;
    private final LinkedList<WaitElement> waitingThreadList = new LinkedList();
    private final ArrayMap<Transaction, TxLockElement> txLockElementMap = new ArrayMap(5, false, true);
    private final RagManager ragManager;

    RWLock(Object resource, RagManager ragManager) {
        this.resource = resource;
        this.ragManager = ragManager;
    }

    synchronized void mark() {
        ++this.marked;
    }

    synchronized boolean isMarked() {
        return this.marked > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void acquireReadLock() throws DeadlockDetectedException {
        TxLockElement tle;
        Transaction tx = this.ragManager.getCurrentTransaction();
        if (tx == null) {
            tx = new PlaceboTransaction();
        }
        if ((tle = this.txLockElementMap.get(tx)) == null) {
            tle = new TxLockElement(tx);
        }
        try {
            while (this.writeCount > tle.writeCount) {
                this.ragManager.checkWaitOn(this, tx);
                this.waitingThreadList.addFirst(new WaitElement(tle, LockType.READ, Thread.currentThread()));
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                this.ragManager.stopWaitOn(this, tx);
            }
            if (tle.readCount == 0 && tle.writeCount == 0) {
                this.ragManager.lockAcquired(this, tx);
            }
            ++this.readCount;
            ++tle.readCount;
            this.txLockElementMap.put(tx, tle);
        }
        finally {
            --this.marked;
        }
    }

    synchronized void releaseReadLock(Transaction tx) throws LockNotFoundException {
        TxLockElement tle;
        if (tx == null && (tx = this.ragManager.getCurrentTransaction()) == null) {
            tx = new PlaceboTransaction();
        }
        if ((tle = this.txLockElementMap.get(tx)) == null) {
            throw new LockNotFoundException("No transaction lock element found for " + tx);
        }
        if (tle.readCount == 0) {
            throw new LockNotFoundException("" + tx + " don't have readLock");
        }
        --this.readCount;
        --tle.readCount;
        if (tle.readCount == 0 && tle.writeCount == 0) {
            if (!this.isMarked()) {
                this.txLockElementMap.remove(tx);
            }
            this.ragManager.lockReleased(this, tx);
        }
        if (this.waitingThreadList.size() > 0) {
            WaitElement we = this.waitingThreadList.getLast();
            if (we.lockType == LockType.WRITE) {
                if (this.readCount == we.element.readCount) {
                    this.waitingThreadList.removeLast();
                    we.waitingThread.interrupt();
                } else {
                    ListIterator<WaitElement> listItr = this.waitingThreadList.listIterator(this.waitingThreadList.lastIndexOf(we));
                    while (listItr.hasPrevious()) {
                        we = listItr.previous();
                        if (we.lockType == LockType.WRITE && this.readCount == we.element.readCount) {
                            listItr.remove();
                            we.waitingThread.interrupt();
                            break;
                        }
                        if (we.lockType != LockType.READ) continue;
                        listItr.remove();
                        we.waitingThread.interrupt();
                    }
                }
            } else if (this.writeCount == 0) {
                this.waitingThreadList.removeLast();
                we.waitingThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void acquireWriteLock() throws DeadlockDetectedException {
        TxLockElement tle;
        Transaction tx = this.ragManager.getCurrentTransaction();
        if (tx == null) {
            tx = new PlaceboTransaction();
        }
        if ((tle = this.txLockElementMap.get(tx)) == null) {
            tle = new TxLockElement(tx);
        }
        try {
            while (this.writeCount > tle.writeCount || this.readCount > tle.readCount) {
                this.ragManager.checkWaitOn(this, tx);
                this.waitingThreadList.addFirst(new WaitElement(tle, LockType.WRITE, Thread.currentThread()));
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                this.ragManager.stopWaitOn(this, tx);
            }
            if (tle.readCount == 0 && tle.writeCount == 0) {
                this.ragManager.lockAcquired(this, tx);
            }
            ++this.writeCount;
            ++tle.writeCount;
            this.txLockElementMap.put(tx, tle);
        }
        finally {
            --this.marked;
        }
    }

    synchronized void releaseWriteLock(Transaction tx) throws LockNotFoundException {
        TxLockElement tle;
        if (tx == null && (tx = this.ragManager.getCurrentTransaction()) == null) {
            tx = new PlaceboTransaction();
        }
        if ((tle = this.txLockElementMap.get(tx)) == null) {
            throw new LockNotFoundException("No transaction lock element found for " + tx);
        }
        if (tle.writeCount == 0) {
            throw new LockNotFoundException("" + tx + " don't have writeLock");
        }
        --this.writeCount;
        --tle.writeCount;
        if (tle.readCount == 0 && tle.writeCount == 0) {
            if (!this.isMarked()) {
                this.txLockElementMap.remove(tx);
            }
            this.ragManager.lockReleased(this, tx);
        }
        if (this.writeCount == 0 && this.waitingThreadList.size() > 0) {
            WaitElement we;
            do {
                we = this.waitingThreadList.removeLast();
                we.waitingThread.interrupt();
            } while (we.lockType != LockType.WRITE && this.waitingThreadList.size() > 0);
        }
    }

    int getWriteCount() {
        return this.writeCount;
    }

    int getReadCount() {
        return this.readCount;
    }

    synchronized int getWaitingThreadsCount() {
        return this.waitingThreadList.size();
    }

    synchronized void dumpStack() {
        System.out.println("Total lock count: readCount=" + this.readCount + " writeCount=" + this.writeCount + " for " + this.resource);
        System.out.println("Waiting list:");
        Iterator wElements = this.waitingThreadList.iterator();
        while (wElements.hasNext()) {
            WaitElement we = (WaitElement)wElements.next();
            System.out.print("[" + we.waitingThread + "(" + we.element.readCount + "r," + we.element.writeCount + "w)," + (Object)((Object)we.lockType) + "]");
            if (wElements.hasNext()) {
                System.out.print(",");
                continue;
            }
            System.out.println();
        }
        System.out.println("Locking transactions:");
        for (TxLockElement tle : this.txLockElementMap.values()) {
            System.out.println("" + tle.tx + "(" + tle.readCount + "r," + tle.writeCount + "w)");
        }
    }

    public String toString() {
        return "RWLock[" + this.resource + "]";
    }

    private static class PlaceboTransaction
    implements Transaction {
        private final Thread currentThread = Thread.currentThread();

        PlaceboTransaction() {
        }

        public boolean equals(Object o) {
            if (!(o instanceof PlaceboTransaction)) {
                return false;
            }
            return this.currentThread.equals(((PlaceboTransaction)o).currentThread);
        }

        public int hashCode() {
            return this.currentThread.hashCode();
        }

        public void commit() {
            throw new UnsupportedOperationException();
        }

        public boolean delistResource(XAResource arg0, int arg1) {
            throw new UnsupportedOperationException();
        }

        public boolean enlistResource(XAResource arg0) {
            throw new UnsupportedOperationException();
        }

        public int getStatus() {
            throw new UnsupportedOperationException();
        }

        public void registerSynchronization(Synchronization arg0) {
            throw new UnsupportedOperationException();
        }

        public void rollback() {
            throw new UnsupportedOperationException();
        }

        public void setRollbackOnly() {
        }

        public String toString() {
            return "Placebo tx for thread " + this.currentThread;
        }
    }

    private static class WaitElement {
        final TxLockElement element;
        final LockType lockType;
        final Thread waitingThread;

        WaitElement(TxLockElement element, LockType lockType, Thread thread) {
            this.element = element;
            this.lockType = lockType;
            this.waitingThread = thread;
        }
    }

    private static class TxLockElement {
        final Transaction tx;
        int readCount = 0;
        int writeCount = 0;

        TxLockElement(Transaction tx) {
            this.tx = tx;
        }
    }
}

