/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import javax.transaction.xa.XAResource;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexData;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipChainPosition;
import org.neo4j.kernel.impl.nioneo.store.RelationshipData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.nioneo.xa.NodeEventConsumer;
import org.neo4j.kernel.impl.nioneo.xa.PropertyIndexEventConsumer;
import org.neo4j.kernel.impl.nioneo.xa.ReadTransaction;
import org.neo4j.kernel.impl.nioneo.xa.RelationshipEventConsumer;
import org.neo4j.kernel.impl.nioneo.xa.RelationshipTypeEventConsumer;
import org.neo4j.kernel.impl.persistence.PersistenceSource;
import org.neo4j.kernel.impl.persistence.ResourceConnection;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;

public class NioNeoDbPersistenceSource
implements PersistenceSource {
    private static final String MODULE_NAME = "NioNeoDbPersistenceSource";
    private NeoStoreXaDataSource xaDs = null;
    private String dataSourceName = null;
    private ResourceConnection readOnlyResourceConnection;

    public synchronized void init() {
    }

    public synchronized void start(XaDataSourceManager xaDsManager) {
        this.xaDs = (NeoStoreXaDataSource)xaDsManager.getXaDataSource("nioneodb");
        if (this.xaDs == null) {
            throw new IllegalStateException("Unable to get nioneodb datasource");
        }
        this.readOnlyResourceConnection = new ReadOnlyResourceConnection(this.xaDs);
    }

    public synchronized void reload() {
    }

    public synchronized void stop() {
        if (this.xaDs != null) {
            this.xaDs.close();
        }
    }

    public synchronized void destroy() {
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public ResourceConnection createResourceConnection() {
        if (this.xaDs.isReadOnly()) {
            throw new ReadOnlyDbException();
        }
        return new NioNeoDbResourceConnection(this.xaDs);
    }

    public ResourceConnection createReadOnlyResourceConnection() {
        return this.readOnlyResourceConnection;
    }

    public String toString() {
        return "A persistence source to [" + this.dataSourceName + "]";
    }

    @Override
    public long nextId(Class<?> clazz) {
        return this.xaDs.nextId(clazz);
    }

    public XAResource getXaResource() {
        return this.xaDs.getXaConnection().getXaResource();
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public long getHighestPossibleIdInUse(Class<?> clazz) {
        return this.xaDs.getHighestPossibleIdInUse(clazz);
    }

    @Override
    public long getNumberOfIdsInUse(Class<?> clazz) {
        return this.xaDs.getNumberOfIdsInUse(clazz);
    }

    @Override
    public XaDataSource getXaDataSource() {
        return this.xaDs;
    }

    private static class NioNeoDbResourceConnection
    implements ResourceConnection {
        private NeoStoreXaConnection xaCon;
        private NodeEventConsumer nodeConsumer;
        private RelationshipEventConsumer relConsumer;
        private RelationshipTypeEventConsumer relTypeConsumer;
        private PropertyIndexEventConsumer propIndexConsumer;
        private PropertyStore propStore;

        NioNeoDbResourceConnection(NeoStoreXaDataSource xaDs) {
            this.xaCon = (NeoStoreXaConnection)xaDs.getXaConnection();
            this.nodeConsumer = this.xaCon.getNodeConsumer();
            this.relConsumer = this.xaCon.getRelationshipConsumer();
            this.relTypeConsumer = this.xaCon.getRelationshipTypeConsumer();
            this.propIndexConsumer = this.xaCon.getPropertyIndexConsumer();
            this.propStore = this.xaCon.getPropertyStore();
        }

        @Override
        public XAResource getXAResource() {
            return this.xaCon.getXaResource();
        }

        @Override
        public void destroy() {
            this.xaCon.destroy();
            this.xaCon = null;
            this.nodeConsumer = null;
            this.relConsumer = null;
            this.relTypeConsumer = null;
            this.propIndexConsumer = null;
        }

        @Override
        public ArrayMap<Integer, PropertyData> nodeDelete(long nodeId) {
            return this.nodeConsumer.deleteNode(nodeId);
        }

        @Override
        public long nodeAddProperty(long nodeId, PropertyIndex index, Object value) {
            long propertyId = this.propStore.nextId();
            this.nodeConsumer.addProperty(nodeId, propertyId, index, value);
            return propertyId;
        }

        @Override
        public void nodeChangeProperty(long nodeId, long propertyId, Object value) {
            this.nodeConsumer.changeProperty(nodeId, propertyId, value);
        }

        @Override
        public void nodeRemoveProperty(long nodeId, long propertyId) {
            this.nodeConsumer.removeProperty(nodeId, propertyId);
        }

        @Override
        public void nodeCreate(long nodeId) {
            this.nodeConsumer.createNode(nodeId);
        }

        @Override
        public void relationshipCreate(long id, int typeId, long startNodeId, long endNodeId) {
            this.relConsumer.createRelationship(id, startNodeId, endNodeId, typeId);
        }

        @Override
        public ArrayMap<Integer, PropertyData> relDelete(long relId) {
            return this.relConsumer.deleteRelationship(relId);
        }

        @Override
        public long relAddProperty(long relId, PropertyIndex index, Object value) {
            long propertyId = this.propStore.nextId();
            this.relConsumer.addProperty(relId, propertyId, index, value);
            return propertyId;
        }

        @Override
        public void relChangeProperty(long relId, long propertyId, Object value) {
            this.relConsumer.changeProperty(relId, propertyId, value);
        }

        @Override
        public void relRemoveProperty(long relId, long propertyId) {
            this.relConsumer.removeProperty(relId, propertyId);
        }

        @Override
        public String loadIndex(int id) {
            return this.propIndexConsumer.getKeyFor(id);
        }

        @Override
        public PropertyIndexData[] loadPropertyIndexes(int maxCount) {
            return this.propIndexConsumer.getPropertyIndexes(maxCount);
        }

        @Override
        public Object loadPropertyValue(long id) {
            return this.xaCon.getWriteTransaction().propertyGetValue(id);
        }

        @Override
        public RelationshipTypeData[] loadRelationshipTypes() {
            RelationshipTypeData[] relTypeData = this.relTypeConsumer.getRelationshipTypes();
            RelationshipTypeData[] rawRelTypeData = new RelationshipTypeData[relTypeData.length];
            for (int i = 0; i < relTypeData.length; ++i) {
                rawRelTypeData[i] = new RelationshipTypeData(relTypeData[i].getId(), relTypeData[i].getName());
            }
            return rawRelTypeData;
        }

        @Override
        public boolean nodeLoadLight(long id) {
            return this.nodeConsumer.loadLightNode(id);
        }

        @Override
        public ArrayMap<Integer, PropertyData> nodeLoadProperties(long nodeId, boolean light) {
            return this.nodeConsumer.getProperties(nodeId, light);
        }

        @Override
        public RelationshipData relLoadLight(long id) {
            return this.relConsumer.getRelationship(id);
        }

        @Override
        public ArrayMap<Integer, PropertyData> relLoadProperties(long relId, boolean light) {
            return this.relConsumer.getProperties(relId, light);
        }

        @Override
        public void createPropertyIndex(String key, int id) {
            this.propIndexConsumer.createPropertyIndex(id, key);
        }

        @Override
        public void createRelationshipType(int id, String name) {
            this.relTypeConsumer.addRelationshipType(id, name);
        }

        @Override
        public RelationshipChainPosition getRelationshipChainPosition(long nodeId) {
            return this.relConsumer.getRelationshipChainPosition(nodeId);
        }

        @Override
        public Iterable<RelationshipData> getMoreRelationships(long nodeId, RelationshipChainPosition position) {
            return this.relConsumer.getMoreRelationships(nodeId, position);
        }

        @Override
        public RelIdArray getCreatedNodes() {
            return this.nodeConsumer.getCreatedNodes();
        }

        @Override
        public boolean isNodeCreated(long nodeId) {
            return this.nodeConsumer.isNodeCreated(nodeId);
        }

        @Override
        public boolean isRelationshipCreated(long relId) {
            return this.relConsumer.isRelationshipCreated(relId);
        }

        @Override
        public int getKeyIdForProperty(long propertyId) {
            return this.xaCon.getWriteTransaction().getKeyIdForProperty(propertyId);
        }
    }

    private static class ReadOnlyResourceConnection
    implements ResourceConnection {
        private final ReadTransaction readTransaction;
        private final RelationshipTypeStore relTypeStore;

        ReadOnlyResourceConnection(NeoStoreXaDataSource xaDs) {
            this.readTransaction = xaDs.getReadOnlyTransaction();
            this.relTypeStore = xaDs.getNeoStore().getRelationshipTypeStore();
        }

        @Override
        public XAResource getXAResource() {
            throw new IllegalStateException("This is a read only transaction, this method should never be invoked");
        }

        @Override
        public void destroy() {
            throw new IllegalStateException("This is a read only transaction, this method should never be invoked");
        }

        @Override
        public ArrayMap<Integer, PropertyData> nodeDelete(long nodeId) {
            throw new IllegalStateException("This is a read only transaction, this method should never be invoked");
        }

        @Override
        public long nodeAddProperty(long nodeId, PropertyIndex index, Object value) {
            throw new IllegalStateException("This is a read only transaction, this method should never be invoked");
        }

        @Override
        public void nodeChangeProperty(long nodeId, long propertyId, Object value) {
            throw new IllegalStateException("This is a read only transaction, this method should never be invoked");
        }

        @Override
        public void nodeRemoveProperty(long nodeId, long propertyId) {
            throw new IllegalStateException("This is a read only transaction, this method should never be invoked");
        }

        @Override
        public void nodeCreate(long nodeId) {
            throw new IllegalStateException("This is a read only transaction, this method should never be invoked");
        }

        @Override
        public void relationshipCreate(long id, int typeId, long startNodeId, long endNodeId) {
            throw new IllegalStateException("This is a read only transaction, this method should never be invoked");
        }

        @Override
        public ArrayMap<Integer, PropertyData> relDelete(long relId) {
            throw new IllegalStateException("This is a read only transaction, this method should never be invoked");
        }

        @Override
        public long relAddProperty(long relId, PropertyIndex index, Object value) {
            throw new IllegalStateException("This is a read only transaction, this method should never be invoked");
        }

        @Override
        public void relChangeProperty(long relId, long propertyId, Object value) {
            throw new IllegalStateException("This is a read only transaction, this method should never be invoked");
        }

        @Override
        public void relRemoveProperty(long relId, long propertyId) {
            throw new IllegalStateException("This is a read only transaction, this method should never be invoked");
        }

        @Override
        public String loadIndex(int id) {
            return this.readTransaction.getPropertyIndex(id);
        }

        @Override
        public PropertyIndexData[] loadPropertyIndexes(int maxCount) {
            return this.readTransaction.getPropertyIndexes(maxCount);
        }

        @Override
        public Object loadPropertyValue(long id) {
            return this.readTransaction.propertyGetValue(id);
        }

        @Override
        public RelationshipTypeData[] loadRelationshipTypes() {
            RelationshipTypeData[] relTypeData = this.relTypeStore.getRelationshipTypes();
            RelationshipTypeData[] rawRelTypeData = new RelationshipTypeData[relTypeData.length];
            for (int i = 0; i < relTypeData.length; ++i) {
                rawRelTypeData[i] = new RelationshipTypeData(relTypeData[i].getId(), relTypeData[i].getName());
            }
            return rawRelTypeData;
        }

        @Override
        public boolean nodeLoadLight(long id) {
            return this.readTransaction.nodeLoadLight(id);
        }

        @Override
        public ArrayMap<Integer, PropertyData> nodeLoadProperties(long nodeId, boolean light) {
            return this.readTransaction.nodeGetProperties(nodeId);
        }

        @Override
        public RelationshipData relLoadLight(long id) {
            return this.readTransaction.relationshipLoad(id);
        }

        @Override
        public ArrayMap<Integer, PropertyData> relLoadProperties(long relId, boolean light) {
            return this.readTransaction.relGetProperties(relId);
        }

        @Override
        public void createPropertyIndex(String key, int id) {
            throw new IllegalStateException("This is a read only transaction, this method should never be invoked");
        }

        @Override
        public void createRelationshipType(int id, String name) {
            throw new IllegalStateException("This is a read only transaction, this method should never be invoked");
        }

        @Override
        public RelationshipChainPosition getRelationshipChainPosition(long nodeId) {
            return this.readTransaction.getRelationshipChainPosition(nodeId);
        }

        @Override
        public Iterable<RelationshipData> getMoreRelationships(long nodeId, RelationshipChainPosition position) {
            return this.readTransaction.getMoreRelationships(nodeId, position);
        }

        @Override
        public RelIdArray getCreatedNodes() {
            return new RelIdArray();
        }

        @Override
        public boolean isNodeCreated(long nodeId) {
            return false;
        }

        @Override
        public boolean isRelationshipCreated(long relId) {
            return false;
        }

        @Override
        public int getKeyIdForProperty(long propertyId) {
            return this.readTransaction.getKeyIdForProperty(propertyId);
        }
    }
}

