/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.impl.cache.ReferenceCache;
import org.neo4j.kernel.impl.cache.SoftReferenceQueue;
import org.neo4j.kernel.impl.cache.SoftValue;

public class SoftLruCache<K, V>
extends ReferenceCache<K, V> {
    private final ConcurrentHashMap<K, SoftValue<K, V>> cache = new ConcurrentHashMap();
    private final SoftReferenceQueue<K, V> refQueue = new SoftReferenceQueue();
    private final String name;

    public SoftLruCache(String name) {
        this.name = name;
    }

    @Override
    public void put(K key, V value) {
        SoftValue<K, SoftValue> ref = new SoftValue<K, SoftValue>(key, (SoftValue)value, this.refQueue);
        this.cache.put(key, ref);
        this.pollClearedValues();
    }

    @Override
    public void putAll(Map<K, V> map) {
        HashMap<K, SoftValue<K, SoftValue>> softMap = new HashMap<K, SoftValue<K, SoftValue>>(map.size() * 2);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            SoftValue<K, SoftValue> ref = new SoftValue<K, SoftValue>(entry.getKey(), (SoftValue)entry.getValue(), this.refQueue);
            softMap.put(entry.getKey(), ref);
        }
        this.cache.putAll(softMap);
        this.pollClearedValues();
    }

    @Override
    public V get(K key) {
        SoftReference ref = this.cache.get(key);
        if (ref != null) {
            if (ref.get() == null) {
                this.cache.remove(key);
            }
            return (V)ref.get();
        }
        return null;
    }

    @Override
    public V remove(K key) {
        SoftReference ref = this.cache.remove(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    @Override
    protected void pollClearedValues() {
        SoftValue<K, V> clearedValue = this.refQueue.safePoll();
        while (clearedValue != null) {
            this.cache.remove(clearedValue.key);
            clearedValue = this.refQueue.safePoll();
        }
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void elementCleaned(V value) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAdaptive() {
        return true;
    }

    @Override
    public int maxSize() {
        return -1;
    }

    @Override
    public void resize(int newSize) {
    }

    @Override
    public void setAdaptiveStatus(boolean status) {
    }
}

