/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.Map;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.DefaultTransactionManagerProvider;
import org.neo4j.kernel.impl.transaction.ReadOnlyTxManager;
import org.neo4j.kernel.impl.transaction.TransactionManagerProvider;
import org.neo4j.kernel.impl.transaction.TxFinishHook;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class TxModule {
    private static final String MODULE_NAME = "TxModule";
    private boolean startIsOk = true;
    private String txLogDir = "var/tm";
    private final AbstractTransactionManager txManager;
    private final XaDataSourceManager xaDsManager;
    private final KernelPanicEventGenerator kpe;

    public TxModule(String txLogDir, KernelPanicEventGenerator kpe, TxFinishHook rollbackHook, String serviceName) {
        TransactionManagerProvider provider;
        this.txLogDir = txLogDir;
        this.kpe = kpe;
        if (serviceName == null) {
            provider = new DefaultTransactionManagerProvider();
        } else {
            provider = Service.load(TransactionManagerProvider.class, serviceName);
            if (provider == null) {
                throw new IllegalStateException("Unknown transaction manager implementation: " + serviceName);
            }
        }
        this.txManager = provider.loadTransactionManager(txLogDir, kpe, rollbackHook);
        this.xaDsManager = new XaDataSourceManager();
    }

    public TxModule(boolean readOnly, KernelPanicEventGenerator kpe) {
        this.kpe = kpe;
        if (!readOnly) {
            throw new IllegalStateException("Read only must be set for this constructor");
        }
        this.txManager = new ReadOnlyTxManager();
        this.xaDsManager = new XaDataSourceManager();
    }

    public void init() {
    }

    public void start() {
        if (!this.startIsOk) {
            return;
        }
        this.txManager.init(this.xaDsManager);
        this.startIsOk = false;
    }

    public void reload() {
        this.stop();
        this.start();
    }

    public void stop() {
        this.xaDsManager.unregisterAllDataSources();
        this.txManager.stop();
    }

    public void destroy() {
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public XaDataSource registerDataSource(String dsName, String className, byte[] resourceId, Map<?, ?> params) {
        XaDataSourceManager xaDsMgr = this.xaDsManager;
        String name = dsName.toLowerCase();
        if (xaDsMgr.hasDataSource(name)) {
            throw new TransactionFailureException("Data source[" + name + "] has already been registered");
        }
        try {
            XaDataSource dataSource = xaDsMgr.create(className, params);
            xaDsMgr.registerDataSource(name, dataSource, resourceId);
            return dataSource;
        }
        catch (Exception e) {
            throw new TransactionFailureException("Could not create data source [" + name + "], see nested exception for cause of error", e);
        }
    }

    public XaDataSource registerDataSource(String dsName, String className, byte[] resourceId, Map<?, ?> params, boolean useExisting) {
        XaDataSourceManager xaDsMgr = this.xaDsManager;
        String name = dsName.toLowerCase();
        if (xaDsMgr.hasDataSource(name)) {
            if (useExisting) {
                return xaDsMgr.getXaDataSource(name);
            }
            throw new TransactionFailureException("Data source[" + name + "] has already been registered");
        }
        try {
            XaDataSource dataSource = xaDsMgr.create(className, params);
            xaDsMgr.registerDataSource(name, dataSource, resourceId);
            return dataSource;
        }
        catch (Exception e) {
            throw new TransactionFailureException("Could not create data source " + name + "[" + name + "]", e);
        }
    }

    public String getTxLogDirectory() {
        return this.txLogDir;
    }

    public TransactionManager getTxManager() {
        return this.txManager;
    }

    public XaDataSourceManager getXaDataSourceManager() {
        return this.xaDsManager;
    }

    public int getStartedTxCount() {
        if (this.txManager instanceof TxManager) {
            return ((TxManager)this.txManager).getStartedTxCount();
        }
        return 0;
    }

    public int getCommittedTxCount() {
        if (this.txManager instanceof TxManager) {
            return ((TxManager)this.txManager).getCommittedTxCount();
        }
        return 0;
    }

    public int getRolledbackTxCount() {
        if (this.txManager instanceof TxManager) {
            return ((TxManager)this.txManager).getRolledbackTxCount();
        }
        return 0;
    }

    public int getActiveTxCount() {
        if (this.txManager instanceof TxManager) {
            return ((TxManager)this.txManager).getActiveTxCount();
        }
        return 0;
    }

    public int getPeakConcurrentTxCount() {
        if (this.txManager instanceof TxManager) {
            return ((TxManager)this.txManager).getPeakConcurrentTxCount();
        }
        return 0;
    }
}

