/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.persistence;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.core.TransactionEventsSyncHook;
import org.neo4j.kernel.impl.core.TxEventSyncHookFactory;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipChainPosition;
import org.neo4j.kernel.impl.nioneo.store.RelationshipData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.kernel.impl.nioneo.xa.NioNeoDbPersistenceSource;
import org.neo4j.kernel.impl.persistence.PersistenceSource;
import org.neo4j.kernel.impl.persistence.ResourceAcquisitionFailedException;
import org.neo4j.kernel.impl.persistence.ResourceConnection;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.IntArray;

public class PersistenceManager {
    private static Logger log = Logger.getLogger(PersistenceManager.class.getName());
    private final PersistenceSource persistenceSource;
    private final TransactionManager transactionManager;
    private final ArrayMap<Transaction, ResourceConnection> txConnectionMap = new ArrayMap(5, true, true);
    private final TxEventSyncHookFactory syncHookFactory;

    public PersistenceManager(TransactionManager transactionManager, PersistenceSource persistenceSource, TxEventSyncHookFactory syncHookFactory) {
        this.transactionManager = transactionManager;
        this.persistenceSource = persistenceSource;
        this.syncHookFactory = syncHookFactory;
    }

    public PersistenceSource getPersistenceSource() {
        return this.persistenceSource;
    }

    public boolean loadLightNode(int id) {
        return this.getReadOnlyResource().nodeLoadLight(id);
    }

    public Object loadPropertyValue(int id) {
        return this.getReadOnlyResource().loadPropertyValue(id);
    }

    public String loadIndex(int id) {
        return this.getReadOnlyResource().loadIndex(id);
    }

    public PropertyIndexData[] loadPropertyIndexes(int maxCount) {
        return this.getReadOnlyResource().loadPropertyIndexes(maxCount);
    }

    public RelationshipChainPosition getRelationshipChainPosition(int nodeId) {
        return this.getReadOnlyResource().getRelationshipChainPosition(nodeId);
    }

    public Iterable<RelationshipData> getMoreRelationships(int nodeId, RelationshipChainPosition position) {
        return this.getReadOnlyResource().getMoreRelationships(nodeId, position);
    }

    public ArrayMap<Integer, PropertyData> loadNodeProperties(int nodeId, boolean light) {
        return this.getReadOnlyResource().nodeLoadProperties(nodeId, light);
    }

    public ArrayMap<Integer, PropertyData> loadRelProperties(int relId, boolean light) {
        return this.getReadOnlyResource().relLoadProperties(relId, light);
    }

    public RelationshipData loadLightRelationship(int id) {
        return this.getReadOnlyResource().relLoadLight(id);
    }

    public RelationshipTypeData[] loadAllRelationshipTypes() {
        return this.getReadOnlyResource().loadRelationshipTypes();
    }

    public ArrayMap<Integer, PropertyData> nodeDelete(int nodeId) {
        return this.getResource().nodeDelete(nodeId);
    }

    public int nodeAddProperty(int nodeId, PropertyIndex index, Object value) {
        return this.getResource().nodeAddProperty(nodeId, index, value);
    }

    public void nodeChangeProperty(int nodeId, int propertyId, Object value) {
        this.getResource().nodeChangeProperty(nodeId, propertyId, value);
    }

    public void nodeRemoveProperty(int nodeId, int propertyId) {
        this.getResource().nodeRemoveProperty(nodeId, propertyId);
    }

    public void nodeCreate(int id) {
        this.getResource().nodeCreate(id);
    }

    public void relationshipCreate(int id, int typeId, int startNodeId, int endNodeId) {
        this.getResource().relationshipCreate(id, typeId, startNodeId, endNodeId);
    }

    public ArrayMap<Integer, PropertyData> relDelete(int relId) {
        return this.getResource().relDelete(relId);
    }

    public int relAddProperty(int relId, PropertyIndex index, Object value) {
        return this.getResource().relAddProperty(relId, index, value);
    }

    public void relChangeProperty(int relId, int propertyId, Object value) {
        this.getResource().relChangeProperty(relId, propertyId, value);
    }

    public void relRemoveProperty(int relId, int propertyId) {
        this.getResource().relRemoveProperty(relId, propertyId);
    }

    public void createPropertyIndex(String key, int id) {
        this.getResource().createPropertyIndex(key, id);
    }

    public void createRelationshipType(int id, String name) {
        this.getResource().createRelationshipType(id, name);
    }

    private ResourceConnection getReadOnlyResource() {
        Transaction tx = this.getCurrentTransaction();
        ResourceConnection con = this.txConnectionMap.get(tx);
        if (con == null) {
            return ((NioNeoDbPersistenceSource)this.persistenceSource).createReadOnlyResourceConnection();
        }
        return con;
    }

    private ResourceConnection getResource() {
        ResourceConnection con = null;
        Transaction tx = this.getCurrentTransaction();
        if (tx == null) {
            throw new NotInTransactionException();
        }
        con = this.txConnectionMap.get(tx);
        if (con == null) {
            try {
                con = this.persistenceSource.createResourceConnection();
                if (!tx.enlistResource(con.getXAResource())) {
                    throw new ResourceAcquisitionFailedException("Unable to enlist '" + con.getXAResource() + "' in " + "transaction");
                }
                tx.registerSynchronization((Synchronization)new TxCommitHook(tx));
                this.registerTransactionEventHookIfNeeded();
                this.txConnectionMap.put(tx, con);
            }
            catch (RollbackException re) {
                String msg = "The transaction is marked for rollback only.";
                throw new ResourceAcquisitionFailedException(msg, re);
            }
            catch (SystemException se) {
                String msg = "TM encountered an unexpected error condition.";
                throw new ResourceAcquisitionFailedException(msg, se);
            }
        }
        return con;
    }

    private void registerTransactionEventHookIfNeeded() throws SystemException, RollbackException {
        TransactionEventsSyncHook hook = this.syncHookFactory.create();
        if (hook != null) {
            this.transactionManager.getTransaction().registerSynchronization((Synchronization)hook);
        }
    }

    private Transaction getCurrentTransaction() throws NotInTransactionException {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException se) {
            throw new TransactionFailureException("Error fetching transaction for current thread", se);
        }
    }

    void delistResourcesForTransaction() throws NotInTransactionException {
        Transaction tx = this.getCurrentTransaction();
        if (tx == null) {
            throw new NotInTransactionException();
        }
        ResourceConnection con = this.txConnectionMap.get(tx);
        if (con != null) {
            try {
                tx.delistResource(con.getXAResource(), 0x4000000);
            }
            catch (SystemException e) {
                throw new TransactionFailureException("Failed to delist resource '" + con + "' from current transaction.", e);
            }
        }
    }

    void releaseResourceConnectionsForTransaction(Transaction tx) throws NotInTransactionException {
        ResourceConnection con = this.txConnectionMap.remove(tx);
        if (con != null) {
            con.destroy();
        }
    }

    public IntArray getCreatedNodes() {
        return this.getResource().getCreatedNodes();
    }

    public boolean isNodeCreated(int nodeId) {
        return this.getResource().isNodeCreated(nodeId);
    }

    public boolean isRelationshipCreated(int relId) {
        return this.getResource().isRelationshipCreated(relId);
    }

    public int getKeyIdForProperty(int propertyId) {
        return this.getReadOnlyResource().getKeyIdForProperty(propertyId);
    }

    private class TxCommitHook
    implements Synchronization {
        private final Transaction tx;

        TxCommitHook(Transaction tx) {
            this.tx = tx;
        }

        public void afterCompletion(int param) {
            try {
                this.releaseConnections(this.tx);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Unable to release connections for " + this.tx, t);
            }
        }

        public void beforeCompletion() {
            try {
                PersistenceManager.this.delistResourcesForTransaction();
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Unable to delist resources for " + this.tx, t);
            }
        }

        private void releaseConnections(Transaction tx) {
            try {
                PersistenceManager.this.releaseResourceConnectionsForTransaction(tx);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Error releasing resources for " + tx, t);
            }
        }
    }
}

