/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexData;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipChainPosition;
import org.neo4j.kernel.impl.nioneo.store.RelationshipData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.kernel.impl.nioneo.xa.NodeEventConsumer;
import org.neo4j.kernel.impl.nioneo.xa.PropertyIndexEventConsumer;
import org.neo4j.kernel.impl.nioneo.xa.RelationshipEventConsumer;
import org.neo4j.kernel.impl.nioneo.xa.RelationshipTypeEventConsumer;
import org.neo4j.kernel.impl.nioneo.xa.WriteTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnectionHelpImpl;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceHelpImpl;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.IntArray;

public class NeoStoreXaConnection
extends XaConnectionHelpImpl {
    private final NeoStoreXaResource xaResource;
    private final NeoStore neoStore;
    private final NodeEventConsumer nodeConsumer;
    private final RelationshipEventConsumer relConsumer;
    private final RelationshipTypeEventConsumer relTypeConsumer;
    private final PropertyIndexEventConsumer propIndexConsumer;
    private WriteTransaction neoTransaction = null;

    NeoStoreXaConnection(NeoStore neoStore, XaResourceManager xaRm, byte[] branchId) {
        super(xaRm);
        this.neoStore = neoStore;
        this.nodeConsumer = new NodeEventConsumerImpl(this);
        this.relConsumer = new RelationshipEventConsumerImpl(this);
        this.relTypeConsumer = new RelationshipTypeEventConsumerImpl(this);
        this.propIndexConsumer = new PropertyIndexEventConsumerImpl(this);
        this.xaResource = new NeoStoreXaResource(neoStore.getStorageFileName(), xaRm, branchId);
    }

    public NodeEventConsumer getNodeConsumer() {
        return this.nodeConsumer;
    }

    public RelationshipEventConsumer getRelationshipConsumer() {
        return this.relConsumer;
    }

    public PropertyIndexEventConsumer getPropertyIndexConsumer() {
        return this.propIndexConsumer;
    }

    public RelationshipTypeEventConsumer getRelationshipTypeConsumer() {
        return this.relTypeConsumer;
    }

    public PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    RelationshipTypeStore getRelationshipTypeStore() {
        return this.neoStore.getRelationshipTypeStore();
    }

    @Override
    public XAResource getXaResource() {
        return this.xaResource;
    }

    WriteTransaction getWriteTransaction() {
        if (this.neoTransaction != null) {
            return this.neoTransaction;
        }
        try {
            this.neoTransaction = (WriteTransaction)this.getTransaction();
            return this.neoTransaction;
        }
        catch (XAException e) {
            throw new TransactionFailureException("Unable to get transaction.", e);
        }
    }

    private static class PropertyIndexEventConsumerImpl
    implements PropertyIndexEventConsumer {
        private final NeoStoreXaConnection xaCon;

        PropertyIndexEventConsumerImpl(NeoStoreXaConnection xaCon) {
            this.xaCon = xaCon;
        }

        @Override
        public void createPropertyIndex(int id, String key) {
            this.xaCon.getWriteTransaction().createPropertyIndex(id, key);
        }

        @Override
        public String getKeyFor(int id) {
            return this.xaCon.getWriteTransaction().getPropertyIndex(id);
        }

        @Override
        public PropertyIndexData[] getPropertyIndexes(int count) {
            return this.xaCon.getWriteTransaction().getPropertyIndexes(count);
        }
    }

    private static class RelationshipTypeEventConsumerImpl
    implements RelationshipTypeEventConsumer {
        private final NeoStoreXaConnection xaCon;
        private final RelationshipTypeStore relTypeStore;

        RelationshipTypeEventConsumerImpl(NeoStoreXaConnection xaCon) {
            this.xaCon = xaCon;
            this.relTypeStore = xaCon.getRelationshipTypeStore();
        }

        @Override
        public void addRelationshipType(int id, String name) {
            this.xaCon.getWriteTransaction().relationshipTypeAdd(id, name);
        }

        @Override
        public RelationshipTypeData getRelationshipType(int id) {
            return this.relTypeStore.getRelationshipType(id);
        }

        @Override
        public RelationshipTypeData[] getRelationshipTypes() {
            return this.relTypeStore.getRelationshipTypes();
        }
    }

    private static class RelationshipEventConsumerImpl
    implements RelationshipEventConsumer {
        private final NeoStoreXaConnection xaCon;

        public RelationshipEventConsumerImpl(NeoStoreXaConnection xaCon) {
            this.xaCon = xaCon;
        }

        @Override
        public void createRelationship(int id, int firstNode, int secondNode, int type) {
            this.xaCon.getWriteTransaction().relationshipCreate(id, firstNode, secondNode, type);
        }

        @Override
        public ArrayMap<Integer, PropertyData> deleteRelationship(int id) {
            return this.xaCon.getWriteTransaction().relDelete(id);
        }

        @Override
        public void addProperty(int relId, int propertyId, PropertyIndex index, Object value) {
            this.xaCon.getWriteTransaction().relAddProperty(relId, propertyId, index, value);
        }

        @Override
        public void changeProperty(int relId, int propertyId, Object value) {
            this.xaCon.getWriteTransaction().relChangeProperty(relId, propertyId, value);
        }

        @Override
        public void removeProperty(int relId, int propertyId) {
            this.xaCon.getWriteTransaction().relRemoveProperty(relId, propertyId);
        }

        @Override
        public ArrayMap<Integer, PropertyData> getProperties(int relId, boolean light) {
            return this.xaCon.getWriteTransaction().relGetProperties(relId, light);
        }

        @Override
        public RelationshipData getRelationship(int id) {
            return this.xaCon.getWriteTransaction().relationshipLoad(id);
        }

        @Override
        public RelationshipChainPosition getRelationshipChainPosition(int nodeId) {
            return this.xaCon.getWriteTransaction().getRelationshipChainPosition(nodeId);
        }

        @Override
        public Iterable<RelationshipData> getMoreRelationships(int nodeId, RelationshipChainPosition position) {
            return this.xaCon.getWriteTransaction().getMoreRelationships(nodeId, position);
        }

        @Override
        public boolean isRelationshipCreated(int relId) {
            return this.xaCon.getWriteTransaction().relCreated(relId);
        }
    }

    private static class NodeEventConsumerImpl
    implements NodeEventConsumer {
        private final NeoStoreXaConnection xaCon;

        public NodeEventConsumerImpl(NeoStoreXaConnection xaCon) {
            this.xaCon = xaCon;
        }

        @Override
        public void createNode(int nodeId) {
            this.xaCon.getWriteTransaction().nodeCreate(nodeId);
        }

        @Override
        public ArrayMap<Integer, PropertyData> deleteNode(int nodeId) {
            return this.xaCon.getWriteTransaction().nodeDelete(nodeId);
        }

        @Override
        public boolean loadLightNode(int nodeId) {
            return this.xaCon.getWriteTransaction().nodeLoadLight(nodeId);
        }

        @Override
        public void addProperty(int nodeId, int propertyId, PropertyIndex index, Object value) {
            this.xaCon.getWriteTransaction().nodeAddProperty(nodeId, propertyId, index, value);
        }

        @Override
        public void changeProperty(int nodeId, int propertyId, Object value) {
            this.xaCon.getWriteTransaction().nodeChangeProperty(nodeId, propertyId, value);
        }

        @Override
        public void removeProperty(int nodeId, int propertyId) {
            this.xaCon.getWriteTransaction().nodeRemoveProperty(nodeId, propertyId);
        }

        @Override
        public ArrayMap<Integer, PropertyData> getProperties(int nodeId, boolean light) {
            return this.xaCon.getWriteTransaction().nodeGetProperties(nodeId, light);
        }

        @Override
        public IntArray getCreatedNodes() {
            return this.xaCon.getWriteTransaction().getCreatedNodes();
        }

        @Override
        public boolean isNodeCreated(int nodeId) {
            return this.xaCon.getWriteTransaction().nodeCreated(nodeId);
        }
    }

    private static class NeoStoreXaResource
    extends XaResourceHelpImpl {
        private final Object identifier;

        NeoStoreXaResource(Object identifier, XaResourceManager xaRm, byte[] branchId) {
            super(xaRm, branchId);
            this.identifier = identifier;
        }

        @Override
        public boolean isSameRM(XAResource xares) {
            if (xares instanceof NeoStoreXaResource) {
                return this.identifier.equals(((NeoStoreXaResource)xares).identifier);
            }
            return false;
        }
    }
}

