/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.NoSuchElementException;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelTypeElementIterator;
import org.neo4j.kernel.impl.util.IntArray;

class FastRelTypeElement
extends RelTypeElementIterator {
    private final IntArray src;
    private int position = 0;
    private Integer nextElement = null;

    FastRelTypeElement(String type, NodeImpl node, IntArray src) {
        super(type, node);
        this.src = src == null ? IntArray.EMPTY : src;
    }

    FastRelTypeElement(String type, NodeImpl node, IntArray src, int position) {
        this(type, node, src);
        this.position = position;
    }

    @Override
    public boolean hasNext(NodeManager nodeManager) {
        if (this.nextElement != null) {
            return true;
        }
        if (this.position < this.src.length()) {
            this.nextElement = this.src.get(this.position++);
            return true;
        }
        return false;
    }

    @Override
    public int next(NodeManager nodeManager) {
        this.hasNext(nodeManager);
        if (this.nextElement != null) {
            Integer elementToReturn = this.nextElement;
            this.nextElement = null;
            return elementToReturn;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean isSrcEmpty() {
        return this.src.length() == 0;
    }

    @Override
    public RelTypeElementIterator setSrc(IntArray newSrc) {
        return new FastRelTypeElement(this.getType(), this.getNode(), newSrc, this.position);
    }
}

