/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.KernelData;

public abstract class KernelExtension<S>
extends Service {
    static final String INSTANCE_ID = "instanceId";

    protected KernelExtension(String key) {
        super(key, new String[0]);
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }

    public final boolean equals(Object obj) {
        return this.getClass().equals(obj.getClass());
    }

    public final void loadAgent(String agentArgs) {
        KernelData.visitAll(this, this.agentArgument(agentArgs));
    }

    protected final void loadAgent(KernelData kernel, Object param) {
        kernel.accept(this, param);
    }

    protected Object agentArgument(String agentArg) {
        return agentArg;
    }

    protected abstract S load(KernelData var1);

    protected S agentLoad(KernelData kernel, Object param) {
        S state = this.load(kernel);
        this.agentVisit(kernel, state, param);
        return state;
    }

    protected void agentVisit(KernelData kernel, S state, Object param) {
    }

    protected void loadConfiguration(KernelData kernel) {
    }

    protected void unload(S state) {
    }

    protected final S getState(KernelData kernel) {
        return (S)kernel.getState(this);
    }

    protected boolean isLoaded(KernelData kernel) {
        return this.getState(kernel) != null;
    }

    protected <T> Function<T> function(KernelData kernel, String name, Class<T> result, Class<?> ... params) {
        Method method;
        Class[] parameters = new Class[params == null ? 1 : params.length + 1];
        parameters[0] = KernelData.class;
        if (params != null && params.length != 0) {
            System.arraycopy(params, 0, parameters, 1, params.length);
        }
        try {
            method = this.getClass().getMethod(name, parameters);
            if (!Modifier.isPublic(method.getModifiers())) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return new Function(result, kernel, method);
    }

    public class Function<T> {
        private final Class<T> type;
        private final KernelData kernel;
        private final Method method;

        private Function(Class<T> type, KernelData kernel, Method method) {
            this.type = type;
            this.kernel = kernel;
            this.method = method;
        }

        public T call(Object ... args) {
            Object[] arguments = new Object[args == null ? 1 : args.length + 1];
            arguments[0] = this.kernel;
            if (args != null && args.length > 0) {
                System.arraycopy(args, 0, arguments, 1, args.length);
            }
            try {
                return this.type.cast(this.method.invoke((Object)KernelExtension.this, arguments));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Access denied", e);
            }
            catch (InvocationTargetException e) {
                Throwable exception = e.getTargetException();
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof Error) {
                    throw (Error)exception;
                }
                throw new RuntimeException("Unexpected exception: " + exception.getClass(), exception);
            }
        }
    }
}

