/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.AbstractTestBase;

public class TestMultipleFilters
extends AbstractTestBase {
    @BeforeClass
    public static void setupGraph() {
        TestMultipleFilters.createGraph("a TO b", "b TO d", "b TO e", "b TO k", "a TO c", "c TO f", "c TO k");
    }

    @Test
    public void testNarrowingFilters() {
        MustBeConnectedToNodeFilter mustBeConnectedToK = new MustBeConnectedToNodeFilter(this.getNodeWithName("k"));
        Evaluator mustNotHaveMoreThanTwoOutRels = new Evaluator(){

            public Evaluation evaluate(Path path) {
                return Evaluation.ofIncludes((IteratorUtil.count((Iterable)path.endNode().getRelationships(Direction.OUTGOING)) <= 2 ? 1 : 0) != 0);
            }
        };
        TraversalDescription description = Traversal.description().evaluator((Evaluator)mustBeConnectedToK);
        TestMultipleFilters.expectNodes(description.traverse(TestMultipleFilters.referenceNode()), "b", "c");
        TestMultipleFilters.expectNodes(description.evaluator(mustNotHaveMoreThanTwoOutRels).traverse(TestMultipleFilters.referenceNode()), "c");
    }

    @Test
    public void testBroadeningFilters() {
        MustBeConnectedToNodeFilter mustBeConnectedToC = new MustBeConnectedToNodeFilter(this.getNodeWithName("c"));
        MustBeConnectedToNodeFilter mustBeConnectedToE = new MustBeConnectedToNodeFilter(this.getNodeWithName("e"));
        TestMultipleFilters.expectNodes(Traversal.description().evaluator((Evaluator)mustBeConnectedToC).traverse(TestMultipleFilters.referenceNode()), "a");
        TestMultipleFilters.expectNodes(Traversal.description().evaluator((Evaluator)mustBeConnectedToC).evaluator((Evaluator)mustBeConnectedToE).traverse(TestMultipleFilters.referenceNode()), new String[0]);
        TestMultipleFilters.expectNodes(Traversal.description().filter(Traversal.returnAcceptedByAny((Predicate[])new Predicate[]{mustBeConnectedToC, mustBeConnectedToE})).traverse(TestMultipleFilters.referenceNode()), "a", "b");
    }

    private static class MustBeConnectedToNodeFilter
    implements Predicate<Path>,
    Evaluator {
        private final Node node;

        MustBeConnectedToNodeFilter(Node node) {
            this.node = node;
        }

        public boolean accept(Path item) {
            for (Relationship rel : item.endNode().getRelationships(Direction.OUTGOING)) {
                if (!rel.getEndNode().equals(this.node)) continue;
                return true;
            }
            return false;
        }

        public Evaluation evaluate(Path path) {
            return this.accept(path) ? Evaluation.INCLUDE_AND_CONTINUE : Evaluation.EXCLUDE_AND_CONTINUE;
        }
    }
}

