/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.AbstractTestBase;

public class TestMultiRelTypesAndDirections
extends AbstractTestBase {
    private static final RelationshipType ONE = DynamicRelationshipType.withName((String)"ONE");

    @BeforeClass
    public static void setupGraph() {
        TestMultiRelTypesAndDirections.createGraph("A ONE B", "B ONE C", "A TWO C");
    }

    @Test
    public void testCIsReturnedOnDepthTwoDepthFirst() {
        this.testCIsReturnedOnDepthTwo(Traversal.description().depthFirst());
    }

    @Test
    public void testCIsReturnedOnDepthTwoBreadthFirst() {
        this.testCIsReturnedOnDepthTwo(Traversal.description().breadthFirst());
    }

    private void testCIsReturnedOnDepthTwo(TraversalDescription description) {
        description = description.relationships(ONE, Direction.OUTGOING);
        int i = 0;
        for (Path position : description.traverse(TestMultiRelTypesAndDirections.referenceNode())) {
            Assert.assertEquals((long)i++, (long)position.length());
        }
    }
}

