/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.PruneEvaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.AbstractTestBase;

public class TestMultiPruneEvaluators
extends AbstractTestBase {
    @BeforeClass
    public static void setupGraph() {
        TestMultiPruneEvaluators.createGraph("a to b", "a to c", "a to d", "a to e", "b to f", "b to g", "b to h", "c to i", "d to j", "d to k", "d to l", "e to m", "e to n", "k to o", "k to p", "k to q", "k to r");
    }

    @Test
    public void makeSurePruneIsntCalledForStartNode() {
        final boolean[] calledForStartPosition = new boolean[1];
        PruneEvaluator evaluator = new PruneEvaluator(){

            public boolean pruneAfter(Path position) {
                if (position.length() == 0) {
                    calledForStartPosition[0] = true;
                }
                return false;
            }
        };
        IteratorUtil.lastOrNull((Iterable)Traversal.description().prune(evaluator).traverse(TestMultiPruneEvaluators.referenceNode()));
        Assert.assertFalse((boolean)calledForStartPosition[0]);
    }

    @Test
    public void testMaxDepthAndCustomPruneEvaluatorCombined() {
        Evaluator lessThanThreeRels = new Evaluator(){

            public Evaluation evaluate(Path path) {
                return IteratorUtil.count(path.endNode().getRelationships(Direction.OUTGOING).iterator()) < 3 ? Evaluation.INCLUDE_AND_PRUNE : Evaluation.INCLUDE_AND_CONTINUE;
            }
        };
        TraversalDescription description = Traversal.description().evaluator(Evaluators.all()).evaluator(Evaluators.toDepth((int)1)).evaluator(lessThanThreeRels);
        HashSet<String> expectedNodes = new HashSet<String>(Arrays.asList("a", "b", "c", "d", "e"));
        for (Path position : description.traverse(TestMultiPruneEvaluators.referenceNode())) {
            String name = (String)position.endNode().getProperty("name");
            Assert.assertTrue((String)(name + " shouldn't have been returned"), (boolean)expectedNodes.remove(name));
        }
        Assert.assertTrue((boolean)expectedNodes.isEmpty());
    }
}

