/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.traversal.GraphDefinition;

public class GraphDescription
implements GraphDefinition {
    private final RelationshipDescription[] description;

    public GraphDescription(String ... description) {
        ArrayList<RelationshipDescription> lines = new ArrayList<RelationshipDescription>();
        for (String part : description) {
            for (String line : part.split("\n")) {
                lines.add(new RelationshipDescription(line));
            }
        }
        this.description = lines.toArray(new RelationshipDescription[lines.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node create(GraphDatabaseService graphdb) {
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        Node node = null;
        Transaction tx = graphdb.beginTx();
        try {
            for (RelationshipDescription rel : this.description) {
                node = rel.create(graphdb, nodes).getEndNode();
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        return node;
    }

    private static class RelationshipDescription {
        private final String end;
        private final String start;
        private final RelationshipType type;

        public RelationshipDescription(String rel) {
            String[] parts = rel.split(" ");
            if (parts.length != 3) {
                throw new IllegalArgumentException("syntax error: \"" + rel + "\"");
            }
            this.start = parts[0];
            this.type = DynamicRelationshipType.withName((String)parts[1]);
            this.end = parts[2];
        }

        public Relationship create(GraphDatabaseService graphdb, Map<String, Node> nodes) {
            Node startNode = this.getNode(graphdb, nodes, this.start);
            Node endNode = this.getNode(graphdb, nodes, this.end);
            return startNode.createRelationshipTo(endNode, this.type);
        }

        private Node getNode(GraphDatabaseService graphdb, Map<String, Node> nodes, String name) {
            Node node = nodes.get(name);
            if (node == null) {
                node = nodes.size() == 0 ? graphdb.getReferenceNode() : graphdb.createNode();
                node.setProperty("name", (Object)name);
                nodes.put(name, node);
            }
            return node;
        }
    }
}

