/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.traversal.GraphDefinition;
import org.neo4j.kernel.impl.traversal.GraphDescription;

public abstract class AbstractTestBase {
    private static final String TARGET_NEODB = "target/neodb";
    private static GraphDatabaseService graphdb;
    protected static final Representation<PropertyContainer> NAME_PROPERTY_REPRESENTATION;
    protected static final Representation<Relationship> RELATIONSHIP_TYPE_REPRESENTATION;

    @BeforeClass
    public static final void beforeSuite() {
        AbstractTestBase.deleteFileOrDirectory(new File(TARGET_NEODB));
        graphdb = new EmbeddedGraphDatabase(TARGET_NEODB);
    }

    @AfterClass
    public static final void afterSuite() {
        graphdb.shutdown();
        graphdb = null;
    }

    protected static final Node referenceNode() {
        return graphdb.getReferenceNode();
    }

    protected static final Node getNode(long id) {
        return graphdb.getNodeById(id);
    }

    protected static final Transaction beginTx() {
        return graphdb.beginTx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeAllNodes(boolean removeReference) {
        Transaction tx = graphdb.beginTx();
        try {
            Node reference = removeReference ? null : graphdb.getReferenceNode();
            for (Node node : graphdb.getAllNodes()) {
                for (Relationship rel : node.getRelationships()) {
                    rel.delete();
                }
                if (node.equals(reference)) continue;
                node.delete();
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    protected static void createGraph(String ... description) {
        AbstractTestBase.createGraph(new GraphDescription(description));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Node createGraph(GraphDefinition graph) {
        Transaction tx = graphdb.beginTx();
        try {
            Node root = graph.create(graphdb);
            tx.success();
            Node node = root;
            return node;
        }
        finally {
            tx.finish();
        }
    }

    protected Node getNodeWithName(String name) {
        for (Node node : graphdb.getAllNodes()) {
            String nodeName = (String)node.getProperty("name", null);
            if (nodeName == null || !nodeName.equals(name)) continue;
            return node;
        }
        return null;
    }

    protected void assertLevels(Traverser traverser, Stack<Set<String>> levels) {
        Set<String> current = levels.pop();
        for (Path position : traverser) {
            String nodeName = (String)position.endNode().getProperty("name");
            if (current.isEmpty()) {
                current = levels.pop();
            }
            Assert.assertTrue((String)("Should not contain node (" + nodeName + ") at level " + (3 - levels.size())), (boolean)current.remove(nodeName));
        }
        Assert.assertTrue((String)"Should have no more levels", (boolean)levels.isEmpty());
        Assert.assertTrue((String)"Should be empty", (boolean)current.isEmpty());
    }

    private static void deleteFileOrDirectory(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                AbstractTestBase.deleteFileOrDirectory(child);
            }
        } else {
            file.delete();
        }
    }

    protected static <T> void expect(Iterable<? extends T> items, Representation<T> representation, String ... expected) {
        AbstractTestBase.expect(items, representation, new HashSet<String>(Arrays.asList(expected)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> void expect(Iterable<? extends T> items, Representation<T> representation, Set<String> expected) {
        Transaction tx = AbstractTestBase.beginTx();
        try {
            for (T item : items) {
                String repr = representation.represent(item);
                Assert.assertTrue((String)(repr + " not expected "), (boolean)expected.remove(repr));
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        if (!expected.isEmpty()) {
            Assert.fail((String)("The exepected elements " + expected + " were not returned."));
        }
    }

    protected static void expectNodes(Traverser traverser, String ... nodes) {
        AbstractTestBase.expect(traverser.nodes(), NAME_PROPERTY_REPRESENTATION, nodes);
    }

    protected static void expectRelationships(Traverser traverser, String ... relationships) {
        AbstractTestBase.expect(traverser.relationships(), new RelationshipRepresentation(NAME_PROPERTY_REPRESENTATION), relationships);
    }

    protected static void expectPaths(Traverser traverser, String ... paths) {
        AbstractTestBase.expectPaths(traverser, new HashSet<String>(Arrays.asList(paths)));
    }

    protected static void expectPaths(Traverser traverser, Set<String> expected) {
        AbstractTestBase.expect(traverser, new NodePathRepresentation(NAME_PROPERTY_REPRESENTATION), expected);
    }

    static {
        NAME_PROPERTY_REPRESENTATION = new PropertyRepresentation("name");
        RELATIONSHIP_TYPE_REPRESENTATION = new Representation<Relationship>(){

            @Override
            public String represent(Relationship item) {
                return item.getType().name();
            }
        };
    }

    protected static final class NodePathRepresentation
    implements Representation<Path> {
        private final Representation<? super Node> nodes;

        public NodePathRepresentation(Representation<? super Node> nodes) {
            this.nodes = nodes;
        }

        @Override
        public String represent(Path item) {
            StringBuilder builder = new StringBuilder();
            for (Node node : item.nodes()) {
                builder.append(builder.length() > 0 ? "," : "");
                builder.append(this.nodes.represent((Node)node));
            }
            return builder.toString();
        }
    }

    protected static final class RelationshipRepresentation
    implements Representation<Relationship> {
        private final Representation<? super Node> nodes;
        private final Representation<? super Relationship> rel;

        public RelationshipRepresentation(Representation<? super Node> nodes) {
            this(nodes, RELATIONSHIP_TYPE_REPRESENTATION);
        }

        public RelationshipRepresentation(Representation<? super Node> nodes, Representation<? super Relationship> rel) {
            this.nodes = nodes;
            this.rel = rel;
        }

        @Override
        public String represent(Relationship item) {
            return this.nodes.represent((Node)item.getStartNode()) + " " + this.rel.represent((Relationship)item) + " " + this.nodes.represent((Node)item.getEndNode());
        }
    }

    protected static final class PropertyRepresentation
    implements Representation<PropertyContainer> {
        private final String key;

        public PropertyRepresentation(String key) {
            this.key = key;
        }

        @Override
        public String represent(PropertyContainer item) {
            return (String)item.getProperty(this.key);
        }
    }

    protected static interface Representation<T> {
        public String represent(T var1);
    }
}

