/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.transaction.TxLog;

public class TestTxLog {
    private void assertEqualByteArray(byte[] a, byte[] b) {
        Assert.assertTrue((a.length == b.length ? 1 : 0) != 0);
        for (int i = 0; i < a.length; ++i) {
            Assert.assertEquals((long)a[i], (long)b[i]);
        }
    }

    private String path() {
        String path = AbstractNeo4jTestCase.getStorePath("txlog");
        new File(path).mkdirs();
        return path;
    }

    private String file(String name) {
        return this.path() + File.separator + name;
    }

    private String txFile() {
        return this.file("tx_test_log.tx");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTxLog() throws IOException {
        File file = new File(this.txFile());
        if (file.exists()) {
            file.delete();
        }
        try {
            TxLog txLog = new TxLog(this.txFile());
            Assert.assertTrue((!txLog.getDanglingRecords().hasNext() ? 1 : 0) != 0);
            byte[] globalId = new byte[64];
            byte[] branchId = new byte[45];
            txLog.txStart(globalId);
            txLog.addBranch(globalId, branchId);
            Assert.assertEquals((long)2L, (long)txLog.getRecordCount());
            List<?>[] lists = this.getRecordLists(txLog.getDanglingRecords());
            Assert.assertEquals((long)1L, (long)lists.length);
            List<?> records = lists[0];
            Assert.assertEquals((long)2L, (long)records.size());
            TxLog.Record record = (TxLog.Record)records.get(0);
            Assert.assertEquals((long)1L, (long)record.getType());
            this.assertEqualByteArray(globalId, record.getGlobalId());
            Assert.assertTrue((null == record.getBranchId() ? 1 : 0) != 0);
            record = (TxLog.Record)records.get(1);
            Assert.assertEquals((long)2L, (long)record.getType());
            this.assertEqualByteArray(globalId, record.getGlobalId());
            this.assertEqualByteArray(branchId, record.getBranchId());
            txLog.markAsCommitting(globalId);
            Assert.assertEquals((long)3L, (long)txLog.getRecordCount());
            txLog.close();
            txLog = new TxLog(this.txFile());
            Assert.assertEquals((long)0L, (long)txLog.getRecordCount());
            lists = this.getRecordLists(txLog.getDanglingRecords());
            Assert.assertEquals((long)1L, (long)lists.length);
            records = lists[0];
            Assert.assertEquals((long)3L, (long)records.size());
            record = (TxLog.Record)records.get(0);
            Assert.assertEquals((long)1L, (long)record.getType());
            this.assertEqualByteArray(globalId, record.getGlobalId());
            Assert.assertTrue((null == record.getBranchId() ? 1 : 0) != 0);
            record = (TxLog.Record)records.get(1);
            Assert.assertEquals((long)2L, (long)record.getType());
            this.assertEqualByteArray(globalId, record.getGlobalId());
            this.assertEqualByteArray(branchId, record.getBranchId());
            record = (TxLog.Record)records.get(2);
            Assert.assertEquals((long)3L, (long)record.getType());
            this.assertEqualByteArray(globalId, record.getGlobalId());
            Assert.assertTrue((null == record.getBranchId() ? 1 : 0) != 0);
            txLog.txDone(globalId);
            Assert.assertEquals((long)1L, (long)txLog.getRecordCount());
            Assert.assertEquals((long)0L, (long)this.getRecordLists(txLog.getDanglingRecords()).length);
            txLog.close();
            txLog = new TxLog(this.txFile());
            Assert.assertEquals((long)0L, (long)this.getRecordLists(txLog.getDanglingRecords()).length);
            txLog.close();
        }
        finally {
            file = new File(this.txFile());
            if (file.exists()) {
                file.delete();
            }
        }
    }

    private List<?>[] getRecordLists(Iterator<List<TxLog.Record>> danglingRecords) {
        ArrayList<List<TxLog.Record>> list = new ArrayList<List<TxLog.Record>>();
        while (danglingRecords.hasNext()) {
            list.add(danglingRecords.next());
        }
        return list.toArray(new List[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTruncateTxLog() throws IOException {
        File file = new File(this.txFile());
        if (file.exists()) {
            file.delete();
        }
        try {
            TxLog txLog = new TxLog(this.txFile());
            byte[] globalId = new byte[64];
            byte[] branchId = new byte[45];
            txLog.txStart(globalId);
            txLog.addBranch(globalId, branchId);
            txLog.markAsCommitting(globalId);
            txLog.truncate();
            Assert.assertEquals((long)0L, (long)this.getRecordLists(txLog.getDanglingRecords()).length);
            txLog.close();
            txLog = new TxLog(this.txFile());
            txLog.txStart(globalId);
            txLog.addBranch(globalId, branchId);
            txLog.markAsCommitting(globalId);
            txLog.close();
            txLog = new TxLog(this.txFile());
            Assert.assertEquals((long)1L, (long)this.getRecordLists(txLog.getDanglingRecords()).length);
            txLog.truncate();
            Assert.assertEquals((long)0L, (long)this.getRecordLists(txLog.getDanglingRecords()).length);
        }
        finally {
            file = new File(this.txFile());
            if (file.exists()) {
                file.delete();
            }
        }
    }

    @Test
    public void testTxRecovery() {
    }
}

