/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.Random;
import java.util.Stack;
import javax.transaction.TransactionManager;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.PlaceboTm;

public class TestDeadlockDetection {
    private static LockManager lm = new LockManager((TransactionManager)new PlaceboTm());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeadlockDetection() {
        ResourceObject r1 = new ResourceObject("R1");
        ResourceObject r2 = new ResourceObject("R2");
        ResourceObject r3 = new ResourceObject("R3");
        ResourceObject r4 = new ResourceObject("R4");
        HelperThread t1 = new HelperThread("T1");
        HelperThread t2 = new HelperThread("T2");
        HelperThread t3 = new HelperThread("T3");
        HelperThread t4 = new HelperThread("T4");
        try {
            t1.start();
            t2.start();
            t3.start();
            t4.start();
            t1.getReadLock(r1);
            t1.waitForCompletionOfTask();
            t1.getReadLock(r4);
            t1.waitForCompletionOfTask();
            t2.getReadLock(r2);
            t2.waitForCompletionOfTask();
            t2.getReadLock(r3);
            t2.waitForCompletionOfTask();
            t3.getReadLock(r3);
            t3.waitForCompletionOfTask();
            t3.getWriteLock(r1);
            t2.getWriteLock(r4);
            this.sleepSome();
            t1.getWriteLock(r2);
            t1.waitForCompletionOfTask();
            Assert.assertTrue((boolean)t1.isLastGetLockDeadLock());
            t1.releaseReadLock(r4);
            t2.waitForCompletionOfTask();
            t1.getWriteLock(r2);
            t2.releaseReadLock(r2);
            t1.waitForCompletionOfTask();
            t1.getWriteLock(r4);
            this.sleepSome();
            t2.getWriteLock(r2);
            t2.waitForCompletionOfTask();
            Assert.assertTrue((boolean)t2.isLastGetLockDeadLock());
            t2.releaseWriteLock(r4);
            t1.waitForCompletionOfTask();
            t1.releaseWriteLock(r4);
            t2.getReadLock(r4);
            t2.waitForCompletionOfTask();
            t1.releaseWriteLock(r2);
            t1.waitForCompletionOfTask();
            t1.getReadLock(r2);
            t1.waitForCompletionOfTask();
            t1.releaseReadLock(r1);
            t3.waitForCompletionOfTask();
            t3.getReadLock(r2);
            t3.waitForCompletionOfTask();
            t3.releaseWriteLock(r1);
            t1.getReadLock(r1);
            t1.waitForCompletionOfTask();
            t1.getWriteLock(r4);
            t3.getWriteLock(r1);
            t4.getReadLock(r2);
            t4.waitForCompletionOfTask();
            t2.getWriteLock(r2);
            t2.waitForCompletionOfTask();
            Assert.assertTrue((boolean)t2.isLastGetLockDeadLock());
            t2.releaseReadLock(r4);
            t1.waitForCompletionOfTask();
            t1.releaseWriteLock(r4);
            t1.waitForCompletionOfTask();
            t1.releaseReadLock(r1);
            t1.waitForCompletionOfTask();
            t2.getReadLock(r4);
            t3.waitForCompletionOfTask();
            t3.releaseWriteLock(r1);
            t1.getReadLock(r1);
            t1.waitForCompletionOfTask();
            t1.getWriteLock(r4);
            t3.releaseReadLock(r2);
            t3.waitForCompletionOfTask();
            t3.getWriteLock(r1);
            t2.releaseReadLock(r4);
            t1.waitForCompletionOfTask();
            t1.releaseWriteLock(r4);
            t1.waitForCompletionOfTask();
            t1.releaseReadLock(r1);
            t3.waitForCompletionOfTask();
            t3.releaseWriteLock(r1);
            t3.waitForCompletionOfTask();
            t1.releaseReadLock(r2);
            t4.releaseReadLock(r2);
            t2.releaseReadLock(r3);
            t3.releaseReadLock(r3);
            t1.waitForCompletionOfTask();
            t2.waitForCompletionOfTask();
            t3.waitForCompletionOfTask();
            t4.waitForCompletionOfTask();
            t1.getReadLock(r1);
            t1.waitForCompletionOfTask();
            t2.getReadLock(r1);
            t2.waitForCompletionOfTask();
            t1.getWriteLock(r1);
            this.sleepSome();
            t2.getWriteLock(r1);
            t2.waitForCompletionOfTask();
            Assert.assertTrue((boolean)t2.isLastGetLockDeadLock());
            t2.releaseReadLock(r1);
            t1.waitForCompletionOfTask();
            t1.releaseReadLock(r1);
            t1.waitForCompletionOfTask();
            t1.releaseWriteLock(r1);
            t1.waitForCompletionOfTask();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Deadlock detection failed" + e));
        }
        finally {
            t1.quit();
            t2.quit();
            t3.quit();
            t4.quit();
        }
    }

    private void sleepSome() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testStressMultipleThreads() {
        int i;
        for (int i2 = 0; i2 < StressThread.resources.length; ++i2) {
            StressThread.resources[i2] = new ResourceObject("RX" + i2);
        }
        Thread[] stressThreads = new Thread[50];
        StressThread.go = false;
        for (i = 0; i < stressThreads.length; ++i) {
            stressThreads[i] = new StressThread("T" + i, 100, 10, 0.8f);
        }
        for (i = 0; i < stressThreads.length; ++i) {
            stressThreads[i].start();
        }
        StressThread.go = true;
    }

    public static class StressThread
    extends Thread {
        private static Random rand = new Random(System.currentTimeMillis());
        private static final Object READ = new Object();
        private static final Object WRITE = new Object();
        private static ResourceObject[] resources = new ResourceObject[10];
        private static boolean go = false;
        private String name;
        private int numberOfIterations;
        private int depthCount;
        private float readWriteRatio;

        StressThread(String name, int numberOfIterations, int depthCount, float readWriteRatio) {
            this.name = name;
            this.numberOfIterations = numberOfIterations;
            this.depthCount = depthCount;
            this.readWriteRatio = readWriteRatio;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!go) {
                    try {
                        StressThread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                }
                Stack<Object> lockStack = new Stack<Object>();
                Stack<ResourceObject> resourceStack = new Stack<ResourceObject>();
                try {
                    for (int i = 0; i < this.numberOfIterations; ++i) {
                        int depth = this.depthCount;
                        do {
                            float f = rand.nextFloat();
                            int n = rand.nextInt(resources.length);
                            if (f < this.readWriteRatio) {
                                lm.getReadLock((Object)resources[n]);
                                lockStack.push(READ);
                            } else {
                                lm.getWriteLock((Object)resources[n]);
                                lockStack.push(WRITE);
                            }
                            resourceStack.push(resources[n]);
                        } while (--depth > 0);
                        while (!lockStack.isEmpty()) {
                            if (lockStack.pop() == READ) {
                                lm.releaseReadLock(resourceStack.pop());
                                continue;
                            }
                            lm.releaseWriteLock(resourceStack.pop());
                        }
                    }
                }
                catch (DeadlockDetectedException deadlockDetectedException) {
                    while (!lockStack.isEmpty()) {
                        if (lockStack.pop() == READ) {
                            lm.releaseReadLock(resourceStack.pop());
                            continue;
                        }
                        lm.releaseWriteLock(resourceStack.pop());
                    }
                }
                finally {
                    while (!lockStack.isEmpty()) {
                        if (lockStack.pop() == READ) {
                            lm.releaseReadLock(resourceStack.pop());
                            continue;
                        }
                        lm.releaseWriteLock(resourceStack.pop());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private static class ResourceObject {
        private String name = null;

        ResourceObject(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class HelperThread
    extends Thread {
        private static final int DO_NOTHING_TASK = 0;
        private static final int GET_WRITELOCK_TASK = 1;
        private static final int GET_READLOCK_TASK = 2;
        private static final int RELEASE_WRITELOCK_TASK = 3;
        private static final int RELEASE_READLOCK_TASK = 4;
        private static final int QUIT_TASK = 5;
        private String name = null;
        private int nextTask = 0;
        private boolean taskCompleted = true;
        private Object resource = null;
        private boolean deadlockOnLastWait = false;

        HelperThread(String name) {
            this.name = name;
        }

        @Override
        public synchronized void run() {
            try {
                block14: while (this.nextTask != 5) {
                    switch (this.nextTask) {
                        case 0: {
                            this.wait(10L);
                            continue block14;
                        }
                        case 1: {
                            try {
                                lm.getWriteLock(this.resource);
                                this.deadlockOnLastWait = false;
                            }
                            catch (DeadlockDetectedException e) {
                                this.deadlockOnLastWait = true;
                            }
                            this.taskCompleted = true;
                            this.nextTask = 0;
                            continue block14;
                        }
                        case 2: {
                            try {
                                lm.getReadLock(this.resource);
                                this.deadlockOnLastWait = false;
                            }
                            catch (DeadlockDetectedException e) {
                                this.deadlockOnLastWait = true;
                            }
                            this.taskCompleted = true;
                            this.nextTask = 0;
                            continue block14;
                        }
                        case 3: {
                            lm.releaseWriteLock(this.resource);
                            this.taskCompleted = true;
                            this.nextTask = 0;
                            continue block14;
                        }
                        case 4: {
                            lm.releaseReadLock(this.resource);
                            this.taskCompleted = true;
                            this.nextTask = 0;
                            continue block14;
                        }
                        case 5: {
                            continue block14;
                        }
                    }
                    throw new RuntimeException("Unknown task " + this.nextTask);
                }
            }
            catch (Exception e) {
                this.taskCompleted = true;
                System.out.println("" + this + " unable to execute task, " + e);
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        synchronized void waitForCompletionOfTask() {
            while (!this.taskCompleted) {
                try {
                    this.wait(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        boolean isLastGetLockDeadLock() {
            return this.deadlockOnLastWait;
        }

        synchronized void getWriteLock(Object resource) {
            if (!this.taskCompleted) {
                throw new RuntimeException("Previous task not completed");
            }
            this.resource = resource;
            this.taskCompleted = false;
            this.nextTask = 1;
        }

        synchronized void getReadLock(Object resource) {
            if (!this.taskCompleted) {
                throw new RuntimeException("Previous task not completed");
            }
            this.resource = resource;
            this.taskCompleted = false;
            this.nextTask = 2;
        }

        synchronized void releaseWriteLock(Object resource) {
            if (!this.taskCompleted) {
                throw new RuntimeException("Previous task not completed");
            }
            this.resource = resource;
            this.taskCompleted = false;
            this.nextTask = 3;
        }

        synchronized void releaseReadLock(Object resource) {
            if (!this.taskCompleted) {
                throw new RuntimeException("Previous task not completed");
            }
            this.resource = resource;
            this.taskCompleted = false;
            this.nextTask = 4;
        }

        void quit() {
            this.resource = null;
            this.taskCompleted = false;
            this.nextTask = 5;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

