/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.ArrayList;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.neo4j.kernel.impl.transaction.MethodCall;

class FakeXAResource
implements XAResource {
    private String name = null;
    private int transactionTimeout = 0;
    private ArrayList<MethodCall> methodCalls = new ArrayList();

    FakeXAResource(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    synchronized MethodCall[] getAndRemoveMethodCalls() {
        if (this.methodCalls.size() > 0) {
            MethodCall[] methodCallArray = new MethodCall[this.methodCalls.size()];
            methodCallArray = this.methodCalls.toArray(methodCallArray);
            this.methodCalls = new ArrayList();
            return methodCallArray;
        }
        return new MethodCall[0];
    }

    private synchronized void addMethodCall(MethodCall methodCall) {
        this.methodCalls.add(methodCall);
    }

    @Override
    public void commit(Xid xid, boolean onePhase) {
        this.addMethodCall(new MethodCall("commit", new Object[]{xid, new Boolean(onePhase)}, new String[]{"javax.transaction.xa.Xid", "java.lang.Boolean"}));
    }

    @Override
    public void end(Xid xid, int flags) {
        this.addMethodCall(new MethodCall("end", new Object[]{xid, new Integer(flags)}, new String[]{"javax.transaction.xa.Xid", "java.lang.Integer"}));
    }

    @Override
    public void forget(Xid xid) {
        this.addMethodCall(new MethodCall("forget", new Object[]{xid}, new String[]{"javax.transaction.xa.Xid"}));
    }

    @Override
    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    @Override
    public boolean setTransactionTimeout(int timeout) {
        this.transactionTimeout = timeout;
        return true;
    }

    @Override
    public boolean isSameRM(XAResource xares) {
        return xares instanceof FakeXAResource && this.name.equals(((FakeXAResource)xares).getName());
    }

    @Override
    public int prepare(Xid xid) {
        this.addMethodCall(new MethodCall("prepare", new Object[]{xid}, new String[]{"javax.transaction.xa.Xid"}));
        return 0;
    }

    @Override
    public Xid[] recover(int flag) {
        this.addMethodCall(new MethodCall("recover", new Object[]{new Integer(flag)}, new String[]{"java.lang.Integer"}));
        return new Xid[0];
    }

    @Override
    public void rollback(Xid xid) {
        this.addMethodCall(new MethodCall("rollback", new Object[]{xid}, new String[]{"javax.transaction.xa.Xid"}));
    }

    @Override
    public void start(Xid xid, int flags) {
        this.addMethodCall(new MethodCall("start", new Object[]{xid, new Integer(flags)}, new String[]{"javax.transaction.xa.Xid", "java.lang.Integer"}));
    }
}

