/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;

public class TestXa
extends AbstractNeo4jTestCase {
    public static IdGeneratorFactory ID_GENERATOR_FACTORY = CommonFactories.defaultIdGeneratorFactory();
    private NeoStoreXaDataSource ds;
    private NeoStoreXaConnection xaCon;
    private Logger log;
    private Level level;
    private LockManager lockManager;
    private LockReleaser lockReleaser;

    @Override
    protected boolean restartGraphDbBetweenTests() {
        return true;
    }

    private PropertyIndex createDummyIndex(int id, String key) {
        MyPropertyIndex index = new MyPropertyIndex(key, id);
        MyPropertyIndex.add(index);
        return index;
    }

    private String path() {
        String path = TestXa.getStorePath("xatest");
        new File(path).mkdirs();
        return path;
    }

    private String file(String name) {
        return this.path() + File.separator + name;
    }

    @Before
    public void setUpNeoStore() throws Exception {
        this.log = Logger.getLogger("org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog/nioneo_logical.log");
        this.level = this.log.getLevel();
        this.log.setLevel(Level.OFF);
        this.log = Logger.getLogger("org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource");
        this.log.setLevel(Level.OFF);
        NeoStore.createStore((String)this.file("neo"), (Map)MapUtil.map((Object[])new Object[]{IdGeneratorFactory.class, ID_GENERATOR_FACTORY}));
        this.lockManager = this.getEmbeddedGraphDb().getConfig().getLockManager();
        this.lockReleaser = this.getEmbeddedGraphDb().getConfig().getLockReleaser();
        this.ds = this.newNeoStore();
        this.xaCon = (NeoStoreXaConnection)this.ds.getXaConnection();
    }

    @After
    public void tearDownNeoStore() {
        this.ds.close();
        this.log.setLevel(this.level);
        this.log = Logger.getLogger("org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog/nioneo_logical.log");
        this.log.setLevel(this.level);
        this.log = Logger.getLogger("org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource");
        this.log.setLevel(this.level);
        File file = new File(this.file("neo"));
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.nodestore.db"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.nodestore.db.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.index"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.index.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.index.keys"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.index.keys.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.strings"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.strings.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.arrays"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.propertystore.db.arrays.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.relationshipstore.db"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.relationshipstore.db.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.relationshiptypestore.db"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.relationshiptypestore.db.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.relationshiptypestore.db.names"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("neo.relationshiptypestore.db.names.id"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        file = new File(this.path());
        for (File nioFile : file.listFiles()) {
            if (!nioFile.getName().startsWith("nioneo_logical.log")) continue;
            Assert.assertTrue((boolean)nioFile.delete());
        }
    }

    private void deleteLogicalLogIfExist() {
        File file = new File(this.file("nioneo_logical.log.1"));
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.file("nioneo_logical.log.2"))).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        file = new File(this.file("nioneo_logical.log.active"));
        Assert.assertTrue((boolean)file.delete());
    }

    private void renameCopiedLogicalLog() {
        File file = new File(this.file("nioneo_logical.log.bak.1"));
        if (file.exists()) {
            Assert.assertTrue((boolean)file.renameTo(new File(this.file("nioneo_logical.log.1"))));
        } else {
            file = new File(this.file("nioneo_logical.log.bak.2"));
            Assert.assertTrue((boolean)file.renameTo(new File(this.file("nioneo_logical.log.2"))));
        }
        file = new File(this.file("nioneo_logical.log.bak.active"));
        Assert.assertTrue((boolean)file.renameTo(new File(this.file("nioneo_logical.log.active"))));
    }

    private void truncateLogicalLog(int size) throws IOException {
        char active = '1';
        FileChannel af = new RandomAccessFile(this.file("nioneo_logical.log.active"), "r").getChannel();
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        af.read(buffer);
        af.close();
        buffer.flip();
        active = buffer.asCharBuffer().get();
        buffer.clear();
        FileChannel fileChannel = new RandomAccessFile(this.file("nioneo_logical.log." + active), "rw").getChannel();
        if (fileChannel.size() > (long)size) {
            fileChannel.truncate(size);
        } else {
            fileChannel.position(size);
            ByteBuffer buf = ByteBuffer.allocate(1);
            buf.put((byte)0).flip();
            fileChannel.write(buf);
        }
        fileChannel.force(false);
        fileChannel.close();
    }

    private void copyLogicalLog() throws IOException {
        char active = '1';
        FileChannel af = new RandomAccessFile(this.file("nioneo_logical.log.active"), "r").getChannel();
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        af.read(buffer);
        buffer.flip();
        FileChannel activeCopy = new RandomAccessFile(this.file("nioneo_logical.log.bak.active"), "rw").getChannel();
        activeCopy.write(buffer);
        activeCopy.close();
        af.close();
        buffer.flip();
        active = buffer.asCharBuffer().get();
        buffer.clear();
        FileChannel source = new RandomAccessFile(this.file("nioneo_logical.log." + active), "r").getChannel();
        FileChannel dest = new RandomAccessFile(this.file("nioneo_logical.log.bak." + active), "rw").getChannel();
        int read = -1;
        do {
            read = source.read(buffer);
            buffer.flip();
            dest.write(buffer);
            buffer.clear();
        } while (read == 1024);
        source.close();
        dest.close();
    }

    private PropertyIndex index(String key) {
        Iterator<PropertyIndex> itr = MyPropertyIndex.index(key).iterator();
        if (!itr.hasNext()) {
            int id = this.ds.nextId(PropertyIndex.class);
            PropertyIndex index = this.createDummyIndex(id, key);
            this.xaCon.getPropertyIndexConsumer().createPropertyIndex(id, key);
            return index;
        }
        return itr.next();
    }

    @Test
    public void testLogicalLog() throws Exception {
        XidImpl xid = new XidImpl(new byte[1], new byte[1]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        int node1 = this.ds.nextId(Node.class);
        this.xaCon.getNodeConsumer().createNode(node1);
        int node2 = this.ds.nextId(Node.class);
        this.xaCon.getNodeConsumer().createNode(node2);
        int n1prop1 = this.ds.nextId(PropertyStore.class);
        this.xaCon.getNodeConsumer().addProperty(node1, n1prop1, this.index("prop1"), (Object)"string1");
        this.xaCon.getNodeConsumer().getProperties(node1, false);
        int relType1 = this.ds.nextId(RelationshipType.class);
        this.xaCon.getRelationshipTypeConsumer().addRelationshipType(relType1, "relationshiptype1");
        int rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getRelationshipConsumer().createRelationship(rel1, node1, node2, relType1);
        int r1prop1 = this.ds.nextId(PropertyStore.class);
        this.xaCon.getRelationshipConsumer().addProperty(rel1, r1prop1, this.index("prop1"), (Object)"string1");
        this.xaCon.getNodeConsumer().changeProperty(node1, n1prop1, (Object)"string2");
        this.xaCon.getRelationshipConsumer().changeProperty(rel1, r1prop1, (Object)"string2");
        this.xaCon.getNodeConsumer().removeProperty(node1, n1prop1);
        this.xaCon.getRelationshipConsumer().removeProperty(rel1, r1prop1);
        this.xaCon.getRelationshipConsumer().deleteRelationship(rel1);
        this.xaCon.getNodeConsumer().deleteNode(node1);
        this.xaCon.getNodeConsumer().deleteNode(node2);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.commit((Xid)xid, true);
        this.copyLogicalLog();
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        this.renameCopiedLogicalLog();
        this.ds = this.newNeoStore();
        this.xaCon = (NeoStoreXaConnection)this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)0L, (long)xaRes.recover(0).length);
        this.xaCon.clearAllTransactions();
    }

    private NeoStoreXaDataSource newNeoStore() throws InstantiationException, IOException {
        return new NeoStoreXaDataSource(MapUtil.genericMap((Object[])new Object[]{LockManager.class, this.lockManager, LockReleaser.class, this.lockReleaser, IdGeneratorFactory.class, ID_GENERATOR_FACTORY, TxIdGenerator.class, TxIdGenerator.DEFAULT, "store_dir", this.path(), "neo_store", this.file("neo"), "logical_log", this.file("nioneo_logical.log")}));
    }

    @Test
    public void testLogicalLogPrepared() throws Exception {
        XidImpl xid = new XidImpl(new byte[2], new byte[2]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        int node1 = this.ds.nextId(Node.class);
        this.xaCon.getNodeConsumer().createNode(node1);
        int node2 = this.ds.nextId(Node.class);
        this.xaCon.getNodeConsumer().createNode(node2);
        int n1prop1 = this.ds.nextId(PropertyStore.class);
        this.xaCon.getNodeConsumer().addProperty(node1, n1prop1, this.index("prop1"), (Object)"string1");
        int relType1 = this.ds.nextId(RelationshipType.class);
        this.xaCon.getRelationshipTypeConsumer().addRelationshipType(relType1, "relationshiptype1");
        int rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getRelationshipConsumer().createRelationship(rel1, node1, node2, relType1);
        int r1prop1 = this.ds.nextId(PropertyStore.class);
        this.xaCon.getRelationshipConsumer().addProperty(rel1, r1prop1, this.index("prop1"), (Object)"string1");
        this.xaCon.getNodeConsumer().changeProperty(node1, n1prop1, (Object)"string2");
        this.xaCon.getRelationshipConsumer().changeProperty(rel1, r1prop1, (Object)"string2");
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.copyLogicalLog();
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        this.renameCopiedLogicalLog();
        this.ds = this.newNeoStore();
        this.xaCon = (NeoStoreXaConnection)this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)1L, (long)xaRes.recover(0).length);
        xaRes.commit((Xid)xid, true);
        this.xaCon.clearAllTransactions();
    }

    @Test
    public void testLogicalLogPrePrepared() throws Exception {
        XidImpl xid = new XidImpl(new byte[3], new byte[3]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        int node1 = this.ds.nextId(Node.class);
        this.xaCon.getNodeConsumer().createNode(node1);
        int node2 = this.ds.nextId(Node.class);
        this.xaCon.getNodeConsumer().createNode(node2);
        int n1prop1 = this.ds.nextId(PropertyStore.class);
        this.xaCon.getNodeConsumer().addProperty(node1, n1prop1, this.index("prop1"), (Object)"string1");
        int relType1 = this.ds.nextId(RelationshipType.class);
        this.xaCon.getRelationshipTypeConsumer().addRelationshipType(relType1, "relationshiptype1");
        int rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getRelationshipConsumer().createRelationship(rel1, node1, node2, relType1);
        int r1prop1 = this.ds.nextId(PropertyStore.class);
        this.xaCon.getRelationshipConsumer().addProperty(rel1, r1prop1, this.index("prop1"), (Object)"string1");
        this.xaCon.getNodeConsumer().changeProperty(node1, n1prop1, (Object)"string2");
        this.xaCon.getRelationshipConsumer().changeProperty(rel1, r1prop1, (Object)"string2");
        xaRes.end((Xid)xid, 0x4000000);
        this.xaCon.clearAllTransactions();
        this.copyLogicalLog();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        this.renameCopiedLogicalLog();
        this.ds = this.newNeoStore();
        this.xaCon = (NeoStoreXaConnection)this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)0L, (long)xaRes.recover(0).length);
    }

    @Test
    public void testBrokenNodeCommand() throws Exception {
        XidImpl xid = new XidImpl(new byte[4], new byte[4]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        int node1 = this.ds.nextId(Node.class);
        this.xaCon.getNodeConsumer().createNode(node1);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.xaCon.clearAllTransactions();
        this.copyLogicalLog();
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        this.renameCopiedLogicalLog();
        this.truncateLogicalLog(39);
        this.truncateLogicalLog(40);
        this.ds = this.newNeoStore();
        this.xaCon = (NeoStoreXaConnection)this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)0L, (long)xaRes.recover(0).length);
        this.xaCon.clearAllTransactions();
    }

    @Test
    public void testBrokenCommand() throws Exception {
        XidImpl xid = new XidImpl(new byte[4], new byte[4]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        int node1 = this.ds.nextId(Node.class);
        this.xaCon.getNodeConsumer().createNode(node1);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.xaCon.clearAllTransactions();
        this.copyLogicalLog();
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        this.renameCopiedLogicalLog();
        this.truncateLogicalLog(32);
        this.truncateLogicalLog(40);
        this.ds = this.newNeoStore();
        this.xaCon = (NeoStoreXaConnection)this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)0L, (long)xaRes.recover(0).length);
        this.xaCon.clearAllTransactions();
    }

    @Test
    public void testBrokenPrepare() throws Exception {
        XidImpl xid = new XidImpl(new byte[4], new byte[4]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        int node1 = this.ds.nextId(Node.class);
        this.xaCon.getNodeConsumer().createNode(node1);
        int node2 = this.ds.nextId(Node.class);
        this.xaCon.getNodeConsumer().createNode(node2);
        int n1prop1 = this.ds.nextId(PropertyStore.class);
        this.xaCon.getNodeConsumer().addProperty(node1, n1prop1, this.index("prop1"), (Object)"string value 1");
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        this.copyLogicalLog();
        this.xaCon.clearAllTransactions();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        this.renameCopiedLogicalLog();
        this.truncateLogicalLog(155);
        this.ds = this.newNeoStore();
        this.xaCon = (NeoStoreXaConnection)this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)0L, (long)xaRes.recover(0).length);
        this.xaCon.clearAllTransactions();
    }

    @Test
    public void testBrokenDone() throws Exception {
        XidImpl xid = new XidImpl(new byte[4], new byte[4]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        int node1 = this.ds.nextId(Node.class);
        this.xaCon.getNodeConsumer().createNode(node1);
        int node2 = this.ds.nextId(Node.class);
        this.xaCon.getNodeConsumer().createNode(node2);
        int n1prop1 = this.ds.nextId(PropertyStore.class);
        this.xaCon.getNodeConsumer().addProperty(node1, n1prop1, this.index("prop1"), (Object)"string value 1");
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.prepare((Xid)xid);
        xaRes.commit((Xid)xid, false);
        this.copyLogicalLog();
        this.ds.close();
        this.deleteLogicalLogIfExist();
        this.renameCopiedLogicalLog();
        this.truncateLogicalLog(171);
        this.ds = this.newNeoStore();
        this.xaCon = (NeoStoreXaConnection)this.ds.getXaConnection();
        xaRes = this.xaCon.getXaResource();
        Assert.assertEquals((long)1L, (long)xaRes.recover(0).length);
        this.xaCon.clearAllTransactions();
    }

    @Test
    public void testLogVersion() {
        long creationTime = this.ds.getCreationTime();
        long randomIdentifier = this.ds.getRandomIdentifier();
        long currentVersion = this.ds.getCurrentLogVersion();
        Assert.assertEquals((long)currentVersion, (long)this.ds.incrementAndGetLogVersion());
        Assert.assertEquals((long)(currentVersion + 1L), (long)this.ds.incrementAndGetLogVersion());
        Assert.assertEquals((long)creationTime, (long)this.ds.getCreationTime());
        Assert.assertEquals((long)randomIdentifier, (long)this.ds.getRandomIdentifier());
    }

    @Test
    public void testLogicalLogRotation() throws Exception {
        this.ds.keepLogicalLogs(true);
        XidImpl xid = new XidImpl(new byte[1], new byte[1]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        int node1 = this.ds.nextId(Node.class);
        this.xaCon.getNodeConsumer().createNode(node1);
        int node2 = this.ds.nextId(Node.class);
        this.xaCon.getNodeConsumer().createNode(node2);
        int n1prop1 = this.ds.nextId(PropertyStore.class);
        this.xaCon.getNodeConsumer().addProperty(node1, n1prop1, this.index("prop1"), (Object)"string1");
        this.xaCon.getNodeConsumer().getProperties(node1, false);
        int relType1 = this.ds.nextId(RelationshipType.class);
        this.xaCon.getRelationshipTypeConsumer().addRelationshipType(relType1, "relationshiptype1");
        int rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getRelationshipConsumer().createRelationship(rel1, node1, node2, relType1);
        int r1prop1 = this.ds.nextId(PropertyStore.class);
        this.xaCon.getRelationshipConsumer().addProperty(rel1, r1prop1, this.index("prop1"), (Object)"string1");
        this.xaCon.getNodeConsumer().changeProperty(node1, n1prop1, (Object)"string2");
        this.xaCon.getRelationshipConsumer().changeProperty(rel1, r1prop1, (Object)"string2");
        this.xaCon.getNodeConsumer().removeProperty(node1, n1prop1);
        this.xaCon.getRelationshipConsumer().removeProperty(rel1, r1prop1);
        this.xaCon.getRelationshipConsumer().deleteRelationship(rel1);
        this.xaCon.getNodeConsumer().deleteNode(node1);
        this.xaCon.getNodeConsumer().deleteNode(node2);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.commit((Xid)xid, true);
        long currentVersion = this.ds.getCurrentLogVersion();
        this.ds.rotateLogicalLog();
        Assert.assertTrue((this.ds.getLogicalLog(currentVersion) != null ? 1 : 0) != 0);
        this.ds.rotateLogicalLog();
        Assert.assertTrue((this.ds.getLogicalLog(currentVersion) != null ? 1 : 0) != 0);
        Assert.assertTrue((this.ds.getLogicalLog(currentVersion + 1L) != null ? 1 : 0) != 0);
    }

    @Test
    public void testApplyLogicalLog() throws Exception {
        this.ds.keepLogicalLogs(true);
        XidImpl xid = new XidImpl(new byte[1], new byte[1]);
        XAResource xaRes = this.xaCon.getXaResource();
        xaRes.start((Xid)xid, 0);
        int node1 = this.ds.nextId(Node.class);
        this.xaCon.getNodeConsumer().createNode(node1);
        int node2 = this.ds.nextId(Node.class);
        this.xaCon.getNodeConsumer().createNode(node2);
        int n1prop1 = this.ds.nextId(PropertyStore.class);
        this.xaCon.getNodeConsumer().addProperty(node1, n1prop1, this.index("prop1"), (Object)"string1");
        this.xaCon.getNodeConsumer().getProperties(node1, false);
        int relType1 = this.ds.nextId(RelationshipType.class);
        this.xaCon.getRelationshipTypeConsumer().addRelationshipType(relType1, "relationshiptype1");
        int rel1 = this.ds.nextId(Relationship.class);
        this.xaCon.getRelationshipConsumer().createRelationship(rel1, node1, node2, relType1);
        int r1prop1 = this.ds.nextId(PropertyStore.class);
        this.xaCon.getRelationshipConsumer().addProperty(rel1, r1prop1, this.index("prop1"), (Object)"string1");
        this.xaCon.getNodeConsumer().changeProperty(node1, n1prop1, (Object)"string2");
        this.xaCon.getRelationshipConsumer().changeProperty(rel1, r1prop1, (Object)"string2");
        this.xaCon.getNodeConsumer().removeProperty(node1, n1prop1);
        this.xaCon.getRelationshipConsumer().removeProperty(rel1, r1prop1);
        this.xaCon.getRelationshipConsumer().deleteRelationship(rel1);
        this.xaCon.getNodeConsumer().deleteNode(node1);
        this.xaCon.getNodeConsumer().deleteNode(node2);
        xaRes.end((Xid)xid, 0x4000000);
        xaRes.commit((Xid)xid, true);
        long currentVersion = this.ds.getCurrentLogVersion();
        this.ds.keepLogicalLogs(true);
        this.ds.rotateLogicalLog();
        this.ds.rotateLogicalLog();
        this.ds.rotateLogicalLog();
        this.ds.setCurrentLogVersion(currentVersion);
        this.ds.setLastCommittedTxId(0L);
        this.ds.makeBackupSlave();
        this.ds.applyLog(this.ds.getLogicalLog(currentVersion));
        this.ds.applyLog(this.ds.getLogicalLog(currentVersion + 1L));
        this.ds.applyLog(this.ds.getLogicalLog(currentVersion + 2L));
        this.ds.keepLogicalLogs(false);
    }

    private static class MyPropertyIndex
    extends PropertyIndex {
        private static Map<String, PropertyIndex> stringToIndex = new HashMap<String, PropertyIndex>();
        private static Map<Integer, PropertyIndex> intToIndex = new HashMap<Integer, PropertyIndex>();

        protected MyPropertyIndex(String key, int keyId) {
            super(key, keyId);
        }

        public static Iterable<PropertyIndex> index(String key) {
            if (stringToIndex.containsKey(key)) {
                return Arrays.asList(stringToIndex.get(key));
            }
            return Collections.emptyList();
        }

        public static void add(MyPropertyIndex index) {
            stringToIndex.put(index.getKey(), index);
            intToIndex.put(index.getKeyId(), index);
        }
    }
}

