/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;

public class TestStore {
    public static IdGeneratorFactory ID_GENERATOR_FACTORY = CommonFactories.defaultIdGeneratorFactory();

    private String path() {
        String path = AbstractNeo4jTestCase.getStorePath("teststore");
        new File(path).mkdirs();
        return path;
    }

    private String file(String name) {
        return this.path() + File.separator + name;
    }

    private String storeFile() {
        return this.file("testStore.db");
    }

    private String storeIdFile() {
        return this.file("testStore.db.id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateStore() throws IOException {
        try {
            try {
                Store.createStore(null);
                Assert.fail((String)"Null fileName should throw exception");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            Store store = Store.createStore(this.storeFile());
            try {
                Store.createStore(this.storeFile());
                Assert.fail((String)"Creating existing store should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    private void deleteBothFiles() {
        File file = new File(this.storeFile());
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.storeIdFile())).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStickyStore() throws IOException {
        try {
            Store.createStore(this.storeFile()).close();
            FileChannel fileChannel = new RandomAccessFile(this.storeFile(), "rw").getChannel();
            fileChannel.truncate(fileChannel.size() - 2L);
            fileChannel.close();
            Store store = new Store(this.storeFile());
            store.makeStoreOk();
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClose() throws IOException {
        try {
            Store store = Store.createStore(this.storeFile());
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    private static class Store
    extends AbstractStore {
        private static final String VERSION = "TestVersion v0.1";
        private static final int RECORD_SIZE = 1;

        public Store(String fileName) throws IOException {
            super(fileName, MapUtil.genericMap((Object[])new Object[]{IdGeneratorFactory.class, ID_GENERATOR_FACTORY, "store_dir", "target/var/teststore"}), null);
        }

        protected void initStorage() {
        }

        public int getRecordSize() {
            return 1;
        }

        public String getTypeAndVersionDescriptor() {
            return VERSION;
        }

        public static Store createStore(String fileName) throws IOException {
            Store.createEmptyStore((String)fileName, (String)VERSION, (IdGeneratorFactory)ID_GENERATOR_FACTORY);
            return new Store(fileName);
        }

        protected void rebuildIdGenerator() {
        }

        public List<WindowPoolStats> getAllWindowPoolStats() {
            return null;
        }
    }
}

