/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipChainPosition;
import org.neo4j.kernel.impl.nioneo.store.RelationshipData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.nioneo.xa.NodeEventConsumer;
import org.neo4j.kernel.impl.nioneo.xa.RelationshipEventConsumer;
import org.neo4j.kernel.impl.nioneo.xa.RelationshipTypeEventConsumer;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.util.ArrayMap;

public class TestNeoStore
extends AbstractNeo4jTestCase {
    private static final IdGeneratorFactory ID_GENERATOR_FACTORY = CommonFactories.defaultIdGeneratorFactory();
    private NodeEventConsumer nStore;
    private PropertyStore pStore;
    private RelationshipTypeEventConsumer relTypeStore;
    private RelationshipEventConsumer rStore;
    private NeoStoreXaDataSource ds;
    private NeoStoreXaConnection xaCon;
    private Xid dummyXid;
    private byte txCount = 0;
    XAResource xaResource;

    @Override
    protected boolean restartGraphDbBetweenTests() {
        return true;
    }

    private String path() {
        String path = AbstractNeo4jTestCase.getStorePath("test-neostore");
        new File(path).mkdirs();
        return path;
    }

    private String file(String name) {
        return this.path() + File.separator + name;
    }

    @Before
    public void setUpNeoStore() throws Exception {
        NeoStore.createStore((String)this.file("neo"), (Map)MapUtil.map((Object[])new Object[]{IdGeneratorFactory.class, ID_GENERATOR_FACTORY}));
    }

    private PropertyIndex createDummyIndex(int id, String key) {
        MyPropertyIndex index = new MyPropertyIndex(key, id);
        MyPropertyIndex.add(index);
        return index;
    }

    private void initializeStores() throws IOException {
        try {
            LockManager lockManager = this.getEmbeddedGraphDb().getConfig().getLockManager();
            LockReleaser lockReleaser = this.getEmbeddedGraphDb().getConfig().getLockReleaser();
            this.ds = new NeoStoreXaDataSource(MapUtil.genericMap((Object[])new Object[]{LockManager.class, lockManager, LockReleaser.class, lockReleaser, IdGeneratorFactory.class, ID_GENERATOR_FACTORY, TxIdGenerator.class, TxIdGenerator.DEFAULT, "store_dir", this.path(), "neo_store", this.file("neo"), "logical_log", this.file("nioneo_logical.log")}));
        }
        catch (InstantiationException e) {
            throw new IOException("" + e);
        }
        this.xaCon = (NeoStoreXaConnection)this.ds.getXaConnection();
        this.nStore = this.xaCon.getNodeConsumer();
        this.pStore = this.xaCon.getPropertyStore();
        this.relTypeStore = this.xaCon.getRelationshipTypeConsumer();
        this.rStore = this.xaCon.getRelationshipConsumer();
    }

    private void startTx() throws XAException {
        this.dummyXid = new XidImpl(new byte[this.txCount], new byte[this.txCount]);
        this.txCount = (byte)(this.txCount + 1);
        this.xaResource = this.xaCon.getXaResource();
        this.xaResource.start(this.dummyXid, 0);
    }

    private void commitTx() throws XAException {
        this.xaResource.end(this.dummyXid, 0x4000000);
        this.xaResource.commit(this.dummyXid, true);
    }

    @After
    public void tearDownNeoStore() {
        File file = new File(this.file("neo"));
        file.delete();
        file = new File(this.file("neo.id"));
        file.delete();
        file = new File(this.file("neo.nodestore.db"));
        file.delete();
        file = new File(this.file("neo.nodestore.db.id"));
        file.delete();
        file = new File(this.file("neo.propertystore.db"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.id"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.index"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.index.id"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.index.keys"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.index.keys.id"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.strings"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.strings.id"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.arrays"));
        file.delete();
        file = new File(this.file("neo.propertystore.db.arrays.id"));
        file.delete();
        file = new File(this.file("neo.relationshipstore.db"));
        file.delete();
        file = new File(this.file("neo.relationshipstore.db.id"));
        file.delete();
        file = new File(this.file("neo.relationshiptypestore.db"));
        file.delete();
        file = new File(this.file("neo.relationshiptypestore.db.id"));
        file.delete();
        file = new File(this.file("neo.relationshiptypestore.db.names"));
        file.delete();
        file = new File(this.file("neo.relationshiptypestore.db.names.id"));
        file.delete();
        file = new File(".");
        for (File nioFile : file.listFiles()) {
            if (!nioFile.getName().startsWith("nioneo_logical.log")) continue;
            nioFile.delete();
        }
    }

    private PropertyIndex index(String key) {
        Iterator<PropertyIndex> itr = MyPropertyIndex.index(key).iterator();
        if (!itr.hasNext()) {
            int id = this.ds.nextId(PropertyIndex.class);
            PropertyIndex index = this.createDummyIndex(id, key);
            this.xaCon.getPropertyIndexConsumer().createPropertyIndex(id, key);
            return index;
        }
        return itr.next();
    }

    @Test
    public void testCreateNeoStore() throws Exception {
        int i;
        this.initializeStores();
        this.startTx();
        int node1 = this.ds.nextId(Node.class);
        this.nStore.createNode(node1);
        int node2 = this.ds.nextId(Node.class);
        this.nStore.createNode(node2);
        int n1prop1 = this.pStore.nextId();
        int n1prop2 = this.pStore.nextId();
        int n1prop3 = this.pStore.nextId();
        this.nStore.addProperty(node1, n1prop1, this.index("prop1"), (Object)"string1");
        this.nStore.addProperty(node1, n1prop2, this.index("prop2"), (Object)new Integer(1));
        this.nStore.addProperty(node1, n1prop3, this.index("prop3"), (Object)new Boolean(true));
        int n2prop1 = this.pStore.nextId();
        int n2prop2 = this.pStore.nextId();
        int n2prop3 = this.pStore.nextId();
        this.nStore.addProperty(node2, n2prop1, this.index("prop1"), (Object)"string2");
        this.nStore.addProperty(node2, n2prop2, this.index("prop2"), (Object)new Integer(2));
        this.nStore.addProperty(node2, n2prop3, this.index("prop3"), (Object)new Boolean(false));
        int relType1 = this.ds.nextId(RelationshipType.class);
        this.relTypeStore.addRelationshipType(relType1, "relationshiptype1");
        int relType2 = this.ds.nextId(RelationshipType.class);
        this.relTypeStore.addRelationshipType(relType2, "relationshiptype2");
        int rel1 = this.ds.nextId(Relationship.class);
        this.rStore.createRelationship(rel1, node1, node2, relType1);
        int rel2 = this.ds.nextId(Relationship.class);
        this.rStore.createRelationship(rel2, node2, node1, relType2);
        int r1prop1 = this.pStore.nextId();
        int r1prop2 = this.pStore.nextId();
        int r1prop3 = this.pStore.nextId();
        this.rStore.addProperty(rel1, r1prop1, this.index("prop1"), (Object)"string1");
        this.rStore.addProperty(rel1, r1prop2, this.index("prop2"), (Object)new Integer(1));
        this.rStore.addProperty(rel1, r1prop3, this.index("prop3"), (Object)new Boolean(true));
        int r2prop1 = this.pStore.nextId();
        int r2prop2 = this.pStore.nextId();
        int r2prop3 = this.pStore.nextId();
        this.rStore.addProperty(rel2, r2prop1, this.index("prop1"), (Object)"string2");
        this.rStore.addProperty(rel2, r2prop2, this.index("prop2"), (Object)new Integer(2));
        this.rStore.addProperty(rel2, r2prop3, this.index("prop3"), (Object)new Boolean(false));
        this.commitTx();
        this.ds.close();
        this.initializeStores();
        this.startTx();
        this.validateNodeRel1(node1, n1prop1, n1prop2, n1prop3, rel1, rel2, relType1, relType2);
        this.validateNodeRel2(node2, n2prop1, n2prop2, n2prop3, rel1, rel2, relType1, relType2);
        this.validateRel1(rel1, r1prop1, r1prop2, r1prop3, node1, node2, relType1);
        this.validateRel2(rel2, r2prop1, r2prop2, r2prop3, node2, node1, relType2);
        this.validateRelTypes(relType1, relType2);
        this.validateRelTypes(relType1, relType2);
        this.commitTx();
        this.ds.close();
        this.initializeStores();
        this.startTx();
        this.deleteRel1(rel1, r1prop1, r1prop2, r1prop3, node1, node2, relType1);
        this.deleteRel2(rel2, r2prop1, r2prop2, r2prop3, node2, node1, relType2);
        this.deleteNode1(node1, n1prop1, n1prop2, n1prop3);
        this.deleteNode2(node2, n2prop1, n2prop2, n2prop3);
        this.commitTx();
        this.ds.close();
        this.initializeStores();
        this.startTx();
        Assert.assertEquals((Object)false, (Object)this.nStore.loadLightNode(node1));
        Assert.assertEquals((Object)false, (Object)this.nStore.loadLightNode(node2));
        this.testGetRels(new int[]{rel1, rel2});
        int[] nodeIds = new int[10];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.ds.nextId(Node.class);
            this.nStore.createNode(nodeIds[i]);
            this.nStore.addProperty(nodeIds[i], this.pStore.nextId(), this.index("nisse"), (Object)new Integer(10 - i));
        }
        for (i = 0; i < 2; ++i) {
            int id = this.ds.nextId(Relationship.class);
            this.rStore.createRelationship(id, nodeIds[i], nodeIds[i + 1], relType1);
            this.rStore.deleteRelationship(id);
        }
        for (i = 0; i < 3; ++i) {
            RelationshipChainPosition pos = this.rStore.getRelationshipChainPosition(nodeIds[i]);
            for (RelationshipData rel : this.rStore.getMoreRelationships(nodeIds[i], pos)) {
                this.rStore.deleteRelationship(rel.getId());
            }
            this.nStore.deleteNode(nodeIds[i]);
        }
        this.commitTx();
        this.ds.close();
    }

    private Object getValue(PropertyRecord propertyRecord) throws IOException {
        try {
            return propertyRecord.getType().getValue(propertyRecord, this.pStore);
        }
        catch (InvalidRecordException ex) {
            throw new IOException(ex);
        }
    }

    private void validateNodeRel1(int node, int prop1, int prop2, int prop3, int rel1, int rel2, int relType1, int relType2) throws IOException {
        Iterable relData;
        Assert.assertTrue((boolean)this.nStore.loadLightNode(node));
        ArrayMap props = this.nStore.getProperties(node, false);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            PropertyRecord record;
            int keyId = (Integer)i$.next();
            int id = ((PropertyData)props.get((Object)keyId)).getId();
            PropertyData data = new PropertyData(id, this.getValue(record = this.pStore.getRecord(id)));
            if (data.getId() == prop1) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)"string1", (Object)data.getValue());
                this.nStore.changeProperty(node, prop1, (Object)"-string1");
            } else if (data.getId() == prop2) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Integer(1), (Object)data.getValue());
                this.nStore.changeProperty(node, prop2, (Object)new Integer(-1));
            } else if (data.getId() == prop3) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Boolean(true), (Object)data.getValue());
                this.nStore.changeProperty(node, prop3, (Object)new Boolean(false));
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        count = 0;
        RelationshipChainPosition pos = this.rStore.getRelationshipChainPosition(node);
        while ((relData = this.rStore.getMoreRelationships(node, pos)).iterator().hasNext()) {
            for (RelationshipData rel : relData) {
                if (rel.getId() == rel1) {
                    Assert.assertEquals((long)node, (long)rel.firstNode());
                    Assert.assertEquals((long)relType1, (long)rel.relationshipType());
                } else if (rel.getId() == rel2) {
                    Assert.assertEquals((long)node, (long)rel.secondNode());
                    Assert.assertEquals((long)relType2, (long)rel.relationshipType());
                } else {
                    throw new IOException();
                }
                ++count;
            }
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    private void validateNodeRel2(int node, int prop1, int prop2, int prop3, int rel1, int rel2, int relType1, int relType2) throws IOException {
        Iterable relData;
        Assert.assertTrue((boolean)this.nStore.loadLightNode(node));
        ArrayMap props = this.nStore.getProperties(node, false);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            PropertyRecord record;
            int keyId = (Integer)i$.next();
            int id = ((PropertyData)props.get((Object)keyId)).getId();
            PropertyData data = new PropertyData(id, this.getValue(record = this.pStore.getRecord(id)));
            if (data.getId() == prop1) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)"string2", (Object)data.getValue());
                this.nStore.changeProperty(node, prop1, (Object)"-string2");
            } else if (data.getId() == prop2) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Integer(2), (Object)data.getValue());
                this.nStore.changeProperty(node, prop2, (Object)new Integer(-2));
            } else if (data.getId() == prop3) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Boolean(false), (Object)data.getValue());
                this.nStore.changeProperty(node, prop3, (Object)new Boolean(true));
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        count = 0;
        RelationshipChainPosition pos = this.rStore.getRelationshipChainPosition(node);
        while ((relData = this.rStore.getMoreRelationships(node, pos)).iterator().hasNext()) {
            for (RelationshipData rel : relData) {
                if (rel.getId() == rel1) {
                    Assert.assertEquals((long)node, (long)rel.secondNode());
                    Assert.assertEquals((long)relType1, (long)rel.relationshipType());
                } else if (rel.getId() == rel2) {
                    Assert.assertEquals((long)node, (long)rel.firstNode());
                    Assert.assertEquals((long)relType2, (long)rel.relationshipType());
                } else {
                    throw new IOException();
                }
                ++count;
            }
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    private void validateRel1(int rel, int prop1, int prop2, int prop3, int firstNode, int secondNode, int relType) throws IOException {
        ArrayMap props = this.rStore.getProperties(rel, false);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            PropertyRecord record;
            int keyId = (Integer)i$.next();
            int id = ((PropertyData)props.get((Object)keyId)).getId();
            PropertyData data = new PropertyData(id, this.getValue(record = this.pStore.getRecord(id)));
            if (data.getId() == prop1) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)"string1", (Object)data.getValue());
                this.rStore.changeProperty(rel, prop1, (Object)"-string1");
            } else if (data.getId() == prop2) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Integer(1), (Object)data.getValue());
                this.rStore.changeProperty(rel, prop2, (Object)new Integer(-1));
            } else if (data.getId() == prop3) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Boolean(true), (Object)data.getValue());
                this.rStore.changeProperty(rel, prop3, (Object)new Boolean(false));
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        RelationshipData relData = this.rStore.getRelationship(rel);
        Assert.assertEquals((long)firstNode, (long)relData.firstNode());
        Assert.assertEquals((long)secondNode, (long)relData.secondNode());
        Assert.assertEquals((long)relType, (long)relData.relationshipType());
    }

    private void validateRel2(int rel, int prop1, int prop2, int prop3, int firstNode, int secondNode, int relType) throws IOException {
        ArrayMap props = this.rStore.getProperties(rel, false);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            PropertyRecord record;
            int keyId = (Integer)i$.next();
            int id = ((PropertyData)props.get((Object)keyId)).getId();
            PropertyData data = new PropertyData(id, this.getValue(record = this.pStore.getRecord(id)));
            if (data.getId() == prop1) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)"string2", (Object)data.getValue());
                this.rStore.changeProperty(rel, prop1, (Object)"-string2");
            } else if (data.getId() == prop2) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Integer(2), (Object)data.getValue());
                this.rStore.changeProperty(rel, prop2, (Object)new Integer(-2));
            } else if (data.getId() == prop3) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Boolean(false), (Object)data.getValue());
                this.rStore.changeProperty(rel, prop3, (Object)new Boolean(true));
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        RelationshipData relData = this.rStore.getRelationship(rel);
        Assert.assertEquals((long)firstNode, (long)relData.firstNode());
        Assert.assertEquals((long)secondNode, (long)relData.secondNode());
        Assert.assertEquals((long)relType, (long)relData.relationshipType());
    }

    private void validateRelTypes(int relType1, int relType2) throws IOException {
        RelationshipTypeData data = this.relTypeStore.getRelationshipType(relType1);
        Assert.assertEquals((long)relType1, (long)data.getId());
        Assert.assertEquals((Object)"relationshiptype1", (Object)data.getName());
        data = this.relTypeStore.getRelationshipType(relType2);
        Assert.assertEquals((long)relType2, (long)data.getId());
        Assert.assertEquals((Object)"relationshiptype2", (Object)data.getName());
        RelationshipTypeData[] allData = this.relTypeStore.getRelationshipTypes();
        Assert.assertEquals((long)2L, (long)allData.length);
        for (int i = 0; i < 2; ++i) {
            if (allData[i].getId() == relType1) {
                Assert.assertEquals((long)relType1, (long)allData[i].getId());
                Assert.assertEquals((Object)"relationshiptype1", (Object)allData[i].getName());
                continue;
            }
            if (allData[i].getId() == relType2) {
                Assert.assertEquals((long)relType2, (long)allData[i].getId());
                Assert.assertEquals((Object)"relationshiptype2", (Object)allData[i].getName());
                continue;
            }
            throw new IOException();
        }
    }

    private void deleteRel1(int rel, int prop1, int prop2, int prop3, int firstNode, int secondNode, int relType) throws IOException {
        ArrayMap props = this.rStore.getProperties(rel, false);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            PropertyRecord record;
            int keyId = (Integer)i$.next();
            int id = ((PropertyData)props.get((Object)keyId)).getId();
            PropertyData data = new PropertyData(id, this.getValue(record = this.pStore.getRecord(id)));
            if (data.getId() == prop1) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)"-string1", (Object)data.getValue());
            } else if (data.getId() == prop2) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Integer(-1), (Object)data.getValue());
            } else if (data.getId() == prop3) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Boolean(false), (Object)data.getValue());
                this.rStore.removeProperty(rel, prop3);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        Assert.assertEquals((long)3L, (long)this.rStore.getProperties(rel, false).size());
        RelationshipData relData = this.rStore.getRelationship(rel);
        Assert.assertEquals((long)firstNode, (long)relData.firstNode());
        Assert.assertEquals((long)secondNode, (long)relData.secondNode());
        Assert.assertEquals((long)relType, (long)relData.relationshipType());
        this.rStore.deleteRelationship(rel);
        RelationshipChainPosition firstPos = this.rStore.getRelationshipChainPosition(firstNode);
        Iterator first = this.rStore.getMoreRelationships(firstNode, firstPos).iterator();
        first.next();
        RelationshipChainPosition secondPos = this.rStore.getRelationshipChainPosition(secondNode);
        Iterator second = this.rStore.getMoreRelationships(secondNode, secondPos).iterator();
        second.next();
        Assert.assertTrue((boolean)first.hasNext());
        Assert.assertTrue((boolean)second.hasNext());
    }

    private void deleteRel2(int rel, int prop1, int prop2, int prop3, int firstNode, int secondNode, int relType) throws IOException {
        ArrayMap props = this.rStore.getProperties(rel, false);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            PropertyRecord record;
            int keyId = (Integer)i$.next();
            int id = ((PropertyData)props.get((Object)keyId)).getId();
            PropertyData data = new PropertyData(id, this.getValue(record = this.pStore.getRecord(id)));
            if (data.getId() == prop1) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)"-string2", (Object)data.getValue());
            } else if (data.getId() == prop2) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Integer(-2), (Object)data.getValue());
            } else if (data.getId() == prop3) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Boolean(true), (Object)data.getValue());
                this.rStore.removeProperty(rel, prop3);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        Assert.assertEquals((long)3L, (long)this.rStore.getProperties(rel, false).size());
        RelationshipData relData = this.rStore.getRelationship(rel);
        Assert.assertEquals((long)firstNode, (long)relData.firstNode());
        Assert.assertEquals((long)secondNode, (long)relData.secondNode());
        Assert.assertEquals((long)relType, (long)relData.relationshipType());
        this.rStore.deleteRelationship(rel);
        RelationshipChainPosition firstPos = this.rStore.getRelationshipChainPosition(firstNode);
        Iterator first = this.rStore.getMoreRelationships(firstNode, firstPos).iterator();
        RelationshipChainPosition secondPos = this.rStore.getRelationshipChainPosition(secondNode);
        Iterator second = this.rStore.getMoreRelationships(secondNode, secondPos).iterator();
        Assert.assertTrue((boolean)first.hasNext());
        Assert.assertTrue((boolean)second.hasNext());
    }

    private void deleteNode1(int node, int prop1, int prop2, int prop3) throws IOException {
        ArrayMap props = this.nStore.getProperties(node, false);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            PropertyRecord record;
            int keyId = (Integer)i$.next();
            int id = ((PropertyData)props.get((Object)keyId)).getId();
            PropertyData data = new PropertyData(id, this.getValue(record = this.pStore.getRecord(id)));
            if (data.getId() == prop1) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)"-string1", (Object)data.getValue());
            } else if (data.getId() == prop2) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Integer(-1), (Object)data.getValue());
            } else if (data.getId() == prop3) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Boolean(false), (Object)data.getValue());
                this.nStore.removeProperty(node, prop3);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        Assert.assertEquals((long)3L, (long)this.nStore.getProperties(node, false).size());
        RelationshipChainPosition pos = this.rStore.getRelationshipChainPosition(node);
        Iterator rels = this.rStore.getMoreRelationships(node, pos).iterator();
        Assert.assertTrue((boolean)rels.hasNext());
        this.nStore.deleteNode(node);
    }

    private void deleteNode2(int node, int prop1, int prop2, int prop3) throws IOException {
        ArrayMap props = this.nStore.getProperties(node, false);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            PropertyRecord record;
            int keyId = (Integer)i$.next();
            int id = ((PropertyData)props.get((Object)keyId)).getId();
            PropertyData data = new PropertyData(id, this.getValue(record = this.pStore.getRecord(id)));
            if (data.getId() == prop1) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)"-string2", (Object)data.getValue());
            } else if (data.getId() == prop2) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Integer(-2), (Object)data.getValue());
            } else if (data.getId() == prop3) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyIndex.getIndexFor(keyId).getKey());
                Assert.assertEquals((Object)new Boolean(true), (Object)data.getValue());
                this.nStore.removeProperty(node, prop3);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        Assert.assertEquals((long)3L, (long)this.nStore.getProperties(node, false).size());
        RelationshipChainPosition pos = this.rStore.getRelationshipChainPosition(node);
        Iterator rels = this.rStore.getMoreRelationships(node, pos).iterator();
        Assert.assertTrue((boolean)rels.hasNext());
        this.nStore.deleteNode(node);
    }

    private void testGetRels(int[] relIds) {
        for (int i = 0; i < relIds.length; ++i) {
            Assert.assertEquals(null, (Object)this.rStore.getRelationship(relIds[i]));
        }
    }

    @Test
    public void testRels1() throws Exception {
        int i;
        this.initializeStores();
        this.startTx();
        int relType1 = this.ds.nextId(RelationshipType.class);
        this.relTypeStore.addRelationshipType(relType1, "relationshiptype1");
        int[] nodeIds = new int[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.ds.nextId(Node.class);
            this.nStore.createNode(nodeIds[i]);
            this.nStore.addProperty(nodeIds[i], this.pStore.nextId(), this.index("nisse"), (Object)new Integer(10 - i));
        }
        for (i = 0; i < 2; ++i) {
            this.rStore.createRelationship(this.ds.nextId(Relationship.class), nodeIds[i], nodeIds[i + 1], relType1);
        }
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; i += 2) {
            RelationshipChainPosition pos = this.rStore.getRelationshipChainPosition(nodeIds[i]);
            for (RelationshipData rel : this.rStore.getMoreRelationships(nodeIds[i], pos)) {
                this.rStore.deleteRelationship(rel.getId());
            }
            this.nStore.deleteNode(nodeIds[i]);
        }
        this.commitTx();
        this.ds.close();
    }

    public void testRels2() throws Exception {
        int i;
        this.initializeStores();
        this.startTx();
        int relType1 = this.ds.nextId(RelationshipType.class);
        this.relTypeStore.addRelationshipType(relType1, "relationshiptype1");
        int[] nodeIds = new int[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.ds.nextId(Node.class);
            this.nStore.createNode(nodeIds[i]);
            this.nStore.addProperty(nodeIds[i], this.pStore.nextId(), this.index("nisse"), (Object)new Integer(10 - i));
        }
        for (i = 0; i < 2; ++i) {
            this.rStore.createRelationship(this.ds.nextId(Relationship.class), nodeIds[i], nodeIds[i + 1], relType1);
        }
        this.rStore.createRelationship(this.ds.nextId(Relationship.class), nodeIds[0], nodeIds[2], relType1);
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; ++i) {
            RelationshipChainPosition pos = this.rStore.getRelationshipChainPosition(nodeIds[i]);
            for (RelationshipData rel : this.rStore.getMoreRelationships(nodeIds[i], pos)) {
                this.rStore.deleteRelationship(rel.getId());
            }
            this.nStore.deleteNode(nodeIds[i]);
        }
        this.commitTx();
        this.ds.close();
    }

    public void testRels3() throws Exception {
        int i;
        this.initializeStores();
        this.startTx();
        int relType1 = this.ds.nextId(RelationshipType.class);
        this.relTypeStore.addRelationshipType(relType1, "relationshiptype1");
        int[] nodeIds = new int[8];
        for (i = 0; i < nodeIds.length; ++i) {
            nodeIds[i] = this.ds.nextId(Node.class);
            this.nStore.createNode(nodeIds[i]);
        }
        for (i = 0; i < nodeIds.length / 2; ++i) {
            this.rStore.createRelationship(this.ds.nextId(Relationship.class), nodeIds[i], nodeIds[i * 2], relType1);
        }
        int rel5 = this.ds.nextId(Relationship.class);
        this.rStore.createRelationship(rel5, nodeIds[0], nodeIds[5], relType1);
        int rel2 = this.ds.nextId(Relationship.class);
        this.rStore.createRelationship(rel2, nodeIds[1], nodeIds[2], relType1);
        int rel3 = this.ds.nextId(Relationship.class);
        this.rStore.createRelationship(rel3, nodeIds[1], nodeIds[3], relType1);
        int rel6 = this.ds.nextId(Relationship.class);
        this.rStore.createRelationship(rel6, nodeIds[1], nodeIds[6], relType1);
        int rel1 = this.ds.nextId(Relationship.class);
        this.rStore.createRelationship(rel1, nodeIds[0], nodeIds[1], relType1);
        int rel4 = this.ds.nextId(Relationship.class);
        this.rStore.createRelationship(rel4, nodeIds[0], nodeIds[4], relType1);
        int rel7 = this.ds.nextId(Relationship.class);
        this.rStore.createRelationship(rel7, nodeIds[0], nodeIds[7], relType1);
        this.commitTx();
        this.startTx();
        this.rStore.deleteRelationship(rel7);
        this.rStore.deleteRelationship(rel4);
        this.rStore.deleteRelationship(rel1);
        this.rStore.deleteRelationship(rel6);
        this.rStore.deleteRelationship(rel3);
        this.rStore.deleteRelationship(rel2);
        this.rStore.deleteRelationship(rel5);
        this.commitTx();
        this.ds.close();
    }

    public void testProps1() throws Exception {
        this.initializeStores();
        this.startTx();
        int nodeId = this.ds.nextId(Node.class);
        this.nStore.createNode(nodeId);
        int propertyId = this.pStore.nextId();
        this.nStore.addProperty(nodeId, propertyId, this.index("nisse"), (Object)new Integer(10));
        this.commitTx();
        this.ds.close();
        this.initializeStores();
        this.startTx();
        this.nStore.changeProperty(nodeId, propertyId, (Object)new Integer(5));
        this.nStore.removeProperty(nodeId, propertyId);
        this.nStore.deleteNode(nodeId);
        this.commitTx();
        this.ds.close();
    }

    @Test
    public void testSetBlockSize() throws Exception {
        this.tearDownNeoStore();
        HashMap<Object, String> config = new HashMap<Object, String>();
        config.put("string_block_size", "62");
        config.put("array_block_size", "302");
        config.put(IdGeneratorFactory.class, (String)CommonFactories.defaultIdGeneratorFactory());
        NeoStore.createStore((String)this.file("neo"), config);
        this.initializeStores();
        Assert.assertEquals((long)75L, (long)this.pStore.getStringBlockSize());
        Assert.assertEquals((long)315L, (long)this.pStore.getArrayBlockSize());
        this.ds.close();
    }

    private static class MyPropertyIndex
    extends PropertyIndex {
        private static Map<String, PropertyIndex> stringToIndex = new HashMap<String, PropertyIndex>();
        private static Map<Integer, PropertyIndex> intToIndex = new HashMap<Integer, PropertyIndex>();

        protected MyPropertyIndex(String key, int keyId) {
            super(key, keyId);
        }

        public static Iterable<PropertyIndex> index(String key) {
            if (stringToIndex.containsKey(key)) {
                return Arrays.asList(stringToIndex.get(key));
            }
            return Collections.emptyList();
        }

        public static PropertyIndex getIndexFor(int index) {
            return intToIndex.get(index);
        }

        public static void add(MyPropertyIndex index) {
            stringToIndex.put(index.getKey(), index);
            intToIndex.put(index.getKeyId(), index);
        }
    }
}

