/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.nioneo.store.IdGeneratorImpl;
import org.neo4j.kernel.impl.nioneo.store.StoreFailureException;

public class TestIdGenerator {
    private String path() {
        String path = AbstractNeo4jTestCase.getStorePath("xatest");
        new File(path).mkdirs();
        return path;
    }

    private String file(String name) {
        return this.path() + File.separator + name;
    }

    private String idGeneratorFile() {
        return this.file("testIdGenerator.id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateIdGenerator() throws IOException {
        try {
            IdGeneratorImpl.createGenerator(null);
            Assert.fail((String)"Null filename should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
            new IdGeneratorImpl(this.idGeneratorFile(), 0).close();
            Assert.fail((String)"Zero grab size should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new IdGeneratorImpl("testIdGenerator.id", -1).close();
            Assert.fail((String)"Negative grab size should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 1008);
            try {
                IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
                Assert.fail((String)"Creating a id generator with existing file name should throw exception");
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            idGenerator.close();
            FileChannel fileChannel = new FileInputStream(this.idGeneratorFile()).getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(9);
            Assert.assertEquals((long)9L, (long)fileChannel.read(buffer));
            buffer.flip();
            Assert.assertEquals((long)0L, (long)buffer.get());
            Assert.assertEquals((long)0L, (long)buffer.getLong());
            buffer.flip();
            int readCount = fileChannel.read(buffer);
            if (readCount != -1 && readCount != 0) {
                Assert.fail((String)("Id generator header not ok read 9 + " + readCount + " bytes from file"));
            }
            fileChannel.close();
        }
        finally {
            File file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStickyGenerator() {
        try {
            IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
            IdGeneratorImpl idGen = new IdGeneratorImpl(this.idGeneratorFile(), 3);
            try {
                new IdGeneratorImpl(this.idGeneratorFile(), 3);
                Assert.fail((String)"Opening sticky id generator should throw exception");
            }
            catch (StoreFailureException storeFailureException) {
                // empty catch block
            }
            idGen.close();
        }
        finally {
            File file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNextId() {
        try {
            IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
            IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 3);
            for (long i = 0L; i < 7L; ++i) {
                Assert.assertEquals((long)i, (long)idGenerator.nextId());
            }
            idGenerator.freeId(1L);
            idGenerator.freeId(3L);
            idGenerator.freeId(5L);
            Assert.assertEquals((long)7L, (long)idGenerator.nextId());
            idGenerator.freeId(6L);
            idGenerator.close();
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 5);
            idGenerator.freeId(2L);
            idGenerator.freeId(4L);
            Assert.assertEquals((long)1L, (long)idGenerator.nextId());
            idGenerator.freeId(1L);
            Assert.assertEquals((long)3L, (long)idGenerator.nextId());
            idGenerator.freeId(3L);
            Assert.assertEquals((long)5L, (long)idGenerator.nextId());
            idGenerator.freeId(5L);
            Assert.assertEquals((long)6L, (long)idGenerator.nextId());
            idGenerator.freeId(6L);
            Assert.assertEquals((long)8L, (long)idGenerator.nextId());
            idGenerator.freeId(8L);
            Assert.assertEquals((long)9L, (long)idGenerator.nextId());
            idGenerator.freeId(9L);
            idGenerator.close();
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 3);
            Assert.assertEquals((long)2L, (long)idGenerator.nextId());
            Assert.assertEquals((long)4L, (long)idGenerator.nextId());
            Assert.assertEquals((long)1L, (long)idGenerator.nextId());
            Assert.assertEquals((long)3L, (long)idGenerator.nextId());
            Assert.assertEquals((long)5L, (long)idGenerator.nextId());
            Assert.assertEquals((long)6L, (long)idGenerator.nextId());
            Assert.assertEquals((long)8L, (long)idGenerator.nextId());
            Assert.assertEquals((long)9L, (long)idGenerator.nextId());
            Assert.assertEquals((long)10L, (long)idGenerator.nextId());
            Assert.assertEquals((long)11L, (long)idGenerator.nextId());
            idGenerator.close();
        }
        finally {
            File file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFreeId() {
        try {
            IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
            IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 3);
            for (long i = 0L; i < 7L; ++i) {
                Assert.assertEquals((long)i, (long)idGenerator.nextId());
            }
            try {
                idGenerator.freeId(-1L);
                Assert.fail((String)"Negative id should throw exception");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                idGenerator.freeId(7L);
                Assert.fail((String)"Greater id than ever returned should throw exception");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            for (int i = 0; i < 7; ++i) {
                idGenerator.freeId((long)i);
            }
            idGenerator.close();
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 2);
            Assert.assertEquals((long)0L, (long)idGenerator.nextId());
            Assert.assertEquals((long)1L, (long)idGenerator.nextId());
            Assert.assertEquals((long)2L, (long)idGenerator.nextId());
            idGenerator.close();
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 2);
            Assert.assertEquals((long)4L, (long)idGenerator.nextId());
            Assert.assertEquals((long)5L, (long)idGenerator.nextId());
            Assert.assertEquals((long)6L, (long)idGenerator.nextId());
            Assert.assertEquals((long)3L, (long)idGenerator.nextId());
            idGenerator.close();
        }
        finally {
            File file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClose() {
        try {
            IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
            IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 2);
            idGenerator.close();
            try {
                idGenerator.nextId();
                Assert.fail((String)"nextId after close should throw exception");
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            try {
                idGenerator.freeId(0L);
                Assert.fail((String)"freeId after close should throw exception");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 2);
            Assert.assertEquals((long)0L, (long)idGenerator.nextId());
            Assert.assertEquals((long)1L, (long)idGenerator.nextId());
            Assert.assertEquals((long)2L, (long)idGenerator.nextId());
            idGenerator.close();
            try {
                idGenerator.nextId();
                Assert.fail((String)"nextId after close should throw exception");
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            try {
                idGenerator.freeId(0L);
                Assert.fail((String)"freeId after close should throw exception");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        finally {
            File file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOddAndEvenWorstCase() {
        File file;
        long i;
        IdGeneratorImpl idGenerator;
        int capacity = 8193;
        try {
            IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 128);
            for (int i2 = 0; i2 < capacity; ++i2) {
                idGenerator.nextId();
            }
            HashMap<Long, TestIdGenerator> freedIds = new HashMap<Long, TestIdGenerator>();
            for (i = 1L; i < (long)capacity; i += 2L) {
                idGenerator.freeId(i);
                freedIds.put(i, this);
            }
            idGenerator.close();
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 2000);
            long oldId = -1L;
            for (int i3 = 0; i3 < capacity - 1; i3 += 2) {
                long id = idGenerator.nextId();
                if (freedIds.remove(id) == null) {
                    throw new RuntimeException("Id=" + id + " prevId=" + oldId + " list.size()=" + freedIds.size());
                }
                oldId = id;
            }
            Assert.assertTrue((freedIds.values().size() == 0 ? 1 : 0) != 0);
            idGenerator.close();
        }
        finally {
            file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
        try {
            IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 128);
            for (int i4 = 0; i4 < capacity; ++i4) {
                idGenerator.nextId();
            }
            HashMap<Long, TestIdGenerator> freedIds = new HashMap<Long, TestIdGenerator>();
            for (i = 0L; i < (long)capacity; i += 2L) {
                idGenerator.freeId(i);
                freedIds.put(i, this);
            }
            idGenerator.close();
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 2000);
            for (int i5 = 0; i5 < capacity; i5 += 2) {
                Assert.assertEquals((Object)this, freedIds.remove(idGenerator.nextId()));
            }
            Assert.assertEquals((long)0L, (long)freedIds.values().size());
            idGenerator.close();
        }
        finally {
            file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomTest() {
        int numberOfCloses = 0;
        Random random = new Random(System.currentTimeMillis());
        int capacity = random.nextInt(1024) + 1024;
        int grabSize = random.nextInt(128) + 128;
        IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), grabSize);
        ArrayList<Long> idsTaken = new ArrayList<Long>();
        float releaseIndex = 0.25f;
        float closeIndex = 0.05f;
        int currentIdCount = 0;
        try {
            while (currentIdCount < capacity) {
                float rIndex = random.nextFloat();
                if (rIndex < releaseIndex && currentIdCount > 0) {
                    idGenerator.freeId((long)((Long)idsTaken.remove(random.nextInt(currentIdCount))).intValue());
                    --currentIdCount;
                } else {
                    idsTaken.add(idGenerator.nextId());
                    ++currentIdCount;
                }
                if (!(rIndex > 1.0f - closeIndex) && !(rIndex < closeIndex)) continue;
                idGenerator.close();
                grabSize = random.nextInt(128) + 128;
                idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), grabSize);
                ++numberOfCloses;
            }
            idGenerator.close();
        }
        finally {
            File file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnsignedId() {
        try {
            IdGeneratorImpl.createGenerator((String)this.idGeneratorFile());
            IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 1);
            idGenerator.setHighId(0xFFFFFFFDL);
            long id = idGenerator.nextId();
            Assert.assertEquals((long)0xFFFFFFFDL, (long)id);
            idGenerator.freeId(id);
            try {
                idGenerator.nextId();
            }
            catch (StoreFailureException e) {
                // empty catch block
            }
            idGenerator.close();
            idGenerator = new IdGeneratorImpl(this.idGeneratorFile(), 1);
            Assert.assertEquals((long)0xFFFFFFFEL, (long)idGenerator.getHighId());
            id = idGenerator.nextId();
            Assert.assertEquals((long)0xFFFFFFFDL, (long)id);
            try {
                idGenerator.nextId();
            }
            catch (StoreFailureException e) {
                // empty catch block
            }
            idGenerator.close();
        }
        finally {
            File file = new File(this.idGeneratorFile());
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }
}

