/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;

public class TestDynamicStore {
    public static IdGeneratorFactory ID_GENERATOR_FACTORY = CommonFactories.defaultIdGeneratorFactory();

    private String path() {
        String path = AbstractNeo4jTestCase.getStorePath("dynamicstore");
        new File(path).mkdirs();
        return path;
    }

    private String file(String name) {
        return this.path() + File.separator + name;
    }

    private String dynamicStoreFile() {
        return this.file("testDynamicStore.db");
    }

    private String dynamicStoreIdFile() {
        return this.file("testDynamicStore.db.id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateStore() {
        try {
            try {
                ByteStore.createStore(null, 1, this.path());
                Assert.fail((String)"Null fileName should throw exception");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                ByteStore.createStore(this.dynamicStoreFile(), 0, this.path());
                Assert.fail((String)"Illegal blocksize should throw exception");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            ByteStore store = ByteStore.createStore(this.dynamicStoreFile(), 30, this.path());
            try {
                ByteStore.createStore(this.dynamicStoreFile(), 15, this.path());
                Assert.fail((String)"Creating existing store should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    private void deleteBothFiles() {
        File file = new File(this.dynamicStoreFile());
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.dynamicStoreIdFile())).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStickyStore() throws IOException {
        Logger log = Logger.getLogger(CommonAbstractStore.class.getName());
        Level level = log.getLevel();
        try {
            log.setLevel(Level.OFF);
            ByteStore.createStore(this.dynamicStoreFile(), 30, this.path()).close();
            FileChannel fileChannel = new RandomAccessFile(this.dynamicStoreFile(), "rw").getChannel();
            fileChannel.truncate(fileChannel.size() - 2L);
            fileChannel.close();
            ByteStore store = new ByteStore(this.dynamicStoreFile(), ID_GENERATOR_FACTORY, this.path());
            store.makeStoreOk();
            store.close();
        }
        finally {
            log.setLevel(level);
            this.deleteBothFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClose() {
        try {
            ByteStore store = ByteStore.createStore(this.dynamicStoreFile(), 30, this.path());
            int blockId = store.nextBlockId();
            Collection records = store.allocateRecords(blockId, new byte[10]);
            for (DynamicRecord record : records) {
                store.updateRecord(record);
            }
            store.close();
            try {
                store.getBytes(0);
                Assert.fail((String)"Closed store should throw exception");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            try {
                store.getLightRecords(0);
                Assert.fail((String)"Closed store should throw exception");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        finally {
            this.deleteBothFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStoreGetCharsFromString() {
        try {
            String STR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            ByteStore store = ByteStore.createStore(this.dynamicStoreFile(), 30, this.path());
            int blockId = store.nextBlockId();
            char[] chars = new char["abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length()];
            "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getChars(0, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length(), chars, 0);
            Collection records = store.allocateRecords(blockId, chars);
            for (DynamicRecord record : records) {
                store.updateRecord(record);
            }
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomTest() {
        Random random = new Random(System.currentTimeMillis());
        ByteStore store = ByteStore.createStore(this.dynamicStoreFile(), 30, this.path());
        ArrayList<Integer> idsTaken = new ArrayList<Integer>();
        HashMap<Integer, byte[]> byteData = new HashMap<Integer, byte[]>();
        float deleteIndex = 0.2f;
        float closeIndex = 0.1f;
        int currentCount = 0;
        int maxCount = 128;
        HashSet<Integer> set = new HashSet<Integer>();
        try {
            while (currentCount < maxCount) {
                float rIndex = random.nextFloat();
                if (rIndex < deleteIndex && currentCount > 0) {
                    int blockId = (Integer)idsTaken.remove(random.nextInt(currentCount));
                    store.getLightRecords(blockId);
                    this.validateData(store.getBytes(blockId), (byte[])byteData.remove(new Integer(blockId)));
                    Collection records = store.getLightRecords(blockId);
                    for (DynamicRecord record : records) {
                        record.setInUse(false);
                        store.updateRecord(record);
                        set.remove(record.getId());
                    }
                    --currentCount;
                } else {
                    byte[] bytes = this.createRandomBytes(random);
                    int blockId = store.nextBlockId();
                    Collection records = store.allocateRecords(blockId, bytes);
                    for (DynamicRecord record : records) {
                        assert (!set.contains(record.getId()));
                        store.updateRecord(record);
                        set.add(record.getId());
                    }
                    idsTaken.add(new Integer(blockId));
                    byteData.put(new Integer(blockId), bytes);
                    ++currentCount;
                }
                if (!(rIndex > 1.0f - closeIndex) && !(rIndex < closeIndex)) continue;
                store.close();
                store = new ByteStore(this.dynamicStoreFile(), ID_GENERATOR_FACTORY, this.path());
            }
        }
        finally {
            store.close();
            this.deleteBothFiles();
        }
    }

    private byte[] createRandomBytes(Random r) {
        return new byte[r.nextInt(1024)];
    }

    private void validateData(byte[] data1, byte[] data2) {
        Assert.assertEquals((long)data1.length, (long)data2.length);
        for (int i = 0; i < data1.length; ++i) {
            Assert.assertEquals((long)data1[i], (long)data2[i]);
        }
    }

    private static class ByteStore
    extends AbstractDynamicStore {
        private static final String VERSION = "DynamicTestVersion v0.1";

        public ByteStore(String fileName, IdGeneratorFactory idGenerator, String storeDir) {
            super(fileName, MapUtil.map((Object[])new Object[]{"neo_store", fileName, IdGeneratorFactory.class, idGenerator, "store_dir", storeDir}), IdType.ARRAY_BLOCK);
        }

        public String getTypeAndVersionDescriptor() {
            return VERSION;
        }

        public static ByteStore createStore(String fileName, int blockSize, String storeDir) {
            ByteStore.createEmptyStore((String)fileName, (int)blockSize, (String)VERSION, (IdGeneratorFactory)ID_GENERATOR_FACTORY, (IdType)IdType.ARRAY_BLOCK);
            return new ByteStore(fileName, ID_GENERATOR_FACTORY, storeDir);
        }

        public byte[] getBytes(int blockId) {
            return this.get(blockId);
        }
    }
}

