/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.event.ExpectedTransactionData;
import org.neo4j.kernel.impl.event.VerifyingTransactionEventHandler;

public class TestTransactionEvents
extends AbstractNeo4jTestCase {
    @Test
    public void testRegisterUnregisterHandlers() {
        this.commit();
        Integer value1 = 10;
        Double value2 = 3.5;
        DummyTransactionEventHandler<Integer> handler1 = new DummyTransactionEventHandler<Integer>(value1);
        DummyTransactionEventHandler<Double> handler2 = new DummyTransactionEventHandler<Double>(value2);
        try {
            this.getGraphDb().unregisterTransactionEventHandler(handler1);
            Assert.fail((String)"Shouldn't be able to do unregister on a unregistered handler");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Assert.assertTrue((handler1 == this.getGraphDb().registerTransactionEventHandler(handler1) ? 1 : 0) != 0);
        Assert.assertTrue((handler1 == this.getGraphDb().registerTransactionEventHandler(handler1) ? 1 : 0) != 0);
        Assert.assertTrue((handler1 == this.getGraphDb().unregisterTransactionEventHandler(handler1) ? 1 : 0) != 0);
        try {
            this.getGraphDb().unregisterTransactionEventHandler(handler1);
            Assert.fail((String)"Shouldn't be able to do unregister on a unregistered handler");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Assert.assertTrue((handler1 == this.getGraphDb().registerTransactionEventHandler(handler1) ? 1 : 0) != 0);
        Assert.assertTrue((handler2 == this.getGraphDb().registerTransactionEventHandler(handler2) ? 1 : 0) != 0);
        Assert.assertTrue((handler1 == this.getGraphDb().unregisterTransactionEventHandler(handler1) ? 1 : 0) != 0);
        Assert.assertTrue((handler2 == this.getGraphDb().unregisterTransactionEventHandler(handler2) ? 1 : 0) != 0);
        this.getGraphDb().registerTransactionEventHandler(handler1);
        this.newTransaction();
        this.getGraphDb().createNode().delete();
        this.commit();
        Assert.assertNotNull((Object)((DummyTransactionEventHandler)handler1).beforeCommit);
        Assert.assertNotNull((Object)((DummyTransactionEventHandler)handler1).afterCommit);
        Assert.assertNull((Object)((DummyTransactionEventHandler)handler1).afterRollback);
        Assert.assertEquals((Object)value1, (Object)((DummyTransactionEventHandler)handler1).receivedState);
        Assert.assertNotNull((Object)((DummyTransactionEventHandler)handler1).receivedTransactionData);
        this.getGraphDb().unregisterTransactionEventHandler(handler1);
    }

    @Test
    public void makeSureHandlersCantBeRegisteredTwice() {
        this.commit();
        DummyTransactionEventHandler<Object> handler = new DummyTransactionEventHandler<Object>(null);
        this.getGraphDb().registerTransactionEventHandler(handler);
        this.getGraphDb().registerTransactionEventHandler(handler);
        this.newTransaction();
        this.getGraphDb().createNode().delete();
        this.commit();
        Assert.assertEquals((Object)0, (Object)((DummyTransactionEventHandler)handler).beforeCommit);
        Assert.assertEquals((Object)1, (Object)((DummyTransactionEventHandler)handler).afterCommit);
        Assert.assertNull((Object)((DummyTransactionEventHandler)handler).afterRollback);
        this.getGraphDb().unregisterTransactionEventHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldGetCorrectTransactionDataUponCommit() {
        this.makeSureRelationshipTypeIsCreated(RelTypes.TXEVENT);
        ExpectedTransactionData expectedData = new ExpectedTransactionData();
        VerifyingTransactionEventHandler handler = new VerifyingTransactionEventHandler(expectedData);
        this.getGraphDb().registerTransactionEventHandler((TransactionEventHandler)handler);
        this.newTransaction();
        Node node1 = null;
        Node node2 = null;
        Node node3 = null;
        Relationship rel1 = null;
        Relationship rel2 = null;
        try {
            node1 = this.getGraphDb().createNode();
            expectedData.expectedCreatedNodes.add(node1);
            node2 = this.getGraphDb().createNode();
            expectedData.expectedCreatedNodes.add(node2);
            rel1 = node1.createRelationshipTo(node2, (RelationshipType)RelTypes.TXEVENT);
            expectedData.expectedCreatedRelationships.add(rel1);
            node1.setProperty("name", (Object)"Mattias");
            expectedData.assignedProperty(node1, "name", (Object)"Mattias", null);
            node1.setProperty("last name", (Object)"Persson");
            expectedData.assignedProperty(node1, "last name", (Object)"Persson", null);
            node1.setProperty("counter", (Object)10);
            expectedData.assignedProperty(node1, "counter", (Object)10, null);
            rel1.setProperty("description", (Object)"A description");
            expectedData.assignedProperty(rel1, "description", (Object)"A description", null);
            rel1.setProperty("number", (Object)4.5);
            expectedData.assignedProperty(rel1, "number", (Object)4.5, null);
            node3 = this.getGraphDb().createNode();
            expectedData.expectedCreatedNodes.add(node3);
            rel2 = node3.createRelationshipTo(node2, (RelationshipType)RelTypes.TXEVENT);
            expectedData.expectedCreatedRelationships.add(rel2);
            node3.setProperty("name", (Object)"Node 3");
            expectedData.assignedProperty(node3, "name", (Object)"Node 3", null);
            this.newTransaction();
            Assert.assertTrue((boolean)handler.hasBeenCalled());
        }
        finally {
            this.getGraphDb().unregisterTransactionEventHandler((TransactionEventHandler)handler);
        }
        expectedData = new ExpectedTransactionData();
        handler = new VerifyingTransactionEventHandler(expectedData);
        this.getGraphDb().registerTransactionEventHandler((TransactionEventHandler)handler);
        this.newTransaction();
        try {
            Node tempNode = this.getGraphDb().createNode();
            Relationship tempRel = tempNode.createRelationshipTo(node1, (RelationshipType)RelTypes.TXEVENT);
            tempNode.setProperty("something", (Object)"Some value");
            tempRel.setProperty("someproperty", (Object)101010);
            tempNode.removeProperty("nothing");
            node3.setProperty("test", (Object)"hello");
            node3.setProperty("name", (Object)"No name");
            node3.delete();
            expectedData.expectedDeletedNodes.add(node3);
            expectedData.removedProperty(node3, "name", null, (Object)"Node 3");
            node1.setProperty("new name", (Object)"A name");
            node1.setProperty("new name", (Object)"A better name");
            expectedData.assignedProperty(node1, "new name", (Object)"A better name", null);
            node1.setProperty("name", (Object)"Nothing");
            node1.setProperty("name", (Object)"Mattias Persson");
            expectedData.assignedProperty(node1, "name", (Object)"Mattias Persson", (Object)"Mattias");
            node1.removeProperty("counter");
            expectedData.removedProperty(node1, "counter", null, (Object)10);
            node1.removeProperty("last name");
            node1.setProperty("last name", (Object)"Hi");
            expectedData.assignedProperty(node1, "last name", (Object)"Hi", (Object)"Persson");
            rel2.delete();
            expectedData.expectedDeletedRelationships.add(rel2);
            rel1.removeProperty("number");
            expectedData.removedProperty(rel1, "number", null, (Object)4.5);
            rel1.setProperty("description", (Object)"Ignored");
            rel1.setProperty("description", (Object)"New");
            expectedData.assignedProperty(rel1, "description", (Object)"New", (Object)"A description");
            tempRel.delete();
            tempNode.delete();
            this.newTransaction();
        }
        finally {
            this.getGraphDb().unregisterTransactionEventHandler((TransactionEventHandler)handler);
        }
    }

    private void makeSureRelationshipTypeIsCreated(RelationshipType type) {
        Node dummy1 = this.getGraphDb().createNode();
        Node dummy2 = this.getGraphDb().createNode();
        dummy1.createRelationshipTo(dummy2, type).delete();
        dummy1.delete();
        dummy2.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void makeSureBeforeAfterAreCalledCorrectly() {
        this.commit();
        ArrayList<TransactionEventHandler<Object>> handlers = new ArrayList<TransactionEventHandler<Object>>();
        handlers.add(new FailingEventHandler<Object>(new DummyTransactionEventHandler<Object>(null), false));
        handlers.add(new FailingEventHandler<Object>(new DummyTransactionEventHandler<Object>(null), false));
        handlers.add(new FailingEventHandler<Object>(new DummyTransactionEventHandler<Object>(null), true));
        handlers.add(new FailingEventHandler<Object>(new DummyTransactionEventHandler<Object>(null), false));
        for (TransactionEventHandler transactionEventHandler : handlers) {
            this.getGraphDb().registerTransactionEventHandler(transactionEventHandler);
        }
        try {
            this.newTransaction();
            this.getGraphDb().createNode().delete();
            try {
                this.commit();
                Assert.fail((String)"Should fail commit");
            }
            catch (TransactionFailureException e) {
                // empty catch block
            }
            this.verifyHandlerCalls(handlers, false);
            this.getGraphDb().unregisterTransactionEventHandler((TransactionEventHandler)handlers.remove(2));
            for (TransactionEventHandler transactionEventHandler : handlers) {
                ((DummyTransactionEventHandler)((FailingEventHandler)transactionEventHandler).source).reset();
            }
            this.newTransaction();
            this.getGraphDb().createNode().delete();
            this.commit();
            this.verifyHandlerCalls(handlers, true);
        }
        finally {
            for (TransactionEventHandler transactionEventHandler : handlers) {
                this.getGraphDb().unregisterTransactionEventHandler(transactionEventHandler);
            }
        }
    }

    @Test
    public void deleteNodeRelTriggerPropertyRemoveEvents() {
        Node node1 = this.getGraphDb().createNode();
        Node node2 = this.getGraphDb().createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)RelTypes.TXEVENT);
        node1.setProperty("test1", (Object)"stringvalue");
        node1.setProperty("test2", (Object)1L);
        rel.setProperty("test1", (Object)"stringvalue");
        rel.setProperty("test2", (Object)1L);
        rel.setProperty("test3", (Object)new int[]{1, 2, 3});
        this.commit();
        MyTxEventHandler handler = new MyTxEventHandler();
        this.getGraphDb().registerTransactionEventHandler((TransactionEventHandler)handler);
        this.newTransaction();
        this.getEmbeddedGraphDb().getConfig().getGraphDbModule().getNodeManager().clearCache();
        rel.delete();
        node1.delete();
        node2.delete();
        this.getEmbeddedGraphDb().getConfig().getGraphDbModule().getNodeManager().clearCache();
        this.commit();
        Assert.assertEquals((Object)"stringvalue", (Object)handler.nodeProps.get("test1"));
        Assert.assertEquals((Object)"stringvalue", (Object)handler.relProps.get("test1"));
        Assert.assertEquals((Object)1L, (Object)handler.nodeProps.get("test2"));
        Assert.assertEquals((Object)1L, (Object)handler.relProps.get("test2"));
        int[] intArray = (int[])handler.relProps.get("test3");
        Assert.assertEquals((long)3L, (long)intArray.length);
        Assert.assertEquals((long)1L, (long)intArray[0]);
        Assert.assertEquals((long)2L, (long)intArray[1]);
        Assert.assertEquals((long)3L, (long)intArray[2]);
    }

    private void verifyHandlerCalls(List<TransactionEventHandler<Object>> handlers, boolean txSuccess) {
        for (TransactionEventHandler<Object> handler : handlers) {
            DummyTransactionEventHandler realHandler = (DummyTransactionEventHandler)((FailingEventHandler)handler).source;
            if (txSuccess) {
                Assert.assertEquals((Object)0, (Object)realHandler.beforeCommit);
                Assert.assertEquals((Object)1, (Object)realHandler.afterCommit);
                continue;
            }
            if (realHandler.counter <= 0) continue;
            Assert.assertEquals((Object)0, (Object)realHandler.beforeCommit);
            Assert.assertEquals((Object)1, (Object)realHandler.afterRollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void makeSureHandlerIsntCalledWhenTxRolledBack() {
        this.commit();
        DummyTransactionEventHandler<Integer> handler = new DummyTransactionEventHandler<Integer>(10);
        this.getGraphDb().registerTransactionEventHandler(handler);
        try {
            this.newTransaction();
            this.getGraphDb().createNode().delete();
            this.rollback();
            Assert.assertNull((Object)((DummyTransactionEventHandler)handler).beforeCommit);
            Assert.assertNull((Object)((DummyTransactionEventHandler)handler).afterCommit);
            Assert.assertNull((Object)((DummyTransactionEventHandler)handler).afterRollback);
        }
        finally {
            this.getGraphDb().unregisterTransactionEventHandler(handler);
        }
    }

    private static class DummyTransactionEventHandler<T>
    implements TransactionEventHandler<T> {
        private final T object;
        private TransactionData receivedTransactionData;
        private T receivedState;
        private int counter;
        private Integer beforeCommit;
        private Integer afterCommit;
        private Integer afterRollback;

        public DummyTransactionEventHandler(T object) {
            this.object = object;
        }

        public void afterCommit(TransactionData data, T state) {
            Assert.assertNotNull((Object)data);
            this.receivedState = state;
            this.afterCommit = this.counter++;
        }

        public void afterRollback(TransactionData data, T state) {
            Assert.assertNotNull((Object)data);
            this.receivedState = state;
            this.afterRollback = this.counter++;
        }

        public T beforeCommit(TransactionData data) throws Exception {
            Assert.assertNotNull((Object)data);
            this.receivedTransactionData = data;
            this.beforeCommit = this.counter++;
            if (this.beforeCommit == 2) {
                new Exception("blabla").printStackTrace();
            }
            return this.object;
        }

        void reset() {
            this.receivedTransactionData = null;
            this.receivedState = null;
            this.counter = 0;
            this.beforeCommit = null;
            this.afterCommit = null;
            this.afterRollback = null;
        }
    }

    private static class FailingEventHandler<T>
    implements TransactionEventHandler<T> {
        private final TransactionEventHandler<T> source;
        private final boolean willFail;

        public FailingEventHandler(TransactionEventHandler<T> source, boolean willFail) {
            this.source = source;
            this.willFail = willFail;
        }

        public void afterCommit(TransactionData data, T state) {
            this.source.afterCommit(data, state);
        }

        public void afterRollback(TransactionData data, T state) {
            this.source.afterRollback(data, state);
        }

        public T beforeCommit(TransactionData data) throws Exception {
            if (this.willFail) {
                throw new Exception("Just failing commit, that's all");
            }
            return (T)this.source.beforeCommit(data);
        }
    }

    private static enum RelTypes implements RelationshipType
    {
        TXEVENT;

    }

    private static class MyTxEventHandler
    implements TransactionEventHandler<Object> {
        Map<String, Object> nodeProps = new HashMap<String, Object>();
        Map<String, Object> relProps = new HashMap<String, Object>();

        private MyTxEventHandler() {
        }

        public void afterCommit(TransactionData data, Object state) {
            for (PropertyEntry entry : data.removedNodeProperties()) {
                String key = entry.key();
                Object value = entry.previouslyCommitedValue();
                this.nodeProps.put(key, value);
            }
            for (PropertyEntry entry : data.removedRelationshipProperties()) {
                this.relProps.put(entry.key(), entry.previouslyCommitedValue());
            }
        }

        public void afterRollback(TransactionData data, Object state) {
        }

        public Object beforeCommit(TransactionData data) throws Exception {
            return null;
        }
    }
}

