/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import org.junit.Assert;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.event.PropertyEntry;

class PropertyEntryImpl<T extends PropertyContainer>
implements PropertyEntry<T> {
    private final T entity;
    private final String key;
    private final Object value;
    private final Object valueBeforeTx;

    PropertyEntryImpl(T entity, String key, Object value, Object valueBeforeTx) {
        this.entity = entity;
        this.key = key;
        this.value = value;
        this.valueBeforeTx = valueBeforeTx;
    }

    public T entity() {
        return this.entity;
    }

    public String key() {
        return this.key;
    }

    public Object value() {
        return this.value;
    }

    public Object previouslyCommitedValue() {
        return this.valueBeforeTx;
    }

    void compareToAssigned(PropertyEntry<T> entry) {
        this.basicCompareTo(entry);
        PropertyEntryImpl.assertEqualsMaybeNull(entry.value(), this.value());
    }

    void compareToRemoved(PropertyEntry<T> entry) {
        this.basicCompareTo(entry);
        try {
            entry.value();
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertNull((Object)this.value());
    }

    void basicCompareTo(PropertyEntry<T> entry) {
        Assert.assertEquals((Object)entry.entity(), this.entity());
        Assert.assertEquals((Object)entry.key(), (Object)this.key());
        PropertyEntryImpl.assertEqualsMaybeNull(entry.previouslyCommitedValue(), this.previouslyCommitedValue());
    }

    public static void assertEqualsMaybeNull(Object o1, Object o2) {
        if (o1 == null) {
            Assert.assertTrue((o1 == o2 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((Object)o1, (Object)o2);
        }
    }
}

