/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;

public class TestTxSuspendResume
extends AbstractNeo4jTestCase {
    @Test
    public void testMultipleTxSameThread() throws Exception {
        EmbeddedGraphDatabase neo2 = new EmbeddedGraphDatabase(TestTxSuspendResume.getStorePath("test-neo2"));
        TransactionManager tm = neo2.getConfig().getTxModule().getTxManager();
        tm.begin();
        Node refNode = neo2.getReferenceNode();
        Transaction tx1 = tm.suspend();
        tm.begin();
        refNode.setProperty("test2", (Object)"test");
        Transaction tx2 = tm.suspend();
        tm.resume(tx1);
        CommitThread thread = new CommitThread(tm, tx2);
        thread.start();
        refNode.removeProperty("test2");
        Assert.assertTrue((boolean)thread.success());
        tm.commit();
        neo2.shutdown();
    }

    private static class CommitThread
    extends Thread {
        private final TransactionManager tm;
        private final Transaction tx;
        private boolean success = false;

        CommitThread(TransactionManager tm, Transaction tx) {
            this.tm = tm;
            this.tx = tx;
        }

        @Override
        public synchronized void run() {
            try {
                CommitThread.sleep(1000L);
                this.tm.resume(this.tx);
                this.tm.commit();
                this.success = true;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        synchronized boolean success() {
            return this.success;
        }
    }
}

