/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.lang.reflect.Field;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.TestShortString;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.test.TargetDirectory;

public class TestShortStringProperties
extends TestShortString {
    private static final TargetDirectory target = TargetDirectory.forTest(TestShortStringProperties.class);
    private static AbstractGraphDatabase graphdb;
    private Transaction tx;
    private static final String LONG_STRING = "this is a really long string, believe me!";
    private static Field storeField;

    @BeforeClass
    public static void startup() {
        graphdb = new EmbeddedGraphDatabase(target.graphDbDir(true).getAbsolutePath());
    }

    @AfterClass
    public static void shutdown() {
        if (graphdb != null) {
            graphdb.shutdown();
        }
        graphdb = null;
    }

    @Before
    public void beginTx() {
        if (this.tx == null) {
            this.tx = graphdb.beginTx();
        }
    }

    @After
    public void finishTx() {
        if (this.tx != null) {
            this.tx.finish();
        }
        this.tx = null;
    }

    public void commit() {
        if (this.tx != null) {
            this.tx.success();
        }
        this.finishTx();
        this.clearCache();
    }

    public void newTx() {
        this.commit();
        this.beginTx();
    }

    private void clearCache() {
        graphdb.getConfig().getGraphDbModule().getNodeManager().clearCache();
    }

    @Test
    public void canAddMultipleShortStringsToTheSameNode() throws Exception {
        long recordCount = this.dynamicRecordsInUse();
        Node node = graphdb.createNode();
        node.setProperty("key", (Object)"value");
        node.setProperty("reverse", (Object)"esrever");
        this.commit();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertEquals((Object)"value", (Object)node.getProperty("key"));
        Assert.assertEquals((Object)"esrever", (Object)node.getProperty("reverse"));
    }

    @Test
    public void canAddShortStringToRelationship() throws Exception {
        long recordCount = this.dynamicRecordsInUse();
        Relationship rel = graphdb.createNode().createRelationshipTo(graphdb.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"REL_TYPE"));
        rel.setProperty("type", (Object)rel.getType().name());
        this.commit();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertEquals((Object)rel.getType().name(), (Object)rel.getProperty("type"));
    }

    @Test
    public void canUpdateShortStringInplace() throws Exception {
        long recordCount = this.dynamicRecordsInUse();
        long propCount = this.propertyRecordsInUse();
        Node node = graphdb.createNode();
        node.setProperty("key", (Object)"value");
        this.newTx();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((Object)"value", (Object)node.getProperty("key"));
        node.setProperty("key", (Object)"other");
        this.commit();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((Object)"other", (Object)node.getProperty("key"));
    }

    @Test
    public void canReplaceLongStringWithShortString() throws Exception {
        long recordCount = this.dynamicRecordsInUse();
        long propCount = this.propertyRecordsInUse();
        Node node = graphdb.createNode();
        node.setProperty("key", (Object)LONG_STRING);
        this.newTx();
        Assert.assertEquals((long)(recordCount + 1L), (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((Object)LONG_STRING, (Object)node.getProperty("key"));
        node.setProperty("key", (Object)"value");
        this.commit();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((Object)"value", (Object)node.getProperty("key"));
    }

    @Test
    public void canReplaceShortStringWithLongString() throws Exception {
        long recordCount = this.dynamicRecordsInUse();
        long propCount = this.propertyRecordsInUse();
        Node node = graphdb.createNode();
        node.setProperty("key", (Object)"value");
        this.newTx();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((Object)"value", (Object)node.getProperty("key"));
        node.setProperty("key", (Object)LONG_STRING);
        this.commit();
        Assert.assertEquals((long)(recordCount + 1L), (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((Object)LONG_STRING, (Object)node.getProperty("key"));
    }

    @Test
    public void canRemoveShortStringProperty() throws Exception {
        long recordCount = this.dynamicRecordsInUse();
        long propCount = this.propertyRecordsInUse();
        Node node = graphdb.createNode();
        node.setProperty("key", (Object)"value");
        this.newTx();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((Object)"value", (Object)node.getProperty("key"));
        node.removeProperty("key");
        this.commit();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)propCount, (long)this.propertyRecordsInUse());
        Assert.assertFalse((boolean)node.hasProperty("key"));
    }

    @Override
    protected void assertCanEncode(String string) {
        this.encode(string, true);
    }

    @Override
    protected void assertCannotEncode(String string) {
        this.encode(string, false);
    }

    private void encode(String string, boolean isShort) {
        long recordCount = this.dynamicRecordsInUse();
        Node node = graphdb.createNode();
        node.setProperty("key", (Object)string);
        this.newTx();
        if (isShort) {
            Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        } else {
            Assert.assertTrue((recordCount < this.dynamicRecordsInUse() ? 1 : 0) != 0);
        }
        this.clearCache();
        Assert.assertEquals((Object)string, (Object)node.getProperty("key"));
    }

    private long propertyRecordsInUse() {
        return this.propertyStore().getNumberOfIdsInUse();
    }

    private long dynamicRecordsInUse() {
        try {
            return ((AbstractDynamicStore)storeField.get(this.propertyStore())).getNumberOfIdsInUse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PropertyStore propertyStore() {
        XaDataSourceManager dsMgr = graphdb.getConfig().getTxModule().getXaDataSourceManager();
        return ((NeoStoreXaConnection)dsMgr.getXaDataSource("nioneodb").getXaConnection()).getPropertyStore();
    }

    static {
        try {
            storeField = PropertyStore.class.getDeclaredField("stringPropertyStore");
            storeField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

